/**************************************************************************/
/** Sqed/32 Installation Batch                                           **/
/**                                                                      **/
/**              INSTALL [Language]                                      **/
/**                                                                      **/
/**         F.e. INSTALL                                                 **/
/**              INSTALL E (where E is a shortcut for english language)  **/
/**                                                                      **/
/** At the moment the batch processes (not case sensetive) the following **/
/** parameters:                                                          **/
/**                                                                      **/
/**      A -  danish     E -  english  * D -  dutch     G -  german      **/
/**      I -  italian    S -  spanish    W -  swedish                    **/
/**                                                                      **/
/** Note:  This installation batch requires the 'OS/2 Procedures         **/
/**        Language 2/REXX'.                                             **/
/**                                                                      **/
/**     *  The dutch language is not used in this batch (sorry).         **/
/**        I've no dutch message strings, all 'dutch' msgs in english.   **/
/**************************************************************************/

/* Initialize */
Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

/**************************** Hier Versionsnummer etc. ************************/

Space_Req = 1000000           /* Knapp ein M Platzerfordernis         */
Sqed_Ver  = 'v0.97'           /* Versionsnummer                       */

/******************************************************************************/
'@Echo Off'

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs

Parse Arg Language .          /* Parameters */

/* dutch (ops english strings) */
D_START = 'Sqed/32 '||Sqed_Ver||' is now being installed...'
D_INST1  = '   Sqed/32 Message Editor - about the installation batch:      '
D_INST4  = ' This program will install all necessary files for Sqed/32 in a user'
D_INST5  = ' selectable directory on your harddisk.'
D_INST6  = ' Prior to the installation you will be asked for the source and target'
D_INST7  = ' directory. Please provide a full specified path including drive and'
D_INST8  = ' directory designator (i.e. D:\SQED). After you provided all necessary'
D_INST9  = ' information, the install program will display a summary. At this point'
D_INST10 = ' you can cancel the installation, if you do not like what you see.'
D_INST11 = ' After that you can call the install routine again and provide the'
D_INST12 = ' correct information.'
D_INST14 = ' The installation batch parses only one parameter. This is a shortcut for'
D_INST15 = ' the language version which you want to install. E.g.: If you want to'
D_INST16 = ' install Sqed/32 with dutch dialogs start the batch as follows:'
D_INST18 = '                            INSTALL.CMD D'
D_INST20 = ' Possible parameters:  A - danish   D - dutch    E - english  G - german'
D_INST21 = '                       I - italian  S - spanish  W - swedish'
D_CONT   = ' Continue ?'
D_YN     = ' (Y/N)'
if right(directory(),1) == '\' then
    D_SRCDIR = 'Source directory:  ['directory()']: '
  else
    D_SRCDIR = 'Source directory:  ['directory()'\]: '
D_TRGDIR = 'Target directory:  ['FileSpec("drive",directory())||'\SQED\]: '
D_READY1  = '          Sqed/32 '||Sqed_Ver||' - 32bit Multithreaded Message Editor          '
D_READY2  = ' The following settings have been provided:'
D_LANG    = ' Language:              dutch'
D_ASKOK   = ' Install?'
D_COPY    = 'Sqed/32:  Copying to disk.'
D_OBJMSG1 = '     A folder for Sqed/32 can be created on the desktop.      '
D_OBJASK  = 'Shall we create a program object for Sqed/32?'
D_OBJLOC  = 'Target for program object: (D)esktop  (S)tartup folder :'
D_OBJMSG3 = 'Object creation successful.'
D_OBJMSG4 = 'ERROR: Unable to create object!'
D_ALLOK   = 'The dutch version of Sqed/32 has been successfully installed.'.
D_ERRFR1  = 'There is not enough space on your hard disk!'
D_ERRFR2  = 'Installation requires about '||Space_Req||' bytes of free space.'
D_ERRFR3  = 'Please select a different partition or delete files that are no longer'
D_ERRFR4  = 'needed and restart the install program.'

/* Deutsche Meldungen  */
G_START = 'Sqed/32 '||Sqed_Ver||' wird nun installiert...'
G_INST1  = '   Sqed/32 Nachrichten Editor - Hinweise zur Installation  :   '
G_INST4  = ' Dieser Batch installiert alle von Sqed/32 bentigten Dateien in ein eigenes'
G_INST5  = ' Verzeichnis auf Ihrer Festplatte.'
G_INST6  = ' Sie werden whrend der Installation nach dem Quell- und Zielverzeichnis'
G_INST7  = ' gefragt. Geben Sie bitte die Verzeichnisse als volle Pfadangaben mit'
G_INST8  = ' Laufwerks- und Pfadangabe an (z.B.: D:\SQED). Nachdem Sie die bentigten'
G_INST9  = ' Angaben gemacht haben, wird die getroffene Auswahl angezeigt. Sollten Sie'
G_INST10 = ' falsche Angaben gemacht haben, knnen Sie die Installation abbrechen.'
G_INST11 = ' Fhren Sie danach einfach den Batch erneut aus und korigieren Sie Ihre'
G_INST12 = ' Eingabe.'
G_INST14 = ' Install.Cmd versteht als Parameter so gut wie garnichts. Einzig die Sprache'
G_INST15 = ' kann durch Buchstaben angegeben werden. Um z.B. Sqed/32 mit deutschen Dialogen'
G_INST16 = ' zu installieren, knnten Sie die Installation von der Befehlszeile so starten:'
G_INST18 = '                             INSTALL.CMD G'
G_INST20 = ' Mgliche Wahl:  A - dnisch      E - englisch  D - hollndisch   G - deutsch'
G_INST21 = '                 I - italienisch  S - spanisch  W - schwedisch'
G_CONT   = ' Weiter ?'
G_YN     = ' (J/N)'
if right(directory(),1) == '\' then
    G_SRCDIR = 'Quell-Verzeichniss:  ['directory()']: '
  else
    G_SRCDIR = 'Quell-Verzeichniss:  ['directory()'\]: '
G_TRGDIR = 'Ziel-Verzeichnis:    ['FileSpec("drive",directory())||'\SQED\]: '
G_READY1  = '      Sqed/32 '||Sqed_Ver||' - ein 32bit multithreaded Nachrichten Editor      '
G_READY2  = ' Bisher wurden folgende Angaben gemacht:'
G_LANG    = ' Sprache:                deutsch'
G_ASKOK   = ' Installieren?'
G_COPY    = 'Sqed/32:  Kopiere nun die Dateien auf Ihre Festplatte.'
G_OBJMSG1 = '     Ordner fr Sqed/32 auf der Arbeitsoberflche anlegen.    '
G_OBJASK  = 'Soll ein Programm Objekt angelegt werden ?'
G_OBJMSG3 = 'Objekt wurde erfolgreich angelegt.'
G_OBJMSG4 = 'FEHLER: Objekt konnte nicht angelegt werden!'
G_ALLOK   = 'Die deutsche Version von Sqed/32 wurde erfolgreich installiert.'
G_ERRFR1  = 'Es ist nicht gengend freier Platz auf Ihrer Festplatte!'
G_ERRFR2  = 'Es werden ca. '||Space_Req||' Bytes freier Speicherplatz bentigt.'
G_ERRFR3  = 'Whlen Sie entweder eine Partition mit ausreichendem Platz, oder lschen'
G_ERRFR4  = 'sie nicht mehr bentigte Programme und starten den Install Batch erneut.'

/* English message strings */
E_START = 'Sqed/32 '||Sqed_Ver||' is now being installed...'
E_INST1  = '   Sqed/32 Message Editor - about the installation routine:    '
E_INST4  = ' This program will install all necessary files for Sqed/32 in a user'
E_INST5  = ' selectable directory on your harddisk.'
E_INST6  = ' Prior to the installation you will be asked for the source and target'
E_INST7  = ' directory. Please provide a full specified path including drive and'
E_INST8  = ' directory designator (i.e. D:\SQED). After you provided all necessary'
E_INST9  = ' information, the install program will display a summary. At this point'
E_INST10 = ' you can cancel the installation, if you do not like what you see.'
E_INST11 = ' After that you can call the install routine again and provide the'
E_INST12 = ' correct information.'
E_INST14 = ' The installation batch parses only one parameter. This is a shortcut for'
E_INST15 = ' the language version which you want to install. E.g.: If you want to'
E_INST16 = ' install Sqed/32 with english dialogs start the batch as follows:'
E_INST18 = '                            INSTALL.CMD E'
E_INST20 = ' Possible parameters:  A - danish   D - dutch    E - english  G - german'
E_INST21 = '                       I - italian  S - spanish  W - swedish'
E_CONT   = ' Continue ?'
E_YN     = ' (Y/N)'
if right(directory(),1) == '\' then
    E_SRCDIR = 'Source directory:  ['directory()']: '
  else
    E_SRCDIR = 'Source directory:  ['directory()'\]: '
E_TRGDIR = 'Target directory:  ['FileSpec("drive",directory())||'\SQED\]: '
E_READY1  = '      Sqed/32 '||Sqed_Ver||' - A 32bit Multithreaded Message Editor            '
E_READY2  = ' The following settings have been provided:'
E_LANG    = ' Language:              english'
E_ASKOK   = ' Install?'
E_COPY    = 'Sqed/32:  Copying to disk.'
E_OBJMSG1 = '     A folder for Sqed/32 can be created on the desktop.      '
E_OBJASK  = 'Shall we create a program object for Sqed/32?'
E_OBJMSG3 = 'Object creation successful.'
E_OBJMSG4 = 'ERROR: Unable to create object!'
E_ALLOK   = 'The english version of Sqed/32 has been successfully installed.'.
E_ERRFR1  = 'There is not enough space on your hard disk!'
E_ERRFR2  = 'Installation requires about '||Space_Req||' bytes of free space.'
E_ERRFR3  = 'Please select a different partition or delete files that are no longer'
E_ERRFR4  = 'needed and restart the install program.'

/* italian strings */
I_START  = 'Sqed/32 '||Sqed_Ver||'  in corso di installazione...'
I_INST1  = '   Sqed/32 Message Editor - informazioni sull"installazione:   '
I_INST4  = ' Questo programma installer tutti i file necessari a Sqed/32 in una'
I_INST5  = ' directory di vostra scelta.           '
I_INST6  = ' Prima dell"installazione vi saranno richieste le directory di partenza'
I_INST7  = ' e di arrivo. Per favore inserite la path completa compresa di disco'
I_INST8  = ' e directory (ad esempio: . D:\SQED). Dopo che avrete inserito tutte  '
I_INST9  = ' le informazioni necessari il programma visualizzer un sommario.      '
I_INST10 = " A questo punto potrete cancellare l'installazione se vorrete.    "
I_INST11 = ' Dopo di che potrete sempre rieseguire il programma per inserire  '
I_INST12 = ' le informazioni corrette.'
I_INST14 = ''
I_INST15 = ''
I_INST16 = ''
I_INST18 = ''
I_INST20 = ''
I_INST21 = ''
I_CONT   = ' Continuo ?'
I_YN     = ' (Y/N)'
if right(directory(),1) == '\' then
    I_SRCDIR = 'Source directory:  ['directory()']: '
  else
    I_SRCDIR = 'Source directory:  ['directory()'\]: '
I_TRGDIR = 'Target directory:  ['FileSpec("drive",directory())||'\SQED\]: '
I_READY1  = '      Sqed/32 '||Sqed_Ver||' - A 32bit Multithreaded Message Editor            '
I_READY2  = ' Le seguenti preferenze sono state scelte: '
I_LANG    = ' Linguaggio:            italiano'
I_ASKOK   = ' Installo?'
I_COPY    = 'Sqed/32:  Copio sul disco.'
I_OBJMSG1 = '     A folder for Sqed/32 can be created on the desktop.      '
I_OBJASK  = 'Devo creare un icona programma per Sqed/32 ? '
I_OBJMSG3 = 'Icona creata con successo. '
I_OBJMSG4 = 'ERRORE: Non posso creare l"icona'
I_ALLOK   = 'La versione italiana di Squed/32  stata installata correttamente.'
I_ERRFR1  = 'Non c" spazio sufficiente sul tuo disco.'
I_ERRFR2  = 'L"installazione richiede circa '||Space_Req||' bytes di spazio libero.'
I_ERRFR3  = 'Per favore scegli una disco differente o cancella dei files che non'
I_ERRFR4  = 'sono necessari e riesegui il programma di installazione.'

/* spanish strings */
S_START = 'Sqed/32 '||Sqed_Ver||' est siendo instalado...'
S_INST1  = '   Sqed/32 Editor de Mensajes - rutina de instalacin:         '
S_INST4  = ' Este programa va a instalar todos los ficheros necesarios para'
S_INST5  = ' Sqed/32 en un directorio de su disco duro.'
S_INST6  = ' Antes de la instalacin se le preguntar por los directorios de'
S_INST7  = ' origen y destino. Por favor, especifique el path completo incluyendo'
S_INST8  = ' el disco (p.ej. D:\SQED). Despus de que usted haya dado toda la'
S_INST9  = ' informacin necesaria, el programa de instalacin mostrar un sumario.'
S_INST10 = ' En ese momento, puede usted cancelar la instalacin si no le gusta lo'
S_INST11 = ' que ve. Ms tarde, puede ejecutar la rutina de instalacin de nuevo'
S_INST12 = ' y dar la informacin correcta.'
S_INST14 = ' Install.Cmd slo requiere un parmetro. El nico parmetro a dar es el'
S_INST15 = ' carcter que representa el lenguaje a instalar. Este es un ejemplo de'
S_INST16 = ' cmo instalar la versin espaola de Sqed/32:'
S_INST18 = '                             INSTALL.CMD S'
S_INST20 = ' Opciones posibles:  A - dans     D - holands  E - ingls  G - alemn'
S_INST21 = '                     I - italiano  S - espaol   W - sueco   '
S_CONT   = ' Continuar?'
S_YN     = ' (Y/N)'
if right(directory(),1) == '\' then
    S_SRCDIR = 'Directorio de origen:   ['directory()']: '
  else
    S_SRCDIR = 'Directorio de origen:   ['directory()'\]: '
S_SRCDIR = 'Directorio de origen:   ['directory()']: '
S_TRGDIR = 'Directorio de destino:  ['FileSpec("drive",directory())||'\SQED\]: '
S_READY1  = '      Sqed/32 '||Sqed_Ver||' - Un Editor de Mensajes multithread de 32 bits    '
S_READY2  = ' Se ha seleccionado la siguiente configuracin:'
S_LANG    = ' Lenguaje:              espaol'
S_ASKOK   = ' Instalar?'
S_COPY    = 'Sqed/32:  Copiando a disco.'
S_OBJMSG1 = '     A folder for Sqed/32 can be created on the desktop.      '
S_OBJASK  = 'Crear objeto de programa para Sqed/32?'
S_OBJMSG3 = 'Objeto creado con xito.'
S_OBJMSG4 = 'ERROR: No se pudo crear objeto!'
S_ALLOK   = 'La versin espaola de Sqed/32 ha sido instalada con xito'.
S_ERRFR1  = 'No hay suficiente espacio en su disco duro!'
S_ERRFR2  = 'La instalacin requiere unos '||Space_Req||' bytes de espacio libre.'
S_ERRFR3  = 'Seleccione otra particin o borre algunos ficheros que no sean'
S_ERRFR4  = 'necesarios y reinicie el programa de instalacin.'

/* swedish strings */
W_START = 'Sqed/32 '||Sqed_Ver||' installeras...'
W_INST1  = '   Sqed/32 Message Editor - om installationen:                 '
W_INST4  = ' Detta program kommer att installera alla ndvndiga filer fr Sqed/32 i ett av'
W_INST5  = ' dig valt bibliotek p din hrddisk.'
W_INST6  = ' Innan installationen kommer du att tillfrgas om frn resp till vilket'
W_INST7  = ' bibliotek installationen skall ske i. V.v ge full skvg inklusive enhet'
W_INST8  = ' (drive) och biblioteksnamn (ex. D:\SQED). Efter det att alla ndvndiga '
W_INST9  = ' indata fr installationen uppgivits kommer installationsprogrammet att visa'
W_INST10 = ' en sammanfattning av installationsdata. Vid denna tidpunkt kan, om s nskas,'
W_INST11 = ' installationen avbrytas. Drefter kan man nyo starta installationsprogrammet'
W_INST12 = ' och mata in ndrade uppgifter.'
W_INST14 = ''
W_INST15 = ''
W_INST16 = ''
W_INST18 = ''
W_INST20 = ''
W_INST21 = ''
W_CONT   = ' Fortstta ?'
W_YN     = ' (J/N)'
if right(directory(),1) == '\' then
    W_SRCDIR = 'Installera frn bibliotek: ['directory()']: '
  else
    W_SRCDIR = 'Installera frn bibliotek: ['directory()'\]: '
W_TRGDIR = 'Till bibliotek:            ['FileSpec("drive",directory())||'\SQED\]: '
W_READY1  = '      Sqed/32 '||Sqed_Ver||' - <en 32bit Multithreaded Message Editor            '
W_READY2  = ' Fljande instllningar fresls:'
W_LANG    = ' Sprk:                 svenska'
W_ASKOK   = ' Installera?'
W_COPY    = 'Sqed/32:  Kopierar till disk.'
W_OBJMSG1 = '     A folder for Sqed/32 can be created on the desktop.      '
W_OBJASK  = 'Skapa Programobjektet SQED/32?'
W_OBJMSG3 = 'Programobjekt skapat.... '
W_OBJMSG4 = 'ERROR: Programobjekt kan ej skapas!'
W_ALLOK   = 'Den svenska versionen av Sqed/32 r nu installerad.'.
W_ERRFR1  = 'Det finns inte tillrcklig plats p hrddisken!'
W_ERRFR2  = 'Installationen behver omkring '||Space_Req||' byte fritt utrymme.'
W_ERRFR3  = 'Vlj en annan partition eller radera andra filer som inte lngre '
W_ERRFR4  = 'behvs och starta om installationsprogrammet.'

/* danish strings */
A_START = 'Sqed/32 '||Sqed_Ver||' bliver nu installeret...'
A_INST1  = '   Sqed/32 Message Editor - om installationsrutinen:           '
A_INST4  = ' Dette program vil installere alle ndvendige filer til SQED/32 til'
A_INST5  = ' et af brugeren valgt directory p harddisken.'
A_INST6  = ' Fr installationen sprges der om afsender og modtager directory,'
A_INST7  = ' hvilket skal besvares med fuld sti inklusive drev (fx. D:\SQED).'
A_INST8  = ' Efter den ndvendige information er blevet givet vil installations-'
A_INST9  = ' programmet vise et resume af oplysningerne. P dette tidspunkt kan'
A_INST10 = ' installationen afbrydes, hvis oplysningerne ikke er korrekte.   '
A_INST11 = ' Installationsprogrammet kan s udfres igen og oplysningerne kan'
A_INST12 = ' korrigeres.'
A_INST14 = ''
A_INST15 = ''
A_INST16 = ''
A_INST18 = ''
A_INST20 = ''
A_INST21 = ''
A_CONT   = ' Fortst?'
A_YN     = ' (J/N)'
if right(directory(),1) == '\' then
    A_SRCDIR = 'Afsender directory:  ['directory()']: '
  else
    A_SRCDIR = 'Afsender directory:  ['directory()'\]: '
A_TRGDIR = 'Modtager directory:  ['FileSpec("drive",directory())||'\SQED\]: '
A_READY1  = '      Sqed/32 '||Sqed_Ver||' - en 32 bit multitrdet Message Editor            '
A_READY2  = ' Flgende indstilling er mulig:'
A_LANG    = ' Sprog:                 dansk'
A_ASKOK   = ' Installr?'
A_COPY    = 'Sqed/32:  Kopierer til disk.'
A_OBJMSG1 = '     A folder for Sqed/32 can be created on the desktop.      '
A_OBJASK  = 'Opret program objekt for Sqed/32?'
A_OBJLOC  = 'Placering for program objekt: (D)esktop  (S)tartop folder :'
A_OBJMSG3 = 'Objekt oprettet ok.'
A_OBJMSG4 = 'FEJL: Objekt kunne ikke oprettes!'
A_ALLOK   = 'Den danske version af Sqed/32 er installeret ok.'.
A_ERRFR1  = 'Der er ikke plads nok p harddisken!'
A_ERRFR2  = 'Installation behver ca. '||Space_Req||' bytes fri plads.'
A_ERRFR3  = 'Vlg venligst en anden partition med mere fri plads eller ryd plads og'
A_ERRFR4  = 'genstart installationsprogrammet.'

Call SysCls
if Language = " " then do
  Language = GetLanguage()
  Call InstallNote
end

/* Source */
Say
Call GetInput value(Language||'_SRCDIR')
Pull SourcePath

If SourcePath = "" Then Do
   SourcePath = directory()
end

/* Target */
If first = 0 then call InstallNote
Say
Call GetInput value(Language||'_TRGDIR')
Parse Pull TargetPath

If TargetPath = "" Then
  TargetPath=FileSpec("drive",directory())||'\SQED'

/* Fr die Ausgabe erst mal alle mit '\' am Ende  */
if right(TargetPath,1)<>"\" then TargetPath=''TargetPath'\'
if right(SourcePath,1)<>"\" then SourcePath=''SourcePath'\'

/* dutch (ops english) strings */
D_ASKDIR = 'The directory ['TargetPath'] does not yet exist.'
D_ASKDIR1 = 'Shall we create the directory ['TargetPath'] ?'
D_INFDIR  = 'Creating directory ['TargetPath'] ...'
D_FILEEXIST = 'Sqed/32 files already exist in target directory! Replace?'
D_ERRDIR  = 'Unable to create directory ['TargetPath'].'
D_ERRLW   = 'You do not have write permission on drive: ['filespec("drive", Targetpath)'] '
D_ERRLW1  = "ERROR:  Couldn't write on target drive: "filespec("drive", Targetpath)
D_ERRLW2  = "Possible reasons are: Drive isn't ready or it is a CD-ROM or ..."
D_ERRCOP1 = "ERROR: Couldn't copy Dutch.Dll. Proceed ?"
D_SRCINF  = ' Source directory:      'SourcePath
D_TRGINF  = ' Target directory:      'TargetPath

/* deutsche Strings */
G_ASKDIR = 'Das Verzeichnis: ['TargetPath'] existiert noch nicht auf Ihrer Festplatte.'
G_ASKDIR1 = 'Soll das Verzeichnis: ['TargetPath'] angelegt werden?'
G_INFDIR  = 'Lege Verzeichnis: ['TargetPath'] an...'
G_ERRDIR  = 'Konnte Verzeichnis ['TargetPath'] nicht anlegen.'
G_FILEEXIST = 'Es existieren bereits Sqed/32 Dateien im Zielverzeichnis! berschreiben?'
G_ERRLW   = 'Auf das Ziel-Laufwerk: 'FileSpec("drive",TargetPath)' kann nicht geschrieben werden!'
G_ERRLW1  = 'Beim Testen des Ziellaufwerks: 'filespec("drive", Targetpath)'ist ein Fehler aufgetreten'
G_ERRLW2  = 'Mglicherweise ist das Laufwerk nicht bereit, es handelt sich um CD-ROM oder...'
G_ERRCOP1 = 'WARNUNG! German.Dll konnte nicht kopiert werden. Fortfahren ?'
G_SRCINF  = ' Quell-Verzeichnis:      ['SourcePath']'
G_TRGINF  = ' Ziel-Verzeichnis:       ['TargetPath']'

/* english strings */
E_ASKDIR = 'The directory ['TargetPath'] does not yet exist.'
E_ASKDIR1 = 'Shall we create the directory ['TargetPath'] ?'
E_INFDIR  = 'Creating directory ['TargetPath'] ...'
E_FILEEXIST = 'Sqed/32 files already exist in target directory! Replace?'
E_ERRDIR  = 'Unable to create directory ['TargetPath'].'
E_ERRLW   = 'You do not have write permission on drive: ['filespec("drive", Targetpath)'] '
E_ERRLW1  = "ERROR:  Couldn't write on target drive: "filespec("drive", Targetpath)
E_ERRLW2  = "Possible reasons are: Drive isn't ready or it is a CD-ROM or ..."
E_ERRCOP1 = "ERROR: Couldn't copy English.Dll. Proceed ?"
E_SRCINF  = ' Source directory:      ['SourcePath']'
E_TRGINF  = ' Target directory:      ['TargetPath']'

/* italian Strings */
I_ASKDIR  = 'La directory ['TargetPath'] non esiste.'
I_ASKDIR1 = 'Devo creare la directory ['TargetPath'] ?'
I_INFDIR  = 'Creo la directory ['TargetPath'] ...'
I_ERRDIR  = 'Non posso creare la directory ['TargetPath'].'
I_FILEEXIST = 'Sqed/32 files already exist in target directory! Replace?'
I_ERRLW   = 'Non hai accesso in scrittura al disco: ['filespec("drive", Targetpath)'] '
I_ERRLW1  = "ERROR:  Couldn't write on target drive: "filespec("drive", Targetpath)
I_ERRLW2  = "Possible reasons are: Drive isn't ready or it is a CD-ROM or ..."
I_ERRCOP1 = "ERROR: Couldn't copy Italian.Dll. Proceed ?"
I_SRCINF  = ' Directory sorgente:    ['SourcePath']'
I_TRGINF  = ' Directory di arrivo:   ['TargetPath']'

/* spanish strings */
S_ASKDIR  = 'El directorio ['TargetPath'] no existe.'
S_ASKDIR1 = 'Crear directorio ['TargetPath'] ?'
S_INFDIR  = 'Creando directorio ['TargetPath'] ...'
S_FILEEXIST = 'Sqed/32 files already exist in target directory! Replace?'
S_ERRDIR  = 'No se pudo crear directorio ['TargetPath'].'
S_ERRLW   = 'No hay acceso a escritura en el disco: ['filespec("drive", Targetpath)'] '
S_ERRLW1  = 'Ocurri un error al verificar el disco de destino: 'filespec("drive", Targetpath)
S_ERRLW2  = 'El disco puede estar desconectado, daado....'
S_ERRCOP1 = 'ERROR: No se pudo copiar Spanish.Dll. Proceder?'
S_SRCINF  = ' Directorio de origen:      ['SourcePath']'
S_TRGINF  = ' Directorio de destino:     ['TargetPath']'

/* swedish strings */
W_ASKDIR  = 'Biblioteket ['TargetPath'] finns ej.'
W_ASKDIR1 = 'Skapa bibliotek ['TargetPath'] ?'
W_INFDIR  = 'Skapar bibliotek ['TargetPath'] ...'
W_ERRDIR  = 'Kan ej skapa bibliotek ['TargetPath'].'
W_FILEEXIST = 'Sqed/32 files already exist in target directory! Replace?'
W_ERRLW   = 'Du kan ej skriva till enhet (drive): ['filespec("drive", Targetpath)'] '
W_ERRLW1  = "ERROR:  Couldn't write on target drive: "filespec("drive", Targetpath)
W_ERRLW2  = "Possible reasons are: Drive isn't ready or it is a CD-ROM or ..."
W_ERRCOP1 = "ERROR: Couldn't copy Sweden.Dll. Proceed ?"
W_SRCINF  = ' Frn bibliotek:      ['SourcePath']'
W_TRGINF  = ' Till bibliotek:      ['TargetPath']'

/* danish strings */
A_ASKDIR  = 'The directory ['TargetPath'] does not yet exist.'
A_ASKDIR1 = 'Shall we create the directory ['TargetPath'] ?'
A_INFDIR  = 'Creating directory ['TargetPath'] ...'
A_ERRDIR  = 'Unable to create directory ['TargetPath'].'
A_FILEEXIST = 'Sqed/32 files already exist in target directory! Replace? '
A_ERRLW   = 'You do not have write permission on drive: ['filespec("drive", Targetpath)'] '
A_ERRLW1  = "ERROR:  Couldn't write on target drive: "filespec("drive", Targetpath)
A_ERRLW2  = "Possible reasons are: Drive isn't ready or it is a CD-ROM or ..."
A_ERRCOP1 = "ERROR: Couldn't copy Dansk.Dll. Proceed ?"
A_SRCINF  = ' Source directory:      ['SourcePath']'
A_TRGINF  = ' Target directory:      ['TargetPath']'

/* Jetzt alle '\' wieder rann, vorlufig ;-)       */
If right(SourcePath,1) == "\" then
    SourcePath=strip(SourcePath, 'T', '\')

if right(TargetPath,1) == "\" then
    TargetPath=strip(TargetPath, 'T', '\')

/* Ziellaufwerk writeonly ? */
call checkdrive

/* Gengend Speicher ?  */
Drv_Info = SysDriveInfo(FileSpec("drive",TargetPath))
Free = X2C(C2X(word(drv_info, 2)))

if Space_Req > Free then do
 Call SysCls
 say
 say value(Language||'_ERRFR1')
 say
 say value(Language||'_ERRFR2')
 say value(Language||'_ERRFR3')
 say value(Language||'_ERRFR4')
 exit
end

/* Wenn ROOT Direktory dann "\" wieder rann  */
if right(TargetPath,1)==":" then TargetPath=''TargetPath'\'

Call SysFileTree TargetPath, FileStem, 'D'

/* Directory doesn't exist */
if FileStem.0 = '0' then do
  say
  say value(Language||'_ASKDIR')
  say
  call YNPrompt value(Language||'_ASKDIR1'), '1'
  say
  say value(Language||'_INFDIR')
  retc = sysmkdir(TargetPath)
  if retc <> 0 Then Do
    say value(Language||'_ERRDIR')
    exit
  end
end

/* Wenn vorher '\' dann jetzt wieder weg :-( */
If Right(TargetPath,1) == "\" Then
  TargetPath=strip(TargetPath, 'T', '\')

/* ready ? */
Call SysCls
Say '    ͻ'
Say '    '||value(Language||'_READY1')
Say '    ͼ'
Say
Say '    '||value(Language||'_READY2')
Say
Say '    'value(Language||'_SRCINF')
Say '    'value(Language||'_TRGINF')
Say '    'value(Language||'_LANG')
Say
Say
Call YNPrompt value(Language||'_ASKOK'), '1'

Call SysCls
Say value(Language||'_START')

/* Prfen, ob schon Dateien existieren */
rc=stream(TargetPath'\SQED.*', 'c', 'query exists')
if rc <> '' then do
  say
  call YNPrompt value(Language||'_FILEEXIST'), '1'
end

Call CopyFile 'Sqed.exe', SourcePath, TargetPath
Call CopyFile 'Control.Dll', SourcePath, TargetPath
Call CopyFile 'MSGAPI32.DLL', SourcePath, TargetPath
Call CopyFile 'SQED.INF', SourcePath, TargetPath
Call CopyFile 'HISTORY.INF', SourcePath, TargetPath

Select
  When Language = 'G' Then
    do
      Address CMD '@COPY 'SourcePath'\German.Dll 'TargetPath'\Sqed.Dll';
      If rc <> 0 Then
        Call YNPrompt Value(Language||'_ERRCOP1'), '1'
/*      Call CopyFile 'whatsnew', SourcePath, TargetPath */
    end

  When Language = 'E' Then
    Do
      Address CMD '@COPY 'SourcePath'\English.Dll 'TargetPath'\Sqed.Dll';
      If rc <> 0 Then
        Call YNPrompt Value(Language||'_ERRCOP1'), '1'
/*      Call CopyFile 'whatsnew', SourcePath, TargetPath */
    End

  When Language = 'S' Then
    Do
      Address CMD '@COPY 'SourcePath'\Spanish.Dll 'TargetPath'\Sqed.Dll';
      If rc <> 0 Then
        Call YNPrompt Value(Language||'_ERRCOP1'), '1'
/*      Call CopyFile 'whatsnew', SourcePath, TargetPath     */
    End

  When Language = 'I' Then
    Do
      Address CMD '@COPY 'SourcePath'\Italian.Dll 'TargetPath'\Sqed.Dll';
      If rc <> 0 Then
        Call YNPrompt Value(Language||'_ERRCOP1'), '1'
/*      Call CopyFile 'whatsnew', SourcePath, TargetPath */
    End

  When Language = 'W' Then
    Do
      Address CMD '@COPY 'SourcePath'\Sweden.Dll 'TargetPath'\Sqed.Dll';
      If rc <> 0 Then
        Call YNPrompt Value(Language||'_ERRCOP1'), '1'
/*      Call CopyFile 'whatsnew', SourcePath, TargetPath     */
    End

  When Language = 'A' Then
    Do
      Address CMD '@COPY 'SourcePath'\Dansk.Dll 'TargetPath'\Sqed.Dll';
      If rc <> 0 Then
        Call YNPrompt Value(Language||'_ERRCOP1'), '1'
/*      Call CopyFile 'whatsnew', SourcePath, TargetPath */
    End

  When Language = 'D' Then
    Do
      Address CMD '@COPY 'SourcePath'\Dutch.Dll 'TargetPath'\Sqed.Dll';
      If rc <> 0 Then
        Call YNPrompt Value(Language||'_ERRCOP1'), '1'
/*      Call CopyFile 'whatsnew', SourcePath, TargetPath */
    End
End            /* of select */

/* Create folder/program object on desktop? */
Call SysCls
Say
Say '        ͻ'
Say '                                                                      '
Say '        'value(Language||'_OBJMSG1')
Say '                                                                      '
Say '        ͼ'
Say

Ret = YNPrompt(value(Language||'_OBJASK'), '0')
If Ret='Y'|Ret='J' Then Do
  /* first, create Sqed folder */
  G_FLDEXIST  = 'Es gibt schon einen Sqed/32 Ordner.'
  G_FLDEXIST1 = 'Sollen die bestehenden Objekte ersetzt werden: '

  E_FLDEXIST  = 'The Sqed/32 folder already exists.'
  E_FLDEXIST1 = 'Should I replace the objects? '

  A_FLDEXIST  = 'The Sqed/32 folder already exists.'
  A_FLDEXIST1 = 'Should I replace the objects? '

  D_FLDEXIST  = 'The Sqed/32 folder already exists.'
  D_FLDEXIST1 = 'Should I replace the objects? '

  I_FLDEXIST  = 'The Sqed/32 folder already exists.'
  I_FLDEXIST1 = 'Should I replace the objects? '

  S_FLDEXIST  = 'The Sqed/32 folder already exists.'
  S_FLDEXIST1 = 'Should I replace the objects? '

  W_FLDEXIST  = 'The Sqed/32 folder already exists.'
  W_FLDEXIST1 = 'Should I replace the objects? '

  title = "Sqed/32"
  classname = 'WPFolder'
  location = '<WP_DESKTOP>'
  setup = 'OBJECTID=<SQ32_Folder>;OPEN=DEFAULT'
  result=SysCreateObject(classname,title,location,setup,f)

  if result = 0 then
  do
    say ''
    say Value(Language||'_FLDEXIST')
    call YNPrompt value(Language||'_FLDEXIST1'), '1'
  end

  title = "Sqed/32"
  classname = 'WPProgram'
  location = '<SQ32_Folder>'
  setup = 'MINWIN=DESKTOP;PROGTYPE=PM;EXENAME='TargetPath'\SQED.EXE;STARTUPDIR='TargetPath
  rt = SysCreateObject(classname,title,location,setup,'u')

  If rt = 1 Then Do
    Say value(Language||'_OBJMSG3')
  end
  Else
    Say value(Language||'_OBJMSG4')
  end

  viewer=syssearchpath('PATH', 'VIEW.EXE')
  if viewer = '' then
  do
    say
    say 'Sorry, VIEW.EXE not found.  Online Help in INF-'
    say 'format copied, but NO object for viewing installed.'
    say
  end
  else do
    title = "Sqed/32 Manual"
    classname = 'WPProgram'
    location = '<SQ32_Folder>'
    setup = 'EXENAME='viewer';PARAMETERS='TargetPath'\SQED.INF'
    call SysCreateObject classname,title,location,setup,u
  end

  if viewer = '' then
  do
  end
  else do
    title = "Sqed/32 - History and latest information"
    classname = 'WPProgram'
    location = '<SQ32_Folder>'
    setup = 'EXENAME='viewer';PARAMETERS='TargetPath'\HISTORY.INF'
    call SysCreateObject classname,title,location,setup,u
  end

Say
Say value(Language||'_ALLOK')

Signal DONE

/* Some Routines, Signal Handler */
/* Language */
GetLanguage:
  Say
  Say "Choose language for dialogs:"
  Say
  Say           '         A - danish   D - dutch    E - english  G - german'
  Call GetInput '         I - italian  S - spanish  W - swedish              '
  Do Forever
    Key = SysGetKey( 'NOECHO' )
    Key = translate(Key)
    If Key = 'G' Then Do
      return Key
    End
    Else If Key = 'D' Then Do
      return Key
    End
    Else If Key = 'E' Then Do
      return Key
    End
    Else If Key = 'S' Then Do
      return Key
    End
    Else If Key = 'I' Then Do
      return Key
    End
    Else If Key = 'W' Then Do
      return Key
    End
    Else If Key = 'A' Then Do
      return Key
    End
    Else
      Call Beep 240,200
  End
  Say
End

/* Copy File */
CopyFile: Parse Arg ArgFile2Copy, ArgSourceDir, ArgTargetDir

/* dutch (ops english) strings */
D_ERRCOP = 'Warning: Cannot copy 'ArgFile2Copy'. Proceed ?'
D_MSGCOP = 'Copy 'ArgSourceDir||'\'||ArgFile2Copy' to 'ArgTargetDir||'\'||ArgFile2Copy'.'

/* deutsche Strings */
G_ERRCOP = 'Warnung! 'ArgFile2Copy' konnte nicht kopiert werden. Fortfahren?'
G_MSGCOP = 'Kopiere 'ArgSourceDir||'\'||ArgFile2Copy' nach 'ArgTargetDir||'\'||ArgFile2Copy'.'

/* english strings */
E_ERRCOP = 'Warning: Cannot copy 'ArgFile2Copy'. Proceed ?'
E_MSGCOP = 'Copy 'ArgSourceDir||'\'||ArgFile2Copy' to 'ArgTargetDir||'\'||ArgFile2Copy'.'

/* italian strings */
I_ERRCOP = 'Attenzione: non posso copiare 'ArgFile2Copy'. Continuo?'
I_MSGCOP = 'Copy 'ArgSourceDir||'\'||ArgFile2Copy' to 'ArgTargetDir||'\'||ArgFile2Copy'.'

/* spanish strings */
S_ERRCOP = 'Aviso: No se puede copiar 'ArgFile2Copy'. Proceder?'
S_MSGCOP = 'Copiar 'ArgSourceDir||'\'||ArgFile2Copy' a 'ArgTargetDir||'\'||ArgFile2Copy'.'

/* swedish strings */
W_ERRCOP = 'Varning: Kan ej kopiera 'ArgFile2Copy'. Fortstta ?'
W_MSGCOP = 'Kopierar 'ArgSourceDir||'\'||ArgFile2Copy' till 'ArgTargetDir||'\'||ArgFile2Copy'.'

/* danish strings */
A_ERRCOP = 'Warning: Cannot copy 'ArgFile2Copy'. Proceed ?'
A_MSGCOP = 'Copy 'ArgSourceDir||'\'||ArgFile2Copy' to 'ArgTargetDir||'\'||ArgFile2Copy'.'

  Say value(Language||'_MSGCOP')
  Address CMD '@COPY 'ArgSourceDir'\'ArgFile2Copy ArgTargetDir'\'ArgFile2Copy;
  if rc <> 0 Then Call YNPrompt value(Language||'_ERRCOP'), '1'
Return

/* Show Input prompt */
GetInput: Parse Arg ArgPrompt

  /* Cursor position */
  Parse Value SysCurPos() With Row .

  /* Screen Size */
  Parse Value SysTextScreenSize() With NumRows .

  /* End of Screen ? */
  if Row = NumRows - 1 Then Row = Row - 1

  /* Input */
  Col = Length( ArgPrompt ) + 1

  /* Show input */
  Say ArgPrompt
  Call SysCurPos Row, Col

  Return

/* Yes/No user prompt */
YNPrompt: Parse Arg ArgPrompt, ArgAbort

  Call GetInput ArgPrompt||value(Language||'_YN')

  Do Forever
    Key = SysGetKey( 'NOECHO' )
    Key = translate(Key)
    If Key = 'J'|Key = 'Y'Then Do
      Say
      Return Key
    End
    Else If Key = 'N' Then Do
      Say
      If ArgAbort = '1' Then exit
      Return Key
    End
  End

  Return 'Y'

/* Checks target drive */
CheckDrive:
  strname = FileSpec("drive",TargetPath)||"\DEL.ME"
  strtxt  = "result of a stupid drive check function, please delete"
  checkdrv = lineout(strname,strtxt)
  if checkdrv = 0 then do
    check = lineout(strname)
    chkfd = sysfiledelete(strname)
    return
  end
  else do
   Call SysCls
   say
   say value(Language||'_ERRLW1')
   say value(Language||'_ERRLW2')
   say
   exit
 end

/* Show help screen */
InstallNote:
  Call SysCls
  Say '        ͻ'
  Say '        '||value(Language||'_INST1')
  Say '        ͼ'
  Say
  Say value(Language||'_INST4')
  Say value(Language||'_INST5')
  Say value(Language||'_INST6')
  Say value(Language||'_INST7')
  Say value(Language||'_INST8')
  Say value(Language||'_INST9')
  Say value(Language||'_INST10')
  Say value(Language||'_INST11')
  Say value(Language||'_INST12')
  Say
  Say value(Language||'_INST14')
  Say value(Language||'_INST15')
  Say value(Language||'_INST16')
  Say
  Say value(Language||'_INST18')
  Say
  Say value(Language||'_INST20')
  Say value(Language||'_INST21')
  Say

  Call YNPrompt value(Language||'_CONT'), '1'
  Call SysCls

Return

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX syntax error.'
Signal DONE

DONE:
/* Fertig: Exit */
