
/**
***  This file is part of the source to QQLink, a FTS-9 reply linker for
*** use with the Squish(tm) mail processor.
*** Copyright (c) 1993 Josh Parsons. All rights reserved, however:
***
***         1) You are permitted to freely distribute this source,
***           provided you do not remove this copyright notice, and
***           provided you do not charge a fee, for the service of
***           distributing this material, over and above the value
***           of disks, phone tolls, etc. incurred in such distribution.
***        2) You are permitted to use executables produced from this
***           source in the manner described in QQLink.DOC, which should
***           accompany this file.
***        3) You are permitted to use this source in your own programs,
***           provided that your derivative work carries an
***           acknowledgement that portions of its source are derived
***           from QQLink, by Josh Parsons.
***
***        NB: This source carries no warrantee, implicit or explicit
***            of fitness for any particular task.
**/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include "MsgApi.h"
#include "qqdat.h"

#define LOCAL static

//#define PORTED_BY "Your name here"
//#define PORTED_TO "OS/2"

char kill_log=0,kill_qql=0,link_all=0,link_meth=LINK_FTS9;
char cfg_read=0,link_clean=0,use_colours=1,link_prune=0,link_passthru=0,link_slow=0;

char *all_name="";

static char h_att=0x17,l_att=0x13,s_att=0x16,p_att=0x02,e_att=0x11;

#define NORM_ATT 0x0100
#define HEADER_ATT h_att
#define LINKING_ATT l_att
#define SUMMARY_ATT s_att
#define HELP_ATT p_att
#define ERROR_ATT e_att
LOCAL void do_attr(int att,int do_bk) {
  char buf[32];
  char *s;
  if(!use_colours) return;
  if(att&0x0100) sprintf(buf,"\x1b[0m");
  else {
    if(att&0x0010) sprintf(buf,"\x1b[1;3%dm",att&7);
    else sprintf(buf,"\x1b[0;3%dm",att&7);
    };
  printf("%s\r",buf);
  if(!do_bk) return;
  for(s=buf;*s;s++) *s=' ';
  printf("%s\r",buf);
  };
LOCAL void cvtcol(char in,char *att) {
  static char tbl[]="krgybmcw";
  char *s=strchr(tbl,tolower(in));
  if(s) {
    *att=s-tbl;
    if(isupper(in)) *att|=0x10;
    };
  };
LOCAL void set_colours(const char *parm) {
  int i;
  if(strlen(parm)!=5) {
    printf("\nError in colourset \"%s\" - incorrect length.\n",parm);
    exit(13);
    };
  cvtcol(parm[0],&h_att);
  cvtcol(parm[1],&l_att);
  cvtcol(parm[2],&s_att);
  cvtcol(parm[3],&p_att);
  cvtcol(parm[4],&e_att);
  };

void q_config(void);

extern char *squishcfg_fname,*areasbbs_fname;
char *outlog_fname=NULL;
typedef struct area_t {
  struct area_t *next; // linked list
  char *tag,*path; // echotag and path
  char is_sq;  // area is .SQ format
  char dolink; // area is tagged to be linked
  char subj;   // future expansion
  char is_net; // is a netmail area
  } AREA;

AREA *rootarea=NULL;

void add_area(const char *tag,const char *path,int is_sq,int is_net) {
  AREA *ar=calloc(1,sizeof(AREA));
  if(ar==NULL) return;
  ar->tag=strdup(tag);
  ar->path=strupr(strdup(path));
  if(ar->path[strlen(ar->path)-1]=='\\') ar->path[strlen(ar->path)-1]=0;
  ar->is_sq=is_sq;
  ar->is_net=is_net;
  if(link_all) ar->dolink=1;
  else ar->dolink=0;
  ar->next=rootarea;
  rootarea=ar;
  };
AREA *findarea(const char *tag) {
  AREA *ar;
  for(ar=rootarea;ar;ar=ar->next) if(!stricmp(ar->tag,tag)) break;
  return ar;
  };

/**
*** To do: message expiry here...
**/

int do_prune(MSG *area,int is_sq) {
/*  MSGH *msg=NULL;
  long i,maxmsgs=0,minmsgs=0,maxdays=0;
  if(is_sq) SquishGetMaxMsg(area,(dword *)&maxmsgs,(dword *)&minmsgs,(dword *)&maxdays);
  if(MsgHighMsg(area)<minmsgs) return 0;
  if(maxdays<1) return 0;
  for(i=1;i<MsgHighMsg(area);i++) {
    msg=MsgOpenMsg(area,MOPEN_RW,i);
    if(msg) break;
    };
  if(msg==NULL) return 0;
           */
  return 0;
  };

LOCAL void bkspace(int i) {
  while(i-->0) putchar(8);
  };

#define CENT(num,den) (int)(((long)num*100)/den)
LOCAL int link_upd(long msgn,long msgh,int nmsg,int num2link) {
  int cent;
  if(num2link==0) nmsg=num2link=1; // Avoid dividing by zero
  cent=CENT(nmsg,num2link);
  if(cent>100) cent=100;
  if(cent<0) cent=0;
  return printf("%04ld/%04ld (%02d%%)",msgn,msgh,cent);
  };

int link_area(char *name,int is_sq,int is_net) {
  MSG *area=NULL;
  QQDAT *qq=NULL;
  int nlinked=0,nided=0,nmsg=0,goback,num2link;
  long msgn,msgh;
  time_t tt=0;
  printf("Reading...");
  bkspace(10);
  area=MsgOpenArea(name,MSGAREA_CRIFNEC,(is_sq?MSGTYPE_SQUISH:MSGTYPE_SDM)|((is_net||is_sq)?0:MSGTYPE_ECHO));
  if(area) qq=open_qq(name,area,is_sq,link_meth);
  if(area) MsgLock(area);
  if(area!=NULL&&qq!=NULL) {
    msgh=MsgGetHighMsg(area);
    if(kill_qql) {
      qq->oldhigh=0;
      msgn=0;
      }
    else msgn=MsgUidToMsgn(area,qq->f.high,UID_NEXT);
    num2link=msgh-msgn;
    goback=link_upd(msgn,msgh,nmsg,num2link);
    if(msgn<msgh) {
      while(msgn<=msgh) {
        MSGH *msg=MsgOpenMsg(area,MOPEN_RW,msgn);
        if(msg) switch(link_qq(qq,msg,MsgMsgnToUid(area,msgn),link_clean)) {
          case(3): // linked sucessfully!
            nlinked++;
          case(2): // original has expired
          case(1): // message is not a reply
            nided++;
          case(0): // message does not use FTS-9
            nmsg++;
          };
        if(msg) MsgCloseMsg(msg);
        if(time(NULL)>tt) {
          bkspace(goback);
          goback=link_upd(msgn,msgh,nmsg,num2link);
          time(&tt);
          };
        msgn++;
        };
      bkspace(goback);
      goback=link_upd(msgn-1,msgh,nmsg,num2link);
      };
    }
  else printf("Error!");
  if(qq) {
    int id_pc=percent_qq(qq,msgh);
    goback+=printf(" Writing...");
    close_qq(qq);
    bkspace(goback);
    if(is_sq&&link_prune) {
      long n_pruned=0,n2prune=MsgHighMsg(area);
      tt=0;
      while(do_prune(area,is_sq)) {
        n_pruned++;
        if(time(NULL)>tt) {
          time(&tt);
          goback=printf("%04ld/%04ld (pruning) ",n_pruned,n2prune);
          bkspace(goback);
          };
        };
      };
    if(link_meth==LINK_SUBJ)
      printf("%04d/%04d linked              ",nlinked,num2link);
    else
      printf("%04d/%04d linked  %02d%% MSGID ",nlinked,num2link,id_pc);
    };
  if(area) MsgUnlock(area);
  if(area) MsgCloseArea(area);
  return nmsg;
  };

int link_echo(AREA *ar) {
  int i,n;
  printf("Linking %s",ar->tag);
  for(i=strlen(ar->tag)+8;i<48;i++) putchar(' ');
  n=link_area(ar->path,ar->is_sq,ar->is_net);
  printf("\n");
  return n;
  };

#define PARJCMP(x,y) strncmp(x,y,strlen(y))
#define PARCMP(x,y) strnicmp(x,y,strlen(y))
#define PARGET(x,y) ((x)+strlen(y))

LOCAL void read_echolog(const char *echolog_fname,int kill) {
  FILE *fin;
  char buf[32];
  if(echolog_fname==NULL) return;
  if(!cfg_read) {
    q_config();
    cfg_read++;
    };
  fin=fopen(echolog_fname,"r");
  if(fin==NULL) return;
  while(!feof(fin)) {
    AREA *ar;
    fgets(buf,32,fin);
    if(strchr(buf,'\n')) *strchr(buf,'\n')=0;
    ar=findarea(buf);
    if(ar) ar->dolink=1;
    };
  fclose(fin);
  if(kill) unlink(echolog_fname);
  };
LOCAL void read_antilog(const char *echolog_fname,int kill) {
  FILE *fin;
  char buf[32];
  if(echolog_fname==NULL) return;
  if(!cfg_read) {
    q_config();
    cfg_read++;
    };
  fin=fopen(echolog_fname,"r");
  if(fin==NULL) return;
  while(!feof(fin)) {
    AREA *ar;
    fgets(buf,32,fin);
    if(strchr(buf,'\n')) *strchr(buf,'\n')=0;
    ar=findarea(buf);
    if(ar) ar->dolink=0;
    };
  fclose(fin);
  if(kill) unlink(echolog_fname);
  };


static void help(void) {
  printf("Usage: QQLink [-c<Squish.CFG>] [<Areas>] [-k] [-r] [-l] [-f<EchoToss.Log>]\n");
  printf("   or: QQLink [-a<Areas.BBS>] [<Areas>] [-k] [-r] [-l] [-f<EchoToss.Log>]\n\n");
//  printf("   or: QQLink <Area path> -*\n\n");
  printf("    -c, and -a are ways of specifying your areas.\n");
  printf("    -f names a file containing a list of area tags to link.\n");
  printf("    -r means relink any already linked messages.\n");
  printf("    -l means link every area listed in Squish.CFG or Areas.BBS\n");
  printf("    -k means delete <EchoToss.log> after linking.\n");
  printf("    <Areas> is a list of echo tags of areas you want linked.\n\n");
//  printf("    <Area path> is the path to a Squish (or *.MSG, with -*) message area.\n\n");
  printf("Example: QQLink -c\\Squish\\Squish.CFG NETMAIL -fin.log\n");
  printf("         This will read \\SQUISH\\SQUISH.CFG for area definitions, and link\n");
  printf("         any new messages in NETMAIL and the areas listed in IN.LOG.\n\n");
  exit(1);
  };
/*
LOCAL void help(void) {
  extern char help_screen[];
  *strstr(help_screen,"###END###")=0;
  do_attr(HELP_ATT,1);
  printf("%s",help_screen);
  do_attr(NORM_ATT,1);
  exit(1);
  };
*/
LOCAL void write_outlog(const char *fn) {
  AREA *ar;
  FILE *fout=fopen(fn,"a");
  if(fout==NULL) return;
  for(ar=rootarea;ar;ar=ar->next)
    if(ar->dolink) fprintf(fout,"%s\n",ar->tag);
  fclose(fout);
  };

static void pre_param(const char *arg) {
    if(!stricmp(arg,"-u")||!stricmp(arg,"/UGLY"))
      use_colours=0;
    else if(!PARCMP(arg,"-u")) set_colours(arg+2);
    else if(!PARCMP(arg,"/UGLY:")) set_colours(arg+6);
    };
static void post_param(const char *arg) {
    if(!stricmp(arg,"/?")) help();
    else if(!strcmp(arg,"-?")) help();
    else if(!PARJCMP(arg,"-u")) /* UGLY mode */;
    else if(!strcmp(arg,"-k")) kill_log=1;
    else if(!strcmp(arg,"-k+")) kill_log=1;
    else if(!strcmp(arg,"-k-")) kill_log=0;
    else if(!strcmp(arg,"-r")) kill_qql=1;
    else if(!strcmp(arg,"-l")) link_all=1;
    else if(!strcmp(arg,"-s")) link_meth=LINK_SUBJ;
    else if(!strcmp(arg,"-m")) link_meth=LINK_COM1;
    else if(!strcmp(arg,"-n")) link_clean=1;
    else if(!strcmp(arg,"-p")) link_prune=1;
    else if(!strcmp(arg,"-pt")) link_passthru=1;
    else if(!strcmp(arg,"-S")) link_slow=1;
    else if(!PARJCMP(arg,"-f")) read_echolog(arg+2,kill_log);
    else if(!PARJCMP(arg,"-x")) read_antilog(arg+2,kill_log);
    else if(!PARJCMP(arg,"-o")) outlog_fname=strdup(arg+2);
    else if(!PARJCMP(arg,"-c")) squishcfg_fname=strdup(arg+2);
    else if(!PARJCMP(arg,"-a")) areasbbs_fname=strdup(arg+2);
    else if(!PARJCMP(arg,"-T")) trunc_qq=atoi(arg+2);
    else if(!PARJCMP(arg,"-t")) all_name=strdup(arg+2);
//    else if(!PARCMP(arg,"-d")) cancel_parm=arg+2;
//    else if(!PARCMP(arg,"-*")) /* add arg+2 as a *.MSG area */;
//    else if(!PARCMP(arg,"-$")) /* add arg+2 as a *.SQ? area */;
    else if(!stricmp(arg,"/HELP")) help();
    else if(!PARCMP(arg,"/UGLY")) /* UGLY mode */;
    else if(!stricmp(arg,"/KILL")) kill_log=1;
    else if(!stricmp(arg,"/NOKILL")) kill_log=0;
    else if(!stricmp(arg,"/RELINK")) kill_qql=1;
    else if(!stricmp(arg,"/ALL")) link_all=1;
    else if(!stricmp(arg,"/SUBJ")) link_meth=LINK_SUBJ;
    else if(!stricmp(arg,"/MIXED")) link_meth=LINK_COM1;
    else if(!stricmp(arg,"/CLEAN")) link_clean=1;
    else if(!stricmp(arg,"/PRUNE")) link_prune=1;
    else if(!stricmp(arg,"/LINKPASS")) link_passthru=1;
    else if(!stricmp(arg,"/SLOW")) link_slow=1;
    else if(!PARCMP(arg,"/LOG:")) read_echolog(arg+5,kill_log);
    else if(!PARCMP(arg,"/XLOG:")) read_antilog(arg+6,kill_log);
    else if(!PARCMP(arg,"/OUT:")) outlog_fname=strdup(arg+5);
    else if(!PARCMP(arg,"/CFG:")) squishcfg_fname=strdup(arg+5);
    else if(!PARCMP(arg,"/AREAS:")) areasbbs_fname=strdup(arg+7);
    else if(!PARCMP(arg,"/TRUNC:")) trunc_qq=atoi(arg+7);
    else if(!PARCMP(arg,"/TOALL:")) all_name=strdup(arg+7);
    else if(!stricmp(arg,"/TOALL")) all_name=NULL;
//    else if(!PARCMP(arg,"-d")) cancel_parm=arg+2;
//    else if(!PARCMP(arg,"/MSG:")) /* add arg+2 as a *.MSG area */;
//    else if(!PARCMP(arg,"/SQ:")) /* add arg+2 as a *.SQ? area */;
    else if(*arg=='/'||*arg=='-') {
      do_attr(ERROR_ATT,0);
      printf("Unrecognised option: \"%s\". %s\n\n",arg,"(Run QQLink -? for a list of options)");
//      help();
      do_attr(NORM_ATT,1);
      exit(7);
      };
  };

void env_args(char *buf,void (*do_arg)(const char *arg)) {
  char *s=buf;
  while(*s) {
    if(isspace(*s)) s++;
    else {
      char *end=s+strcspn(s," \r\n\x9");
      char old=*end;
      *end=0;
      do_arg(s);
      *(s=end)=old;
      };
    };
  };

int cdecl main(int argc,char **argv) {
  struct _minf minf={0,0,0};
  int i,nlinked=0,alinked=0;
  time_t tstart,tdone;
  AREA *ar;
  if(getenv("QQLINK")) env_args(getenv("QQLINK"),pre_param);
  for(i=1;i<argc;i++) pre_param(argv[i]);
  do_attr(NORM_ATT,0);
  do_attr(HEADER_ATT,0);
  printf("QQLink V1.24 for Squish(tm)  *  A Strange Software\n");
  printf("Copyright (c) 1993 Josh Parsons (3:771/330.64). All rights reserved.\n\n");
#ifdef PORTED_BY
  printf("Ported to %s by %s.\n",PORTED_TO,PORTED_BY);
#endif
  if(getenv("QQLINK")) env_args(getenv("QQLINK"),post_param);
  for(i=1;i<argc;i++) post_param(argv[i]);
  if(!cfg_read) {
    q_config();
    cfg_read++;
    };
  do_attr(LINKING_ATT,1);
  MsgOpenApi(&minf);
  time(&tstart);
  for(i=1;i<argc;i++) if(*argv[i]!='-'&&*argv[i]!='/') {
    if(*argv[i]=='*') add_area(argv[i],argv[i]+1,0,0);
    else if(*argv[i]=='$') add_area(argv[i],argv[i]+1,1,0);
    ar=findarea(argv[i]);
    if(ar==NULL) {
      do_attr(ERROR_ATT,1);
      printf("Unrecognised area \"%s\"\n",argv[i]);
      do_attr(NORM_ATT,1);
      exit(5);
      };
/*    nlinked+=link_echo(ar);
    alinked++;*/
    ar->dolink=1;
    };
  /*if(nlinked==0)*/ for(ar=rootarea;ar;ar=ar->next) if(ar->dolink) {
    nlinked+=link_echo(ar);
    alinked++;
    };
  time(&tdone);
  tdone-=tstart;
  if(tdone==0) tdone=1;
  do_attr(SUMMARY_ATT,1);
  if(alinked) printf("\n%d message%s in %d area%s linked in %ld second%s (%d.%d msgs/sec)\n",
    nlinked,
    nlinked==1?"":"s",
    alinked,
    alinked==1?"":"s",
    tdone,
    tdone==1?"":"s",
    (int)(nlinked/tdone),
    (int)(((10L*nlinked)/tdone)%10L));
  else printf("\nNo areas linked. %s\n",argc==1?"(Run QQLink -? for a list of options)":"");
  MsgCloseApi();
  if(outlog_fname) write_outlog(outlog_fname);
  do_attr(NORM_ATT,1);
  return 0;
  };
