
/* A simple terminal program,  using comm.dll.
 *
 * This program avoids polling by using a second thread.
 *
 * MSC 5/6:  cl /Ox /W3 /Lp /G2 term.c maxcomm.lib
 */

#define INCL_NOPM
#define INCL_DOS
#define INCL_VIO
#define INCL_DOSDEVIOCTL
#include <os2.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "comm.h"

TID _loadds cdecl far BeginThread( void (cdecl _loadds far *func)(void *param),
                                   int StackSize,
                                   void far *param);

static int alive = 1;

#pragma check_stack(off)

void far cdecl _loadds readThread(void far *p)
{
    HCOMM hc = *(HCOMM far *)p;
    USHORT bytes, bw;
    BYTE buf[1000];
    static char msg[] = "Error\r\n";

    while(alive){
        if(!ComRxWait(hc, -1L)){         // wait for something.
            ComRead(hc, buf, sizeof(buf), &bytes);
            DosWrite(1, buf, bytes, &bw);
        }
        else{
            VioWrtTTY(msg, strlen(msg), 0);
            if(!ComIsOnline(hc))
                DosExit(EXIT_PROCESS, 0);
        }
    }
}

void cdecl main(int argc, char **argv)
{
    HCOMM hcR;
    USHORT rc;
    int done = FALSE;
    int c;

    rc = ComOpen(argv[1],  &hcR, 0, 0);
    if(rc){
        printf("SYS%04u: Couldn't open %s\n", rc, argv[1]);
        exit(0);
    }
    //ComSetBaudRate(hcR, 2400L, 'n', 8, 1);
    BeginThread(readThread, 2048, &hcR);
    if(argc>2)      /* if the user supplies a 2nd argument (any arg),  turn on
                     * the carrier check. */
        ComWatchDog(hcR, TRUE, 5);
    while(!done){
        c = getch();
        if(c == 0xe0)
            c = 0;
        ComPutc(hcR, c);
        if(c==0)        /* quit if a function key is pressed */
            done = TRUE;
    }
    ComTxWait(hcR, -1L);
    ComClose(hcR);
}

