
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>
#include <stdio.h>
#include <math.h> 	/* need math.h on SGI 4D/?? for atof() function */
#include "df.h"

#include "fdefs.h"

#include "fvars.com"

#define NOPTS 21
#define MINARGS 3

#define NTSC_XSIZ 640
#define NTSC_YSIZ 480

main(argc,argv)
int argc;
char *argv[];
{
	char *pname,*pstr;
	float pver;
	unsigned short dev_month,dev_year;
	int err_ret,nopts,nargs;
	char pstat;
	char *opt_array[NOPTS],*opt_desc[NOPTS];
	int opt_loc[NOPTS];

	char *hfile,*cfile,*lutfile,*opfile;
	char *ax_str,*ay_str,*az_str;
	unsigned char *hbuff,*hbuf24,*cbuff,palette[PALBUFSIZE][3];
	int hflag24;
	short ir,ig,ib;
	int opt_ptr,num_bytes;
	long hxsize,hysize,hzsize,idims[4];
	long cxsize,cysize,czsize,tsize;
	int ispal,iscpal,pil,opf_flag,win_parms[6];
	long x1,y1,x2,y2;
	short dev,val;
	Colorindex ic,ic1;
	register int i;
	Func_ptr *gx_func;
	long illum_mod;

	float rx,ry,rz,tx,ty,tz,sx,sy,sz,lx,ly,lz,lr,lg,lb,ka,kd,ks,ns;
	long br,bg,bb,bkc_flag;
	long swapxy_flag;
	long xrate,yrate,lwidth;
	float fmat[NOPTS][3];

	pname = "hcvis";
	pver = 1.10;
	dev_month = 5;
	dev_year = 1990;
	pstat = 'D';
	pstr = "public domain software";

	opt_desc[0] = "hcvis [-options] <height_file> <color_file>";
	opt_array[0] = opt_desc[0];
	opt_array[ROT] = "-r";  opt_desc[ROT] = "<rx ry rz>";
	opt_array[TRA] = "-t";  opt_desc[TRA] = "<tx ty tz>";
	opt_array[SCA] = "-s";  opt_desc[SCA] = "<sx sy sz>";
	opt_array[LLO] = "-ll"; opt_desc[LLO] = "<lx ly lz>";
	opt_array[LCO] = "-lc"; opt_desc[LCO] = "<lr lg lb>";
	opt_array[KCO] = "-k";  opt_desc[KCO] = "<Ka Kd Ks>";
	opt_array[NSV] = "-ns"; opt_desc[NSV] = "<Ns>";
	opt_array[OD2] = "-ad"; opt_desc[OD2] = "(use alternate defaults)";
	opt_array[NTS] = "-ntsc";  opt_desc[NTS] = "(use ntsc size viewport)";
	opt_array[VPT] = "-v";  opt_desc[VPT] = "<xorg yorg xsize ysize>";
	opt_array[ILU] = "-i";  opt_desc[ILU] = "<illumination_model[0,1]>";
	opt_array[COL] = "-c";  opt_desc[COL] = "<color_palette_file_name>";
	opt_array[BKC] = "-bc";  opt_desc[BKC] = "<br bg bb>";
	opt_array[AXS] = "-axes"; opt_desc[AXS] = "<x_string y_string z_string>";
	opt_array[OO8] = "-O8";  opt_desc[OO8] = "(use 8 bit/pixel output)";
	opt_array[RLF] = "-R";  opt_desc[RLF] = "(use RELIEF representation)";
	opt_array[WFM] = "-W";  opt_desc[WFM] = "<x_sample y_sample line_width>";
	opt_array[OPR] = "-p";  opt_desc[OPR] = "(print current settings)";
	opt_array[SXY] = "-swapxy";  opt_desc[SXY] = "(swap the X and Y data dimensions)";
	opt_array[OPF] = "-o";  opt_desc[OPF] = "<output_file_name>";
	nopts = NOPTS;

	win_parms[0] = 0;
	win_parms[1] = 0;
	win_parms[2] = 0;
	win_parms[3] = 0;
	win_parms[4] = 0;
	win_parms[5] = 1;

	illum_mod = 1;

	rx = 0.0;  ry = 0.0;  rz = 0.0;
	tx = 0.0;  ty = 0.0;  tz = 0.0;
	sx = 1.0;  sy = 1.0;  sz = 1.0;
	lx = 0.0;  ly = 0.0;  lz = 1.0;
	lr = 1.0;  lg = 1.0;  lb = 1.0;
	ka = 0.3;  kd = 0.7;  ks = 0.0;
	ns = 3.0;
	xrate = 1; yrate = 1; lwidth = 1;
	br = 0; bg = 0; bb = 0; bkc_flag = 0;
	swapxy_flag = 0;

	err_ret = prog_title(pname,pver,dev_month,dev_year,pstat,pstr);

	if (argc < MINARGS){
		err_ret = prog_opts(nopts,opt_array,opt_desc);
		exit(1);
	}

	if (argc > MINARGS)
		err_ret = opt_index(argv,opt_array,argc,nopts,opt_loc);

	hfile  = argv[argc-2];
	cfile  = argv[argc-1];

/* determine what's in the height HDF file */

Hdf8:
	hflag24 = 0;
	err_ret = DFR8getdims(hfile,&hxsize,&hysize,&ispal);
	if (err_ret){
		goto Hdf24;
	}
	else{
		hzsize = 1;
		num_bytes = hxsize * hysize * hzsize * sizeof(char);
		hbuff = (unsigned char *)malloc(num_bytes);
		if (!hbuff){
			printf("%s: Not enough memory\n",hfile);
			exit(1);
		}
		err_ret = DFR8getimage(hfile,hbuff,hxsize,hysize,palette);
		if (err_ret){
			printf("%s: Error with DFR8getimage\n",hfile);
			exit(1);
		}
		goto Hdfdone;
	}

Hdf24:
	err_ret = DF24getdims(hfile,&hxsize,&hysize,&pil);
	if (err_ret){
		goto Hdfsd;
	}
	else{
		num_bytes = hxsize * hysize * sizeof(char);
		hbuff = (unsigned char *)malloc(num_bytes);
		if (!hbuff){
			printf("%s: Not enough memory\n",hfile);
			exit(1);
		}
		hzsize = 3;
		hflag24 = 1;
		num_bytes = hxsize * hysize * hzsize * sizeof(char);
		hbuf24 = (unsigned char *)malloc(num_bytes);
		if (!hbuf24){
			printf("%s: Not enough memory\n",hfile);
			exit(1);
		}
		if (pil != 0){
/*			DF24reqil(0); */
			pil = 0;
		}
		err_ret = DF24getimage(hfile,hbuf24,hxsize,hysize);
		if (err_ret){
			printf("%s: Error with DF24getimage\n",hfile);
			exit(1);
		}
	printf("WARNING: '%s' is a true color 24 bit image.\n",hfile);
	puts("RGB values will be converted into single scalar intensitites");
	puts("which will be used to establish the height field geometry");
		err_ret = img24_tobw(hbuf24,hbuff,hxsize,hysize);
		if (err_ret){
			printf("%s: Error converting RGB intensities\n",hfile);
			exit(1);
		}
		if (strcmp(cfile,hfile))
			free(hbuf24);
		hzsize = 1;

		goto Hdfdone;
	}

Hdfsd:
	err_ret = gx_sdgetdim(hfile,&hxsize,&hysize);
	if (err_ret){
		printf("%s: Cannot open file\n",hfile);
		exit(1);
	}
	else{
		hzsize = 1;
		num_bytes = hxsize * hysize * hzsize * sizeof(char);
		hbuff = (unsigned char *)malloc(num_bytes);
		if (!hbuff){
			printf("%s: Not enough memory\n",hfile);
			exit(1);
		}
		err_ret = gx_sdgetdata(hfile,hbuff,hxsize,hysize);
		if (err_ret){
			printf("%s: Error with DFSDgetdata\n",hfile);
			exit(1);
		}
	}

Hdfdone:

	if (!strcmp(cfile,"WHITE")){
		cbuff = hbuff;
		cxsize = hxsize;
		cysize = hysize;
		czsize = 1;
		goto Cdfdone;
	}
	if (!strcmp(cfile,hfile)){
		if (hflag24){
			cbuff = hbuf24;
			czsize = 3;
		}
		else{
			cbuff = hbuff;
			czsize = 1;
		}
		cxsize = hxsize;
		cysize = hysize;
		goto Cdfdone;
	}

	err_ret = DFR8getdims(cfile,&cxsize,&cysize,&ispal);
	if (err_ret){
		goto Cdf24;
	}
	czsize = 1;
	num_bytes = cxsize * cysize * czsize * sizeof(char);
	cbuff = (unsigned char *)malloc(num_bytes);
	if (!cbuff){
		printf("%s: Not enough memory\n",cfile);
		exit(1);
	}
	err_ret = DFR8getimage(cfile,cbuff,cxsize,cysize,palette);
	if (err_ret){
		printf("%s: Error with DFR8getimage\n",cfile);
		exit(1);
	}
	goto Cdfdone;

Cdf24:
	err_ret = DF24getdims(cfile,&cxsize,&cysize,&pil);
	if (err_ret){
		goto Cdfsd;
	}
	czsize = 3;
	if (pil != 0){
/*		DF24reqil(0); */
		pil = 0;
	}
	num_bytes = cxsize * cysize * czsize * sizeof(char);
	cbuff = (unsigned char *)malloc(num_bytes);
	if (!cbuff){
		printf("%s: Not enough memory\n",cfile);
		exit(1);
	}
	err_ret = DF24getimage(cfile,cbuff,cxsize,cysize);
	if (err_ret){
		printf("%s: Error with DF24getimage\n",cfile);
		exit(1);
	}
	goto Cdfdone;

Cdfsd:
	err_ret = gx_sdgetdim(cfile,&cxsize,&cysize);
	if (err_ret){
		printf("%s: Cannot open file\n",cfile);
		exit(1);
	}
	else{
		czsize = 1;
		num_bytes = cxsize * cysize * czsize * sizeof(char);
		cbuff = (unsigned char *)malloc(num_bytes);
		if (!cbuff){
			printf("%s: Not enough memory\n",cfile);
			exit(1);
		}
		err_ret = gx_sdgetdata(cfile,cbuff,cxsize,cysize);
		if (err_ret){
			printf("%s: Error with DFSDgetdata\n",cfile);
			exit(1);
		}
	}

Cdfdone:

	if ((hxsize != cxsize) || (hysize != cysize)){
		printf("%s %s: Files have different sizes\n",hfile,cfile);
		exit(1);
	}

	opt_ptr = opt_loc[SXY];
	if (opt_ptr){
		swapxy_flag = 1;
		tsize = cxsize;
		cxsize = cysize;
		cysize = tsize;
		tsize = hxsize;
		hxsize = hysize;
		hysize = tsize;
	}

	opt_ptr = opt_loc[ROT];
	if (opt_ptr){
		rx = atof(argv[++opt_ptr]);
		ry = atof(argv[++opt_ptr]);
		rz = atof(argv[++opt_ptr]);
		}

	opt_ptr = opt_loc[TRA];
	if (opt_ptr){
		tx = atof(argv[++opt_ptr]);
		ty = atof(argv[++opt_ptr]);
		tz = atof(argv[++opt_ptr]);
		}

	opt_ptr = opt_loc[SCA];
	if (opt_ptr){
		sx = atof(argv[++opt_ptr]);
		sy = atof(argv[++opt_ptr]);
		sz = atof(argv[++opt_ptr]);
		}

	opt_ptr = opt_loc[LLO];
	if (opt_ptr){
		lx = atof(argv[++opt_ptr]);
		ly = atof(argv[++opt_ptr]);
		lz = atof(argv[++opt_ptr]);
		}

	opt_ptr = opt_loc[LCO];
	if (opt_ptr){
		lr = atof(argv[++opt_ptr]);
		lg = atof(argv[++opt_ptr]);
		lb = atof(argv[++opt_ptr]);
		}

	opt_ptr = opt_loc[KCO];
	if (opt_ptr){
		ka = atof(argv[++opt_ptr]);
		kd = atof(argv[++opt_ptr]);
		ks = atof(argv[++opt_ptr]);
	}

	opt_ptr = opt_loc[NSV];
	if (opt_ptr)
		ns = atof(argv[++opt_ptr]);

	if (opt_loc[OD2]){
		rx =  -45.0;   ry =   45.0;   rz =    0.0;
		tx =    0.0;   ty =    0.0;   tz =   -1.0;
		sx =    2.0;   sy =    2.0;   sz =    0.25;
		lx =   -3.0;   ly =    4.0;   lz =    7.0;
		lr =    0.9;   lg =    0.9;   lb =    0.9;
		ka =    0.3;   kd =    0.7;   ks =    0.0;
		ns =    3.0;
		xrate = 2; yrate = 2; lwidth = 2;
	}

	if (opt_loc[NTS]){
		win_parms[0] = 0;
		win_parms[1] = 0;
		win_parms[2] = NTSC_XSIZ;
		win_parms[3] = NTSC_YSIZ;
		win_parms[4] = 2;
		win_parms[5] = 1;
	}

	opt_ptr = opt_loc[VPT];
	if (opt_ptr){
		x1 = atol(argv[++opt_ptr]);
		y1 = atol(argv[++opt_ptr]);
		x2 = atol(argv[++opt_ptr]);
		y2 = atol(argv[++opt_ptr]);
		win_parms[0] = x1;
		win_parms[1] = y1;
		win_parms[2] = x2;
		win_parms[3] = y2;
		win_parms[4] = 2;
		win_parms[5] = 1;
	}

	opt_ptr = opt_loc[BKC];
	if (opt_ptr){
		br = atol(argv[++opt_ptr]);
		bg = atol(argv[++opt_ptr]);
		bb = atol(argv[++opt_ptr]);
		bkc_flag = 1;
	}
	br = max(br,0);
	br = min(br,255);
	bg = max(bg,0);
	bg = min(bg,255);
	bb = max(bb,0);
	bb = min(bb,255);

	opt_ptr = opt_loc[ILU];
	if (opt_ptr){
		illum_mod = atol(argv[++opt_ptr]);
	}
	illum_mod = max(illum_mod,0);
	illum_mod = min(illum_mod,1);

	opt_ptr = opt_loc[WFM];
	if (opt_ptr){
		xrate = atol(argv[++opt_ptr]);
		yrate = atol(argv[++opt_ptr]);
		lwidth = atol(argv[++opt_ptr]);
		RELIEF = 0;
		POLYGON = 0;
		WIREFRAME = 1;
		illum_mod = 0;
		SCREEN_BITS = 24;
		win_parms[5] = 1;
	}
	xrate = max(xrate,1);
	yrate = max(yrate,1);
	lwidth = max(lwidth,1);

	opt_ptr = opt_loc[AXS];
	if (opt_ptr){
		ax_str = argv[++opt_ptr];
		ay_str = argv[++opt_ptr];
		az_str = argv[++opt_ptr];
	}

	opt_ptr = opt_loc[COL];
	iscpal = opt_ptr;
	if (opt_ptr){
		lutfile = argv[++opt_ptr];
	}

	if (opt_loc[OO8]){
		SCREEN_BITS = 8;
		if(illum_mod == 0) win_parms[5] = 0;
	}

	if (opt_loc[RLF]){
		RELIEF = 1;
		POLYGON = 0;
		WIREFRAME = 0;
		illum_mod = 1;
		SCREEN_BITS = 24;
		win_parms[5] = 1;
	}

	opt_ptr = opt_loc[OPF];
	opf_flag = opt_ptr;
	if (opt_ptr){
		opfile = argv[++opt_ptr];
	}

	if((opt_loc[OO8]) && (!opf_flag) && (SCREEN_BITS == 24))
		printf("WARNING: -O8 option ignored\n");

	if (opt_loc[OPR]){
	printf("           %s %9.2f %9.2f %9.2f \\\n",opt_array[ROT],rx,ry,rz);
	printf("           %s %9.2f %9.2f %9.2f \\\n",opt_array[TRA],tx,ty,tz);
	printf("           %s %9.2f %9.2f %9.2f \\\n",opt_array[SCA],sx,sy,sz);
	printf("           %s %9.2f %9.2f %9.2f \\\n",opt_array[LLO],lx,ly,lz);
	printf("           %s %9.2f %9.2f %9.2f \\\n",opt_array[LCO],lr,lg,lb);
	printf("           %s %9.2f %9.2f %9.2f \\\n",opt_array[KCO],ka,kd,ks);
	printf("           %s %9.2f \\\n",opt_array[NSV],ns);
	if (opt_loc[OD2]) printf("           %s \\\n",opt_array[OD2]);
	if (opt_loc[NTS]) printf("           %s \\\n",opt_array[NTS]);
	printf("           %s %7d %7d %7d %7d \\\n",opt_array[VPT],win_parms[0],win_parms[1],win_parms[2],win_parms[3]);
	printf("           %s %4d \\\n",opt_array[ILU],illum_mod);
	if (opt_loc[COL]) printf("           %s   %s \\\n",opt_array[COL],lutfile);
	printf("           %s %6d %6d %6d \\\n",opt_array[BKC],br,bg,bb);
	if (opt_loc[OO8]) printf("           %s \\\n",opt_array[OO8]);
	if (opt_loc[RLF]) printf("           %s \\\n",opt_array[RLF]);
	if (opt_loc[WFM]) printf("           %s %6d %6d %5d \\\n",opt_array[WFM],xrate,yrate,lwidth);
	if (opt_loc[OPR]) printf("           %s \\\n",opt_array[OPR]);
	if (opt_loc[OPF]) printf("           %s   %s \\\n",opt_loc[OPF],opfile);
	printf("           %s   %s\n",hfile,cfile);
	printf("\n");
	}

	if (!strcmp(cfile,"WHITE")){
		for(ic=0; ic < PALBUFSIZE; ic++){
			palette[ic][0] = 255;
			palette[ic][1] = 255;
			palette[ic][2] = 255;
		}
	}
	else if (iscpal){
		err_ret = DFPgetpal(lutfile,palette);
		if (err_ret){
			err_ret = seqpal_io(lutfile,"rb",palette);
			if (err_ret){
				printf("%s: i/o error\n",lutfile);
				exit(1);
			}
			else
				printf("WARNING: '%s' palette read as non-HDF raw binary\n",lutfile);
		}
	}
	else if ((!iscpal) && (!ispal)){
		for(ic=0; ic < PALBUFSIZE; ic++){
			palette[ic][0] = (unsigned char)ic;
			palette[ic][1] = (unsigned char)ic;
			palette[ic][2] = (unsigned char)ic;
		}
	}

	if ((bkc_flag) && (SCREEN_BITS == 8)){
		printf("WARNING: -bc option overwriting palette entry zero\n");
		palette[0][0] = (unsigned char)br;
		palette[0][1] = (unsigned char)bg;
		palette[0][2] = (unsigned char)bb;
	}

	fmat[ROT][0] = rx; fmat[ROT][1] = ry; fmat[ROT][2] = rz;
	fmat[TRA][0] = tx; fmat[TRA][1] = ty; fmat[TRA][2] = tz;
	fmat[SCA][0] = sx; fmat[SCA][1] = sy; fmat[SCA][2] = sz;
	fmat[LLO][0] = lx; fmat[LLO][1] = ly; fmat[LLO][2] = lz;
	fmat[LCO][0] = lr; fmat[LCO][1] = lg; fmat[LCO][2] = lb;
	fmat[KCO][0] = ka; fmat[KCO][1] = kd; fmat[KCO][2] = ks;
	fmat[NSV][0] = ns; fmat[NSV][1] = ns; fmat[NSV][2] = ns;
	fmat[BKC][0] = (float)br;
	fmat[BKC][1] = (float)bg;
	fmat[BKC][2] = (float)bb;
	fmat[WFM][0] = (float)xrate;
	fmat[WFM][1] = (float)yrate;
	fmat[WFM][2] =(float)lwidth;

	gx_init(win_parms,argv[0]);

	wintitle(hfile);
	
	for(ic=0; ic < PALBUFSIZE; ic++){
		ic1 = ic | 512; /* statement is ic1=ic+512 */
		ir = (short)palette[ic][0];
		ig = (short)palette[ic][1];
		ib = (short)palette[ic][2];
		mapcolor(ic1, ir,ig,ib);
	}

	if (POLYGON){
		if (illum_mod == 0){
			if (czsize == 1){
				if (SCREEN_BITS == 8)
					gx_func = (Func_ptr *)gx_ppps0;
				else
					gx_func = (Func_ptr *)gx_ppts0;
			}
			else
				gx_func = (Func_ptr *)gx_ptts0;			
		}
		else if (illum_mod == 1){
			if (czsize == 1)
				gx_func = (Func_ptr *)gx_ppts1;			
			else
				gx_func = (Func_ptr *)gx_ptts1;			
		}
	}

	if (RELIEF){
		if (czsize == 1)
			gx_func = (Func_ptr *)gx_rpts1;
		else
			gx_func = (Func_ptr *)gx_rtts1;
	}

	if (WIREFRAME){
		if (czsize == 1){
			if (SCREEN_BITS == 8)
				gx_func = (Func_ptr *)gx_wpps0;
			else
				gx_func = (Func_ptr *)gx_wpts0;
		}
		else
			gx_func = (Func_ptr *)gx_wtts0;
	}
	

	idims[0] = hxsize;
	idims[1] = hysize;
	idims[2] = hzsize;
	idims[3] = czsize;

	err_ret = (*gx_func)(idims,hbuff,cbuff,palette,fmat);
	if (err_ret){
		printf("%s: exiting...\n",argv[0]);
		gexit();
		exit(1);
	}

	if(opt_loc[AXS])
		gx_drawaxes(ax_str,ay_str,az_str,fmat,palette);

	if (opf_flag){
		unsigned char *buff,*temp_buff,temp_pal[PALBUFSIZE][3];
		int icmd;
		long xsize,ysize,zsize;
		free(hbuff);
		free(cbuff);
		gx_scrsize(&xsize,&ysize,&zsize);

		num_bytes = xsize * ysize * zsize * sizeof(char);
		buff = (unsigned char *)malloc(num_bytes);
		if (!buff){
			printf("%s: Not enough memory\n",opfile);
			exit(1);
		}

		icmd = (SCREEN_BITS == 8) ? 0 : 1;
		if((SCREEN_BITS == 8) && (zsize == 3)) icmd = 1;
		gx_readscr(&xsize,&ysize,&zsize,icmd,buff);

		DFPrestart();
		if((zsize == 3) && (SCREEN_BITS == 8)){
			num_bytes = xsize * ysize * sizeof(char);
			temp_buff = (unsigned char *)malloc(num_bytes);
			if(!temp_buff){
				printf("%s: Not enough memory\n",opfile);
				exit(1);
			}
			printf("WARNING: '%s' being compressed from 24 bits to 8 bits\n",opfile);
			img_quant2(buff,temp_buff,xsize,ysize,temp_pal);
			DFR8setpalette(temp_pal);
			err_ret = DFR8putimage(opfile,temp_buff,xsize,ysize,DFTAG_RLE);
			if (err_ret){
				printf("%s: Error with DFR8putimage\n",opfile);
				exit(1);
			}
			free(temp_buff);
		}
		else if (zsize == 1){
			DFR8setpalette(palette);
			err_ret = DFR8putimage(opfile,buff,xsize,ysize,DFTAG_RLE);
			if (err_ret){
				printf("%s: Error with DFR8putimage\n",opfile);
				exit(1);
			}
		}
		else if (zsize == 3){
			DF24setdims(xsize,ysize,0);
			err_ret = DF24addimage(opfile,buff,xsize,ysize);
			if (err_ret){
				printf("%s: Error with DF24addimage\n",opfile);
				exit(1);
			}
		}
		exit(0);
	}

	for(;;){
		dev = qread(&val);
		if (dev == REDRAW){
			reshapeviewport();
			err_ret = (*gx_func)(idims,hbuff,cbuff,palette,fmat);
			if (err_ret){
				printf("%s: Error with gx_func\n",argv[0]);
				gexit();
				exit(1);
			}
		}
		else if (dev == ESCKEY){
			gexit();
			exit(1);
		}
	}


}
