/* 1500, Wed 7 Oct 92

   FLOWTREE.H:  Data structures for AU Monitor trees

   Copyright (C) 1992 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

#ifdef EXTFLOW
#define EXTFLOW
#else
#define EXTFLOW extern
#endif

#define N_VOID       0  /* Types of tree node */
#define N_ROOT	     1
#define N_FLOW       2
#define N_BACK_FLOW  3

typedef  struct node far *  node_p;

struct node_header {
   node_p llink, rlink;  /* Left and right pointers */
   char balance;  /* -1 = left heavy, 0 = balanced, +1 = right heavy */
   char type;  /* Node type */
   };

struct root_info {
   unsigned int height, nbr_nodes;
   unsigned long compares, searches;
   };

#define AT_IGNORE     0  /* Addr_type values */
#define AT_IP         1
#define AT_NOVELL     2
#define AT_DECNET     3
#define AT_ETHERTALK  4

#define ADDR_LEN  4

struct key {
   unsigned char addr_type,
      from_value[ADDR_LEN], from_mask[ADDR_LEN], from_tally[ADDR_LEN],
      to_value[ADDR_LEN], to_mask[ADDR_LEN], to_tally[ADDR_LEN];
   };

struct flow {
   unsigned int flow_nbr;
   unsigned long
      fwd_packets,fwd_bytes, back_packets,back_bytes,
      s_fwd_packets,s_fwd_bytes, s_back_packets,s_back_bytes;
   unsigned char s_active;
   };

struct back_flow {
   node_p fwd_flow;
   };

struct node {
   struct node_header h;
   struct key k;
   union nb {
      struct root_info r;
      struct flow f;
      struct back_flow b;
      unsigned char tree_nbr;
      } i;  /* info */
   };

struct f_node {
   struct node_header h;
   struct key k;
   struct flow f;
   };

struct b_node {
   struct node_header h;
   struct key k;
   struct back_flow b;
   };

struct active_flow_data {
   unsigned short flow_nbr;
   unsigned long fwd_bytes, back_bytes;
   };

#define FLOWBLOBSZ  25

struct opaque_flow_data {
   struct active_flow_data afd[FLOWBLOBSZ];
   };

/* Global Variables */

EXTFLOW struct opaque_flow_data flow_blob;

#define FORESTSZ  10  /* Max nbr of flow trees */
EXTFLOW node_p forest[FORESTSZ+1];  /* +1 for null end marker */

#define MXFLOWS  8000
EXTFLOW unsigned int nflows;  /* Nbr of flows allocated: ftFlowCount */

EXTFLOW struct b_node current_rule;  /* Rule being built by snmp SETs */
EXTFLOW struct node *crp;  /* Points to current_rule */
EXTFLOW int nrules;  /* Nbr of rules in rule table */

EXTFLOW unsigned char kb_enabled;

/* MIB variables */

EXTFLOW unsigned short s_nflows;      /* ftChkFlowCount */
EXTFLOW unsigned short s_act_flows;   /* ftChkActFlows */
EXTFLOW unsigned short s_first_flow;  /* ftFirstActFlow */

EXTFLOW long s_chktime;               /* ftChkTime */
EXTFLOW long p_s_chktime;             /* ftPrevChkTime */

/* Flow-tree functions */

#define addrcpy(d,s,n) qmove(s,d,n)  /* Stick to d,s order for copies! */

node_p getnode(int t);
void freenode(node_p q);
node_p new_tree(void);
node_p new_node(int t);

node_p hbtree(node_p n, int (*compfn)(node_p n, node_p p),
   int type, node_p (*add_new_node)(int type, node_p n, node_p tree),
   node_p tree);

void d_tree_walk(node_p t,int d,void (*f)());
void tree_walk(node_p t,void (*f)());

int compfn(node_p n, node_p p);
int tally_compfn(node_p n, node_p p);
node_p no_flow_node(int type, node_p n, node_p tree);
node_p new_flow_node(int type, node_p n, node_p tree);
node_p tally_flow_node(int type, node_p n, node_p tree);
void make_back_flow(node_p tree,node_p n,node_p f);

void init_rule_table(void);
void add_rule(void);
node_p find_rule(int n);
void clear_rule_table(void);
void add_flow(node_p node, unsigned char tree_nbr);
void setup_flows(void);

void init_flow(node_p tree,node_p f);

void number_flow(node_p n);
void free_flow(node_p n);
node_p find_flow(int x);

void t_clear_flows(node_p t);
void clear_flows(void);

void build_flow_blob(int fx);

void pkt_monitor(unsigned char far *pp,int len,unsigned char pt);
void t_save_counts(node_p t);
void save_counts(void);

void open_log(void);
void write_flows(void);
void t_write_log(node_p t,int d);    /* !!! */
void write_log(void);                /* !!! */

void tree_stats(unsigned long *searches, unsigned long *compares);
void show_stats(node_p t);
void show_time(void);
void t_show_pcount(node_p t);  /* !!! */
void show_pcount(void);        /* !!! */

void init_monitor(void);

void show_help(void);
void handle_kb(int ch);

