// ObjectWindows - (C) Copyright 1992 by Borland International
//
// Cup of Fungus Audio CD Player
// Copyright (C) 1993 by Cup of Fungus
// Version 1.0 -- Coded 1/16/93-1/23/93
// Beta Test -- 1/24/93-3/6/93
// Final Bug Fix and Release -- 3/7/93
//
#include <owl.h>      // for ObjectWindows
#include <mmsystem.h> // for MCI API
#include <string.h>   // for strcmp
#include <stdlib.h>   // for the atoi, atol, and rand functions
#include <time.h>     // for the randomize fuction
#include <listbox.h>  // for TListBox
#include <edit.h>     // for TEdit
#include <combobox.h> // for TComboBox
#include "cdplay.h"   // my message and identifier definitions

class TCDApp : public TApplication
{
public:
  TCDApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

_CLASSDEF(TCDDialog)
class TCDDialog : public TDialog
{
public:
	PTListBox CDListBox;
	PTEdit CDCurrentTrackEdit, CDTrackTimeEdit, CDTotalTimeEdit, CDStatusEdit;
  PTComboBox CDPlayModeCombo;
	BOOL IsPaused;
	int CurrentTrack, NumberOfTracks;
	char outputstr[80], buffer[40], Tracks[100][12];

	virtual LPSTR GetClassName();
	virtual void SetupCDInformation();
  virtual void UpdateInfo();
  virtual void SetupWindow();
	virtual void GetWindowClass(WNDCLASS&);
	virtual void HandleAboutButtonMsg(RTMessage Msg) = [ID_FIRST + aboutbutton];
	virtual void HandleHelpButtonMsg(RTMessage Msg) = [ID_FIRST + helpbutton];
	virtual void HandleCloseButtonMsg(RTMessage Msg) = [ID_FIRST + closebutton];
	virtual void HandlePlay(RTMessage Msg) = [ID_FIRST + play];
	virtual void HandleForward10(RTMessage Msg) = [ID_FIRST + forward10];
	virtual void HandleTrackForward(RTMessage Msg) = [ID_FIRST + trackforward];
	virtual void HandlePause(RTMessage Msg) = [ID_FIRST + pause];
	virtual void HandleStop(RTMessage Msg) = [ID_FIRST + stop];
	virtual void HandleEject(RTMessage Msg) = [ID_FIRST + eject];
	virtual void HandleTrackBack(RTMessage Msg) = [ID_FIRST + trackback];
	virtual void HandleBack10(RTMessage Msg) = [ID_FIRST + back10];
	virtual void HandleCDListBoxMsg(RTMessage Msg) = [ID_FIRST + numberandtimebox];
  virtual void WMTimer(RTMessage Msg) = [WM_FIRST + WM_TIMER];
	TCDDialog(PTWindowsObject AParent, int ResourceId);
};

_CLASSDEF(TCDAbout)
class TCDAbout : public TDialog
{
public:
		virtual void HandleSendMoneyButtonMsg(RTMessage Msg) = [ID_FIRST + sendthemoneybutton];
		TCDAbout(PTWindowsObject AParent, int ResourceId)
			: TDialog(AParent, ResourceId) {};
};

_CLASSDEF(TCDHelp)
class TCDHelp : public TDialog
{
public:
	PTListBox HelpListBox;
	PTEdit HelpEdit;

	TCDHelp(PTWindowsObject AParent, int ResourceId);
  virtual void SetupWindow();
	virtual void HandleHelpListBoxMsg(RTMessage Msg) = [ID_FIRST + helplistbox];
  virtual void HandleButton1Msg(RTMessage Msg) = [ID_FIRST + helphelpbutton];
  virtual void HandleButton2Msg(RTMessage Msg) = [ID_FIRST + cancelbutton];
	virtual void FillHelpEdit(Pchar SelString);
};

TCDDialog::TCDDialog(PTWindowsObject AParent, int ResourceId)
	: TDialog(AParent, ResourceId)
{
	CDListBox = new TListBox(this, numberandtimebox);
	CDCurrentTrackEdit = new TEdit(this, currenttrackbox, 40);
	CDTrackTimeEdit = new TEdit(this, tracktimebox, 40);
	CDTotalTimeEdit = new TEdit(this, totaltimebox, 40);
	CDStatusEdit = new TEdit(this, statusbox, 40);
	CDPlayModeCombo = new TComboBox(this, playmodebox, 40);
};


TCDHelp::TCDHelp(PTWindowsObject AParent, int ResourceId)
	: TDialog(AParent, ResourceId)
{
	HelpListBox = new TListBox(this, helplistbox);
	HelpEdit = new TEdit(this, helpeditbox, 40);
}

void TCDDialog::SetupWindow()
{
	int crashbutton;
  BOOL Bomb;

	TDialog::SetupWindow();
  Bomb=FALSE;
	if (!SetTimer(HWindow, 1, 1000, NULL))
		MessageBox(HWindow, "Too Many Timers!", "Fungus Warning", MB_OK | MB_ICONEXCLAMATION);
	mciSendString((LPSTR)"open cdaudio", buffer, 40, NULL);
		// if above was successful buffer should be "1" otherwise it's ""
  while(strcmp(buffer,"")==0) {
		crashbutton=MessageBox(HWindow, "Can't open MCI CD Audio!\n\nInsert an audio CD and\npress OK to continue.\n\nOr press CANCEL to quit.", "Fungus Error", MB_OKCANCEL | MB_ICONEXCLAMATION);
		if(crashbutton==IDCANCEL) {
			Bomb=TRUE;
			break;  // this will exit the WHILE loop if CANCEL is pressed
    }
		else mciSendString((LPSTR)"open cdaudio", buffer, 40, NULL);
	}
	if(Bomb) CloseWindow();  // if CANCEL was pressed then quit the program
	mciSendString((LPSTR)"set cdaudio time format tmsf", NULL, 0, NULL);
	mciSendString("status cdaudio current track", buffer, 40, NULL);
	CurrentTrack=(int)atoi(buffer);
	IsPaused=FALSE;
	CDPlayModeCombo->AddString(" Continuous");
	CDPlayModeCombo->AddString(" Random");
	CDPlayModeCombo->AddString(" Single");
	CDPlayModeCombo->SetSelIndex(0);
	SetupCDInformation();
	mciSendString("status cdaudio mode", buffer, 40, NULL);
	if(strcmp(buffer, "playing")==0) CDStatusEdit->SetText("Playing");
	else {
		CDStatusEdit->SetText("Stopped");
		CDCurrentTrackEdit->SetText("1");
		CDTrackTimeEdit->SetText("00:00");
		CDTotalTimeEdit->SetText("00:00");
	}
}

void TCDDialog::SetupCDInformation(void)
{
	int i;
	mciSendString("status cdaudio number of tracks", buffer, 40, NULL);
	NumberOfTracks=(int)atoi(buffer);
	CDListBox->ClearList();
	for(i=1;i<=NumberOfTracks;i++) {
    wsprintf(buffer, "status cdaudio length track %d", i);
		mciSendString(buffer, Tracks[i], 12, NULL);
		wsprintf(outputstr, " Track %2d:   %c%c:%c%c", i, Tracks[i][0], Tracks[i][1], Tracks[i][3], Tracks[i][4]);
		CDListBox->AddString(outputstr);
	}
	CDListBox->SetSelIndex(CurrentTrack-1);
}

void TCDDialog::UpdateInfo(void)
{
	char tempbuffer[40];
	static int temptrack, tempprevtrack=0, randomtrack;

	mciSendString("status cdaudio mode", outputstr, 80, NULL);
	if(strcmp(outputstr, "playing")==0) {
		mciSendString((LPSTR)"set cdaudio time format tmsf", NULL, 0, NULL);
		mciSendString("status cdaudio position", outputstr, 80, NULL);
		wsprintf(tempbuffer, "%c%c:%c%c", outputstr[3], outputstr[4], outputstr[6], outputstr[7]);
		CDTrackTimeEdit->SetText(tempbuffer);

		mciSendString("set cdaudio time format msf", NULL , 0, NULL);
		mciSendString("status cdaudio position", outputstr, 80, NULL);
		wsprintf(tempbuffer, "%c%c:%c%c", outputstr[0], outputstr[1], outputstr[3], outputstr[4]);
		CDTotalTimeEdit->SetText(tempbuffer);
		mciSendString("set cdaudio time format tmsf", NULL, 0, NULL);

		mciSendString("status cdaudio current track", outputstr, 80, NULL);
		temptrack=atoi(outputstr);
		if(temptrack!=tempprevtrack) {
			switch(CDPlayModeCombo->GetSelIndex()) {
      	case 0:
					CDCurrentTrackEdit->SetText(outputstr);
					CurrentTrack=temptrack;
					CDListBox->SetSelIndex(CurrentTrack-1);
					break;
				case 1:
        	randomize();
					randomtrack=(rand()%NumberOfTracks)+1;
					wsprintf(buffer, "play cdaudio from %d", randomtrack);
					mciSendString(buffer, NULL, 0, NULL);
					wsprintf(outputstr, "%d", randomtrack);
					CDCurrentTrackEdit->SetText(outputstr);
					CurrentTrack=randomtrack;
					CDListBox->SetSelIndex(randomtrack-1);
					temptrack=randomtrack;
					break;
				case 2:
					wsprintf(outputstr, "play cdaudio from %d", tempprevtrack);
					mciSendString(outputstr, NULL, 0, NULL);
					temptrack=tempprevtrack;
          CDListBox->SetSelIndex(temptrack-1);
					break;
      }
		}
    tempprevtrack=temptrack;
	}
}

void TCDDialog::WMTimer(RTMessage Msg)
{
	UpdateInfo();
}

LPSTR TCDDialog::GetClassName()
{
	return("TCDDialog");
}

void TCDDialog::GetWindowClass(WNDCLASS& AWndClass)
{
	TDialog::GetWindowClass(AWndClass);
	AWndClass.hIcon = LoadIcon(GetApplication()->hInstance, "cdicon");
}

void TCDDialog::HandleAboutButtonMsg(RTMessage Msg)
{
	GetModule()->ExecDialog(new TCDAbout(this, aboutbox));
}

void TCDAbout::HandleSendMoneyButtonMsg(RTMessage Msg)
{
	CloseWindow();
}

void TCDDialog::HandleHelpButtonMsg(RTMessage Msg)
{
	GetModule()->ExecDialog(new TCDHelp(this, helpbox));
}

void TCDDialog::HandleCloseButtonMsg(RTMessage Msg)
{
	mciSendString("close cdaudio", NULL, 0, NULL);
  IsPaused=FALSE;
	CloseWindow();
}

void TCDDialog::HandlePlay(RTMessage Msg)
{
	mciSendString("status cdaudio mode", buffer, 40, NULL);
	if(strcmp(buffer, "stopped")==0 && (!IsPaused)) SetupCDInformation();

	if(!IsPaused) {
		wsprintf(outputstr, "play cdaudio from %d", (CDListBox->GetSelIndex())+1);
		mciSendString((LPSTR)outputstr, NULL, 0, NULL);
	}
	else {
		mciSendString("play cdaudio", NULL, 0, NULL);
		IsPaused=FALSE;
	}
	CDStatusEdit->SetText("Playing");
}

void TCDDialog::HandleStop(RTMessage Msg)
{
	mciSendString((LPSTR)"stop cdaudio", NULL, 0, NULL);
	CDListBox->SetSelIndex(0);
  CurrentTrack=1;
	IsPaused=FALSE;
	CDStatusEdit->SetText("Stopped");
	CDCurrentTrackEdit->SetText("1");
	CDTrackTimeEdit->SetText("00:00");
  CDTotalTimeEdit->SetText("00:00");
}

void TCDDialog::HandlePause(RTMessage Msg)
{
	if(!IsPaused) {
		mciSendString((LPSTR)"pause cdaudio", NULL, 0, NULL);
		IsPaused=TRUE;
		CDStatusEdit->SetText("Paused");
  }
	else {
		mciSendString((LPSTR)"play cdaudio", NULL, 0, NULL);
		IsPaused=FALSE;
		CDStatusEdit->SetText("Playing");
	}
}

void TCDDialog::HandleTrackForward(RTMessage Msg)
{
	mciSendString("status cdaudio current track", buffer, 40, NULL);
	CurrentTrack=(int)atoi(buffer);
	if(CurrentTrack<NumberOfTracks) CurrentTrack++;
	else CurrentTrack=1;
	IsPaused=FALSE;
	wsprintf(buffer, "play cdaudio from %d", CurrentTrack);
	mciSendString(buffer, NULL, 0, NULL);
  CDStatusEdit->SetText("Playing");
}

void TCDDialog::HandleTrackBack(RTMessage Msg)
{
	mciSendString("status cdaudio current track", buffer, 40, NULL);
	CurrentTrack=(int)atoi(buffer);
	if(CurrentTrack>1) CurrentTrack--;
	else CurrentTrack=NumberOfTracks;
	wsprintf(buffer, "play cdaudio from %d", CurrentTrack);
	mciSendString(buffer, NULL, 0, NULL);
  CDStatusEdit->SetText("Playing");
}

void TCDDialog::HandleEject(RTMessage Msg)
{
		HandleStop(Msg);
		mciSendString("set cdaudio door open", NULL, 0, NULL);
}

void TCDDialog::HandleForward10(RTMessage Msg)
{
	long int CDPosition;
	mciSendString("set cdaudio time format milliseconds", NULL, 0, NULL);
	mciSendString("status cdaudio position", buffer, 40, NULL);
	CDPosition=(long)atol(buffer);
	CDPosition+=10000;  // adds 10 seconds to position
  wsprintf(buffer, "seek cdaudio to %ld", CDPosition);
	mciSendString(buffer, NULL, 0, NULL);
	mciSendString("play cdaudio", NULL, 0, NULL);
	IsPaused=FALSE;
  CDStatusEdit->SetText("Playing");
	mciSendString("set cdaudio time format tmsf", NULL, 0, NULL);
	mciSendString("status cdaudio current track", buffer, 40, NULL);
	CurrentTrack=(int)atoi(buffer);
}

void TCDDialog::HandleBack10(RTMessage Msg)
{
	long int CDPosition;
	mciSendString("set cdaudio time format milliseconds", NULL, 0, NULL);
	mciSendString("status cdaudio position", buffer, 40, NULL);
	CDPosition=(long)atol(buffer);
	CDPosition-=10000;  // subtracts 10 seconds from position
	if(CDPosition<0) CDPosition=0;
  wsprintf(buffer, "seek cdaudio to %ld", CDPosition);
	mciSendString(buffer, NULL, 0, NULL);
	mciSendString("play cdaudio", NULL, 0, NULL);
	IsPaused=FALSE;
	CDStatusEdit->SetText("Playing");
	mciSendString("set cdaudio time format tmsf", NULL, 0, NULL);
	mciSendString("status cdaudio current track", buffer, 40, NULL);
	CurrentTrack=(int)atoi(buffer);
}

void TCDDialog::HandleCDListBoxMsg(RTMessage Msg)
{
  int trackselected;

  if ( Msg.LP.Hi == LBN_DBLCLK )
  {
		trackselected=(CDListBox->GetSelIndex())+1;
		wsprintf(buffer, "play cdaudio from %d", trackselected);
		mciSendString(buffer, NULL, 0, NULL);
		CDStatusEdit->SetText("Playing");
		IsPaused=FALSE;
  }
}

void TCDHelp::SetupWindow()
{
  TDialog::SetupWindow();
	
	HelpListBox->AddString("< (10 sec. back)");
	HelpListBox->AddString("> (10 sec. forward)");
	HelpListBox->AddString("<< (Track Back)");
	HelpListBox->AddString(">> (Track Forward)");
	HelpListBox->AddString("Close");
  HelpListBox->AddString("Current Track");
	HelpListBox->AddString("Eject");
	HelpListBox->AddString("Pause");
	HelpListBox->AddString("Play");
	HelpListBox->AddString("Play Mode");
  HelpListBox->AddString("Status");
	HelpListBox->AddString("Stop");
	HelpListBox->AddString("Tips & Techniques");
	HelpListBox->AddString("Total Time");
  HelpListBox->AddString("Track #'s & Time");
  HelpListBox->AddString("Track Time");
	HelpListBox->SetSelIndex(0);
};

void TCDHelp::HandleHelpListBoxMsg(RTMessage Msg)
{
  char SelString[25];

  if ( Msg.LP.Hi == LBN_DBLCLK )
  {
		HelpListBox->GetSelString(SelString, sizeof(SelString));
		FillHelpEdit(SelString);
  }
}

void TCDHelp::HandleButton1Msg(RTMessage)
{
  char SelString[25];

  HelpListBox->GetSelString(SelString, sizeof(SelString));
	FillHelpEdit(SelString);
}

void TCDHelp::HandleButton2Msg(RTMessage)
{
  CloseWindow();
}

void TCDHelp::FillHelpEdit(Pchar SelString)
{
  Pchar HelpStr;

  if ( strcmp(SelString, "<< (Track Back)") == 0 )
	{  HelpStr =
				"<< plays the track on the CD that\r\n"
				"is immediately before the current\r\n"
				"track.  It is a Track Rewind. In\r\n"
				"Random mode this jumps to a\r\n"
				"random track.  In Single mode it\r\n"
				"jumps to the beginning of the\r\n"
        "current track.";
	};
  if ( strcmp(SelString, "< (10 sec. back)") == 0 )
	{  HelpStr =
				"< moves to the position on the CD\r\n"
				"that is 10 seconds before the\r\n"
				"current position.  It is a Position\r\n"
				"Rewind.";
	}
  if ( strcmp(SelString, "Play") == 0 )
	{  HelpStr =
				"Unless the CD is paused, Play starts\r\n"
				"the CD at the track currently selected\r\n"
				"in the 'Track Numbers and Times'\r\n"
				"box.  If paused, the CD will resume\r\n"
				"playing when Play is pressed.";
	};
  if ( strcmp(SelString, "> (10 sec. forward)") == 0 )
  {  HelpStr =
				"> moves to the position on the CD\r\n"
				"that is 10 seconds after the\r\n"
				"current position.  It is a Position\r\n"
        "Fast Forward.";
	};
  if ( strcmp(SelString, ">> (Track Forward)") == 0 )
  {  HelpStr =
				">> plays the track on the CD that is\r\n"
				"immediately after the current track.\r\n"
				"It is a Track Fast Forward.  In\r\n"
				"Random mode it jumps to a random\r\n"
				"track.  In Single mode it jumps to\r\n"
				"the beginning of the current track.";
	};
  if ( strcmp(SelString, "Pause") == 0 )
	{  HelpStr =
				"Pause pauses the CD if it is\r\n"
				"playing and resumes playing the\r\n"
				"CD if it is pressed again.";
	};
  if (strcmp(SelString, "Stop") == 0 )
	{  HelpStr =
				"Stop ends the playback of the CD,\r\n"
				"and moves the current position\r\n"
        "back to the beginning of the CD.";
	};
  if ( strcmp(SelString, "Eject") == 0 )
	{  HelpStr =
				"Eject ends the playback of the CD, \r\n"
				"and ejects the CD from the drive--\r\n"
				"but only if the drive has software\r\n"
        "eject capabilities.";
	};
  if ( strcmp(SelString, "Close") == 0 )
	{  HelpStr =
				"Close ends the Cup of Fungus Audio\r\n"
				"CD Player application.  It allows\r\n"
				"the CD to continue playback if it\r\n"
        "is playing when Close is pressed.";
	};
	if ( strcmp(SelString, "Play Mode") == 0 )
	{		HelpStr =
				"Continuous, Random, and Single\r\n"
				"modes are available.  Continuous\r\n"
				"plays each track in the order they\r\n"
				"are on the CD.  Random plays them\r\n"
				"in a random order (with repeats\r\n"
				"allowed).  Single plays only the\r\n"
				"current track.";
	};
	if (strcmp(SelString, "Track #'s & Time") == 0)
	{		HelpStr =
				"This box displays the length of each\r\n"
				"track on the disk in the order that\r\n"
        "they appear on the disk.";
	};
	if (strcmp(SelString, "Current Track")==0)
	{		HelpStr =
				"This box shows the number of the\r\n"
				"current track.";
	};
	if (strcmp(SelString, "Track Time")==0)
	{		HelpStr =
				"This shows the minutes and seconds\r\n"
				"from the beginning of the current\r\n"
				"track to the current position.";
	};
	if (strcmp(SelString, "Total Time")==0)
	{		HelpStr =
				"This shows the minutes and seconds\r\n"
				"from the beginning of the CD to the\r\n"
				"current position.";
	};
	if (strcmp(SelString, "Status")==0)
	{		HelpStr =
				"This box displays the status of the\r\n"
				"CD.  The possible messages are\r\n"
				"Playing, Paused, and Stopped---\r\n"
				"which are self-explanatory.";
  };
	if ( strcmp(SelString, "Tips & Techniques") == 0 )
	{		HelpStr =
				"This application requires Microsoft\r\n"
				"Windows 3.1.\r\n"
				"The '[MCI] CD Audio' driver MUST\r\n"
				"be installed for this to work (through\r\n"
				"the 'Control Panel | Drivers | Add'\r\n"
				"facility.)\r\n"
				"Cup of Fungus was originally the\r\n"
				"name of my band, but when all the\r\n"
				"members left but me and my best\r\n"
				"friend, we decided to turn it into\r\n"
				"a Creative Team.  Now we are\r\n"
				"slowly (VERY SLOWLY!) building\r\n"
				"our empire with the returns from our\r\n"
				"creative efforts.  By the year 2075,\r\n"
				"we plan to be a formidable market\r\n"
				"presence.  Watch for us, or better\r\n"
				"yet, send money! (Comments are\r\n"
        "also welcomed...)";
  };
	HelpEdit->SetText(HelpStr);
}

void TCDApp::InitMainWindow()
{                                                 
	MainWindow = new TCDDialog(NULL, cdplaybox);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TCDApp CDApp("Cup of Fungus Audio CD Player", hInstance, hPrevInstance,
							 lpCmdLine, nCmdShow);
	if(hPrevInstance!=0) return CDApp.Status;
  CDApp.Run();
  return CDApp.Status;
}
