#define TAB_SIZE 8

struct art_list {
   struct art_list *next_list;
   int             first_article;
   int             last_article;
};

struct newsrc_item {
   struct newsrc_item *next_item;
   struct newsrc_item *previous_item;
   char               *newsrc_grp_name;
   int               newsrc_subscribed;
   struct art_list   *read_list;
};


struct subj_line {
   struct subj_line *subj_next;
   int art_no;
   char *subject;
};


extern struct newsrc_item *newsrc_list;
extern struct newsrc_item *newsrc_last;
extern struct art_list *free_arts;

extern struct subj_line *subjects;

extern int last_subj_art;

extern int cmd;                     /* The current command character */

extern char art_format[FILENAME_MAX];

extern struct newsrc_item *active_group;  /* The "current" newsgroup being read */
extern struct newsrc_item *previous_group; /* The last active_group */

extern int cmd;                     /* The current command character */

extern char *cwd;                /* The initial drive:directory */
extern FILE *this_article;
extern FILE *last_article;

/* rn options */
extern int erase_for_more;          /* -e sets TRUE      */
extern int supress_initial;         /* -s[count] sets it to count (0 if absent) */
extern int dont_flush;              /* -T ses TRUE    */



/* rn strings

   The following strings are implemented (at least partially)

      %a Current article number
      %B Byte offset in file of start of file save
            (0 for save; start of body for write)
      %c Current newsgroup, directory form
      %C Current newsgroup, dot form
      %f "From:" line ("Reply-To:" if it exists)
      %F "Newsgroups:" for new article constructed from
            "Newsgroups:" ("Followup-To:") of current
            article
      %H Host name
      %i "Message-I.D.:"
      %L Your Login name
      %O Original working directory
      %p Your private news directory, ~/News
      %P Public news directory
      %s Subject with all "Re:"s and ???
      %S Subject with one "Re:" stripped off
      %T "To:" line for reply.  Constructed from the "Path:"
      %t "To:" line for reply.  Constructed from "From:"
            ("Reply-To:") line
      %u Number of unread articles in the current newsgroup
      %z Length of current article in bytes
      %~ Your home directory

   The following strings are NOT implemented at this time

      %A Full name of current article (%P/%c/%a)
      %b Destination of last save
      %d Full name of newsgroup directory (%P/%c
      %D "Distribution:" line from current article
      %h Nmae of header file to pass to mail or news poster
      %I reference indication mark
      %l administrator's login
      %m current mode
      %M number of articles Marked
      %n
      %o
      %r
      %R
      %U Number unread articles not counting this one
      %x
      %.
      %$
      %/
      %(name)
      %[name]
      %`command`
      %"prompt"
      %(test=pattern?then:else)
      %digit

*/

/* The following "strings" are stored as numbers

      %a    int      current_article
      %B    long  last_start_of_save
      %u    int      current_unread
      %z    long  current_article_length

*/

extern int  current_article;
extern long last_start_of_save;
extern long current_start_of_body;
extern int  current_unread;
extern long current_article_length;

extern char *current_to;
extern char *current_path_to;
extern char *message_ID;
extern char *current_subject;
extern char *current_refs;
extern char *current_newsgroups;
extern char *current_followup;
extern char *current_reply_to;
extern char *current_distribution;


extern void check_alloc(void *ptr);
char *expand(char *rn_string, int *cnt);
void reply(FILE *f, int cmd);
void clear_screen(void);
void save_article(FILE *f, int cmd);
void update_list(int article);
void unmark_article(int article);
struct subj_line *get_subj_line(int art_no);
void catch_up_subj(int article);
char *subj_str(int art_no) ;
char *get_subject_line(FILE *f);
void flush_kybd(void);
int is_read (int article);
int do_article(FILE *art, int decrypt, int art_no, int verbose);
