{ =========================================================================== }
{ Wndw5X-.pas - unit for Multi-level Virtual Windows        ver 5.X, 12-20-88 }
{            with multi-video page and virtual window capability.             }
{                                                                             }
{ This unit has the complete utilities for serial- or random-access, or       }
{ virtual multi-level windows.  It works on any IBM or compatible including   }
{ PCjr, IBM 3270 PC, and the PS/2 systems, in any video mode.  It uses        }
{ QWIK42.TPU for fast screen writing on any video page.                       }
{                                                                             }
{ Only the interface is shown in this partial file.                           }
{  Copyright (C) 1987,1988 by James H. LeMay                                  }
{ =========================================================================== }

{ R-,S-,I-,D-,T-,F-,V-,B-,N-,L+ }       { TP4 directives }
{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}  { TP5 directives }

{ If undefined, these directives saves data space and about 2.5k of code. }
{ If you are using only video page 0, remove the following "$": }
{$Define MultiPage }

{ If you are NOT using virtual windows, remove the following "$": }
{$Define AddVirtual }

UNIT Wndw;

INTERFACE

USES Crt,Qwik,Wutil;

{$I w5X-var.inc }

{ -- Basic Window Utilities -- }
procedure InitWindow      (Wattr: integer; ClearScr: boolean);
function  HeapOK          (NumOfBytes: word): boolean;
procedure SetCursorDefault(CursorMode: word);
procedure SetWindowModes  (SumOfAllModes: word);
procedure MakeWindow      (Row,Col,Rows,Cols: byte; Wattr,Battr: integer;
                           BrdrSel: Borders; WindowName: WindowNames);
procedure TitleWindow     (TopOrBottom,Justify: DirType;
			   TitleAttr: integer; Title: string);
procedure LocateCursor;
procedure RestoreTurboWindow;
procedure RemoveWindow;

{ -- Window-relative writing utilities -- }
procedure WWrite          (Row,Col: byte; aStr: string);
procedure WWriteC         (Row: byte; aStr: string);
procedure WWriteA         (Row,Col: byte; ArrayLength: word; VAR aStr);
procedure WGotoRC         (Row,Col: byte);
procedure WGotoEos;
procedure WEosToRC        (Row,Col: byte);
function  WWhereR:        byte;
function  WWhereC:        byte;
function  WEosR:          byte;
function  WEosC:          byte;
procedure WEosLn;
procedure WBrdrH          (Row: byte);
procedure WBrdrV          (Col: byte);
procedure WBrdrPart       (Row,Col: byte; Part: BrdrParts);
procedure WLineH          (Row,Col,Cols: byte);
procedure WLineV          (Row,Col,Rows: byte);
procedure WLinePart       (Row,Col: byte; Part: BrdrParts);
procedure WScrollUp;
procedure WScrollDown;
procedure WInsLine        (Row: byte);
procedure WDelLine        (Row: byte);
procedure WClrLine        (Row: byte);
procedure WClrField       (Row,Col,Cols: byte; Attr: integer);
procedure WClrFieldEos    (        Cols: byte; Attr: integer);
procedure WClrEol         (Row,Col:      byte; Attr: integer);
procedure WClrEos         (                    Attr: integer);
procedure WClrTitle       (TopOrBottom: DirType);
procedure WClrScr;

{ -- Window management utilities -- }
procedure WriteToCRT;
procedure WriteToHidden   (WindowName: WindowNames);
  {$IfDef MultiPage }
procedure WriteToPage     (PageNum: byte);
procedure WriteAndViewPage(PageNum: byte);
  {$EndIf }
procedure HideWindow;
procedure ShowWindow      (WindowName: WindowNames);
procedure MoveWindow      (NumOfRows,NumOfCols: integer);
function  GetLevelIndex   (WindowName: WindowNames): word;
procedure AccessWindow    (WindowName: WindowNames);
procedure ChangeBorder    (NewBrdr: Borders);
procedure RestoreBorder;

{ -- Virtual window utilities -- }
  {$IfDef AddVirtual }
procedure SetVirtualSize  (Rows,Cols: byte);
procedure WriteToVirtual  (WindowName: WindowNames);
procedure VViewRC         (Row,Col: byte);
procedure VViewRCrel      (NumOfRows,NumOfCols: integer);
procedure VUpdateWindow;   { Simply does the following 3 procedures: }
procedure VUpdateView;
procedure VUpdateTitles;
procedure VUpdateCursor;
procedure VUpdateRows     (Row,Rows: byte);
procedure VScrollView     (NumOfRows,NumOfCols: integer);
procedure VResizeWindow   (NumOfRows,NumOfCols: integer);
procedure VZoomWindow;
  {$EndIf }


IMPLEMENTATION

END.
