program EDITDEMO;
{$S-}
uses
  App, Views, Objects, Drivers, Dialogs, Menus;

var
  ResFile: PResourceFile;

type
  TEDITDEMOApp = Object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
  end;

constructor TEDITDEMOApp.Init;
begin
  RegisterObjects;
  RegisterViews;
  RegisterDialogs;
  RegisterMenus;
  ResFile := New(PResourceFile, Init(New(PBufStream, Init('TVRWDMO.RES', stOpen, 4096))));
  TApplication.Init;
end;

destructor TEDITDEMOApp.Done;
begin
  if ResFile <> nil then Dispose(ResFile, Done);
  TApplication.Done;
end;

procedure TEDITDEMOApp.HandleEvent(var Event: TEvent);
begin
  TApplication.HandleEvent(Event);
  case Event.What of
    evCommand:
      case Event.Command of
        cmOpen: ;
        else
          Exit;
      end;
    else
      Exit;
  end;
  ClearEvent(Event);
end;

procedure TEDITDEMOApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + 1;
  MenuBar := PMenuView(ResFile^.Get('MainMenu'));
  MenuBar^.ChangeBounds(R);
end;

procedure TEDITDEMOApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := PStatusLine(ResFile^.Get('StatusLine'));
  StatusLine^.ChangeBounds(R);
end;

var
  EDITDEMOApp: TEDITDEMOApp;

begin
  EDITDEMOApp.Init;
  EDITDEMOApp.Run;
  EDITDEMOApp.Done;
end.
