/**************************************
 * ptyopen.c : open a pty (Solaris)
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 **************************************/

#include <fcntl.h>
#include <signal.h>

#include "ptyopen.h"

int PtyOpen(ptyFd,ttyName)
int *ptyFd;
char **ttyName;
{
  char *ptsname();
  void (*func)();

  *ptyFd = open("/dev/ptmx",O_RDWR);
  if (*ptyFd < 0)
    return(-1);

  *ttyName = ptsname(*ptyFd);
  
  /* grantpt() generates a fork()
   * and apparently wait()s
   * for the child. Hence, the
   * the handling of SIGCHLD
   * cannot be allowed or the
   * program may hang.
   */

  func = signal(SIGCHLD,SIG_DFL);
  grantpt(*ptyFd); 
  signal(SIGCHLD,func);
  unlockpt(*ptyFd);
  return(0); 
}


