/************************************************************
 * cttyopen.c : open a tty as the control tty (Bsd386)
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 ************************************************************/

#include <fcntl.h>
#include <sys/ioctl.h>

#include "system.h"
#include "cttyopen.h"

int CttyOpen(tty)
char *tty;
{
  int fd;
  
  /* open stdin, stdout and stderr */

  fd = open(tty,O_RDWR); 
  if (fd < 0)
    return(-1);
    
  if (dup2(fd,0) != 0 || dup2(fd,1) != 1 || dup2(fd,2) != 2)
    {
      close(fd);
      return(-2);
    }

  close(fd);

  /* make it the control tty */

  if (setsid() < 0)
    return(-1);
  if (ioctl(0, TIOCSCTTY, 0) < 0)
    return(-1);
  
  return(0);
}
