<?php
// ! Support file only, run AjaxTablePaging.html instead !
// This file is used as both Data_Url and Upload_Url
// Generates data for TreeGrid when no data received or saves received changes to database
// Single file, without using TreeGridFramework.php

// --- Database switching ---
require_once("IncDbTxt.php");                 // Routines to connect to database via text file database
$db = new Database("Database");               // Database in folder "Database"

header("Content-Type: text/xml; charset=utf-8"); 

// --------------------------------------------------------------------------
// --- Gets cfg ---
$XML = array_key_exists("TGData",$_REQUEST) ? $_REQUEST["TGData"] : "";
if(get_magic_quotes_gpc()) $XML = stripslashes($XML);
if(!$XML) $XML = "<Grid><Cfg/><Body><B Pos='2'/></Body></Grid>";   // Just for examples if called directly
      
// --- simple xml or php xml --- 
$SXML = is_callable(simplexml_load_string);
if(!$SXML) require_once("Xml.php");
if($SXML){ 
   $Xml = simplexml_load_string(html_entity_decode($XML));
   $Cfg = $Xml->Cfg[0];
   $B = $Xml->Body->B[0];
   }
else { 
   $Xml = CreateXmlFromString(html_entity_decode($XML));
   $Cfg = $Xml->getElementsByTagName("Cfg");
   $Cfg = $Cfg[0];
   $B = $Xml->getElementsByTagName("B");
   $B = $B[0];
   }

   
$Cfg = $SXML ? $Cfg->attributes() : $Cfg->attributes;
$B = $SXML ? $B->attributes() : $B->attributes;
// --- end of simple xml or php xml ---  

// --- Parses sorting settings ---
$x = strtok($Cfg["SortCols"],",");
$cnt = 0;
while($x!==false){
   $SC[$cnt++] = $x;
   $x = strtok(",");
   }

$x = strtok($Cfg["SortTypes"],",");
$i = 0;
while($x!==false){
   $ST[$i++] = $x;
   $x = strtok(",");
   }

$S = "";
for($i=0;$i<$cnt;$i++){
   if($S!="") $S .= ", ";
   $S = $S . $SC[$i];
   if($ST[$i] >= 1) $S .= " DESC";
   }
if($cnt) $S = " ORDER BY " . $S;

// --- Gets information about page number ---
$start = $B["Pos"]*20;   // PageLength


// --- Reads data from database ---
$rows = $db->Query("SELECT * FROM TableData" . $S)->GetRows();

// --- Writes data for requested page ---
echo "<Grid><Body><B Pos='" . $B["Pos"] . "'>";
$cnt = count($rows);
if($cnt>$start+20) $cnt = $start+20;
for($i=$start;$i<$cnt;$i++){
   $row = $rows[$i];
   echo "<I id='" . $row["ID"] . "'" 
         . " Project='" . htmlspecialchars($row["Project"],ENT_QUOTES) . "'"
         . " Resource='" . htmlspecialchars($row["Resource"],ENT_QUOTES) . "'"
         . " Week='" . $row["Week"] . "'"
         . " Hours='"  . $row["Hours"] . "'"
         . "/>";
   }         
echo "</B></Body></Grid>";
// --------------------------------------------------------------------------
?>