// --------------------------------------------------------------------------------------------------------------------------
// Supported functions for particular examples
// These scripts are used to run particular examples properly and are not intended to demonstrate using Extended API
// --------------------------------------------------------------------------------------------------------------------------

// --------------------------------------------------------------------------------------------------------------------------
// Event handler for Data3.xml example for not US countries disables State editing
function List3CanEdit(G,row,col,can){
if(col=="O") return G.GetString(row,"N")=="UNITED STATES" || row.Kind=="Filter" && G.Paging!=3;
return can;
}
// --------------------------------------------------------------------------------------------------------
// Event handler for Data3.xml - returns correct enum for Country and State for by value in Region and Country
function List3GetEnum(G,row,col,f){
if(col=="N"){
	switch(G.GetValue(row,"M")){
		case 0 : return ["ARMENIA","AZERBAIJAN","BANGLADESH","INDIA","KAZAKSTAN","PAKISTAN","SRI LANKA"];
		case 1 : return ["AUSTRALIA","BRUNEI","CHINA","HONG KONG","INDONESIA","JAPAN","KOREA, DPR","MALAYSIA","MONGOLIA","MYANMAR","NEW ZEALAND","PAPUA NEW GUINEA","PHILIPPINES","SINGAPORE","SOUTH KOREA","TAIWAN","THAILAND","VIETNAM"];
		case 2 : return ["ALBANIA","BELARUS","BULGARIA","CROATIA","CZECH REPUBLIC","ESTONIA","HUNGARY","LATVIA","LITHUANIA","MOLDOVA","POLAND","ROMANIA","RUSSIA","SERBIA-MONTENEGRO","SLOVAK REPUBLIC","SLOVENIA","UKRAINE"];
		case 3 : return ["ALGERIA","BAHRAIN","EGYPT","IRAN","IRAQ","ISRAEL","JORDAN","KUWAIT","LEBANON","LIBYA","MOROCCO","OMAN","QATAR","SAUDI ARABIA","SYRIA","TUNISIA","UAE","YEMEN"];
		case 4 : return ["BAHAMAS","CANADA","COSTA RICA","CUBA","DOMINICAN REPUBLIC","EL SALVADOR","GUATEMALA","HAITI","HONDURAS","JAMAICA","MEXICO","NICARAGUA","PANAMA","TRINIDAD & TOBAGO","UNITED STATES"];
		case 5 : return ["ARGENTINA","BOLIVIA","BRAZIL","CHILE","COLOMBIA","ECUADOR","GUYANA","PARAGUAY","PERU","SURINAME","URUGUAY","VENEZUELA"];
		case 6 : return ["ANGOLA","BOTSWANA","BURKINA FASO","CAMEROON","CONGO","CONGO DR","COTE D'IVOIRE","ETHIOPIA","GABON","GAMBIA","GHANA","GUINEA","GUINEA-BISSAU","KENYA","LIBERIA","MADAGASCAR","MALAWI","MALI","MOZAMBIQUE","NAMIBIA","NIGER","NIGERIA","SENEGAL","SIERRA LEONE","SOMALIA","SOUTH AFRICA","SUDAN","TANZANIA","TOGO","UGANDA","ZAMBIA","ZIMBABWE"];
		case 7 : return ["AUSTRIA","BELGIUM","CYPRUS","DENMARK","FINLAND","FRANCE","GERMANY","GREECE","ICELAND","IRELAND","ITALY","LUXEMBOURG","MALTA","NETHERLANDS","NORWAY","PORTUGAL","SPAIN","SWEDEN","SWITZERLAND","TURKEY","UNITED KINGDOM"];
		}
	}
if(col=="O"){
	if(G.GetString(row,"N")=="UNITED STATES"){
		return ["Alabama","Alaska","Arizona","Arkansas","California","Colorado","Connecticut","Delaware","Florida","Georgia","Hawaii","Idaho","Illinois","Indiana","Iowa","Kansas","Kentucky","Louisiana","Maine","Maryland","Massachusetts","Michigan","Minnesota","Mississippi","Missouri","Montana","Nebraska","Nevada","New Hampshire","New Jersey","New Mexico","New York","North Carolina","North Dakota","Ohio","Oklahoma","Oregon","Pennsylvania","Rhode Island","South Carolina","South Dakota","Tennessee","Texas","Utah","Vermont","Virginia","Washington","West Virginia","Wisconsin","Wyoming"];	
		}
	}
return f;
}
// --------------------------------------------------------------------------------------------------------
// Refreshes cells for Data3.xml if changed Region or country and for all Data...xml examples guards value of Rabat
function List3ValueChanged(G,row,col,val){
if(col=="C"){
	if(val-0<0 || val-0>50){ alert("Rabat can be in range 0% - 50% only"); val = val-0 < 0 ? 0 : 50; }
	return val;
	}
if(G.id!="List3") return val;
if(col=="M") setTimeout( function(){ 
	if(G.FRow!=row || G.FCol!="N") G.RefreshCell(row,"N"); 
	if(G.FRow!=row || G.FCol!="O") G.RefreshCell(row,"O"); 
	},100);
else if(col=="N") setTimeout( function(){ 
	if(G.FRow!=row || G.FCol!="O") G.RefreshCell(row,"O");
	},100);
return val;
}
// --------------------------------------------------------------------------------------------------------------------------
// Class for row Results for Data...xml
function ListGetClass(G,row,col,cls){
if(row.id=="Results"){
	if(cls=="GText" && col=="B") return "GTextM";
	if(cls=="GNumber" && col=="L") return "GNumberM";
	if(cls=="GNumber") return "GNumberB";
	if(cls=="GText") return "GNumberB";
	}
return cls;
}
// --------------------------------------------------------------------------------------------------------------------------
// Helper function for example Books.xml, changes edit mode
function EditChange(edit){
Grids["Books"].Editing = edit ? 1 : 2;
}
// --------------------------------------------------------------------------------------------------------------------------
