<%@ Page language="vb" Debug="true"%>
<%
   '! Support file only, run AjaxTablePaging.html instead !
   ' This file is used as Page_Url
   ' Generates data for one TreeGrid page from database, according to sorting information
   ' This is only simple example with not ideal database access (for every page gets all data)
   ' Single file, without using TreeGridFramework.asp

   ' --- Database initialization ---
   Dim Path As String : Path = System.IO.Path.GetDirectoryName(Context.Request.PhysicalPath)
   Dim Conn As System.Data.OleDb.OleDbConnection : Conn = New System.Data.OleDb.OleDbConnection("Jet OLEDB:Global Partial Bulk Ops=2;Jet OLEDB:Registry Path=;Jet OLEDB:Database Locking Mode=1;Data Source=""" + Path + "\\Database.mdb"";Mode=Share Deny None;Jet OLEDB:Engine Type=5;Provider=""Microsoft.Jet.OLEDB.4.0"";Jet OLEDB:System database=;Jet OLEDB:SFP=False;persist security info=False;Extended Properties=;Jet OLEDB:Compact Without Replica Repair=False;Jet OLEDB:Encrypt Database=False;Jet OLEDB:Create System Database=False;Jet OLEDB:Don't Copy Locale on Compact=False;User ID=Admin;Jet OLEDB:Global Bulk Transactions=1")
   Conn.Open()
   Dim Cmd As System.Data.OleDb.OleDbCommand : Cmd = Conn.CreateCommand()
   
   ' --- Response initialization ---
   Response.ContentType = "text/xml"
   Response.Charset = "utf-8"
   Response.AppendHeader("Cache-Control", "max-age=1, must-revalidate")
   System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.CreateSpecificCulture("en-US")
   
   ' --- Request read --- 
   Dim XML As String : XML = Request("TGData")
   If XML = Nothing Then XML = "<Grid><Cfg SortCols='Week,Hours' SortTypes='1,0'/><Body><B Pos='3'/></Body></Grid>" ' Just for examples if called directly

   Dim X As System.Xml.XmlDocument : X = New System.Xml.XmlDocument()
   X.LoadXml(HttpUtility.HtmlDecode(XML))
   
   ' --- Parses sorting settings ---
   Dim Cfg As System.Xml.XmlElement : Cfg = CType(X.GetElementsByTagName("Cfg")(0), System.Xml.XmlElement)
   Dim SC() As String : SC = Cfg.GetAttribute("SortCols").Split(",".ToCharArray())
   Dim ST() As String : ST = Cfg.GetAttribute("SortTypes").Split(",".ToCharArray())
   Dim S As String : S = ""
   Dim i As Integer
   If SC(0) <> "" Then
      For i = 0 To SC.Length - 1
         If S <> "" Then S += ", "
         S = S + SC(i)
         If Int32.Parse(ST(i)) >= 1 Then S = S + " DESC"
      Next i
      If S <> "" Then S = " ORDER BY " + S
   End If


   ' --- Gets information about page number ---
   Dim pos As Integer : pos = Int32.Parse(CType(X.GetElementsByTagName("B")(0), System.Xml.XmlElement).GetAttribute("Pos"))
   Dim start As Integer : start = pos * 20      ' 20 = PageLength

   ' --- Reads data from database ---
   Cmd.CommandText = "SELECT * FROM TableData" + S
  
   Dim R As System.Data.OleDb.OleDbDataReader : R = Cmd.ExecuteReader()
   
   ' --- Throws away data in front of requested page ---
   i = 0
   Do While i < start And R.Read()
      i = i + 1
   Loop
   
   ' --- Writes data for requested page ---
   Response.Write("<Grid><Body><B Pos='" + pos.ToString() + "'>")
   Do While i < start + 20 And R.Read()
      Response.Write("<I id='" + R(0).ToString() + "'" _
         + " Project='" + R(1).ToString().Replace("&", "&amp;").Replace("'", "&apos;").Replace("<", "&lt;") + "'" _
         + " Resource='" + R(2).ToString().Replace("&", "&amp;").Replace("'", "&apos;").Replace("<", "&lt;") + "'" _
         + " Week='" + R(3).ToString() + "'" _
         + " Hours='" + R(4).ToString() + "'" _
         + "/>")
      i = i + 1
   Loop
   Response.Write("</B></Body></Grid>")
   
%>