<%@ Page language="c#"%>
<!-----------------------------------------------------------------------------------------------------------------
Example of TreeGrid using synchronous (submit, non AJAX) communication with server
Example of simple table without tree
Uses DataTable for database communication
Uses new ASP.NET style scripting with event Page_Load
Uses MS Access database TableData.mdb as data and XML file TableDef.xml as TreeGrid layout
! Check if ASP application has write access to TableData.mdb file
------------------------------------------------------------------------------------------------------------------>
<html>
   <head>
      <link id="GridCSS" href="../../Grid/Grid.css" title="GridStyle" type="text/css" rel="stylesheet">
      <script src="../../Grid/GridE.js"> </script>
   </head>
   <body>
      <div style="WIDTH:100%;HEIGHT:90%">
         <bdo 
            Layout_Url="TableDef.xml" 
            Data_Tag="TGData" 
            Upload_Tag="TGData" Upload_Format="Internal"
            Export_Url="Export.aspx" Export_Data="TGData" Export_Param_File="SubmitTable.xls"
            ></bdo>
      </div>
      <form id="Form1" method="post" runat="server">
         <input id="TGData" type="hidden" runat="server"/>
         <input type="submit" value="Submit changes to server"/>
      </form>
   </body>
</html>
<script language="c#" runat="server">
// -------------------------------------------------------------------------------------------------------------------------------
void Page_Load(object sender, System.EventArgs e) 
{
   // --- Database initialization ---
   string Path = System.IO.Path.GetDirectoryName(Context.Request.PhysicalPath);
   System.Data.OleDb.OleDbConnection Conn = new System.Data.OleDb.OleDbConnection("Jet OLEDB:Global Partial Bulk Ops=2;Jet OLEDB:Registry Path=;Jet OLEDB:Database Locking Mode=1;Data Source=\"" + Path + "\\Database.mdb\";Mode=Share Deny None;Jet OLEDB:Engine Type=5;Provider=\"Microsoft.Jet.OLEDB.4.0\";Jet OLEDB:System database=;Jet OLEDB:SFP=False;persist security info=False;Extended Properties=;Jet OLEDB:Compact Without Replica Repair=False;Jet OLEDB:Encrypt Database=False;Jet OLEDB:Create System Database=False;Jet OLEDB:Don't Copy Locale on Compact=False;User ID=Admin;Jet OLEDB:Global Bulk Transactions=1");
   Conn.Open();
   System.Data.OleDb.OleDbCommand Cmd = Conn.CreateCommand();
   
   // --- Response initialization ---
   Response.ContentType = "text/html";
   Response.Charset = "utf-8";
   Response.AppendHeader("Cache-Control","max-age=1, must-revalidate");
   System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.CreateSpecificCulture("en-US");

   // --- Save data to database ---
   string XML = TGData.Value;
   if (XML != "" && XML != null)
   {
      System.Xml.XmlDocument X = new System.Xml.XmlDocument();
      X.LoadXml(HttpUtility.HtmlDecode(XML));
      System.Xml.XmlNodeList Ch = X.GetElementsByTagName("Changes");
      if (Ch.Count > 0) foreach (System.Xml.XmlElement I in Ch[0])
      {
         string SQL = "";
         string id = I.GetAttribute("id");
         
         if(I.GetAttribute("Deleted")=="1") SQL = "DELETE FROM TableData WHERE ID=" + id;
         else if(I.GetAttribute("Added")=="1")
         {
            SQL = "INSERT INTO TableData(ID,Project,Resource,Week,Hours) VALUES("
               + id + ","
               + "'" + I.GetAttribute("Project").Replace("'","''") + "'," 
               + "'" + I.GetAttribute("Resource").Replace("'","''") + "'," 
               + I.GetAttribute("Week") + "," 
               + I.GetAttribute("Hours") + ")";
         }
         else if(I.GetAttribute("Changed")=="1")
         {
            SQL = "UPDATE TableData SET ";
            for(int idx=0;idx<I.Attributes.Count;idx++)
            {
               System.Xml.XmlAttribute A = I.Attributes[idx];
               if (A!=null)
               { 
                  string name = A.Name;
                  string val = A.Value;
                  if(name=="Project" || name=="Resource") SQL += name + " = '" + val.Replace("'","''") + "',";
                  else if(name=="Week" || name=="Hours") SQL += name + " = " + val + ",";
               }
            }
            SQL = SQL.TrimEnd(",".ToCharArray()); // Last comma away
            SQL += " WHERE ID=" + id;
         }
         Cmd.CommandText = SQL;
         Cmd.ExecuteNonQuery();  
      }
   }

   // --- Load data from database ---
   {
      Cmd.CommandText = "SELECT * FROM TableData";
      System.Data.OleDb.OleDbDataReader R = Cmd.ExecuteReader();

      XML = "<Grid><Body><B>";
      while (R.Read())
      {
         XML += "<I id='" + R[0].ToString() + "'"
            + " Project='" + R[1].ToString().Replace("&", "&amp;").Replace("'", "&apos;").Replace("<", "&lt;") + "'"
            + " Resource='" + R[2].ToString().Replace("&", "&amp;").Replace("'", "&apos;").Replace("<", "&lt;") + "'"
            + " Week='" + R[3].ToString() + "'"
            + " Hours='" + R[4].ToString() + "'"
            + "/>";
      }
      XML += "</B></Body></Grid>";
      TGData.Value = XML;
   }

   // ---   
   Conn.Close();      
}
// -------------------------------------------------------------------------------------------------------------------------------
</script>
