<%
'================== The GNU General Public License ================

'ImageIsle - An Image Management Web Application created by
'White Pacific Software. Copyright (C) 2005 White Pacific Software

'This program is free software; you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation using version 2 of the License
'or any later version.

'This license must remain intact inside all distributions and/or
'copies of this application.

'www.whitepacificsoftware.com

'======================================================================





'...............................................
On Error Resume Next
'...............................................


' ASP CACHE CONTROL for the web application
'-----------------------------------------------------------------
' USE BELOW TO TURN WEB CACHING "ON" or "OFF"...
' Turn on caching to improve performance over slow connections when data displays get large in the page.
' The defaults set below and in the metatags may be switched if you see problems with either contant not showing up (too much caching) or too little (slow performance on dial-up users and server load is heavy)
'-----------------------------------------------------------------

' This property below allows you to suggest whether a page should be cached or not and is used for PROXY SERVER CACHING control only. If a proxy server is serving clients and has caching on, this controls that process. "private" prevents any caching storage of ASP files coming between a client and ASP server on the proxy server. "public" creates an html header control that tells the proxy TO cache server data for the site at the proxy level. Dont use this unless for high volume web sites, needing efficiency improvements. Some additional Cache control values for this property include: public - the page may be cached, private - the page should not be kept in a shared cached setting, no-cache - the cache should always check for a newer version, no-store - do not cache at all.

response.cachecontrol = "PRIVATE" 'use for no caching
'response.cachecontrol = "PUBLIC" 'use for caching

'-----------------------------------------------------------------
' This property (response.expires) represents a number used, which is the time in MINUTES before the page expires. IIS creates an HTTP header, indicating the time on the server for this value as a reference point if used. If the system time on the client is earlier than the system time sent from the server, the page is drawn from cache and not expired. That cached reference point determines and the value sent from server determines if the file has expired, and if so, a fresh request for content is obtained by the user agent. You can also use "response.expiresabsolute" to set the "expire immediately" value, if needed (see below). If this (response.expires) value below is not set, the browser uses the last modified date of the page(saved time and date). "response.expires = -1442" tells the browser to expire the content page 24 hours (60x24 hours = 1440 minutes) earlier plus two minutes extra for global users, so prevents caching of pages, accounting for world time zone differences. Can also be "response.expires = 0", but above is more guaranteed."response.expires = 1440" caches the page for 24 hours. Caching is good in that it allows users visiting the web page the first time to avoid loading the same page content again, speeding up download and rendering.

response.expires = -1442 'use for no caching
'response.expires = 1440 'use for caching

'-----------------------------------------------------------------
' This property (response.expiresabsolute) really controls all CLIENT side caching, and allows you to overrride a browser's default or custom caching. The ExpiresAbsolute property sets the precise, absolutre date and time when a response page cached on the browser will expire. If the time is not given, then the page will expire exactly at midnight on the given date. If the date is not given, then the page will expire at the given time on the same day that the script is run. The following code specifies that the page will expire at 6:00 PM on May 15th of 2006. Note: You must use a 24 hour clock for the time and four digits for the year. Other format can be used for the 'date' format: response.expiresabsolute = #May 15,2006 18:00:00#. "response.expiresabsolute = Now() + 2" caches the page for 48 hours. Good for allowing users, once visiting the admin page the first time, to not have to load it again. The "-2" days is the opposite and prevents caching for all viewers. The 48 hour setting allows the setting to work for global differences between the server's time zone and other viewers around the world.

response.expiresabsolute = Now() - 2 'use for no caching
'response.expiresabsolute = Now() + 2 'use for caching

'-----------------------------------------------------------------
' The two parameters below apply cache control much like the same tags found in the meta-tags of most web pages. These however are applied to the browser's html headers and further control caching, though some issues make them inconsistent among browsers as described below. As applied from the server, this property below should put an html header in the page that helps control caching. Note: The equivalent Cache-Control META HTTP-EQUIV tags are ignored and have no effect in Internet Explorer versions 4 or 5. Netscape also may not allow caching using these tags, or is overridden by prefences in the browser. HTML Headers like this, sent from the server ar more effective.'Pragma: no-cache' prevents caching only when used over a secure connection. A Pragma: no-cache META tag is treated identically to "response.expires = -1" if used in a non-secure page. The page will be cached but marked as immediately expired

response.AddHeader "pragma","no-cache" 'use for no caching
'response.AddHeader "pragma","cache" 'use for caching

response.AddHeader "cache-control","private" 'use for no caching
'response.AddHeader "cache-control","public" 'use for caching

'White Pacific Software (c) Copyright, 2005   www.whitepacificsoftware.com
'-----------------------------------------------------------------







'...............................................
'check for errors
If Err.number <> 0 then
    Call CaptureThisError("Cache.asp:check this file for the error")
    Err.Clear
End If
'...............................................
%>
