/*
 *  Copyright 2004 the mime4j project
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
using System;
using System.IO;
using System.Text;

using NI.Email.Mime;
using NUnit.Framework;

namespace NI.Tests.Email.Mime {

	/**
	* 
	*
	* @author Niklas Therning
	* @version $Id: EOLConvertingInputStreamTest.java,v 1.2 2004/10/02 12:41:11 ntherning Exp $
	*/
	public class EOLConvertingInputStreamTest {

		string[] inputPatterns = new string[] {
			"Line 1\r\nLine 2\r\n",
			"Line 1\nLine 2\n",
			"Line 1\rLine 2\r",
			"\r\n",
			"\n",
			"\r",
			""
		};
		string[] outputConvertBothPatterns = new string[] {
			"Line 1\r\nLine 2\r\n",
			"Line 1\r\nLine 2\r\n",
			"Line 1\r\nLine 2\r\n",
			"\r\n",
			"\r\n",
			"\r\n",
			""
		};
		
		string[] outputConvertCRPatterns = new string[] {
			"Line 1\r\nLine 2\r\n",
			"Line 1\nLine 2\n",
			"Line 1\r\nLine 2\r\n",
			"\r\n",
			"\n",
			"\r\n",
			"",
			""
		};
		
		string[] outputConvertLFPatterns = new string[] {
			"Line 1\r\nLine 2\r\n",
			"Line 1\r\nLine 2\r\n",
			"Line 1\rLine 2\r",
			"\r\n",
			"\r\n",
			"\r",
			"",
		};		

		byte[] ReadBytes(Stream stream) {
			MemoryStream resultStream = new MemoryStream();
			int b;
			while ( (b = stream.ReadByte() ) != -1 ) {
				resultStream.WriteByte( (byte)b);
			}
			return resultStream.ToArray();			
		}		

		[Test]
		public void test_ReadByte() {
			
			for (int i=0; i<inputPatterns.Length; i++) {
				// convert-both
				EOLConvertingInputStream inputStream =
					new EOLConvertingInputStream(
						new MemoryStream(Encoding.ASCII.GetBytes(inputPatterns[i])),
						EOLConvertingInputStream.BehaviourType.ConvertBoth  );
				byte[] data = ReadBytes(inputStream);
				Assert.AreEqual( Encoding.ASCII.GetString(data),
					outputConvertBothPatterns[i] );

				// convert-cr
				inputStream =
					new EOLConvertingInputStream(
					new MemoryStream(Encoding.ASCII.GetBytes(inputPatterns[i])),
					EOLConvertingInputStream.BehaviourType.ConvertCR  );
				data = ReadBytes(inputStream);
				Assert.AreEqual( Encoding.ASCII.GetString(data),
					outputConvertCRPatterns[i] );

				// convert-lf
				inputStream =
					new EOLConvertingInputStream(
					new MemoryStream(Encoding.ASCII.GetBytes(inputPatterns[i])),
					EOLConvertingInputStream.BehaviourType.ConvertLF  );
				data = ReadBytes(inputStream);
				Assert.AreEqual( Encoding.ASCII.GetString(data),
					outputConvertLFPatterns[i] );
				
			}
			
	        
		}

	}


}