/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public class CharacterConverter1Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_ucsReplacement = 0;
    public int[] m_ucsChar = null;
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharSurrogateLevel = null;
    public byte[] m_oraCharLevel2 = null;
    public byte m_oraCharReplacement = 0;

    public CharacterConverter1Byte() {
        this.m_groupId = 0;
    }

    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        Object object;
        Enumeration enumeration;
        int n6;
        this.m_oraCharLevel1 = new char[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n7 = this.m_ucsChar.length;
        char c2 = '\u0000';
        char c3 = '\u0000';
        int n8 = 0;
        while (n8 < 256) {
            this.m_oraCharLevel1[n8] = 65535;
            ++n8;
        }
        n8 = 0;
        while (n8 < n7) {
            n6 = this.m_ucsChar[n8];
            if (n6 != -1) {
                enumeration = (Enumeration)new int[2];
                enumeration[0] = n6;
                enumeration[1] = (Enumeration)n8;
                vector.addElement(enumeration);
                this.storeMappingRange(n6, hashtable, hashtable2);
            }
            ++n8;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            n8 = 0;
            while (n8 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n8][0];
                this.storeMappingRange(n6, hashtable, hashtable2);
                ++n8;
            }
        }
        enumeration = hashtable.keys();
        int n9 = 0;
        int n10 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n9 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n10 += 256;
        }
        if (n9 != 0) {
            this.m_oraCharSurrogateLevel = new char[n9];
        }
        if (n10 != 0) {
            this.m_oraCharLevel2 = new byte[n10];
        }
        n8 = 0;
        while (n8 < n9) {
            this.m_oraCharSurrogateLevel[n8] = 65535;
            ++n8;
        }
        n8 = 0;
        while (n8 < n10) {
            this.m_oraCharLevel2[n8] = -1;
            ++n8;
        }
        n8 = 0;
        while (n8 < vector.size()) {
            int[] nArray = (int[])vector.elementAt(n8);
            n5 = nArray[0] >> 24 & 0xFF;
            n4 = nArray[0] >> 16 & 0xFF;
            n3 = nArray[0] >> 8 & 0xFF;
            n2 = nArray[0] & 0xFF;
            if (n5 >= 216 && n5 < 220) {
                if (this.m_oraCharLevel1[n5] == '\uffff') {
                    this.m_oraCharLevel1[n5] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = c3;
                    c3 = (char)(c3 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] == -1) {
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (byte)(nArray[1] & 0xFFFF);
                }
            } else {
                if (this.m_oraCharLevel1[n3] == '\uffff') {
                    this.m_oraCharLevel1[n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] == -1) {
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (byte)(nArray[1] & 0xFFFF);
                }
            }
            ++n8;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            n8 = 0;
            while (n8 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n8][0];
                n5 = n6 >>> 24 & 0xFF;
                n4 = n6 >>> 16 & 0xFF;
                n3 = n6 >>> 8 & 0xFF;
                n2 = n6 & 0xFF;
                if (n5 >= 216 && n5 < 220) {
                    if (this.m_oraCharLevel1[n5] == '\uffff') {
                        this.m_oraCharLevel1[n5] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = c3;
                        c3 = (char)(c3 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (byte)(this.extraUnicodeToOracleMapping[n8][1] & 0xFF);
                } else {
                    if (this.m_oraCharLevel1[n3] == '\uffff') {
                        this.m_oraCharLevel1[n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (byte)(this.extraUnicodeToOracleMapping[n8][1] & 0xFFFF);
                }
                ++n8;
            }
        }
    }

    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        int n3 = 255;
        int n4 = n2;
        while (n4 <= n3) {
            try {
                int[] nArray = new int[]{n4, this.toUnicode((byte)n4)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n4;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n2][0], this.extraUnicodeToOracleMapping[n2][1]};
            vector.addElement(nArray);
            ++n2;
        }
    }

    public char getOraChar1ByteRep() {
        return (char)this.m_oraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return '\u0000';
    }

    public int getUCS2CharRep() {
        return this.m_ucsReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    byte toOracleCharacter(char c2, char c3) throws SQLException {
        byte by = -1;
        if (c3 != '\u0000') {
            int n2 = c2 >>> 8 & 0xFF;
            int n3 = c2 & 0xFF;
            int n4 = c3 >>> 8 & 0xFF;
            int n5 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                by = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c2 >>> 8 & 0xFF;
            int n7 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                by = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            } else {
                throw new SQLException("Cannot map Unicode to Oracle character.");
            }
        }
        if (by == -1) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return by;
    }

    byte toOracleCharacterWithReplacement(char c2, char c3) {
        byte by = -1;
        if (c3 != '\u0000') {
            int n2 = c2 >>> 8 & 0xFF;
            int n3 = c2 & 0xFF;
            int n4 = c3 >>> 8 & 0xFF;
            int n5 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != -1) {
                by = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c2 >>> 8 & 0xFF;
            int n7 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n6] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != -1) {
                by = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            } else {
                return this.m_oraCharReplacement;
            }
        }
        if (by == -1) {
            return this.m_oraCharReplacement;
        }
        return by;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            byte by;
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 >= n2 || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                by = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                ++n4;
            } else {
                by = this.toOracleCharacter(cArray[n4], '\u0000');
            }
            byArray[n3++] = by;
            ++n4;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        byte by = this.m_oraCharReplacement;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            block6: {
                block5: {
                    block3: {
                        block4: {
                            if (cArray[n4] < '\ud800' || cArray[n4] >= '\udc00') break block3;
                            if (n4 + 1 >= n2 || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') break block4;
                            by = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                            ++n4;
                            break block5;
                        }
                        byArray[n3++] = this.m_oraCharReplacement;
                        break block6;
                    }
                    by = this.toOracleCharacterWithReplacement(cArray[n4], '\u0000');
                }
                byArray[n3++] = by;
            }
            ++n4;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    int toUnicode(byte by) throws SQLException {
        int n2 = this.m_ucsChar[by & 0xFF];
        if (n2 == -1) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return n2;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        String string = new String();
        int n5 = n2;
        while (n5 < n4) {
            int n6 = this.m_ucsChar[byArray[n5] & 0xFF];
            if (n6 == this.m_ucsReplacement) {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            if (((long)n6 & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n6 >>> 16);
                string = String.valueOf(string) + (char)(n6 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n6;
            }
            ++n5;
        }
        return string;
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        String string = new String();
        int n5 = n2;
        while (n5 < n4) {
            int n6 = this.m_ucsChar[byArray[n5] & 0xFF];
            if (((long)n6 & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n6 >>> 16);
                string = String.valueOf(string) + (char)(n6 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n6;
            }
            ++n5;
        }
        return string;
    }

    int toUnicodeWithReplacement(byte by) {
        int n2 = this.m_ucsChar[by & 0xFF];
        if (n2 == -1) {
            return this.m_ucsReplacement;
        }
        return n2;
    }
}

