/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    static int hexDigit2Nibble(char c2) throws SQLException {
        int n2 = Character.digit(c2, 16);
        if (n2 == -1) {
            throw new SQLException("Invalid hex digit: " + c2);
        }
        return n2;
    }

    public static byte[] hexString2Bytes(String string) throws SQLException {
        byte[] byArray;
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = 0;
        int n4 = 0;
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 % 2 > 0) {
            byArray = new byte[(n2 + 1) / 2];
            byArray[n3++] = (byte)RAW.hexDigit2Nibble(cArray[n4++]);
        } else {
            byArray = new byte[n2 / 2];
        }
        while (n3 < byArray.length) {
            byArray[n3] = (byte)(RAW.hexDigit2Nibble(cArray[n4++]) << 4 | RAW.hexDigit2Nibble(cArray[n4++]));
            ++n3;
        }
        return byArray;
    }

    public static RAW newRAW(Object object) throws SQLException {
        RAW rAW = object instanceof String ? new RAW(RAW.hexString2Bytes((String)object)) : new RAW(object);
        return rAW;
    }

    public static RAW oldRAW(Object object) throws SQLException {
        RAW rAW;
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = null;
            try {
                byArray = string.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                DBError.throwSqlException(109, "ISO8859_1 character encoding not found");
            }
            rAW = new RAW(byArray);
        } else {
            rAW = new RAW(object);
        }
        return rAW;
    }

    public RAW() {
    }

    public RAW(byte[] byArray) {
        super(byArray);
    }

    public RAW(Object object) throws SQLException {
        this();
        if (object instanceof byte[]) {
            this.setShareBytes((byte[])object);
        } else if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = null;
            try {
                byArray = string.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                DBError.throwSqlException(109, "ISO8859_1 character encoding not found");
            }
            this.setShareBytes(byArray);
        } else {
            DBError.check_error(59, object);
        }
    }

    public Object toJdbc() throws SQLException {
        return this.getBytes();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public String stringValue() {
        String string = RepConversion.bArray2String(this.getBytes());
        return string;
    }

    public Reader characterStreamValue() throws SQLException {
        int n2 = (int)this.getLength();
        char[] cArray = new char[n2 * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
        CharArrayReader charArrayReader = new CharArrayReader(cArray);
        return charArrayReader;
    }

    public InputStream asciiStreamValue() throws SQLException {
        int n2 = (int)this.getLength();
        char[] cArray = new char[n2 * 2];
        byte[] byArray = this.shareBytes();
        DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
        byte[] byArray2 = new byte[n2 * 2];
        DBConversion.javaCharsToAsciiBytes(cArray, n2 * 2, byArray2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        return byteArrayInputStream;
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    public Object makeJdbcArray(int n2) {
        return new byte[n2][];
    }
}

