/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetUTF
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetUTF(int n2) {
        super(n2);
        this.rep = 2;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToUTF(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 2) {
            byArray2 = CharacterSet.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSet.stringToUTF(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToUTF(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        char c2;
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        if (n2 >= n3) {
            CharacterSet.failUTFConversion();
        }
        char c3 = byArray[n2++];
        int n4 = c3 & 0xF0;
        switch (n4 / 16) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                c2 = c3;
                break;
            }
            case 12: 
            case 13: {
                byte by;
                if (n2 >= n3) {
                    CharacterSet.failUTFConversion();
                }
                if (((by = byArray[n2++]) & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c2 = (char)((c3 & 0x1F) << 6 | by & 0x3F);
                break;
            }
            case 14: {
                if (n2 + 1 >= n3) {
                    CharacterSet.failUTFConversion();
                }
                byte by = byArray[n2++];
                byte by2 = byArray[n2++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c2 = (char)((c3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                break;
            }
            default: {
                CharacterSet.failUTFConversion();
                c2 = '\u0000';
            }
        }
        characterWalker.next = n2;
        return c2;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        if (n2 > 65535) {
            CharacterSet.failUTFConversion();
        } else {
            CharacterSet.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n2};
            int n3 = CharacterSet.javaCharsToUTF(cArray, 0, 1, characterBuffer.bytes, characterBuffer.next);
            characterBuffer.next += n3;
        }
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        return this.toStringWithReplacement(byArray, n2, n3);
    }

    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        char[] cArray;
        try {
            cArray = CharacterSet.UTFToJavaChar(byArray, n2, n3);
        }
        catch (SQLException sQLException) {
            cArray = new char[]{'?', '?', '?'};
        }
        return new String(cArray);
    }
}

