/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL32UTF8
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetAL32UTF8(int n2) {
        super(n2);
        this.rep = 6;
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSet.stringToAL32UTF8(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 6) {
            byArray2 = CharacterSet.useOrCopy(byArray, n2, n3);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            byArray2 = CharacterSet.stringToAL32UTF8(string);
        }
        return byArray2;
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSet.stringToAL32UTF8(string);
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        char c2;
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        if (n2 >= n3) {
            CharacterSet.failUTFConversion();
        }
        char c3 = byArray[n2++];
        int n4 = c3 & 0xF0;
        switch (n4 / 16) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                c2 = c3;
                break;
            }
            case 12: 
            case 13: {
                byte by;
                if (n2 >= n3) {
                    CharacterSet.failUTFConversion();
                }
                if (((by = byArray[n2++]) & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c2 = (char)((c3 & 0x1F) << 6 | by & 0x3F);
                break;
            }
            case 14: {
                if (n2 + 1 >= n3) {
                    CharacterSet.failUTFConversion();
                }
                byte by = byArray[n2++];
                byte by2 = byArray[n2++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c2 = (char)((c3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                break;
            }
            case 15: {
                if (n2 + 2 >= n3) {
                    CharacterSet.failUTFConversion();
                }
                byte by = byArray[n2++];
                byte by3 = byArray[n2++];
                byte by4 = byArray[n2++];
                if ((by & 0xC0) != 128 || (by3 & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                    CharacterSet.failUTFConversion();
                }
                c2 = (char)(((((c3 & 7) << 2 | (by >> 4 & 3) - 1) & 0xF) << 6 | (by & 0xF) << 2 | by3 >> 4 & 3 | 0xD800) << 16 | ((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00));
                break;
            }
            default: {
                CharacterSet.failUTFConversion();
                c2 = '\u0000';
            }
        }
        characterWalker.next = n2;
        return c2;
    }

    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        if (n2 > 65535) {
            CharacterSet.failUTFConversion();
        } else {
            CharacterSet.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n2};
            int n3 = CharacterSet.javaCharsToAL32UTF8(cArray, 0, 1, characterBuffer.bytes, characterBuffer.next);
            characterBuffer.next += n3;
        }
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.isUnicode() ^ true;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        char[] cArray = CharacterSet.AL32UTF8ToJavaChar(byArray, n2, n3);
        return new String(cArray);
    }

    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n2 + n3;
        if (n5 > byArray.length) {
            n5 = byArray.length;
        }
        char[] cArray = new char[CharacterSet.UTFStringLength(byArray, n2, n3)];
        int n6 = 0;
        while (n4 < n5) {
            byte by = byArray[n4++];
            int n7 = by & 0xF0;
            switch (n7 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)(by & 0xFF);
                    break;
                }
                case 12: 
                case 13: {
                    byte by2;
                    if (n4 >= n5) {
                        cArray[n6++] = 63;
                        n4 = n5;
                        break;
                    }
                    if (((by2 = byArray[n4++]) & 0xC0) != 128) {
                        cArray[n6++] = 63;
                        break;
                    }
                    cArray[n6++] = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                    break;
                }
                case 14: {
                    if (n4 + 1 >= n5) {
                        cArray[n6++] = 63;
                        n4 = n5;
                        break;
                    }
                    byte by2 = byArray[n4++];
                    byte by3 = byArray[n4++];
                    if ((by2 & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                        cArray[n6++] = 63;
                        break;
                    }
                    cArray[n6++] = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                    break;
                }
                case 15: {
                    if (n4 + 2 >= n5) {
                        cArray[n6++] = 63;
                        n4 = n5;
                        break;
                    }
                    byte by2 = byArray[n4++];
                    byte by3 = byArray[n4++];
                    byte by4 = byArray[n4++];
                    if ((by2 & 0xC0) != 128 || (by3 & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                        cArray[n6++] = 63;
                        break;
                    }
                    cArray[n6++] = (char)((((by & 7) << 2 | (by2 >> 4 & 3) - 1) & 0xF) << 6 | (by2 & 0xF) << 2 | by3 >> 4 & 3 | 0xD800);
                    cArray[n6++] = (char)((by3 & 0xF) << 6 | by4 & 0x3F | 0xDC00);
                    break;
                }
                default: {
                    cArray[n6++] = 63;
                }
            }
        }
        return new String(cArray);
    }
}

