/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.util.RepConversion;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class CHAR
extends Datum {
    public static final CharacterSet DEFAULT_CHARSET = CharacterSet.make(-1);
    private CharacterSet charSet;
    private int oracleId;
    private static byte[] empty = new byte[0];

    protected CHAR() {
    }

    public CHAR(byte[] byArray, CharacterSet characterSet) {
        this.setValue(byArray, characterSet);
    }

    public CHAR(byte[] byArray, int n2, int n3, CharacterSet characterSet) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.setValue(byArray2, characterSet);
    }

    public CHAR(String string, CharacterSet characterSet) throws SQLException {
        if (characterSet == null) {
            characterSet = DEFAULT_CHARSET;
        }
        this.setValue(characterSet.convert(string), characterSet);
    }

    public CHAR(Object object, CharacterSet characterSet) throws SQLException {
        this(object.toString(), characterSet);
    }

    public CharacterSet getCharacterSet() {
        if (this.charSet == null) {
            if (this.oracleId == 0) {
                this.oracleId = -1;
            }
            this.charSet = CharacterSet.make(this.oracleId);
        }
        return this.charSet;
    }

    public String getString() throws SQLException {
        String string = this.getCharacterSet().toString(this.shareBytes(), 0, (int)this.getLength());
        return string;
    }

    public String getStringWithReplacement() {
        byte[] byArray = this.shareBytes();
        String string = this.getCharacterSet().toStringWithReplacement(byArray, 0, byArray.length);
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        block3: {
            try {
                var1_1 = this.getString();
                break block3;
            }
            catch (SQLException var2_2) {
                var3_3 = new StringBuffer();
                var3_3.append("0x");
                var4_4 = this.shareBytes();
                var5_5 = 0;
                ** while (var5_5 < var4_4.length)
            }
lbl-1000:
            // 1 sources

            {
                var3_3.append((char)RepConversion.nibbleToHex((byte)(var4_4[var5_5] >> 4 & 15)));
                var3_3.append((char)RepConversion.nibbleToHex((byte)(var4_4[var5_5] & 15)));
                ++var5_5;
                continue;
            }
lbl17:
            // 1 sources

            var1_1 = var3_3.toString();
        }
        return var1_1;
    }

    public boolean equals(Object object) {
        return object instanceof CHAR && this.getCharacterSet().equals(((CHAR)object).getCharacterSet()) && super.equals(object);
    }

    void setValue(byte[] byArray, CharacterSet characterSet) {
        this.charSet = characterSet == null ? DEFAULT_CHARSET : characterSet;
        this.oracleId = this.charSet.getOracleId();
        this.setShareBytes(byArray == null ? empty : byArray);
    }

    public Object toJdbc() throws SQLException {
        return this.stringValue();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.sql.Date") == 0 || string.compareTo("java.sql.Time") == 0 || string.compareTo("java.sql.Timestamp") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public String stringValue() {
        return this.toString();
    }

    public boolean booleanValue() throws SQLException {
        boolean bl = false;
        String string = this.stringValue();
        bl = string == null ? false : string.length() != 1 || string.charAt(0) != '0';
        return bl;
    }

    public int intValue() throws SQLException {
        long l2 = this.longValue();
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            DBError.throwSqlException(26);
        }
        int n2 = (int)l2;
        return n2;
    }

    public long longValue() throws SQLException {
        long l2 = 0L;
        try {
            l2 = Long.valueOf(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DBError.throwSqlException(59);
        }
        return l2;
    }

    public float floatValue() throws SQLException {
        float f2 = 0.0f;
        try {
            f2 = Float.valueOf(this.stringValue()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            DBError.throwSqlException(59);
        }
        return f2;
    }

    public double doubleValue() throws SQLException {
        double d2 = 0.0;
        try {
            d2 = Double.valueOf(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DBError.throwSqlException(59);
        }
        return d2;
    }

    public byte byteValue() throws SQLException {
        long l2 = this.longValue();
        if (l2 > 127L || l2 < -128L) {
            DBError.throwSqlException(26);
        }
        byte by = (byte)l2;
        return by;
    }

    public Date dateValue() throws SQLException {
        Date date = Date.valueOf(this.stringValue());
        return date;
    }

    public Time timeValue() throws SQLException {
        Time time = Time.valueOf(this.stringValue());
        return time;
    }

    public Timestamp timestampValue() throws SQLException {
        Timestamp timestamp = Timestamp.valueOf(this.stringValue());
        return timestamp;
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DBError.check_error(12, "bigDecimalValue");
        }
        return bigDecimal;
    }

    public Reader characterStreamValue() throws SQLException {
        StringReader stringReader = new StringReader(this.getString());
        return stringReader;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    public Object makeJdbcArray(int n2) {
        return new String[n2];
    }
}

