rem : Module     - genstats.bat
rem : Updated    - 08/26/2004
rem :              - Sun used to goto 'Next', corrected to goto 'phy1'
rem :              - 'phy1' label relocated to precede the net send
rem : Purpose    - Generate database statistics pre and post repair runs

rem : Run From   - c:\Program Files\Microsoft Visual Studio\Common\Vss\Utilities
rem                (Create as peer of ....\Vss\Win32 directory)

rem : Parameters  NOTE! Full path parameters MUST be quoted strings!
rem : - %1 Drive letter of drive containing the ...\vss\data directory e.g: X
rem        Not used. Enter a dummy parameter e.g null
rem : - %2 Full path to data directory e.g: X:\....\vss\data
rem        Not used. Enter a dummy parameter e.g null
rem : - %3 Drive letter of drive containing ...\Common\vss\win32 directory e.g.: C
rem : - %4 Full path to the vss install directory e.g.: c:\Program Files\...\Common\vss
rem : - %5 Configuration engineer email name
rem : - %6 Yourcompany.com
rem        Not used. Enter a dummy parameter e.g null
rem : - %7 PRE_REPAIR or POST_REPAIR

rem : Outputs    - tool logs
rem :            - ssutility.log : record of utility processing.

rem : Pre-Req #1 - dow.com must be in the Utilities directory

rem : Modifications :
rem           #1 - permanently modify the batch file to set the admin
rem                name and password needed by ssrights or modify it
rem                to take these as extra parameters 8 and 9 and
rem                change the ssrights line.
rem           #2 - If you want to used the extended 'ssxphysical' utility
rem                change the call to 'physical_day_gen.bat' to 'xphysical_day_gen.bat'

rem : -----------------------------------------------------------------------

rem : set administrator acccount for the ssrights step
set adminact=admin
rem : set administrator password for the ssrights step
set adminpwd=(0diT!2

rem : Remove quotes from parameter 4
set ssparm4=%4
set ssparm4=%ssparm4:"=%
set ssparm4=%ssparm4:"=%

rem : switch to the vss program drive utility directory
%3%:
cd "%ssparm4%\Utilities"

rem : -----------------------------------------------------------------------
rem : generate database-logical file concordance
call physical_day_gen.bat null null %3 %4 %5

rem : Copy output physical.day to physical.day_PRE_REPAIR or _POST_REPAIR
dow
echo off
if ERRORLEVEL=6 goto Sat
if ERRORLEVEL=5 goto Fri
if ERRORLEVEL=4 goto Thu
if ERRORLEVEL=3 goto Wed
if ERRORLEVEL=2 goto Tue
if ERRORLEVEL=1 goto Mon
if ERRORLEVEL=0 goto Sun
echo on
net send %5% genstats.bat dow error
goto Exit:

:Sun
copy physical.sun physical.sun_%6%
goto phy1

:Sat
copy physical.sat physical.sat_%6%
goto phy1

:Fri
copy physical.fri physical.fri_%6%
goto phy1

:Thu
copy physical.thu physical.thu_%6%
goto phy1

:Wed
copy physical.wed physical.wed_%6%
goto phy1

:Tue
copy physical.tue physical.tue_%6%
goto phy1

:Mon
copy physical.mon physical.mon_%6%

:phy1

rem : -----------------------------------------------------------------------
rem : ssdir database tree with project-file counts but without usage analysis
rem : output ssdir.txt
net send %5% genstats.bat ssdir run started.
erase ssdir.bat
erase ssdir.$$$
ssdir.exe $/
rem Report exit return from ssdir
echo off
FOR %%E IN (0,1,2) DO IF ERRORLEVEL %%E00 SET ERLVL=%%E
IF "%ERLVL%"=="0" SET ERLVL=
SET RANGE=0,1,2,3,4,5,6,7,8,9
IF "%ERLVL%"=="2" SET RANGE=0,1,2,3,4,5
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E0 SET ERLVL=%ERLVL%%%E
IF "%ERLVL%"=="0" SET ERLVL=
IF NOT "%ERLVL%"=="25" SET RANGE=0,1,2,3,4,5,6,7,8,9
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E SET ERLVL=%ERLVL%%%E
SET RANGE=
net send %5% genstats.bat : ssdir exit code = %ERLVL%.
echo exit|cmd /q /k prompt $D $T genstats.bat : ssdir exit code = %ERLVL% >> ssutility.log

rem : -----------------------------------------------------------------------
rem : check ssphysical output against ssdir output and report differences
rem : Output sscheck.txt
dow
echo off
if ERRORLEVEL=6 goto Sat
if ERRORLEVEL=5 goto Fri
if ERRORLEVEL=4 goto Thu
if ERRORLEVEL=3 goto Wed
if ERRORLEVEL=2 goto Tue
if ERRORLEVEL=1 goto Mon
if ERRORLEVEL=0 goto Sun
echo on
net send %5% genstats.bat dow error
goto Exit:

:Sun
net send %5% genstats.bat sscheck (Sun) run started.
sscheck ssdir.txt physical.sun
goto Next

:Sat
net send %5% genstats.bat sscheck (Sat) run started.
sscheck ssdir.txt physical.sat
goto Next

:Fri
net send %5% genstats.bat sscheck (Fri) run started.
goto Next

:Thu
net send %5% genstats.bat sscheck (Thu) run started.
sscheck ssdir.txt physical.thu
goto Next

:Wed
net send %5% genstats.bat sscheck (Wed) run started.
sscheck ssdir.txt physical.wed
goto Next

:Tue
net send %5% genstats.bat sscheck (Tue) run started.
sscheck ssdir.txt physical.tue
goto Next

:Mon
net send %5% genstats.bat sscheck (Mon) run started.
sscheck ssdir.txt physical.mon


:Next
rem Report exit return from sscheck
echo off
FOR %%E IN (0,1,2) DO IF ERRORLEVEL %%E00 SET ERLVL=%%E
IF "%ERLVL%"=="0" SET ERLVL=
SET RANGE=0,1,2,3,4,5,6,7,8,9
IF "%ERLVL%"=="2" SET RANGE=0,1,2,3,4,5
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E0 SET ERLVL=%ERLVL%%%E
IF "%ERLVL%"=="0" SET ERLVL=
IF NOT "%ERLVL%"=="25" SET RANGE=0,1,2,3,4,5,6,7,8,9
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E SET ERLVL=%ERLVL%%%E
SET RANGE=
net send %5% genstats.bat : sscheck exit code = %ERLVL%.
echo exit|cmd /q /k prompt $D $T genstats.bat : sscheck exit code = %ERLVL% >> ssutility.log

rem : Save sscheck output as _PRE or POST
copy sscheck.txt sscheck.txt_%7%

rem : -----------------------------------------------------------------------
rem : generate list of directories to which the logged on user does NOT have access rights
rem : Output ssrights.txt
net send %5% genstats.bat ssrights run started.

ssrights $/  -Y%adminact%,%adminpwd% -RN
rem Report exit return from ssrights
echo off
FOR %%E IN (0,1,2) DO IF ERRORLEVEL %%E00 SET ERLVL=%%E
IF "%ERLVL%"=="0" SET ERLVL=
SET RANGE=0,1,2,3,4,5,6,7,8,9
IF "%ERLVL%"=="2" SET RANGE=0,1,2,3,4,5
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E0 SET ERLVL=%ERLVL%%%E
IF "%ERLVL%"=="0" SET ERLVL=
IF NOT "%ERLVL%"=="25" SET RANGE=0,1,2,3,4,5,6,7,8,9
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E SET ERLVL=%ERLVL%%%E
SET RANGE=

net send %5% genstats.bat : ssrights exit code = %ERLVL%.
echo exit|cmd /q /k prompt $D $T genstats.bat : ssrights exit code = %ERLVL% >> ssutility.log

rem : Save ssrights output as _PRE or POST
copy ssrights.txt ssrights.txt_%7%

rem : -----------------------------------------------------------------------
rem : List files in the SourceSafe database deleted but not yet purged
rem : Output ssdelist.txt
net send %5% genstats.bat ssdelist run started.

ssdelist
rem Report exit return from ssdelist
echo off
FOR %%E IN (0,1,2) DO IF ERRORLEVEL %%E00 SET ERLVL=%%E
IF "%ERLVL%"=="0" SET ERLVL=
SET RANGE=0,1,2,3,4,5,6,7,8,9
IF "%ERLVL%"=="2" SET RANGE=0,1,2,3,4,5
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E0 SET ERLVL=%ERLVL%%%E
IF "%ERLVL%"=="0" SET ERLVL=
IF NOT "%ERLVL%"=="25" SET RANGE=0,1,2,3,4,5,6,7,8,9
FOR %%E IN (%RANGE%) DO IF ERRORLEVEL %ERLVL%%%E SET ERLVL=%ERLVL%%%E
SET RANGE=

net send %5% genstats.bat : ssdelist exit code = %ERLVL%.
echo exit|cmd /q /k prompt $D $T genstats.bat : ssdelist exit code = %ERLVL% >> ssutility.log

rem : Save ssdelist output as _PRE or POST
copy ssdelist.txt ssdelist.txt_%7%

:Exit
net send %5% genstats.bat completed.
echo exit|cmd /q /k prompt $D $T genstats.bat : ended >> ssutility.log

exit

