/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceForeignKey;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.SourceKey;
import unity.globalschema.GlobalSchema;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;

public class UnityDatabaseMetaData
implements DatabaseMetaData {
    int procedureResultUnknown = 0;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown = 0;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int procedureColumnResult = 3;
    int procedureNoNulls = 0;
    int procedureNullable = 1;
    int procedureNullableUnknown = 2;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown = 0;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade = 0;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int importedKeyNoAction = 3;
    int importedKeySetDefault = 4;
    int importedKeyInitiallyDeferred = 5;
    int importedKeyInitiallyImmediate = 6;
    int importedKeyNotDeferrable = 7;
    int typeNoNulls = 0;
    int typeNullable = 1;
    int typeNullableUnknown = 2;
    int typePredNone = 0;
    int typePredChar = 1;
    int typePredBasic = 2;
    int typeSearchable = 3;
    short tableIndexStatistic = 0;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;
    short attributeNoNulls = 0;
    short attributeNullable = 1;
    short attributeNullableUnknown = (short)2;
    int sqlStateXOpen = 1;
    int sqlStateSQL99 = 2;
    protected GlobalSchema gs;
    protected UnityConnection conn;

    public UnityDatabaseMetaData(GlobalSchema s, UnityConnection c) {
        this.gs = s;
        this.conn = c;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return this.gs.getSourcesURL();
    }

    public String getUserName() throws SQLException {
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "UnityJDBC";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return "1.0";
    }

    public String getDriverName() throws SQLException {
        return UnityDriver.DRIVER_NAME;
    }

    public String getDriverVersion() throws SQLException {
        return "1.0";
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return null;
    }

    public String getNumericFunctions() throws SQLException {
        return null;
    }

    public String getStringFunctions() throws SQLException {
        return null;
    }

    public String getSystemFunctions() throws SQLException {
        return null;
    }

    public String getTimeDateFunctions() throws SQLException {
        return null;
    }

    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int arg0, int arg1) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    public String getSchemaTerm() throws SQLException {
        return null;
    }

    public String getProcedureTerm() throws SQLException {
        return null;
    }

    public String getCatalogTerm() throws SQLException {
        return null;
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return false;
    }

    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String[] columns = new String[10];
        ArrayList<AnnotatedSourceField> metadata = new ArrayList<AnnotatedSourceField>(10);
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_TYPE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 5, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TYPE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TYPE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 7, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "SELF_REFERENCING_COL_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 9, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "REF_GENERATION", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 10, "YES"));
        int i = 0;
        while (i < 10) {
            columns[i] = ((AnnotatedSourceField)metadata.get(i)).getColumnName();
            ++i;
        }
        ArrayList data = new ArrayList();
        ArrayList dbs = this.gs.getAnnotatedDatabases();
        this.sortByDatabaseName(dbs);
        String dbPattern = this.buildRegEx(schemaPattern);
        String tblPattern = this.buildRegEx(tableNamePattern);
        int i2 = 0;
        while (i2 < dbs.size()) {
            AnnotatedSourceDatabase asd = (AnnotatedSourceDatabase)dbs.get(i2);
            String dbName = asd.getDatabaseName();
            if (schemaPattern == null || dbName.matches(dbPattern)) {
                HashMap sourceTables = asd.getSourceTables();
                Iterator tbls = sourceTables.values().iterator();
                AnnotatedSourceTable[] tblArray = new AnnotatedSourceTable[sourceTables.values().size()];
                int j = 0;
                while (tbls.hasNext()) {
                    tblArray[j++] = (AnnotatedSourceTable)tbls.next();
                }
                this.sortByTableName(tblArray);
                j = 0;
                while (j < tblArray.length) {
                    AnnotatedSourceTable ast = tblArray[j];
                    String tableName = ast.getTableName();
                    if (tableNamePattern == null || tableName.matches(tblPattern)) {
                        ArrayList<String> row = new ArrayList<String>(10);
                        row.add(null);
                        row.add(dbName);
                        row.add(tableName);
                        row.add("TABLE");
                        row.add("");
                        row.add(null);
                        row.add(null);
                        row.add(null);
                        row.add(null);
                        row.add(null);
                        data.add(row);
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return new LocalResultSet(data, columns, metadata);
    }

    private String buildRegEx(String input) {
        if (input == null) {
            return null;
        }
        String output = input.replaceAll("%", ".*");
        return output.replaceAll("_", ".");
    }

    public ResultSet getSchemas() throws SQLException {
        String[] columns = new String[2];
        ArrayList<AnnotatedSourceField> metadata = new ArrayList<AnnotatedSourceField>(2);
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_CATALOG", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        int i = 0;
        while (i < 2) {
            columns[i] = ((AnnotatedSourceField)metadata.get(i)).getColumnName();
            ++i;
        }
        ArrayList data = new ArrayList();
        ArrayList dbs = this.gs.getAnnotatedDatabases();
        this.sortByDatabaseName(dbs);
        int i2 = 0;
        while (i2 < dbs.size()) {
            AnnotatedSourceDatabase asd = (AnnotatedSourceDatabase)dbs.get(i2);
            String dbName = asd.getDatabaseName();
            ArrayList<String> row = new ArrayList<String>(2);
            row.add(dbName);
            row.add(null);
            data.add(row);
            ++i2;
        }
        return new LocalResultSet(data, columns, metadata);
    }

    private void sortByDatabaseName(ArrayList dbs) {
        boolean swapped = true;
        while (swapped) {
            swapped = false;
            int i = 0;
            while (i < dbs.size() - 1) {
                AnnotatedSourceDatabase db1 = (AnnotatedSourceDatabase)dbs.get(i);
                AnnotatedSourceDatabase db2 = (AnnotatedSourceDatabase)dbs.get(i + 1);
                if (db1.getDatabaseName().compareTo(db2.getDatabaseName()) > 0) {
                    swapped = true;
                    Object tmp = dbs.get(i);
                    dbs.set(i, dbs.get(i + 1));
                    dbs.set(i + 1, tmp);
                }
                ++i;
            }
        }
    }

    private void sortByTableName(AnnotatedSourceTable[] tbls) {
        boolean swapped = true;
        while (swapped) {
            swapped = false;
            int i = 0;
            while (i < tbls.length - 1) {
                if (tbls[i].getTableName().compareTo(tbls[i + 1].getTableName()) > 0) {
                    swapped = true;
                    AnnotatedSourceTable tmp = tbls[i];
                    tbls[i] = tbls[i + 1];
                    tbls[i + 1] = tmp;
                }
                ++i;
            }
        }
    }

    private void sortByFieldPosition(AnnotatedSourceField[] flds) {
        boolean swapped = true;
        while (swapped) {
            swapped = false;
            int i = 0;
            while (i < flds.length - 1) {
                if (flds[i].getOrdinalPosition() > flds[i + 1].getOrdinalPosition()) {
                    swapped = true;
                    AnnotatedSourceField tmp = flds[i];
                    flds[i] = flds[i + 1];
                    flds[i + 1] = tmp;
                }
                ++i;
            }
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        return null;
    }

    public ResultSet getTableTypes() throws SQLException {
        return null;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        int mdsize = 22;
        String[] columns = new String[mdsize];
        ArrayList<AnnotatedSourceField> metadata = new ArrayList<AnnotatedSourceField>(mdsize);
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TYPE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "COLUMN_SIZE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "BUFFER_LENGTH", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "DECIMAL_DIGITS", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 9, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "NUM_PREC_RADIX", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "NULLABLE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 11, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "REMARKS", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 12, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "COLUMN_DEF", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 13, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "SQL_DATA_TYPE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 14, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "SQL_DATETIME_SUB", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 15, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "CHAR_OCTET_LENGTH", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 16, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "ORDINAL_POSITION", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 17, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "IS_NULLABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 18, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "SCOPE_CATLOG", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 19, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "SCOPE_SCHEMA", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 20, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "SCOPE_TABLE", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 21, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "SOURCE_DATA_TYPE", 4, "INTEGER", 255, 0, 0, 0, "", null, 0, 22, "YES"));
        int i = 0;
        while (i < mdsize) {
            columns[i] = ((AnnotatedSourceField)metadata.get(i)).getColumnName();
            ++i;
        }
        ArrayList data = new ArrayList();
        ArrayList dbList = this.gs.getAnnotatedDatabases();
        this.sortByDatabaseName(dbList);
        String dbPattern = this.buildRegEx(schemaPattern);
        String tblPattern = this.buildRegEx(tableNamePattern);
        String colPattern = this.buildRegEx(columnNamePattern);
        int i2 = 0;
        while (i2 < dbList.size()) {
            AnnotatedSourceDatabase asd = (AnnotatedSourceDatabase)dbList.get(i2);
            String dbName = asd.getDatabaseName();
            if (schemaPattern == null || dbName.matches(dbPattern)) {
                HashMap sourceTables = asd.getSourceTables();
                Iterator tbls = sourceTables.values().iterator();
                AnnotatedSourceTable[] tblArray = new AnnotatedSourceTable[sourceTables.values().size()];
                int j = 0;
                while (tbls.hasNext()) {
                    tblArray[j++] = (AnnotatedSourceTable)tbls.next();
                }
                this.sortByTableName(tblArray);
                j = 0;
                while (j < tblArray.length) {
                    AnnotatedSourceTable ast = tblArray[j];
                    String tableName = ast.getTableName();
                    if (tableNamePattern == null || tableName.matches(tblPattern)) {
                        HashMap fieldsMap = ast.getSourceFields();
                        Iterator fields = fieldsMap.values().iterator();
                        AnnotatedSourceField[] fieldArray = new AnnotatedSourceField[fieldsMap.values().size()];
                        int k = 0;
                        while (fields.hasNext()) {
                            fieldArray[k++] = (AnnotatedSourceField)fields.next();
                        }
                        this.sortByFieldPosition(fieldArray);
                        k = 0;
                        while (k < fieldArray.length) {
                            AnnotatedSourceField asf = fieldArray[k];
                            String fieldName = asf.getColumnName();
                            if (columnNamePattern == null || fieldName.matches(colPattern)) {
                                ArrayList<Object> row = new ArrayList<Object>(mdsize);
                                row.add(null);
                                row.add(dbName);
                                row.add(tableName);
                                row.add(fieldName);
                                row.add(new Integer(asf.getDataType()));
                                row.add(asf.getDataTypeName());
                                row.add(null);
                                row.add(new Integer(asf.getDecimalDigits()));
                                row.add(new Integer(10));
                                row.add(new Integer(asf.getNullable()));
                                row.add(asf.getRemarks());
                                row.add(null);
                                row.add(null);
                                row.add(null);
                                row.add(new Integer(asf.getCharacterOctetLength()));
                                row.add(new Integer(asf.getOrdinalPosition()));
                                row.add(asf.getIsNullable());
                                row.add(null);
                                row.add(null);
                                row.add(null);
                                row.add(null);
                                data.add(row);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return new LocalResultSet(data, columns, metadata);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return null;
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String tableName = String.valueOf(schema) + "." + table;
        ArrayList res = this.gs.findTable(tableName);
        if (res == null) {
            return null;
        }
        if (res.size() > 1) {
            throw new SQLException("Ambiguous table name provided: " + tableName);
        }
        int mdsize = 6;
        String[] columns = new String[mdsize];
        ArrayList<AnnotatedSourceField> metadata = new ArrayList<AnnotatedSourceField>(mdsize);
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "TABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "COLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "KEY_SEQ", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 6, "YES"));
        int i = 0;
        while (i < mdsize) {
            columns[i] = ((AnnotatedSourceField)metadata.get(i)).getColumnName();
            ++i;
        }
        ArrayList data = new ArrayList();
        ArrayList<Object> row = new ArrayList<Object>(mdsize);
        AnnotatedSourceTable ast = (AnnotatedSourceTable)res.get(0);
        SourceKey pkey = ast.getPrimaryKey();
        ArrayList flds = pkey.getFields();
        int k = 0;
        while (k < flds.size()) {
            AnnotatedSourceField asf = (AnnotatedSourceField)flds.get(k);
            row.add(null);
            row.add(ast.getParentDatabase().getDatabaseName());
            row.add(ast.getTableName());
            row.add(asf.getColumnName());
            row.add(new Integer(k));
            row.add(pkey.getName());
            data.add(row);
            ++k;
        }
        return new LocalResultSet(data, columns, metadata);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String tableName = String.valueOf(schema) + "." + table;
        ArrayList res = this.gs.findTable(tableName);
        if (res == null) {
            return null;
        }
        if (res.size() > 1) {
            throw new SQLException("Ambiguous table name provided: " + tableName);
        }
        int mdsize = 10;
        String[] columns = new String[mdsize];
        ArrayList<AnnotatedSourceField> metadata = new ArrayList<AnnotatedSourceField>(mdsize);
        metadata.add(new AnnotatedSourceField(null, null, null, "PKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "KEY_SEQ", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "UPDATE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 6, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "DELETE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "FK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 9, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "DEFERRABILITY", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        int i = 0;
        while (i < mdsize) {
            columns[i] = ((AnnotatedSourceField)metadata.get(i)).getColumnName();
            ++i;
        }
        ArrayList data = new ArrayList();
        ArrayList<Object> row = new ArrayList<Object>(mdsize);
        AnnotatedSourceTable ast = (AnnotatedSourceTable)res.get(0);
        ArrayList fkeys = ast.getForeignKeys();
        int i2 = 0;
        while (i2 < fkeys.size()) {
            AnnotatedSourceForeignKey asfk = (AnnotatedSourceForeignKey)fkeys.get(i2);
            ArrayList flds = asfk.getFields();
            SourceKey aspk = asfk.getToKey();
            int k = 0;
            while (k < flds.size()) {
                AnnotatedSourceField asf = (AnnotatedSourceField)flds.get(k);
                row.add(null);
                row.add(aspk.getTable().getParentDatabase().getDatabaseName());
                row.add(aspk.getTable().getTableName());
                row.add(asf.getColumnName());
                row.add(new Integer(k));
                row.add(new Integer(0));
                row.add(new Integer(0));
                row.add(aspk.getName());
                row.add(asfk.getName());
                row.add(new Integer(0));
                data.add(row);
                ++k;
            }
            ++i2;
        }
        return new LocalResultSet(data, columns, metadata);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String tableName = String.valueOf(schema) + "." + table;
        AnnotatedSourceDatabase asd = this.gs.getDB(schema);
        if (asd == null) {
            return null;
        }
        ArrayList res = this.gs.findTable(tableName);
        if (res == null) {
            return null;
        }
        if (res.size() > 1) {
            throw new SQLException("Ambiguous table name provided: " + tableName);
        }
        int mdsize = 10;
        String[] columns = new String[mdsize];
        ArrayList<AnnotatedSourceField> metadata = new ArrayList<AnnotatedSourceField>(mdsize);
        metadata.add(new AnnotatedSourceField(null, null, null, "PKTABLE_CAT", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 1, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PKTABLE_SCHEM", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 2, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PKTABLE_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 3, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PKCOLUMN_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 4, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "KEY_SEQ", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 5, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "UPDATE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 6, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "DELETE_RULE", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 7, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "PK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 8, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "FK_NAME", 12, "VARCHAR", 255, 0, 0, 0, "", null, 0, 9, "YES"));
        metadata.add(new AnnotatedSourceField(null, null, null, "DEFERRABILITY", 4, "INTEGER", 10, 0, 0, 0, "", null, 0, 10, "YES"));
        int i = 0;
        while (i < mdsize) {
            columns[i] = ((AnnotatedSourceField)metadata.get(i)).getColumnName();
            ++i;
        }
        ArrayList data = new ArrayList();
        ArrayList<Object> row = new ArrayList<Object>(mdsize);
        AnnotatedSourceTable ast = (AnnotatedSourceTable)res.get(0);
        HashMap sourceTables = asd.getSourceTables();
        Iterator tbls = sourceTables.values().iterator();
        AnnotatedSourceTable[] tblArray = new AnnotatedSourceTable[sourceTables.values().size()];
        int j = 0;
        while (tbls.hasNext()) {
            tblArray[j++] = (AnnotatedSourceTable)tbls.next();
        }
        this.sortByTableName(tblArray);
        j = 0;
        while (j < tblArray.length) {
            AnnotatedSourceTable fkTable = tblArray[j];
            ArrayList fkeys = fkTable.getForeignKeys();
            int i2 = 0;
            while (i2 < fkeys.size()) {
                AnnotatedSourceForeignKey asfk = (AnnotatedSourceForeignKey)fkeys.get(i2);
                if (asfk.getTable() == ast) {
                    ArrayList flds = asfk.getFields();
                    SourceKey aspk = asfk.getToKey();
                    int k = 0;
                    while (k < flds.size()) {
                        AnnotatedSourceField asf = (AnnotatedSourceField)flds.get(k);
                        row.add(null);
                        row.add(aspk.getTable().getParentDatabase().getDatabaseName());
                        row.add(aspk.getTable().getTableName());
                        row.add(asf.getColumnName());
                        row.add(new Integer(k));
                        row.add(new Integer(0));
                        row.add(new Integer(0));
                        row.add(aspk.getName());
                        row.add(asfk.getName());
                        row.add(new Integer(0));
                        data.add(row);
                        ++k;
                    }
                }
                ++i2;
            }
            ++j;
        }
        return new LocalResultSet(data, columns, metadata);
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return null;
    }

    public ResultSet getTypeInfo() throws SQLException {
        return null;
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return null;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type != 1005;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return true;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return null;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return null;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return 1;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 1;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 0;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }
}

