VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{57B5A17C-6DC0-4776-8F51-5519BF1235A6}#31.0#0"; "rsp-zip-compress-s130.ocx"
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RSP Zip Compressor - Debug Sample"
   ClientHeight    =   5685
   ClientLeft      =   45
   ClientTop       =   615
   ClientWidth     =   7965
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5685
   ScaleWidth      =   7965
   StartUpPosition =   2  'CenterScreen
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   6120
      TabIndex        =   31
      Text            =   "Combo1"
      Top             =   2280
      Width           =   1695
   End
   Begin VB.CommandButton Command7 
      Caption         =   "Get CPU speed"
      Height          =   255
      Left            =   120
      TabIndex        =   27
      Top             =   5075
      Width           =   1335
   End
   Begin RSPZipCompress130s.RSPZip RSPZip1 
      Left            =   5040
      Top             =   1320
      _ExtentX        =   979
      _ExtentY        =   979
   End
   Begin ComctlLib.ProgressBar ProgressBar1 
      Height          =   255
      Left            =   120
      TabIndex        =   26
      Top             =   4800
      Width           =   7695
      _ExtentX        =   13573
      _ExtentY        =   450
      _Version        =   327682
      Appearance      =   1
   End
   Begin VB.CommandButton Command6 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   6840
      TabIndex        =   25
      Top             =   1800
      Width           =   975
   End
   Begin VB.CommandButton Command5 
      Caption         =   "Resume"
      Height          =   375
      Left            =   5760
      TabIndex        =   24
      Top             =   1800
      Width           =   975
   End
   Begin VB.CommandButton Command4 
      Caption         =   "Pause"
      Height          =   375
      Left            =   6840
      TabIndex        =   23
      Top             =   1320
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Select"
      Height          =   255
      Left            =   1440
      TabIndex        =   19
      Top             =   720
      Width           =   1215
   End
   Begin VB.ListBox List1 
      Height          =   450
      Left            =   120
      TabIndex        =   22
      Top             =   4320
      Width           =   7695
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   6360
      Top             =   2760
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Select"
      Height          =   255
      Left            =   1440
      TabIndex        =   20
      Top             =   0
      Width           =   1215
   End
   Begin VB.TextBox Text6 
      Height          =   495
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   18
      Top             =   3600
      Width           =   7695
   End
   Begin VB.TextBox Text5 
      Height          =   735
      Left            =   120
      MultiLine       =   -1  'True
      TabIndex        =   17
      Top             =   2640
      Width           =   7695
   End
   Begin VB.TextBox Text4 
      Height          =   285
      Left            =   1440
      TabIndex        =   15
      Text            =   "*.*"
      Top             =   360
      Width           =   6375
   End
   Begin VB.CheckBox Check4 
      Caption         =   "Test zip file (check whether the zip file is not damaged)"
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   2160
      Width           =   4455
   End
   Begin VB.CheckBox Check3 
      Caption         =   "Freshen files (extract only files that exist on disk but are older)"
      Height          =   255
      Left            =   120
      TabIndex        =   12
      Top             =   1920
      Width           =   4935
   End
   Begin VB.CheckBox Check2 
      Caption         =   "Don't overwrite (don't overwrite files in the destination folder)"
      Height          =   255
      Left            =   120
      TabIndex        =   11
      Top             =   1680
      Width           =   4815
   End
   Begin VB.CheckBox Check1 
      Caption         =   "Overwrite (overwrite files on the destination folder)"
      Height          =   255
      Left            =   120
      TabIndex        =   10
      Top             =   1440
      Value           =   1  'Checked
      Width           =   4095
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Unzip"
      Height          =   375
      Left            =   5760
      TabIndex        =   7
      Top             =   1320
      Width           =   975
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   2760
      TabIndex        =   5
      Text            =   "c:\my destination directory"
      Top             =   720
      Width           =   5055
   End
   Begin VB.TextBox Text2 
      Height          =   285
      Left            =   1440
      TabIndex        =   2
      Text            =   "the password"
      Top             =   1080
      Width           =   3135
   End
   Begin VB.TextBox Text1 
      Height          =   285
      Left            =   2760
      TabIndex        =   0
      Text            =   "c:\my zip files\my zip.zip"
      Top             =   0
      Width           =   5055
   End
   Begin VB.Label Label12 
      Caption         =   "Processor priority :"
      Height          =   255
      Left            =   4800
      TabIndex        =   30
      Top             =   2355
      Width           =   1455
   End
   Begin VB.Label Label7 
      Caption         =   "Elapsed :"
      Height          =   255
      Left            =   120
      TabIndex        =   29
      Top             =   5400
      Width           =   3015
   End
   Begin VB.Label Label11 
      Caption         =   "Label11"
      Height          =   255
      Left            =   1560
      TabIndex        =   28
      Top             =   5100
      Width           =   7455
   End
   Begin VB.Label Label5 
      Caption         =   "Internal error and description:"
      Height          =   255
      Left            =   120
      TabIndex        =   21
      Top             =   4080
      Width           =   2175
   End
   Begin VB.Label Label10 
      Caption         =   "Status:"
      Height          =   255
      Left            =   6240
      TabIndex        =   16
      Top             =   1080
      Width           =   1575
   End
   Begin VB.Label Label9 
      Caption         =   "Files to extract:"
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   390
      Width           =   2415
   End
   Begin VB.Label Label8 
      Caption         =   "  RSP Software 1996-2004"
      Height          =   255
      Left            =   5880
      TabIndex        =   9
      Top             =   5400
      Width           =   3015
   End
   Begin VB.Label Label6 
      Caption         =   "Unzip function return code and description:"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   3375
      Width           =   4215
   End
   Begin VB.Label Label4 
      Caption         =   "Command: "
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   2400
      Width           =   735
   End
   Begin VB.Label Label3 
      Caption         =   "Destination path:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   750
      Width           =   1935
   End
   Begin VB.Label Label2 
      Caption         =   "Password:"
      Height          =   255
      Left            =   600
      TabIndex        =   3
      Top             =   1110
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "Zip file to unzip:"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   30
      Width           =   3375
   End
   Begin VB.Menu about 
      Caption         =   "About"
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'RSP Software - Mon Feb 09 15:36:09 2004 - http://rspsoftware.clic3.net

'RSP Zip Compressor OCX 1.3.0 , sample project

Private Declare Function GetTickCount Lib "kernel32" () As Long
Dim First As Long 'To hold profile variable

Private Sub about_Click()
    RSPZip1.About
End Sub

Private Sub Check1_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Check1.value = 1
    Check2.value = 0
    Check3.value = 0
End Sub

Private Sub Check2_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Check1.value = 0
    Check2.value = 1
    Check3.value = 0
End Sub

Private Sub Check3_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Check1.value = 0
    Check2.value = 0
    Check3.value = 1
End Sub

Private Sub Command1_Click()
    
    CommonDialog1.ShowOpen
    Text1.Text = CommonDialog1.filename
    
End Sub

Private Sub Command2_Click()
    Dim Comando As String
    Dim Ret As Long
    Text6.Text = ""
    Label10.Caption = "Status: Working..."
    Form1.Refresh
    
    Label7.Caption = ""
    
    'addition of the <zipfile> command
    'this command will define the zip file that you want to decompress ( or test )
    'this is the name of the zip file with a path like this c:\my path\myzip.zip
    Dim MyString As String
    MyString = Text1.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        'The creation of the command is only a sequence of additions to the Comando string
        Comando = Comando & "<zipfile=" & MyString & ">"
    Else
        MsgBox "A zip file is required , with complete path"
        Label10.Caption = "Status: Finished"
        Form1.Refresh
        Exit Sub
    End If
    
    'addition of the <files-selection> command
    'this command will define the files that you want to extract
    'if you want to extract all files , just select *.*
    'to extract a unique file , just select the filename like this mydatabase.mdb , it will extract only the file  mydatabase.mdb
    MyString = Text4.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        Comando = Comando & "<files-selection=" & MyString & ">"
    Else
        MsgBox "The selection of files to test or extract are required in any unzip command"
        Label10.Caption = "Status: Finished"
        Form1.Refresh
        Exit Sub
    End If
    
    'addition of the <password> command
    'this command will define whether a zip file will be encrypted or not
    'if the password is provided , then the file will be encrypted using the password
    MyString = Text2.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        Comando = Comando & "<password=" & MyString & ">"
    End If
    
    'addition of the <destination-path> command
    'this is the path where the selected files will be extracted
    'if the path don't exist , it will be created
    MyString = Text3.Text
    MyString = Trim(MyString)
    If Len(MyString) Then
        Comando = Comando & "<destination-path=" & MyString & ">"
    End If
    
    'addition of the <file-extraction-mode> command
    'the file extraction mode will define whether the files being extracted will overwrite the files in the destination
    'or don't overwrite or freshen the files
    If Check1.value = 1 Then
        Comando = Comando & "<file-extraction-mode=overwrite>"
    End If
    If Check2.value = 1 Then
        Comando = Comando & "<file-extraction-mode=don't-overwrite>"
    End If
    If Check3.value = 1 Then
        Comando = Comando & "<file-extraction-mode=freshen-files>"
    End If
    
    'addition of the <test-zipfile> command
    'this command will define whether you will extract the files or just test in the memory the extraction
    If Check4.value = 1 Then
        Comando = Comando & "<test-zipfile>"
    End If
        
    'Now just pass the command string the the unzip function , the return information will be available after the Finish event is raised , the event returns error number and error description
    'The RSPZipUncompress don't returns nothing because the code execution occurs in a different thread , and there is no way to predict what will be the return value , this is why
    'we need to wait for the finish event to be raised in order to see what occurred with the information passed
    Text5.Text = Comando
        
    First = GetTickCount 'profile code
        
    'with the version 1.2.0 and above , processor priority functions were added
    'the following code will select a processor level to execute the decompression
    
    'values to define the processor priority
    '1 = IDLE
    '2 = LOWEST
    '3 = BELOW_NORMAL
    '4 = NORMAL
    '5 = ABOVE_NORMAL
    '6 = HIGHEST
    '7 = TIME_CRITICAL
    
    Select Case Combo1.Text
        
    Case "IDLE"
        
        RSPZip1.SetProcessorPriority 1
    Case "LOWEST"
        RSPZip1.SetProcessorPriority 2
    Case "BELOW_NORMAL"
        RSPZip1.SetProcessorPriority 3
    Case "NORMAL"
        RSPZip1.SetProcessorPriority 4
    Case "ABOVE_NORMAL"
        RSPZip1.SetProcessorPriority 5
    Case "HIGHEST"
        RSPZip1.SetProcessorPriority 6
    Case "TIME_CRITICAL"
        RSPZip1.SetProcessorPriority 7
        
    End Select
    
    RSPZip1.RSPZipUncompress (Comando)
    
    Form1.Refresh
    
    'As you can see , you don't more than a unique command in order to execute the code , you only need to learn about the small number of commands available to the control
    'in order to start using the control without possible problems
    'It is very easy to use , and possible ( we hope ) bug free
    
End Sub

Private Sub Command3_Click()
    
    Text3.Text = RSPZip1.RSPBrowseForFolder("RSP Software", "")
    
End Sub

Private Sub Command4_Click()
    
    'it will pause the execution
    RSPZip1.RSPZipPause
    
End Sub

Private Sub Command5_Click()
    'it will resume the execution
    RSPZip1.RSPZipResume
End Sub

Private Sub Command6_Click()
    'it will cancel the execution
    RSPZip1.RSPZipCancel
End Sub

Private Sub Command7_Click()
    
    Label11.Caption = "CPU information : " & RSPZip1.GetCPUVendor & " ,  " & RSPZip1.GetCPUBrandString & " , " & RSPZip1.GetCPUSpeed
    
End Sub

Private Sub Form_Load()
    
    Form1.Caption = RSPZip1.ControlName & " - Unzip decompression sample"
    
    Label11.Caption = "CPU information : " & RSPZip1.GetCPUVendor & " ,  " & RSPZip1.GetCPUBrandString
    
    'Processor priority levels
    '1 = IDLE
    '2 = LOWEST
    '3 = BELOW_NORMAL
    '4 = NORMAL
    '5 = ABOVE_NORMAL
    '6 = HIGHEST
    '7 = TIME_CRITICAL
    
    Combo1.AddItem "IDLE"
    Combo1.AddItem "LOWEST"
    Combo1.AddItem "BELOW_NORMAL"
    Combo1.AddItem "NORMAL"
    Combo1.AddItem "ABOVE_NORMAL"
    Combo1.AddItem "HIGHEST"
    Combo1.AddItem "TIME_CRITICAL"
    
    Combo1.Text = "NORMAL"
    
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    
    'if the code is executing , just cancel when closing the form
    RSPZip1.RSPZipCancel
    
End Sub

Private Sub RSPZip1_ErrorCode(ErrorNumber As Long, ErrorDescription As String)
    
    Static NumberOfErrors As Long
    NumberOfErrors = NumberOfErrors + 1
    List1.AddItem NumberOfErrors & " : " & ErrorNumber & " : " & ErrorDescription    'This event is raised in any exception
    Dim Ret As Long
    Ret = List1.ListCount
    List1.ListIndex = Ret - 1
    
End Sub

Private Sub RSPZip1_Finished(ReturnCode As Long, ReturnDescription As String)
    'This event is the way to know that the execution is finished , this occurs because the
    'code execution is running  in a different thread created internally by the decompressor
    
    First = GetTickCount - First
    
    Label7.Caption = "Elapsed : " & First
    
    Text6.Text = ReturnCode & ": " & ReturnDescription
    
    Label10.Caption = "Status: Finished"
    
End Sub

Private Sub RSPZip1_Progress(Progress As Long)
    ProgressBar1.value = Progress
End Sub


Private Sub RSPZip1_Warning(WarningCode As Long, WarningDescription As String)
    
    Static NumberOfWarnings As Long
    NumberOfWarnings = NumberOfWarnings + 1
    List1.AddItem NumberOfWarnings & " : " & WarningCode & " : " & WarningDescription    'This event is raised in any exception
    Dim Ret As Long
    Ret = List1.ListCount
    List1.ListIndex = Ret - 1
    
End Sub

