/*======================================================================*/
/* genfun.cpp: general functions										*/
/*======================================================================*/
/* COPYRIGHT 1992-2002 Jean-Pierre MENICUCCI - All rights reserved		*/
/*======================================================================*/

#include "afxwin.h"
#include "afxole.h"
#include "Genfun.h"

#define _OLEAUTO_H_
extern "C" {
#include <shlobj.h>
#include <objbase.h>
}

#include <stack>
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* string handling functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* Upper: set a character to uppercase									*/
/* return:																*/
/*		uppercase character												*/
/*======================================================================*/

static unsigned char ttu1250[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x8A,0x9B,0x8C,0x8D,0x8E,0x8F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xA3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xAA,0xBB,0xBC,0xBD,0xBE,0xAF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xF7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xFF };

static unsigned char ttu1251[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x80,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x8A,0x9B,0x8C,0x8D,0x8E,0x8F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xA8,0xB9,0xAA,0xBB,0xBC,0xBD,0xBE,0xAF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF };

static unsigned char ttu1252[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x8A,0x9B,0x8C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xF7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF };

static unsigned char ttu1253[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xF2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xFF };

static unsigned char ttu1254[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x8A,0x9B,0x8C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xF7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xFF };

static unsigned char ttu1255[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttu1256[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x8C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttu1257[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xAF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xF7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xFF };

static unsigned char ttud[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
	0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

unsigned char Upper (
	unsigned char c						// character to set as uppercase
	)
{
	switch (GetACP()) {
		case 1250: return ttu1250[c];
		case 1251: return ttu1251[c];
		case 1252: return ttu1252[c];
		case 1253: return ttu1253[c];
		case 1254: return ttu1254[c];
		case 1255: return ttu1255[c];
		case 1256: return ttu1256[c];
		case 1257: return ttu1257[c];
		}

	return ttud[c];
}

/*======================================================================*/
/* Lower: set a character to lowercase									*/
/* return:																*/
/*		lowercase character												*/
/*======================================================================*/

static unsigned char ttl1250[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xD7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttl1251[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttl1252[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x9A,0x8B,0x9C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xD7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttl1253[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xD2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttl1254[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x9A,0x8B,0x9C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xD7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttl1255[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttl1256[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttl1257[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x9C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xBF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xD7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

static unsigned char ttld[] = {
	0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
	0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
	0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
	0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
	0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
	0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
	0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
	0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
	0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
	0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
	0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
	0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
	0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
	0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF };

unsigned char Lower (
	unsigned char c						// charater to set as lowercase
	)
{
	switch (GetACP()) {
		case 1250: return ttl1250[c];
		case 1251: return ttl1251[c];
		case 1252: return ttl1252[c];
		case 1253: return ttl1253[c];
		case 1254: return ttl1254[c];
		case 1255: return ttl1255[c];
		case 1256: return ttl1256[c];
		case 1257: return ttl1257[c];
		}

	return ttld[c];
}

/*======================================================================*/
/* Lengthen: adding spaces to a string									*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Lengthen (
	LPTSTR lpOut,						// string to lengthen
	long nOut,							// initial length
	long mOut							// size
	)
{
	long n;								// index

	mOut--;								// end-of-string character

	if (nOut == 0)						// if length not specified
		nOut = lstrlen (lpOut);			// specify

	for (n = nOut; n < mOut; n++)
		lpOut[n] = ' ';					// lengthen with spaces

	lpOut[mOut] = '\0';					// end-of-string character
}

/*======================================================================*/
/* Upper: set a string to uppercase										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Upper (
	LPTSTR lp,							// string to uppercase
	int n								// string length
	)
{
	for (LPTSTR lpEnd = lp + n; lp < lpEnd; lp++)
		*lp = Upper (*lp);
}

/*======================================================================*/
/* Lower: set a string to lowercase										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Lower (
	LPTSTR lp,							// string to lowercase
	int n								// string length
	)
{
	for (LPTSTR lpEnd = lp + n; lp < lpEnd; lp++)
		*lp = Lower (*lp);
}

/*======================================================================*/
/* Invert: invert case in a string										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Invert (
	LPTSTR lp,							// string to lowercase
	int n								// string length
	)
{
	for (LPTSTR lpEnd = lp + n; lp < lpEnd; lp++) {
		if (IsCharLower (*lp))
			*lp = Upper (*lp);
		else if (IsCharUpper (*lp))
			*lp = Lower (*lp);
		}
}

/*======================================================================*/
/* Capitalize: capitalize words											*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void Capitalize (
	LPTSTR lp,							// string to uppercase
	int n								// string length
	)
{
	LPTSTR lpBeg;						// first character in string
	LPTSTR lpEnd;						// last character in string

	for (lpBeg = lp, lpEnd = lp + n; lp < lpEnd; lp++) {
		if ((lp == lpBeg || !IsCharAlpha(*(lp-1))) && IsCharLower (*lp))
			*lp = Upper (*lp);
		}
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* string transcoding functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* hexbin: hexadecimal to binary										*/
/* return:																*/
/*		output string length											*/
/*======================================================================*/

static char tta[] = {					// transcoding table
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7,0x8,0x9,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0xa,0xb,0xc,0xd,0xe,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0xa,0xb,0xc,0xd,0xe,0xf,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0} ;

int hexbin (
	unsigned char *pIn,					// hexadecimal input
	int lIn,							// input length
	unsigned char *pOut					// binary output
	)
{
	int iIn;							// input index
	int iOut;							// output index
	int lOut;							// output length

	/*************************************/
	/* compute input length if not given */
	/*************************************/

	if (lIn == 0)
		lIn = lstrlen ((LPTSTR) pIn);
	lOut = (1 + lIn) / 2;

	/***************/
	/* transcoding */
	/***************/

	for (iOut = 0, iIn = 0; iOut < lOut; iOut++) {
		pOut[iOut] = (tta [pIn [iIn++]]) << 4;
		pOut[iOut] += tta [pIn [iIn++]];
		}

	pOut[lOut] = '\0';
	return (lOut);
}

/*======================================================================*/
/* binhex: binary to hexadecimal										*/
/* return:																*/
/*		output string length											*/
/*======================================================================*/

static char tth[] = "0123456789ABCDEF";

int binhex (
	unsigned char *pIn,					// binary input
	int lIn,							// input length
	LPTSTR lpOut						// hexadecimal output
	)
{
	int iIn;							// input index
	int iOut;							// output index

	/*************************************/
	/* compute input length if not given */
	/*************************************/

	if (lIn <= 0)
		lIn = lstrlen ((LPTSTR) pIn);

	/***************/
	/* transcoding */
	/***************/

	for (iIn = 0, iOut = 0; iIn < lIn; iIn++) {
		lpOut[iOut++] = tth [(pIn [iIn] >> 4)];
		lpOut[iOut++] = tth [(pIn [iIn] & 0x0f)];
		}

	lpOut[iOut] = '\0';
	return (iOut);
}

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*///////////////////////////////////////////////////////////////////////*/
/* string delimiting functions											 */
/*///////////////////////////////////////////////////////////////////////*/
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* These functions help in reading parameter files containing delimiters */
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* Point: pointing the character after a delimiter						*/
/* return:																*/
/*		length skipped													*/
/*======================================================================*/
/* Point takes on input a pointer to a string pointer and a delimiter.	*/
/* On output, the string pointer will point to the character after		*/
/* the delimiter. The number of characters skipped is returned			*/
/*======================================================================*/

int Point (
	LPTSTR *lpIn,						// input string
	TCHAR cDel							// delimiter
	)
{
	int iLen = 0;						// substring length

	/****************************************************************/
	/* keep on skipping characters while the current character is	*/
	/* neither an end-of-string nor a delimiter						*/
	/****************************************************************/

	while (**lpIn && **lpIn != cDel) {
		(*lpIn)++;
		iLen++;
		}

	/**********************************************************/
	/* skip the delimiter if reached else point end-of-string */
	/**********************************************************/

	if (**lpIn)
		(*lpIn)++;

	return (iLen);						// substring length
}

/*======================================================================*/
/* Pull: extracting a delimited substring								*/
/* return:																*/
/*		extracted length												*/
/*======================================================================*/
/* Pull extracts the characters contained between the initial position	*/
/* of the pointer and the delimiter. The excess characters are not		*/
/* taken into account													*/
/*======================================================================*/

int Pull (
	LPTSTR *lpIn,						// input string
	LPTSTR lpOut,						// output string
	int mOut,							// output size
	TCHAR cDel							// delimiter
	)
{
	int iLen = 0;						// extracted length

	/********************************************************************/
	/* go ahead into the input string while the current character is	*/
	/* neither an end-of-string nor a delimiter							*/
	/********************************************************************/

	for (;**lpIn && **lpIn != cDel; (*lpIn)++)
		if (iLen < mOut)				// if applicable
			lpOut[iLen++] = **lpIn; 	// extract the character

	/**********************************************************/
	/* skip the delimiter if reached else point end-of-string */
	/**********************************************************/

	if (**lpIn)
		(*lpIn)++;

	lpOut[iLen] = '\0';					// add an end-of-string
	return (iLen);						// extracted length
}

/*======================================================================*/
/* Pulls: extracting a delimited substring								*/
/* return:																*/
/*		extracted length												*/
/*======================================================================*/
/* Pull extracts the characters contained between the initial position	*/
/* of the pointer and one of the possible delimiters. The excess		*/
/* characters are not taken into account								*/
/*======================================================================*/

int Pulls (
	LPTSTR *lpIn,						// input string
	LPTSTR lpOut,						// output string
	int mOut,							// output size
	LPTSTR lpDel						// delimiters
	)
{
	int iLen = 0;						// extracted length
	LPTSTR lp;							// pointer

	/********************************************************************/
	/* go ahead into the input string while the current character is	*/
	/* neither an end-of-string nor a delimiter							*/
	/********************************************************************/

	for (;**lpIn; (*lpIn)++) {

		for (lp = lpDel; *lp; lp++) 	// for all possible delimiters
			if (**lpIn == *lp)			// if the current character is a delimiter
				break;					// get out

		if (**lpIn == *lp)				// if the current character is a delimiter
			break;						// get out

		if (iLen < mOut)				// if applicable
			lpOut[iLen++] = **lpIn; 	// extract the character
		}

	/**********************************************************/
	/* skip the delimiter if reached else point end-of-string */
	/**********************************************************/

	if (**lpIn)
		(*lpIn)++;

	lpOut[iLen] = '\0';					// add an end-of-string
	return (iLen);						// extracted length
}

/*======================================================================*/
/* Special: introduce special characters in strings						*/
/* return:																*/
/*		resulting length												*/
/*======================================================================*/

int Special (
	LPTSTR lpOut,						// string out
	LPTSTR lpIn							// string in
	)
{
	int n;

	for (n = 0; *lpIn; n++) {

		switch (*lpIn) {

		/*********************/
		/* special character */
		/*********************/

		case '$':

			switch (*(lpIn + 1)) {
			case 't':	*lpOut++ = '\t'; lpIn += 2; break;
			case 'n':	*lpOut++ = '\n'; lpIn += 2; break;
			case 'r':	*lpOut++ = '\r'; lpIn += 2; break;
			case '0':	*lpOut++ = '\0'; lpIn += 2; break;
			case '$':	*lpOut++ = '$'; lpIn += 2; break;
			default:	*lpOut++ = *lpIn++; break;
				}
			break;
			
		/********************/
		/* normal character */
		/********************/

		default:
			*lpOut++ = *lpIn++;
			}
		}

	*lpOut = '\0';

	return n;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* registry functions													*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

typedef struct NODE {
	HKEY		hKey;					// key
	struct NODE *NextNode;				// next node
	} dummy;

static NODE *lpFirstNode, *lpCurrentNode, *lpNextNode;

/*======================================================================*/
/* GetDword: get dword value from registry								*/
/* return:																*/
/*		DWORD															*/
/*======================================================================*/

DWORD GetDword (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	DWORD		dwDef					// default
	)
{
	DWORD dwDword; DWORD dwcbDword = sizeof (DWORD);
	if (ERROR_SUCCESS == RegQueryValueEx (hKey, lpszValueName, NULL, NULL, (LPBYTE) &dwDword, &dwcbDword))
		return dwDword;
	else
		return dwDef;
}

/*======================================================================*/
/* GetLpstr: get Lpstr value from registry								*/
/* return:																*/
/*		Lpstr															*/
/*======================================================================*/

void GetLpstr (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	LPTSTR		lpszValue,				// value
	ULONG		uValue,					// value size
	LPCTSTR		lpszDef					// default
	)
{
	if (ERROR_SUCCESS != RegQueryValueEx (hKey, lpszValueName, NULL, NULL, (LPBYTE) lpszValue, &uValue)) {
		if (lpszDef)
			mCpy (lpszValue, uValue, lpszDef);
		else
			*lpszValue = '\0';
		}
	return;
}

/*======================================================================*/
/* GetCstring: get Cstring value from registry							*/
/* return:																*/
/*		Cstring															*/
/*======================================================================*/

CString GetCstring (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	LPCTSTR		lpszDef					// default
	)
{
	LPTSTR lpszData;					// data
	DWORD lpcbData;						// data length
	CString cs;							// data as CString

	/*******************/
	/* get data length */
	/*******************/

	RegQueryValueEx (hKey, lpszValueName, NULL, NULL, NULL, &lpcbData);
	lpszData = lpcbData ? (LPTSTR) calloc (lpcbData, sizeof (TCHAR)) : 0;

	/**************************************************/
	/* get data if any and receiving string allocated */
	/**************************************************/

	if (lpszData) {
		if (ERROR_SUCCESS == RegQueryValueEx (hKey, lpszValueName, NULL, NULL, (LPBYTE) lpszData, &lpcbData))
			cs = lpszData;				// could retrieve data
		else {							// could not retrieve data
			if (lpszDef)				// if a default value exists
				cs = lpszDef;			// return default value
			else						// if no default value exists
				cs = _T("");			// return empty string
			}
		free (lpszData);				// free allocated string
		}
	else {								// no data or allocation failed
		if (lpszDef)					// if a default value exists
			cs = lpszDef;				// return default value
		else							// if no default value exists
			cs = _T("");				// return empty string
		}

	return cs;							// return data
}

/*======================================================================*/
/* SetDword: set dword value into registry								*/
/* return:																*/
/*		TRUE							// success						*/
/*		FALSE							// failure						*/
/*======================================================================*/

BOOL SetDword (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	DWORD		dwDword					// DWORD value
	)
{
	DWORD dwcbDword = sizeof (DWORD);
	int rc = RegSetValueEx (hKey, lpszValueName, NULL, REG_DWORD, (LPBYTE) &dwDword, dwcbDword);
	return (rc == ERROR_SUCCESS ? TRUE : FALSE);
}

/*======================================================================*/
/* SetLpstr: set Lpstr value into registry								*/
/* return:																*/
/*		TRUE							// success						*/
/*		FALSE							// failure						*/
/*======================================================================*/

BOOL SetLpstr (
	HKEY		hKey,					// registry key
	LPCTSTR		lpszValueName,			// value name
	LPCTSTR		lpszData				// value
	)
{
	DWORD lpcbData = lstrlen (lpszData) + 1;
	int rc = RegSetValueEx (hKey, lpszValueName, NULL, REG_SZ, (LPBYTE) lpszData, lpcbData);
	return (rc == ERROR_SUCCESS ? TRUE : FALSE);
}

/*======================================================================*/
/* CloseKeys: close a key list											*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void CloseKeys (
	void								// no argument
	)
{
	for (lpCurrentNode = lpFirstNode; lpCurrentNode; lpCurrentNode = lpNextNode) {
		lpNextNode = lpCurrentNode->NextNode;
		RegCloseKey (lpCurrentNode->hKey);
		delete lpCurrentNode;
		}

	lpFirstNode = lpCurrentNode = lpNextNode = 0;
}

/*======================================================================*/
/* OpenLeafKey: open a chain of subkeys ... including a leaf entry		*/
/* return:																*/
/*		void															*/
/*======================================================================*/

static long OpenLeafKey (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	REGSAM		samDesired,				// security access mask
	HKEY*		phKey					// result key
	)
{
	TCHAR szSubKey[MAX_PATH];			// max subkey size
	long rc;							// return code

	/************************************************/
	/* find a key to a leaf entry into the registry */
	/************************************************/

	lpFirstNode = new NODE;
	if (lpFirstNode) {
		lpFirstNode->hKey = hRootKey;
		lpFirstNode->NextNode = 0;
		lpCurrentNode = lpFirstNode;

		for (LPTSTR lp = (LPTSTR) lpszSubKeys; *lp; lpCurrentNode = lpNextNode) {

			Pull (&lp, szSubKey, sizeof(szSubKey), '\\');

			lpNextNode = new NODE;
			lpNextNode->NextNode = 0;
			lpCurrentNode->NextNode = lpNextNode;

			rc = RegOpenKeyEx (lpCurrentNode->hKey, szSubKey,
				NULL, samDesired, &lpNextNode->hKey);

			if (rc != ERROR_SUCCESS) {
				CloseKeys();
				return rc;
				}
			}

		*phKey = lpCurrentNode->hKey;
		rc = ERROR_SUCCESS;
		}

	else {
		CloseKeys();
		rc = -1;
		}

	return rc;
}

/*======================================================================*/
/* ReadValue: get a subkey value										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

long ReadValue (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPTSTR		lpszValueName,			// address of name of value to query
	DWORD		dwType,					// value type
	LPBYTE		lpbData,				// address of data buffer
	DWORD		cbData					// data buffer size
	)
{
	HKEY hKey;							// key of entry
	long rc;							// return code

	rc = OpenLeafKey (hRootKey, lpszSubKeys, KEY_ALL_ACCESS, &hKey);
	if (rc) return rc;

	rc = RegQueryValueEx (hKey, lpszValueName, NULL, &dwType, lpbData, &cbData);

	CloseKeys();

	return rc;
}

/*======================================================================*/
/* CreateLeafKey: create a chain of subkeys ... including a leaf entry	*/
/* return:																*/
/*		void															*/
/*======================================================================*/

static long CreateLeafKey (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	REGSAM		samDesired,				// security access mask
	HKEY*		phKey					// result key
	)
{
	TCHAR szSubKey[MAX_PATH];			// max subkey size
	DWORD dwDisposition;				// new or old key
	long rc;							// return code

	/************************************************/
	/* find a key to a leaf entry into the registry */
	/************************************************/

	lpFirstNode = new NODE;
	if (lpFirstNode) {
		lpFirstNode->hKey = hRootKey;
		lpFirstNode->NextNode = 0;
		lpCurrentNode = lpFirstNode;

		for (LPTSTR lp = (LPTSTR) lpszSubKeys; *lp; lpCurrentNode = lpNextNode) {

			Pull (&lp, szSubKey, sizeof(szSubKey), '\\');

			lpNextNode = new NODE;
			lpNextNode->NextNode = 0;
			lpCurrentNode->NextNode = lpNextNode;

			rc = RegCreateKeyEx (lpCurrentNode->hKey, szSubKey, NULL,
				TEXT(""), REG_OPTION_NON_VOLATILE, samDesired, NULL,
				&lpNextNode->hKey, &dwDisposition);

			if (rc != ERROR_SUCCESS) {
				CloseKeys();
				return rc;
				}
			}

		*phKey = lpCurrentNode->hKey;
		rc = ERROR_SUCCESS;
		}

	else {
		CloseKeys();
		rc = -1;
		}

	return rc;
}

/*======================================================================*/
/* WriteValue: set a subkey value										*/
/* return:																*/
/*		void															*/
/*======================================================================*/

long WriteValue (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPTSTR		lpszValueName,			// address of name of value to query
	DWORD		dwType,					// value type
	LPBYTE		lpbData,				// address of data buffer
	DWORD		cbData					// data buffer size
	)
{
	HKEY hKey;							// key of entry
	long rc;							// return code

	rc = CreateLeafKey (hRootKey, lpszSubKeys, KEY_ALL_ACCESS, &hKey);
	if (rc) return rc;

	rc = RegSetValueEx (hKey, lpszValueName, NULL, dwType, lpbData, cbData);

	CloseKeys();

	return rc;
}

/*======================================================================*/
/* DeleteKey: 															*/
/* return:																*/
/*		void															*/
/*======================================================================*/

long DeleteKey (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPCTSTR		lpszSubKey				// key to delete
	)
{
	HKEY hKey;							// key of entry
	long rc;							// return code

	rc = OpenLeafKey (hRootKey, lpszSubKeys, KEY_ALL_ACCESS, &hKey);
	if (rc) return rc;

	rc = RegDeleteKey (hKey, lpszSubKey);

	CloseKeys();

	return rc;
}

/*======================================================================*/
/* DeleteSubtree:														*/
/* return:																*/
/*		void															*/
/*======================================================================*/

typedef struct KEY {
	HKEY		hKey;					// key handle
	LPCTSTR		lpszKey;				// key name
	} tagKEY;

long DeleteSubtree (
	HKEY		hRootKey,				// root key
	LPCTSTR		lpszSubKeys,			// chain of subkeys
	LPCTSTR		lpszSubKey				// key to delete
	)
{
	HKEY hSubKeys;						// chain of subkeys
	HKEY hSubKey;						// key to delete
	long rc;							// return code
	
	stack<KEY> st;						// STL stack
	LPCTSTR lpszKey;					// current key
	HKEY hKey;							// current key
	KEY Key;							// current key

	/*************************/
	/* open chain of subkeys */
	/*************************/

	rc = OpenLeafKey (hRootKey, lpszSubKeys, KEY_ALL_ACCESS, &hSubKeys);
	if (rc)
		return rc;

	/**********************/
	/* open key to delete */
	/**********************/

	rc = RegOpenKeyEx (hSubKeys, lpszSubKey, NULL, KEY_ALL_ACCESS, &hSubKey);
	if (rc) {
		CloseKeys();
		return rc;
		}

	/******************************************/
	/* create first elements of walking stack */
	/******************************************/

	Key.hKey = hSubKeys;
	Key.lpszKey = lpszSubKeys;
	st.push (Key);

	Key.hKey = hSubKey;
	Key.lpszKey = lpszSubKey;
	st.push (Key);

	hKey = Key.hKey;
	lpszKey = Key.lpszKey;

	/************************************************/
	/* walk key tree removing final values and keys */
	/************************************************/

	while (st.size() > 1) {

		char szName[MAX_PATH+1];
		DWORD dwName = MAX_PATH+1;

		rc = RegEnumKey (hKey, 0, szName, dwName);

		/***************************/
		/* key has no more subkeys */
		/***************************/

		if (rc == ERROR_NO_MORE_ITEMS) {

			/*****************/
			/* delete values */
			/*****************/

			dwName = MAX_PATH+1;
			DWORD dwType;

			while (!RegEnumValue (hKey, 0, szName, &dwName, 0, &dwType, NULL, 0)) {
				RegDeleteValue (hKey, szName);
				dwName = MAX_PATH+1;
				}

			/**************/
			/* delete key */
			/**************/

			RegCloseKey (hKey);
			st.pop();
			Key = st.top();
			hKey = Key.hKey;
			RegDeleteKey (hKey, lpszKey);
			if (st.size() > 1)
				free ((void *) lpszKey);
			lpszKey = Key.lpszKey;
			}

		/************************/
		/* key has more subkeys */
		/************************/

		else if (rc == ERROR_SUCCESS) {

			lpszKey = (LPSTR) malloc (dwName+1);
			lstrcpy ((LPSTR) lpszKey, szName);
			rc = RegOpenKeyEx (hKey, szName, NULL, KEY_ALL_ACCESS, &hKey);

			Key.hKey = hKey;
			Key.lpszKey = lpszKey;
			st.push (Key);
			}

		/*********/
		/* error */
		/*********/

		else {

			while (st.size() > 1) {
				if (Key.hKey)
					RegCloseKey (Key.hKey);
				if (st.size() > 2)
					free ((void *) Key.lpszKey);
				st.pop();
				Key = st.top();
				}
			break;
			}
		}

	CloseKeys();

	return rc;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* dialogs centering functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* These functions are called during the WM_INITDIALOG processing, that */
/* is to say, before the actual dialog displaying. They afford a		*/
/* correct dialog centering whatever the resolution						*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* DownDialog: displaying a dialog on the window bottom					*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void DownDialog (
	HWND hwApp,							// application window handle
	HWND hwDia,							// dialog window handle
	int cyStatus						// status bar height
	)
{
	RECT RApp;							// application rectangle
	RECT RDia;							// dialog rectangle
	int x;								// new dialog x-axis coordinate
	int y;								// new dialog x-axis coordinate
	int cx;								// dialog width
	int cy;								// dialog height

	GetWindowRect (hwApp, &RApp);
	RApp.bottom -= cyStatus;
	GetWindowRect (hwDia, &RDia);

	cx = RDia.right - RDia.left;
	cy = RDia.bottom - RDia.top;

	x = RApp.left + (RApp.right - cx - RApp.left) / 2;
	y = RApp.bottom - cy - GetSystemMetrics (SM_CYHSCROLL) / 2;

	x = x < 0 ? 0 : x;
	if (x + cx > GetSystemMetrics (SM_CXSCREEN))
		x = GetSystemMetrics (SM_CXSCREEN) - cx;

	y = y < 0 ? 0 : y;
	if (y + cy > GetSystemMetrics (SM_CYSCREEN))
		y = GetSystemMetrics (SM_CYSCREEN) - cy;

	MoveWindow (hwDia, x, y, cx, cy, TRUE);
}

/*======================================================================*/
/* CenterDialog: displaying a dialog at the center of the window		*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void CenterDialog (
	HWND hwApp,							// application window handle
	HWND hwDia							// dialog window handle
	)
{
	RECT RApp;							// application rectangle
	RECT RDia;							// dialog rectangle
	int x;								// new dialog x-axis coordinate
	int y;								// new dialog x-axis coordinate
	int cx;								// dialog width
	int cy;								// dialog height

	GetWindowRect (hwApp, &RApp);
	GetWindowRect (hwDia, &RDia);

	cx = RDia.right - RDia.left;
	cy = RDia.bottom - RDia.top;

	x = RApp.left + (RApp.right - cx - RApp.left) / 2;
	y = RApp.top + (RApp.bottom - cy - RApp.top) / 2;

	x = x < 0 ? 0 : x;
	if (x + cx > GetSystemMetrics (SM_CXSCREEN))
		x = GetSystemMetrics (SM_CXSCREEN) - cx;

	y = y < 0 ? 0 : y;
	if (y + cy > GetSystemMetrics (SM_CYSCREEN))
		y = GetSystemMetrics (SM_CYSCREEN) - cy;

	MoveWindow (hwDia, x, y, cx, cy, TRUE);
}

/*======================================================================*/
/* CenterDialog: displaying a dialog at the center of the screen		*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void CenterDialog (
	HWND hw								// dialog window handle
	)
{
	RECT R;								// dialog rectangle
	int x;								// new dialog x-axis coordinate
	int y;								// new dialog x-axis coordinate
	int cx;								// dialog width
	int cy;								// dialog height

	GetWindowRect (hw, &R);

	cx = R.right - R.left;
	cy = R.bottom - R.top;

	x = (GetSystemMetrics (SM_CXSCREEN) - cx) / 2;
	y = (GetSystemMetrics (SM_CYSCREEN) - cy) / 2;

	x = x < 0 ? 0 : x;
	if (x + cx > GetSystemMetrics (SM_CXSCREEN))
		x = GetSystemMetrics (SM_CXSCREEN) - cx;

	y = y < 0 ? 0 : y;
	if (y + cy > GetSystemMetrics (SM_CYSCREEN))
		y = GetSystemMetrics (SM_CYSCREEN) - cy;

	MoveWindow (hw, x, y, cx, cy, TRUE);
}

/*======================================================================*/
/* DDX_CBList: handle a combo box list									*/
/* return:																*/
/*		TRUE							// success						*/
/*		FALSE							// failure						*/
/*======================================================================*/

void AFXAPI DDX_CBList (
	CDataExchange* pDX,					// data exchange pointer
	int nIDC,							// control Id
	CString& csList						// data
	)
{
	CString csEdit;						// edit field string
	CString csComb;						// combo box field
	int nLen;							// field length

	HWND hWndCtrl = pDX->PrepareCtrl (nIDC);

	/*==================================================================*/
	/* get values back from combo										*/
	/*==================================================================*/

	if (pDX->m_bSaveAndValidate) {

		/****************************/
		/* get edit field in csEdit */
		/****************************/

		if ((nLen = GetWindowTextLength (hWndCtrl)) != -1)
			GetWindowText (hWndCtrl, csEdit.GetBufferSetLength (nLen), nLen+1);
		else {
			GetWindowText (hWndCtrl, csEdit.GetBuffer (1023), 1024);
			csEdit.ReleaseBuffer();
			}

		csList = csEdit + '\n';

		/*******************************************************/
		/* get combo fields in csComb and accumulate in csList */
		/*******************************************************/

		int nIn = SendMessage (hWndCtrl, CB_GETCOUNT, 0, 0);

		int nOut = 1;				// # of items in combo - max 9

		for (int n = 0; n < nIn && nOut < 9; n++) {

			/*********************/
			/* get combo field n */
			/*********************/

			nLen = SendMessage (hWndCtrl, CB_GETLBTEXTLEN, n, 0);
			LPARAM lParam = (LPARAM) csComb.GetBufferSetLength (nLen);
			SendMessage (hWndCtrl, CB_GETLBTEXT, n, lParam);

			/******************************************/
			/* add to csList if different from csEdit */
			/******************************************/

			if (nLen && csEdit.Compare (csComb)) {
				csList += csComb + '\n';
				nOut++;				// # of items in combo - max 9
				}
			}
		}

	/*==================================================================*/
	/* put values in combo												*/
	/*==================================================================*/

	else {

		LPTSTR lp = csList.GetBuffer(0);

		/*******************************/
		/* replace line feeds by nulls */
		/*******************************/

		int nIn = 0;				// # of items in list

		for (int n = 0, m = 0; *(lp+n); n++) {
			if (*(lp+n) == '\n') {
				*(lp+n) = '\0';		// replace line feed with null
				nIn++;				// # of items in combo
				}
			}

		/************************************************/
		/* legacy versions do not include any line feed */
		/************************************************/

		if (n && !nIn)				// string not empty but no line feed
			nIn = 1;				// -> at least 1 item in combo

		/********************************/
		/* enter 9 strings max in combo */
		/********************************/

		int nOut = 0;				// # of items in combo - max 9

		for (n = 0; n < nIn && nOut < 9; n++, lp += lstrlen (lp) + 1) {

			/***************************************/
			/* make sure item is not already there */
			/***************************************/

			for (int p = 0; p < SendMessage (hWndCtrl, CB_GETCOUNT, 0, 0); p++) {

				/*********************/
				/* get combo field p */
				/*********************/

				nLen = SendMessage (hWndCtrl, CB_GETLBTEXTLEN, p, 0);
				LPARAM lParam = (LPARAM) csComb.GetBufferSetLength (nLen);
				SendMessage (hWndCtrl, CB_GETLBTEXT, p, lParam);

				/***************************************************/
				/* break if field n already in combo at position p */
				/***************************************************/

				if (lstrcmp (csComb.GetBuffer(0), lp) == 0)
					break;
				}

			/******************************************/
			/* add field to combo if not found before */
			/******************************************/

			if (p == n) {
				SendMessage (hWndCtrl, CB_ADDSTRING, 0, (LPARAM) lp);
				nOut++;				// # of items in combo - max 9
				}
			}

		SendMessage (hWndCtrl, CB_SETCURSEL, (WPARAM) 0, 0);
	}
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* file handling functions												*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* FileLength: getting the size of a file								*/
/* return:																*/
/*		file size														*/
/*======================================================================*/

long FileLength (
	HFILE hFile						// file handle
	)
{
long lCurrentPos = _llseek (hFile, 0, 1);
long lFileLength = _llseek (hFile, 0, 2);
_llseek (hFile, lCurrentPos, 0);

return lFileLength;
}

/*======================================================================*/
/* Relative: relative path of a file from the current directory			*/
/* return:																*/
/*		pointer to the relative path									*/
/*======================================================================*/

LPTSTR Relative (
	LPTSTR lpszFilePath					// file path
	)
{
	TCHAR szFilePath[MAX_PATH];			// file

	GetCurrentDirectory (CharSize(szFilePath), szFilePath);

	/****************************************/
	/* search for first different character */
	/****************************************/

	for (LPTSTR lp1 = lpszFilePath, lp2 = szFilePath; *lp1 && *lp2; lp1++, lp2++) {
		if (strnicmp (lp1, lp2, 1))
			break;
		}

	if (*lp2 == '\0') {					// directory exhausted
		if (*lp1 == '\\')				// skip backslash
			lp1++;						// point to file name
		}
	else
		lp1 = lpszFilePath;				// directory not exhausted

	return (lp1);
}

/*======================================================================*/
/* SplitPath: splitting a file name into items							*/
/* return:																*/
/*		void															*/
/*======================================================================*/
/* SplitPath takes a complete file path on input and returns pointers	*/
/* to directory, file name and extension								*/
/*======================================================================*/

void SplitPath (
	LPTSTR lpszPath,					// complete file path
	LPTSTR *lpszDir,					// directory
	LPTSTR *lpszName,					// file name
	LPTSTR *lpszExt						// extension
	)
{
	LPTSTR lp = lpszPath;				// flying pointer
	int n;								// number

	/************************/
	/* pointer to directory */
	/************************/

	if (*++lp == ':')
		*lpszDir = lp + 1;
	else
		*lpszDir = lpszPath;

	/************************/
	/* pointer to file name */
	/************************/

	for (lp = *lpszDir, n = 0; *lp; lp++) {
		if (*lp == '\\') {
			*lpszName = lp;
			n++;
			}
		}

	if (n)
		(*lpszName)++;

	/************************/
	/* pointer to extension */
	/************************/

	*lpszExt = *lpszName;
	for (lp = *lpszName; *lp; lp++)
		if (*lp == '.')
			*lpszExt = lp;

	if (*lpszExt == 0)
		*lpszExt = lp;
}

/*======================================================================*/
/* SplitPath: splitting a file name into items							*/
/* return:																*/
/*		void															*/
/*======================================================================*/
/* SplitPath takes a complete file path on input and returns offsets	*/
/* to the directory chain string, file name and suffix					*/
/*======================================================================*/

void SplitPath (
	LPCTSTR lpszPath,					// complete file path
	int *iPath,							// directory chain offset
	int *iRadical,						// file name offset
	int *iSuffix						// file suffix offset
	)
{
	int i;								// index
	int n;								// number

	/*********************************/
	/* offset to the directory chain */
	/*********************************/

	if (lpszPath[1] == ':')
		*iPath = 2;
	else
		*iPath = 0;

	/***************************/
	/* offset to the file name */
	/***************************/

	*iRadical = *iPath;
	for (i = *iPath, n = 0; lpszPath[i]; i++) {
		if (lpszPath[i] == '\\') {
			*iRadical = i;
			n++;
			}
		}

	if (n)
		(*iRadical)++;

	/*****************************/
	/* offset to the file suffix */
	/*****************************/

	*iSuffix = *iRadical;
	for (i = *iRadical; lpszPath[i]; i++)
		if (lpszPath[i] == '.')
			*iSuffix = i;
}

/*======================================================================*/
/* SetFilePath: set full file path from directory path and file name	*/
/* return:																*/
/*		void															*/
/*======================================================================*/

void SetFilePath (
	LPTSTR lpszFilePath,				// full file path
	LPCTSTR lpszPathName,				// directory path
	LPCTSTR lpszFileName				// file name
	)
{
	LPTSTR lp;							// directory pointer
	TCHAR c;							// last character of directory
	UINT uOff;							// offset 

	/**************************/
	/* copy directory to path */
	/**************************/

	uOff = mCpy (lpszFilePath, MAX_PATH, lpszPathName);

	/***********************************************************/
	/* check last character of directory and add a \ if needed */
	/***********************************************************/

	for (lp = lpszFilePath; *lp; lp++)
		c = *lp;

	if (c != '\\')
		uOff = mCat (lpszFilePath, MAX_PATH, uOff, TEXT("\\"));

	/*************************/
	/* copy filename to path */
	/*************************/

	mCat (lpszFilePath, MAX_PATH, uOff, lpszFileName);
}

/*======================================================================*/
/* FileRead: reading a file into a buffer								*/
/* return:																*/
/*		0				buffer allocated and file read					*/
/*		GEN_ERROPEN		could not open file								*/
/*		GEN_ERRALLOC	could not allocate memory						*/
/*		GEN_ERRLOCK		could not lock memory							*/
/*		GEN_ERRREAD		could not read file								*/
/*======================================================================*/
/* FileRead allocates memory and stores the file into it				*/
/*======================================================================*/

int FileRead (
	LPCTSTR lpszFilePath,				// file path
	HGLOBAL *hBuf,						// allocated memory handle
	LPTSTR *lpBuf						// accessed memory pointer
	)
{
	HANDLE hFile;						// file pointer
	DWORD dwToRead;						// length to read
	DWORD dwRead;						// length actually read

	/*****************/
	/* open the file */
	/*****************/

	hFile = CreateFile (lpszFilePath,
		GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL);

	if (hFile == INVALID_HANDLE_VALUE)
		return GEN_ERROPEN;

	/*********************************/
	/* allocate a buffer for reading */
	/*********************************/

	dwToRead = (DWORD) FileLength ((HFILE) hFile);
	*hBuf = GlobalAlloc (GHND, dwToRead + 1);
	if (*hBuf == NULL) {
		CloseHandle (hFile);
		return GEN_ERRALLOC;
		}

	/**********************************/
	/* access to the buffer allocated */
	/**********************************/

	*lpBuf = (LPTSTR) GlobalLock (*hBuf);
	if (*lpBuf == (LPTSTR) 0) {
		GlobalFree (*hBuf);
		CloseHandle (hFile);
		return GEN_ERRLOCK;
		}

	/***************************/
	/* read and close the file */
	/***************************/

	if (!ReadFile (hFile, *lpBuf, dwToRead * sizeof (TCHAR), &dwRead, NULL) ||
		dwRead != dwToRead) {
			CloseHandle (hFile);
			return GEN_ERRREAD;
		}

	CloseHandle (hFile);

	return 0;
}

/*======================================================================*/
/* CreatePath: creating a directory path								*/
/* return:																*/
/*		0		ok														*/
/*		#0		GetLastError()											*/
/*======================================================================*/

DWORD CreatePath (
	LPTSTR lpszDirPath			// file path
	)
{
	int iInd = 3;				// loop control
	int iLen;					// file path length

	iLen = lstrlen (lpszDirPath);

	while (1) {

		/***********************/
		/* get next '\\' index */
		/***********************/

		for (; iInd < iLen; iInd++)
			if (lpszDirPath[iInd] == '\\')
				break;

		/************************************************************/
		/* return in case of end-of-string (last level not created) */
		/************************************************************/

		if (iInd >= iLen)
			return 0;

		/*****************************************************/
		/* directory creation (preexistence is not an error) */
		/*****************************************************/

		lpszDirPath[iInd] = '\0';

		if (!CreateDirectory (lpszDirPath, NULL)) {
			DWORD dw = GetLastError();
			if (dw != ERROR_ALREADY_EXISTS) {
				lpszDirPath[iInd] = '\\';
				return dw;
				}
			}
		lpszDirPath[iInd++] = '\\';
		}
}

/*======================================================================*/
/* CreateShortcut: creating a shortcut to a file						*/
/* return:																*/
/*				0				shortcut created						*/
/*				# 0				ko										*/
/*======================================================================*/

HRESULT CreateShortcut (
	LPTSTR		lpszFile,		// pointer to original file name
	LPTSTR		lpszLink,		// pointer to new link name
	LPTSTR		lpszDesc,		// pointer to description
	LPTSTR		lpszArgs,		// pointer to arguments
	LPTSTR		lpszIcon,		// pointer to icon file
	int			nIcon			// icon index
	)
{
	HRESULT hRes;				// return code
	IShellLink *psl;			// shell link
	IPersistFile *ppf;			// persistent file
	WORD wsz[MAX_PATH];			// Buffer for unicode string

	CoInitialize (NULL);

	hRes = CoCreateInstance (CLSID_ShellLink,
		NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (void **) &psl);
	if (!SUCCEEDED (hRes)) return (hRes);

	hRes = psl->QueryInterface (IID_IPersistFile, (void **) &ppf);
	if (!SUCCEEDED (hRes)) return (hRes);

	hRes = psl->SetPath (lpszFile);
	if (!SUCCEEDED (hRes)) return (hRes);

	hRes = psl->SetDescription (lpszDesc);
	if (!SUCCEEDED (hRes)) return (hRes);

	hRes = psl->SetArguments (lpszArgs);
	if (!SUCCEEDED (hRes)) return (hRes);

	if (*lpszIcon) {
		hRes = psl->SetIconLocation (lpszIcon, nIcon);
		if (!SUCCEEDED (hRes)) return (hRes);
		}

	hRes = psl->SetShowCmd (SW_SHOWNORMAL);
	if (!SUCCEEDED (hRes)) return (hRes);

	MultiByteToWideChar (CP_ACP, 0, lpszLink, -1, wsz, MAX_PATH);

	hRes = ppf->Save (wsz, TRUE);
	if (!SUCCEEDED (hRes)) return (hRes);

	ppf->Release();
	psl->Release();
	CoUninitialize();

	return 0;
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* profile file handling functions										*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* FindProfileSection: finding the beginning of a section				*/
/* return:																*/
/*		0			ok													*/
/*		GEN_ERRSEC	ko - section not found								*/
/*======================================================================*/
/* FindProfileSection finds the section's first line's first character	*/
/*======================================================================*/

int FindProfileSection (
	LPTSTR lpszSecName,					// section name
	BOOL bRequired,						// section required
	LPTSTR lpBuf,						// pointer to profile buffer
	int *nOffBeg						// offset to section beginning
	)
{
	int nOffEnd;						// end-of-line character
	int nLineEnd;						// end-of-line number of characters
	BOOL bFound = FALSE;				// section not found

	/**************************/
	/* while buffer not empty */
	/**************************/

	*nOffBeg = 0;
	while (*(lpBuf + *nOffBeg)) {

		/********************/
		/* find end-of-line */
		/********************/

		for (nOffEnd = *nOffBeg;; nOffEnd++) {

			/*************************************************/
			/* stay on null character in case of end-of-file */
			/*************************************************/

			if (*(lpBuf + nOffEnd) == 0) {
				nLineEnd = 0;
				break;
				}

			/******************************************************************/
			/* delimit the line and point the next one in case of end-of-line */
			/******************************************************************/

			if (*(lpBuf + nOffEnd) == '\n') {
				nLineEnd = 1;
				if (nOffEnd > *nOffBeg) {
					if (*(lpBuf + --nOffEnd) == '\r')
						nLineEnd = 2;
					else
						nOffEnd++;
					}
				break;
				}
			}

		/********************************/
		/* skip empty and comment lines */
		/********************************/

		if (*nOffBeg == nOffEnd || *(lpBuf + *nOffBeg) == ';') {
			*nOffBeg = nOffEnd + nLineEnd;
			continue;
			}

		/*********************/
		/* process a section */
		/*********************/

		if (*(lpBuf + *nOffBeg) == '[') {
			if (nCmp (lpBuf + *nOffBeg + 1, lpszSecName, lstrlen (lpszSecName)) == 0)
				bFound = TRUE;
			}

		/*******************/
		/* go to next line */
		/*******************/

		*nOffBeg = nOffEnd + nLineEnd;
		if (bFound)
			return 0;
		}

	/******************************/
	/* section has not been found */
	/******************************/

	if (bRequired)						// and was required !
		return GEN_ERRSEC;				// ko
	else								// and was not required !
		return 0;						// ok
}

/*======================================================================*/
/* GetProfileLine: reading a profile line								*/
/* return:																*/
/*		0		end-of-profile											*/
/*		#0		offset to the next line									*/
/*======================================================================*/
/* GetProfileLine gets the current profile line. If this line contains	*/
/* an = delimiter, it is split into a left part and a right part. Else, */
/* the left part contains the whole line								*/
/*======================================================================*/

int GetProfileLine (
	LPTSTR lpBuf,						// pointer to the current line
	int *lLef,							// left part length
	LPTSTR *lpRig,						// pointer to right part
	int *lRig							// right part length
	)
{
	int lChar;							// beginning-of-line character
	int nChar;							// number of end-of-line characters

	/************************************************************/
	/* no line read in case of profile-end or section-beginning */
	/************************************************************/

	if (*lpBuf == 0 || *lpBuf == '[')
		return 0;

	/*********************************/
	/* initialize to "no right part" */
	/*********************************/

	*lLef = 0;
	*lpRig = (LPTSTR) 0;
	*lRig = 0;

	/********************/
	/* find end-of-line */
	/********************/

	for (lChar = 0;; lChar++) {

		/*************************************************/
		/* stay on null character in case of end-of-file */
		/*************************************************/

		if (*(lpBuf + lChar) == 0) {
			nChar = 0;
			break;
			}

		/**********************************************************/
		/* delimit line and point next one in case of end-of-line */
		/**********************************************************/

		if (*(lpBuf + lChar) == '\n') {
			nChar = 1;
			if (lChar > 0) {
				if (*(lpBuf + --lChar) == '\r')
					nChar = 2;
				else
					lChar++;
				}
			break;
			}
		}

	/********************************/
	/* skip empty and comment lines */
	/********************************/

	if (lChar == 0 || *lpBuf == ';')
		return (lChar + nChar);

	/****************/
	/* process line */
	/****************/

	for (; *lLef < lChar; (*lLef)++) {
		if (*(lpBuf + *lLef) == '=') {

			/***********************************************************/
			/* ignore spaces and tabulations on the right of left part */
			/***********************************************************/

			if (*lLef > 0) {
				for ((*lLef)--; *lLef >= 0; (*lLef)--)
					if (*(lpBuf + *lLef) != ' ' &&
						*(lpBuf + *lLef) != '\t')
							break;
				(*lLef)++;
				}

			/***********************/
			/* point the left part */
			/***********************/

			for (*lRig = *lLef; *lRig < lChar; (*lRig)++)
				if (*(lpBuf + *lRig) != '=' &&
					*(lpBuf + *lRig) != ' ' &&
					*(lpBuf + *lRig) != '\t')
						break;

			*lpRig = lpBuf + *lRig;
			*lRig = lChar - (*lpRig - lpBuf);
			break;
			}
		}

	return (lChar + nChar);
}

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*//////////////////////////////////////////////////////////////////////*/
/* message handling functions											*/
/*//////////////////////////////////////////////////////////////////////*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*======================================================================*/
/* StrMesBox: displaying a message box with a string parameter			*/
/* return:																*/
/*		identifier of the button pressed on quiting the message box		*/
/*======================================================================*/
/* The message is generated after a formatting string contained in		*/
/* nMessage and a string parameter contained in lpszString				*/
/*======================================================================*/

int StrMesBox (
	int nMessage,				// formatting message number
	LPCTSTR lpszString,			// string parameter
	UINT fuStyle				// dialog buttons
	)
{
	char szMess1[1024];			// message buffer
	char szMess2[1024];			// message buffer

	LoadString (AfxGetInstanceHandle(), nMessage, szMess1, sizeof(szMess1));
	wsprintf (szMess2, szMess1, lpszString);
	return AfxMessageBox (szMess2, fuStyle);
}

/*======================================================================*/
/* SysMesBox: displaying a message box with a system error message		*/
/* return:																*/
/*		identifier of the button pressed on quiting the message box		*/
/*======================================================================*/
/* The message is generated after a formatting string contained in		*/
/* nMessage and a string parameter contained in lpszString				*/
/*======================================================================*/

int SysMesBox (
	int nMessage,				// formatting message number
	LPCTSTR lpszString,			// string parameter
	UINT fuStyle				// dialog buttons
	)
{
	char szMess1[1024];			// message buffer
	char szMess2[1024];			// message buffer
	LPTSTR lpMsgBuf;			// message buffer

	FormatMessage (
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL, GetLastError(), MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPTSTR) &lpMsgBuf, 0, NULL);

	LoadString (AfxGetInstanceHandle(), nMessage, szMess1, sizeof(szMess1));
	wsprintf (szMess2, szMess1, lpszString, lpMsgBuf);
	LocalFree (lpMsgBuf);
	return AfxMessageBox (szMess2, fuStyle);
}
