#include <Windows.h>
#include "PDFChart.h"


UINT ShowError(char *which, UINT iErr)
{
	char message[200];
	
	wsprintf(message, "%s returned error %d", which, iErr);

	MessageBox(NULL, message, "Error Returned From PDFChart DLL", MB_OK | MB_ICONERROR);

	return iErr;
}


int PASCAL WinMain(HINSTANCE hCurrentInstance, HINSTANCE hPreviousInstance,
                   LPSTR lpszCommandLine, int iCommandShow)
{
	UINT	iErr;
	char	appDir[MAX_PATH + 1];
	char	pdfFilename[MAX_PATH + 1];
	char	*p;
	char	errorText[1024];

	// determine where app is running
	lstrcpy(appDir, GetCommandLine());
	if (*appDir == '"')
		lstrcpy(appDir, GetCommandLine() + 1);
	p = strrchr(appDir, '\\');
	if (p) p[1] = 0;
	wsprintf(pdfFilename, "%stest.pdf", appDir);

	PDFC_Chart(CHART_BAR_HORIZONTAL);
	PDFC_Page(600, 400, 0xcc / 255.0, 0xcc / 255.0, 0xff / 255.0); // #ccccff

	PDFC_BarDatum("1950", 2556);
	PDFC_BarDatum("1960", 3040);
	PDFC_BarDatum("1970", 3707);
	PDFC_BarDatum("1980", 4454);
	PDFC_BarDatum("1990", 5277);
	PDFC_BarDatum("2000", 6073);

	PDFC_ChartHeading(VERTICAL_ALIGNMENT_TOP, HORIZONTAL_ALIGNMENT_CENTER);
	PDFC_HeadingTitle(   14, FONT_ID_TIMES_BOLD,       0x33 / 255.0, 0x33 / 255.0, 0xff / 255.0, TEXT_STYLE_NORMAL, 0, 0, 0); // #3333ff
	PDFC_HeadingSubTitle(12, FONT_ID_TIMES_BOLDITALIC, 0x33 / 255.0, 0x33 / 255.0, 0xff / 255.0, TEXT_STYLE_NORMAL, 0, 0, 0); // #3333ff
	PDFC_ChartBackground(0x80 / 255.0, 0x80 / 255.0, 0x80 / 255.0, 0xff / 255.0, 0xff / 255.0, 0xff / 255.0); // #808080 #ffffff

	PDFC_DecimalPoints(0);

	PDFC_AxesCaptionX(14, FONT_ID_TIMES_BOLD, 0x33 / 255.0, 0x33 / 255.0, 0xff / 255.0, TEXT_STYLE_NORMAL, 0, 0, 0, HORIZONTAL_ALIGNMENT_CENTER, "World Population (Millions)"); // #3333ff
	PDFC_AxesCaptionY(14, FONT_ID_TIMES_BOLD, 0x33 / 255.0, 0x33 / 255.0, 0xff / 255.0, TEXT_STYLE_NORMAL, 0, 0, 0, VERTICAL_ALIGNMENT_MIDDLE,   "Year"); // #3333ff

	PDFC_AxesLabelX(   12, FONT_ID_TIMES_BOLD,       0x33 / 255.0, 0x33 / 255.0, 0xff / 255.0, TEXT_STYLE_NORMAL, 0, 0, 0); // #3333ff
	PDFC_AxesLabelY(   12, FONT_ID_TIMES_BOLD,       0x33 / 255.0, 0x33 / 255.0, 0xff / 255.0, TEXT_STYLE_NORMAL, 0, 0, 0); // #3333ff

	PDFC_AxesLine(    1.0, 0.0, 0.0, 0.0, AXES_LINE_FULL);
	PDFC_AxesGridLine(1.0, 0.0, 0.0, 0.0);

	PDFC_AxesDivisions(9);
	PDFC_AxesScale(AXES_SCALE_RANGE, 2000, 6500);

	PDFC_AxesGridLineStyle(7, 7, 4);

	PDFC_BarBorder(1.0, 0.0, 0.0, 0.0);
	PDFC_BarColor(0.0, 0xcc / 255.0, 0.0, 0x99 / 255.0, 0xff / 255.0, 0xff / 255.0); // #00cc00 #99ffff
	PDFC_BarSpacing(7);

	PDFC_BarLabel(LABEL_AT_AXES_AND_END, "");

	PDFC_SetTitle("Example Horizontal Bar Chart produced by the PDF Chart Creator from Utility Warrior");
	PDFC_SetSubject("For more information please visit http://www.UtilityWarrior.com/PDF-Chart-Creator.htm");

	iErr = PDFC_MakePDF(pdfFilename, TRUE, FALSE, errorText, sizeof(errorText));
	if (iErr)
	{
		if (iErr == 1)
			ShowError(errorText, iErr);
		else
			ShowError("PDFC_MakePDF", iErr);
	}

	return iErr;
}
