#region (C) Wout Ware 2005
//
// File: DxfExportExample.cs
// Author: Wout de Zeeuw
// Creation: 5/12/2005
//
// (c) 2005 Wout Ware All Rights Reserved.
//
#endregion
using System;
using System.Drawing;
using System.IO;

using Sharp3D.Math.Core;

using CadLib.Base;
using CadLib.Drawing;
using CadLib.Drawing.GDI;
using CadLib.Drawing.PDF;
using CadLib.IO;
using CadLib.Model;

namespace DxfExportExample
{
	class DxfExportExample
	{
		public static void Main(string[] args)
		{
			if (args.Length != 2) {
				Console.WriteLine("Usage: DxfExport [png|tiff|jpeg|bmp|gif|pdf] <dxf file>");
				Environment.Exit(0);
			}
			string format = args[0];
			string dxfFile = args[1];

			CadData data = null;
			try {
				data = DxfReader.ReadDxf(dxfFile);
			} catch (Exception e) {
				Console.Error.WriteLine("Error occurred: " + e.Message);
				Environment.Exit(1);
			}
			string outfile = Path.GetFileNameWithoutExtension(Path.GetFullPath(dxfFile));
			Stream stream;
			if (format == "pdf") {
	            GDIGraphics3D cadGraphics = 
	            	new GDIGraphics3D(CadGraphicsConfig.Default, Color.White);
	            cadGraphics.CreateDrawables(data);
	            Bounds3D bounds = new Bounds3D();
	            cadGraphics.BoundingBox(bounds, Matrix4D.Identity);
	            // Lengths in inches.
	        	float pageWidth = 8.5f;
	        	float pageHeight = 11f;
	        	float margin = 0.5f;
	            // Scale and transform such that its fits max width/height
	            // and the top left middle of the cad drawing will match the 
	            // top middle of the pdf page.
	            Matrix4D to2DTransform = CadUtil.GetScaleTransform(
	                bounds.Corner1,
	                bounds.Corner2,
	                new Vector3D(bounds.Center.X, bounds.Corner2.Y, 0d),
	                new Vector3D(margin, margin, 0d) * PDFGraphics3D.InchToPixel,
	                new Vector3D(pageWidth - 2d * margin, pageHeight - margin, 0d) * PDFGraphics3D.InchToPixel,
	                new Vector3D(pageWidth / 2d, pageHeight - margin, 0d) * PDFGraphics3D.InchToPixel
	            );
				using (stream = File.Create(outfile + ".pdf")) {
					PDFGraphics3D pdfGraphics = new PDFGraphics3D(stream, true);
					pdfGraphics.Draw(data, CadGraphicsConfig.Default, to2DTransform);
				}
			} else {
	            GDIGraphics3D graphics = new GDIGraphics3D(CadGraphicsConfig.Default, Color.Black);
	            Size maxSize = new Size(500, 500);
				Bitmap bitmap = 
					ImageExporter.CreateBitmap(
						data, 
						graphics, 
						Matrix4D.Identity, 
						Color.Black, 
						maxSize
					);
				switch (format) {
					case "bmp":
						using (stream = File.Create(outfile + ".bmp")) {
							ImageExporter.EncodeImageToBmp(bitmap, stream);
						}
						break;
					case "gif":
						using (stream = File.Create(outfile + ".gif")) {
							ImageExporter.EncodeImageToGif(bitmap, stream);
						}
						break;
					case "tiff":
						using (stream = File.Create(outfile + ".tiff")) {
							ImageExporter.EncodeImageToTiff(bitmap, stream);
						}
						break;
					case "png":
						using (stream = File.Create(outfile + ".png")) {
							ImageExporter.EncodeImageToPng(bitmap, stream);
						}
						break;
					case "jpg":
						using (stream = File.Create(outfile + ".jpg")) {
							ImageExporter.EncodeImageToJpeg(bitmap, stream);
						}
						break;
					default:
						Console.WriteLine("Unknown format " + format + ".");
						break;
				}
			}
		}
	}
}
