
 { 		"LSPELLA" VERSION  2.2L

   COPYRIGHT(C) 1985 PETER A. BANKS

    The copyright of this program is retained by its author.
    It may be  freely  distributed. It may  neither be  sold
    for	profit	nor included in  a  sold  software  package
	without permission of the author.


      DESCRIPTION

 "SPELLA" is a spelling checker program written in Turbo Pascal V3
 for  MSDOS.   The program has some external  similarity  to  the
 public domain program written by Michael Adler, Spell version 2.1
 for CPM.  While spell21 provided some models for suffix stripping
 ,"SPELLA", however, is	over all a  totally  different algorithm.
 The  Standard Dictionary supplied  with  Spell	version  2.1  was
 modified with a different record structure to provide fast random
 access to the dictionary.  The	standard  dictionary supplied has
 almost fifteen thousand basic words, and with the suffix-handling
 capacity of "SPELLA" this translates into three times  that  many
 words.	In addition, "SPELLA" supports a short user dictionary of
 up to 450 words.

 The FREEWARE Editor  "SEDT" can be modified to call "SPELLA".  To
 do so the user	needs  at least 256K bytes of memory.  Using SEDT
 on a system with 256K  bytes  of  memory,  the	largest  document
 "SPELLA" can handle is about 23K  bytes  in size.  In stand-alone
 mode "SPELLA" is not limited by the length of the document.

 When used with an RD50 Winchester, "SPELLA" needs about 30 to  45
 seconds  per  page  to find and mark spelling errors.  Errors are
 marked with  either ASCII character #144,for PTP compatibility or
 a null character for Wordstar compatibility.  These non-printable
 characters (which mark errors)	can  be  later	searched  for and
 corrected using SEDT or Wordstar.
  }



 {VERY	IMPORTANT  compile  Minimum Stack at 400H paragraphs, Maximum Stack at
400H paragraphs for proper operation and size.

 The  following statement must be included in AUTOEXEC.BAT to indicate where
the dictionaries are located( BOTH the STANDARD and the USER dictionaries)

      SET SPELLA=E:\PASCAL\

 Place	the  following	two lines into SEDTKEYS.TXT to call the speller from
the Public Domain editor SEDT.

A019(@F~<144>~:D+C).

GA019:FS~~:SYS~SPELLA  %F~:FE~%F~.
;CONTROL S: CALLS SPELLA OR THE PUBLIC DOMAIN SPELLER
(<144> = ENTERED  IN  SEDT  BY  <GOLD>  144 <GOLD> <KEYPAD3> FOR THE EDT 
 KEYSET)
(<144> = ENTERED IN SEDT  BY  <GOLD>  144  <GOLD> <MAINSCREEN> FOR THE WPS 
 KEYSET)
    }





{ The following compiler directives disable CNTRL-C handling to optimize speed}
{$F20}
{$D-}
{$C-}
{$K-}
 Program spella(Input,Output);

  Const    letters : Set Of Char = ['A'..'Z',#39];

    vowels : Set Of Char = ['A','E','I','O','U','Y'];

    strlimit = 20;  {Max word length}

  
    hilt  = #27'[7m';
    off   = #27'[0m';

    perdiclim = 1501 ; { Maximum limit to personal dictionary}

    minstack = $405;{ 8 Paragraph Guard Band }
 { Maximum size to stack should be five more than the value program is
  compiled at }

    keylen = 10;

    numbstep = 212;

    maxrec =  1696;

    maxrecd = 1688;

    linelimit = 255; { Max size of line }

    bell = ^g^g^g;{used at end of program }

    perdico : Boolean = False;
    texline : String [132] = '';   { Initialize files }
    tex1line : String[132] = '';
    dicstr : String [20] = '';
    bufwrd : String [25] = '';
    letrcnt : Integer = 1;
    notwrd : Integer = 0;
    totwd : Integer = 0;
    hyph : Boolean = False;
    hyph1 : Boolean =  False;
    fstcyc : Boolean = False;
    substr : String [20] = '';
    curdir : String [60] = '';

 { INDEX to standard dictionary }
    



    dicindx : Array [0..numbstep] Of String[keylen] = 
('ABACK','ABSENTIA','ACCOMPLISH','ACROBATIC','ADJUDGE',
'ADVERB','AFORESAID','AIRILY','ALIGN','ALPHABETIZ',
'AMERICAN','ANALYZE','ANISOTROPY','ANTIDOTE','APOCALYPSE',
'APPRECIATI','ARCHIPELAG','ARRACK','ASCRIPTION','ASSUMPTION',
'ATROPHIC','AURAL','AVENGE','BACKARROW','BALLPLAYER',
'BARLEY','BATTLEGROU','BEDTIME','BELLICOSIT','BESTIAL',
'BILE','BITUMINOUS','BLOCKADE','BODY','BOOTSTRAPP',
'BOYISH','BRED','BRONCHI','BULB','BUSHWHACK',
'CALIPH','CAPTAIN','CATCHABLE','CHAGRIN','CHECKPOINT',
'CHRISTMAS','CLASSIFIAB','CLUBBING','COLLECTOR','COMMON',
'COMPOSE','CONDONE','CONSCIENTI','CONTAINMEN','CONVERSE',
'CORROSION','COW','CRIPPLE','CULTURAL','DAGGER',
'DECADE','DEFERRED','DEMORALIZE','DESCRY','DEVOID',
'DIGRESS','DISBAND','DISMAL','DISTRIBUTI','DOT',
'DRINKABLE','EAGLE','EGO','EMBARRASSM','ENCRYPTION',
'ENTERTAINI','ERASURE','EVERYWHERE','EXEMPLIFY','EXPONENT',
'FACIAL','FASHIONABL','FESTIVITY','FISH','FLORA',
'FORE','FORTHWITH','FRICATIVE','GABLE','GENE',
'GLADDER','GOTHIC','GREASY','GUILD','HANDILY',
'HEADACHE','HEREINAFTE','HOAR','HORRIFY','HURRAH',
'ILLUSIVE','IMPETUS','INASMUCH','INDETERMIN','INEXPERIEN',
'INHERITRIC','INSOFAR','INTERCHANG','INTONATION','IRATE',
'JARRING','JUNK','KNIT','LATE','LEGAL',
'LICHEN','LITHE','LOUDSPEAKE','MAGIC','MANIPULABL',
'MASTER','MEDIC','METALANGUA','MILITARISM','MISS',
'MONASTERY','MOTORCYCLE','MUSHY','NAVIGATOR','NICHE',
'NONSPECIAL','NUMEROUS','OCCURRING','OPINION','ORTHOGONAL',
'OVERDRAFT','PACKAGE','PARALYSIS','PASTE','PEDESTRIAN',
'PERMANENT','PHENOMENOL','PINPOINT','PLEASANT','POLITIC',
'POTASH','PREDICT','PRETENTIOU','PROCUREMEN','PROPAGANDA',
'PROVIDENCE','PURR','QUILT','RAP','REARRANGEM',
'RECONFIGUR','REENTRANT','REGULAR','REMIND','REPRESSION',
'RESPECTABI','RETRY','RIFT','ROOST','RUSTY',
'SANITATION','SCHEMA','SEAM','SEMICOLON','SEVER',
'SHILLING','SHUFFLE','SINE','SLANT','SMELT',
'SODIUM','SPADE','SPIRAL','SQUASH','STATION',
'STIRRED','STRIFE','SUBJECT','SUCCESS','SUNNY',
'SURVIVOR','SYMPOSIUM','TANGIBLE','TEETH','TERRORISTI',
'THIN','TIGHTEN','TOOTHPICK','TRAITOR','TRAVESTY',
'TROUBLESOM','TWIN','UNBOUND','UNDERSCORE','UNFORTUNAT',
'UNMODIFIED','UNSELECTED','UPLIFT','VALVE','VERSATILIT',
'VIRGINITY','WAIVERABLE','WEAN','WHIPPER','WIRY',
'WORN','YOUNG',
'[[[[[[[[[['); 
						      



diclimit = 1136;
    { Contents to SHORT dictionary }

    shrtdic : Array[0..diclimit] Of String [8] =
('@@@@@@','ABLE','ABLEST','ABLY','ABORT',
'ABOUT','ABOVE','ABROAD','ABRUPT','ABSENT','ABUSE',
'ABUSES','ACCENT','ACCESS','ACCUSE','ACCUSED',
'ACCUSES','ACHE','ACROSS','ACT','ACTED',
'ACTING','ACTION','ACTIVE','ACTS','ACTUAL','ADD',
'ADDED','ADDICT','ADDING','ADDS','ADJUST',
'ADMIRE','ADMIRED','ADMIRES','ADMIT','ADMITED',
'ADMITS','ADOPT','ADOPTED','ADOPTS','ADULT',
'ADULTS','ADVISE','ADVISED','AFFECT','AFFECTS',
'AFFIRM','AFFIRMS','AFFORD','AFFORDS','AFTER',
'AGAIN','AGE','AGED','AGENCY','AGES',
'AGO','AGONIES','AGONY','AGREE','AGREED',
'AGREES','AHEAD','AID','AIDED','AIDING',
'AIDS','AIM','AIMED','AIMS','AIR',
'AIRED','AIRS','ALIEN','ALIKE','ALIVE',
'ALL','ALLOW','ALLOWED','ALLOWING','ALLOWS','ALMOST',
'ALONE','ALONG','ALOT','ALSO','ALTER',
'ALTERS','ALWAYS','AMAZE','AMEN','AMEND',
'AMONG','AMP','AMPLE','AMPS','AMUSE',
'AMUSED','AND','ANGER','ANGERED','ANGERS',
'ANIMAL','ANSWER','ANSWERS','ANTI','ANY',
'APPEAL','APPEALS','APPEAR','APPEARS','APPLY',
'APR','APRIL','ARE','AROUND','ARRAY',
'ARROW','ART','ASK','ASKED','ASKING',
'ASKS','ASSIGN','ASSUME','ASSUMES','AUG',
'AUGUST','AUNT','AVE','AVENUE','BABIES',
'BABY','BACK','BACKED','BACKS','BAD',
'BAGGED','BAGS','BAND','BANDED','BANDING',
'BANDS','BANK','BANKS','BASE','BASES',
'BASING','BASIS','BEAUTY','BECAME','BECOME',
'BECOMES','BEEF','BEFORE','BEGAN','BEGIN',
'BEGINS','BEGUN','BEHAVE','BEHAVES','BEING',
'BEINGS','BELIEF','BELIEFS','BELONG','BELONGS',
'BELOW','BESIDE','BEST','BETTER','BIG',
'BIGGER','BIGGEST','BILL','BILLS','BIT',
'BITE','BITES','BOOK','BOOKS','BORN',
'BOTH','BOX','BOXES','BOY','BOY'#39'S',
'BOYS','BUFFER','BUFFERS','BUILD','BUILDS',
'BUILT','BURDEN','BURDENS','BUSIED','BUSY',
'BUT','BUY','BUYER','BUYERS','BYTE',
'BYTES','CALL','CALLED','CALLER','CALLERS',
'CALLING','CALLS','CAME','CAN','CAN'#39'T',
'CANNOT','CANS','CAR','CAR'#39'S','CARD',
'CARE','CAREER','CAREERS','CARRY','CARS',
'CASE','CASES','CASH','CAUSE','CAUSED',
'CAUSES','CEASE','CEASED','CEASES','CENTER',
'CHANCE','CHANCED','CHANGE','CHANGED','CHARGE',
'CHEAP','CHECK','CHECKED','CHECKS','CHIEF',
'CHIP','CHIPS','CHOICE','CHOICES','CHOOSE',
'CHOOSES','CHRIST','CINCH','CIRCLE','CITY',
'CIVIL','CLAIM','CLASS','CLEAR','CLEARED',
'CLEARS','CLOCK','CLOSE','CLOSED','CLOSING',
'COARSE','COLD','COM','COME','COMES',
'COMING','COMMIT','COMMON','CONT','CORE',
'CORP','COULD','COULOMB','COUNT','COUNTS','COURSE',
'COURSES','COVER','COVERS','CREATE','CREATES',
'CRISIS','CROSS','CROSSED','CROWD','CRUELLY',
'CUP','CUT','CUTE','DATA','DATE',
'DATED','DATES','DEAR','DEARS','DEC',
'DEFINE','DEFINED','DEFINES','DELETE','DELETED',
'DELETES','DESIGN','DESIGNS','DESIRE','DESIRED',
'DESIRES','DEVICE','DEVICES','DID','DIRECT',
'DISK','DISKS','DIVIDE','DIVIDED','DIVIDES',
'DOER','DOERS','DOES','DOING','DOINGS',
'DOLLAR','DOLLARS','DON'#39'T','DONE','DONOR','DONOR'#39'S',
'DONORS','DOUBT','DOUBTED','DOUBTS','DRIVE',
'DRIVES','DROP','DROPED','DROPS','DROVE',
'DUMB','DUMP','DURING','EACH','EAGER',
'EASE','EASILY','EAST','EASY','EAT',
'EATS','EFFECT','EFFECTS','EFFORT','EFFORTS',
'EIGHT','EIGHTH','EITHER','ELSE','EMPTY',
'ENABLE','ENABLED','END','ENDED','ENDS','ENJOY',
'ENJOYS','ENOUGH','ENTER','ENTERED','ENTERS',
'EQUAL','EQUALED','EQUALS','ERROR','ERRORS',
'ETC','EVENT','EVENTS','EVER','EXACT',
'EXCEPT','EXIT','EXITS','EXTRA','FAIL',
'FAILED','FAILS','FAIR','FALL','FALLS',
'FARAD','FARE','FATE','FATHER','FATHERS','FEB',
'FEEL','FEELING','FEELINGS','FEELS','FEET','FELT','FETAL',
'FETUS','FEW','FIELD','FIELDSL','FIFTH',
'FIGHT','FILE','FILES','FIND',
'FINDS','FINE','FINEST','FINISH','FIRM',
'FIRMLY','FIRST','FIRSTS','FIVE','FIX',
'FIXED','FLAME','FLIER','FLIES','FLOOR',
'FLY','FOLLOW','FOLLOWS','FOOT','FOR',
'FORCE','FORCED','FORCES','FORCING','FORE',
'FORM','FORMS','FORTH','FORTHLY','FORTY','FOUR',
'FOURTH','FREE','FRI','FRIDAY','FROM','FULL',
'FUN','FUND','FUNDED','FUNDING','FUNDS',
'FUNNY','GAIN','GAINED','GAINS','GAME',
'GAMES','GATE','GAVE','GENIUS','GET',
'GETS','GETTING','GIRL','GIRLS','GIVE',
'GIVEN','GIVENS','GIVER','GIVERS','GIVES','GIVING','GOAL','GOALS',
'GOD','GOES','GOING','GOOD','GOODS','GOT',
'GRAND','GRAPH','GRAPHS','GREAT','GREATS',
'GROW','GROWN','GROWS','GRUMPY','GUIDE','GUIDES',
'HAD','HADN'#39'T','HAPPY','HASN'#39'T','HATE',
'HAVE','HE'#39'D','HE'#39'LL','HE'#39'LL','HE'#39'S',
'HEAD','HEADED','HEADER','HEADERS','HEADING',
'HEAR','HEART','HEAT','HEATER','HEATERS',
'HEATING','HEAVY','HEIGHT','HELP','HELPED',
'HELPER','HELPERS','HELPING','HELPS','HER',
'HER'#39'S','HERE','HIGH','HIGHLY','HIM',
'HIS','HOLLY','HOME','HONEST','HOPE',
'HOPES','HOPING','HOW','HRS','HUDSON',
'HUGE','HYPER','HYPO','I'#39'D','I'#39'LL',
'I'#39'M','I'#39'VE','IDEA','IDEALY','IDEAS',
'INC','INCEST','INDEX','INSERT','INTAKE',
'INTO','ISN'#39'T','IT'#39'S','ITS','ITSELF',
'JAN','JEFF','JESUS','JOKE','JUL',
'JULY','JUMP','JUMPED','JUMPING','JUMPS',
'JUN','JUNE','JUST','KEEP','KEEPER',
'KEY','KEYED','KEYS','KIND','KINDS',
'KNEW','KNIT','KNOW','KNOWING','KNOWN','KNOWS',
'LABOR','LABORS','LARGE','LARGER','LARGEST',
'LAST','LATER','LAY','LEAD','LEADER',
'LEADERS','LEADING','LED','LEFT','LENGTH',
'LESS','LET','LIE','LIGHT','LIKE',
'LIKELY','LIKES','LIMIT','LIMITED','LIMITS',
'LINE','LINER','LINES','LIST','LISTS',
'LITTLE','LOAD','LOADS','LOCAL','LONG',
'LONGER','LOOSE','LOOSEN','LORD','LOSE','LOSER','LOSERS',
'LOSS','LOST','LOVE','LOW','LOWER',
'LUMP','LUMPS','MAD','MADAM','MADE',
'MAIN','MAINE','MAJOR','MAKE','MAKES',
'MAKING','MAN','MANUAL','MANY','MAR',
'MARCH','MARK','MAY','MEAN','MEANING',
'MEANS','MELODY','MEMORY','MEN','MERCY',
'MISC','MISS','MISSING','MODE','MON',
'MONDAY','MONEY','MONIES','MONO','MORAL',
'MORE','MOST','MOSTLY','MOTHER','MOVE','MOVED',
'MOVES','MOVING','MRS','MUCH','MULTI',
'MUST','NAME','NAMED','NAMES','NEED',
'NEEDED','NEEDING','NEEDS','NEVER','NEW',
'NEWER','NEWEST','NEWLY','NEWS','NEXT',
'NINE','NINTH','NORTH','NOT','NOTE',
'NOTES','NOTICE','NOTICED','NOTICES','NOTING',
'NOV','NOW','NUMBER','OBJECT','OBJECTS',
'OCCUR','OCCURS','OCT','OFF','OFFER',
'OFFERS','OFTEN','OHM','OHMS','OLD',
'OLDER','OLDEST','OMIT','ONCE','ONE',
'ONLY','OPAMP','OPEN','OPENED','OPENING',
'OPENS','OPPOSE','OPPOSED','OPPOSES','OTHER',
'OTHERS','OUR','OUR'#39'S','OVER','OWN',
'OWNS','PAID','PAIN','PAINS','PART',
'PARTS','PASCAL','PASS','PASSED','PAST',
'PATH','PATHS','PAY','PAYING','PAYS',
'PEACE','PEOPLE','PER','PERMIT','PERMITS',
'PERSON','PERSONS','PETER','PHONE','PHONED',
'PHONES','PIECE','PIECED','PIECES','PLACE',
'PLACED','PLAIN','PLAN','PLANE','PLANS',
'PLAY','PLAYS','PLEASE','PLEASES','POINT',
'POINTS','POLLY','POST','POSTER','POSTERS',
'PRE','PRESS','PRESSED','PRO','PROGRAM',
'PROVE','PROVES','QUICK','QUIET','QUITE',
'QUO','QUOTA','QUOTE','QUOTED','QUOTES','RACE','RADIO',
'RAN','RATHER','REACH','REACT','REACTED',
'REACTS','READ','READER','READER'#39'S','READERS','READS',
'READY','REAL','REALIZE','REALLY','REALS',
'REAR','REASON','RECENT','RECITE','RECORD',
'RECORDS','RED','REDUCE','REDUCED','REF',
'REFER','REFERS','REFUND','REFUSE','REFUSED',
'REFUSES','REGARD','REGRET','REGRETS','REJECT',
'REJECTS','RELATE','RELAX','RELAXED','RELAXES',
'RELAY','RELAYED','RELAYS','RELIEF','REMOVE',
'RESULT','RESULTS','REV','RIGHT','RIGHTS',
'ROOM','ROOMS','ROOT','ROOTS','RUN',
'RUNS','SAD','SADLY','SAFE','SAFES',
'SAFETY','SALE','SALES','SAME','SAMPLE',
'SAMPLED','SAMPLES','SAT','SAW','SCENE',
'SCENES','SEARCH','SEAT','SEATED','SEATING',
'SEATS','SECOND','SEDT','SEE','SEEK',
'SEEM','SEEMED','SEEMING','SEEMS',
'SEEN','SEIZE','SEIZED','SELF',
'SELVES','SENCE','SENT','SEP','SEPT',
'SERIES','SET','SETS','SEVEN','SEX',
'SEXES','SHARE','SHARES','SHARING','SHE',
'SHE'#39'LL','SHE'#39'S','SHOULD','SIGHT','SIGHTS',
'SIGN','SIMPLE','SIMPLY','SIN','SINCE',
'SING','SINGS','SIR','SIRS','SISTER',
'SIT','SITE','SIX','SIXTH','SOCIAL',
'SOLD','SOME','SONG','SONGS','SOUGHT',
'SOUND','SOUNDS','SOURCE','SOURCE','SOURCES',
'SOUTH','SPACE','SPACED','SPACES','SPEAK','SPEAKER',
'SPEAKER'#39'S','SPEAKING',
'SPEAKS','SPEECH','SPEED','SPEEDS','SPELLA',
'SPOKE','SPOKEN','SPRING','STATE','STAY','STAYED',
'STAYS','STORY','STREET','STREETS','STRING',
'SUMMER','SURE','TAKE','TAKES','TAKING',
'TASTE','TASTED','TASTES','TEAM','TEAMS',
'TEEN','TEENS','TELL','TELLING','TELLS',
'TEN','TENS','TENTH','TEXT','TEXTS',
'THAN','THANK','THANKS','THAT','THE',
'THEIR','THEIR'#39'S','THEM','THEN','THERE',
'THESE','THEY','THING','THINGS','THIRD',
'THIS','THOSE','THOUGH','THREE','THROUGH',
'THURS','TIME','TIMES','TIMING','TITLE',
'TITLES','TODAY','TOLD','TOO','TOOL',
'TOOLS','TOWN','TOWNS','TRAIN','TRAINED',
'TRIED','TRIES','TRUE','TRULY','TRUTH',
'TRY','TRYING','TUES','TURBO','TWO',
'TYPE','TYPED','TYPES','TYPING','UNCLE',
'UNDER','UNION','UNIONS','UNSOLD','UNTIL',
'UNWED','UPON','USE','USED','USEFUL',
'USER','USERS','USES','USING','VAGUE',
'VAIL','VAIN','VALID','VALUE','VALUED',
'VALUES','VERSE','VERSES','VERY','VIEW',
'VIEWS','VOLT','VOLTS','WAIT','WAITED',
'WAITING','WAITS','WALL','WALLS','WAS',
'WE'#39'D','WE'#39'LL','WE'#39'RE','WE'#39'VE','WED',
'WEED','WEEDS','WEEK','WEEKS','WELL',
'WENT','WEST','WHAT','WHEN','WHERE',
'WHICH','WHILE','WHO','WHOM','WHOSE',
'WHY','WILL','WILLED','WILLING','WILLS',
'WINDOW','WINTER','WISH','WISHES','WISHING',
'WITH','WOMAN','WOMAN'#39'S','WOMEN','WON'#39'T','WORD',
'WORDS','WORK','WORKED','WORKER',
'WORKERS','WORKING','WORKS','WORSE','WORSEN',
'WORST','WORTH','WORTHY','WOULD','WRITE',
'WRITES','WRITING','WRITTEN','WRONG','WRONGS',
'WROTE','YEAR','YEARS','YES','YIELD',
'YIELDED','YIELDING','YIELDS','YOU','YOU'#39'LL',
'YOU'#39'RE','YOU'#39'VE','YOUR','ZIP','ZONE ',
'ZONED','ZONES','[[[[[[');



Type   calreg = Record
Case Integer Of
1: (ax :Integer);
2: (al,ah:Byte);
End;



wordln =  String [strlimit];
mstring = String [255];
wdkey = String [keylen];
{ used as key for index }
wrdptr = ^wrdrec;
wrdrec = Record
{ used for heap word search }
wrd : wordln;
word: Boolean;
lessr,grtr: wrdptr;
End;

wrd_rec = Record
{Structure of standard dictionary }
rootwd : Array [0..71] Of
Array[1..7] Of
Integer;
End;

Var 
toppt,wdptr: wrdptr;
key : wdkey;
stdct : File;
{standard user dictionary}
buffer : wrd_rec;
DMBTST,parama,dicfil,perdct,fylnam,fylnam2,credct :String[80];
mrkchr,let : Char;
fnd,found,endoln,word,letr,
trmchr,ok: Boolean;
usrdic : Array [0..perdiclim ] Of wordln;
inpoot,ootpoot: Text[4096];
{The corrected document}
test,prdct : Text;
{The Personal dictionary}
heepseg,heepof,toplim,botlim,
txtlng,dicxx,
perlim,index,indexa,x: Integer;

Const 
underline : String[30] = '_______________________________';

						     
Procedure stopit;
Begin
  Close(inpoot);
  Close(ootpoot);
  Close(stdct);
  chdir(curdir);
  Clrscr;
  Write (chr(27),'[00;24r','Exiting back to Operating System');
  Halt;
End;

{$I SETUP.PAS}
{$I SPELL.PAS}
{$I CLOSUP.PAS}



{  Taken off the IBM notes file
** The following function will look for an environment variable
** and return it's definition if found.  If the variable is not
** found, then the returned definition variable will be empty.
** Compiled and run with Turbo Pascal v2.0 on an IBM PC/XT running
** PC-DOS v2.1.
**
** This code is entered into the Public Domain for free use by all.
** George B. Smith, March 15, 1985.
}

Procedure setdic;

Var 
    envseg: Integer;  { segment address of environment from PSP }
    ei: Integer;  { index into environment }
    envname : mstring; { current environment string name }
    ch: Char; { current character from environment }
    KYCLR : CALREG;



Begin
    envseg := Memw[cseg:$2c]; { get address of environment from PSP }
    fnd := False;
    ei := 0;
    ch := Chr(Mem[envseg:ei]); { get first char from environment }
    While (ch <> Chr(0)) And (Not fnd) Do
      Begin
	envname := '';
	While ch <> '=' Do
	  Begin   { get environment string name }
	    envname := envname + ch;
	    ei := Succ(ei);
	    ch := Chr(Mem[envseg:ei])
	  End;
	ei := Succ(ei);  { skip over the EQUALS }
	parama := '';
	ch := Chr(Mem[envseg:ei]);
	While ch <> Chr(0) Do
	  Begin   { get environment string parameter }
	    parama := parama + ch;
	    ei := Succ(ei);
	    ch := Chr(Mem[envseg:ei])
	  End;
	If  envname = 'LSPELLA'
	  Then  { check for a match }
	    fnd := True;
	ei := Succ(ei);
	ch := Chr(Mem[envseg:ei])
      End;
  



  If Not fnd
    Then
      Begin
         getdir(0,parama); {if no set statement in autoexec.bat then
                                lspella has to be called from within the 
                                directory in which the dictionary is in }

        IF (LENGTH(PARAMA) > 3) THEN
        parama := parama + '\';

	dicfil := parama +'PABSP2.DCT';
   
   	Assign (stdct,dicfil);
 {$I-}
	Reset (stdct);
 {$I+} 
	ok := (Ioresult = 0);
	If Not ok
	  Then
            begin
            writeln('CAN NOT FIND STANDARD DICTIONARY');
              WRITELN ('HIT ANY KEY TO CONTINUE');
              kyclr.ah := 07;
              MSDOS(KYCLR); 
	    stopit;
            END;

            writeln('CAN NOT FIND ENVIROMENT STATEMENT');
            WRITELN ('HIT ANY KEY TO CONTINUE');
            kyclr.ah := 07;
            MSDOS(KYCLR); 
      End
    Else
      Begin
	dicfil := parama +'PABSP2.DCT';
	Assign (stdct,dicfil);
 {$I-}
	Reset (stdct);
 {$I+}  
	ok := (Ioresult = 0);
	If Not ok
	  Then
	    Begin
              WRITELN;
              WRITE ('YOU  HAVE  AN  ERROR IN THE ENVIRORMENT STATEMENT IN');
              WRITELN ('AUTOEXEC.BAT');
              WRITELN ('HIT ANY KEY TO CONTINUE');
              kyclr.ah := 07;
              MSDOS(KYCLR); 
       	      Assign (stdct,'PABSP2.DCT');
 {$I-}
	      Reset (stdct)
 {$I+}	;
	      ok := (Ioresult = 0);
	      If Not ok
		Then
		  stopit;
	    End
      End;
      getdir(0,curdir);
 End;





Procedure clrval;
Begin
    hyph1 := False;
    substr := '';
    bufwrd := '';
    dicstr := '';
    letrcnt := 1;
    letr := False;
 End;





        
        
        
     {MAIN PROGRAM}

 Begin
   setdic;
   wdptr := Nil;
   toppt := Nil;
   setfyl;
   heepseg := seg(Heapptr^);
   heepof  := ofs(Heapptr^);
   Assign(ootpoot,'$$$$.tmp');
   Rewrite(ootpoot);
{$I PARSEIT.PAS}
   clsup;
   write(chr(27),'[00;24r');
End.
