/*
 * I have had several requests to implement a method for changing the colors
 * used in tde.  I thought about using a configuration file, but I really
 * didn't like that route.  Changing the executable file seemed the best way
 * to go.  That way, you only need one file to run tde - the executable.
 * Also, I didn't have to add a bunch of code to tde to parse a configuration
 * file.  It doesn't take a lot of time to figure out the offsets of the those
 * variables to initialize in tde.exe, so it's fairly easy to do.
 *
 * Program name:  tdecolor
 * Author:        Frank Davis
 * Date:          July 21, 1991
 * Compiler:      MSC 6.0a and QuickC 2.5
 *                cl /AS /Gs tdecolor.c
 *                exehdr /max:1000 tdecolor
 *
 * This program is released into the public domain.  You may distribute
 * it freely, Frank Davis
 */


/********    EXTREMELY IMPORTANT   ************/
/*
 * If you modify tde, it is your responsibility to find the offset of
 * "static int colors" in function "hw_initialize" in file "main.c" in your
 * new executable, tde.exe.
 *
 * If you don't change the default colors, search for the following string (a
 * hexadecimal integer array) in your new executable file:
 *
 *  7000 0700
 *
 * Then, replace COLOR_OFFSET with your new one and recompile tdecolor.exe
 * with the new offset.
 */

#define  COLOR_OFFSET   50432l

/*******     EXTREMELY IMPORTANT   ************/


#include <bios.h>
#include <dos.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "tdecolor.h"
#include "tdecfg.h"


/*
 * Default color settings.  Incidentally, I'm color blind (mild red-green) and
 * the default colors look fine to me. ;*)
 */
static int colors[2][8] = {
   { HERC_REVERSE, HERC_NORMAL, HERC_REVERSE, HERC_REVERSE, HERC_HIGH,
     HERC_NORMAL, HERC_NORMAL, HERC_HIGH },
   { COLOR_HEAD, COLOR_TEXT, COLOR_MODE, COLOR_BLOCK, COLOR_MESSAGE,
     COLOR_HELP, COLOR_WRAP, COLOR_EOF }
};

extern struct vcfg cfg;         /* video stuff */
extern FILE *tde_exe;           /* FILE pointer to tde.exe */

static int temp_colors[2][8];   /* play around with colors in this array */
static int index;               /* 0 = Monochrome colors, 1 = color colors */


/*
 * Name:    tdecolor
 * Date:    July 21, 1991
 * Notes:   Strategy is fairly straight forward -  1) initialize all the
 *          variables  2) show the user a color sample  3) make the changes
 *          permanent if desired.
 */
void tdecolor( void )
{
   initialize_color( );
   show_init_sample( );
   change_colors( );
}


/*
 * Name:    initialize
 * Date:    July 21, 1991
 * Notes:   Set up all of the global variables.
 */
void initialize_color( void )
{
int i, j;

   fseek( tde_exe, COLOR_OFFSET, SEEK_SET );
   fread( (void *)temp_colors, sizeof( temp_colors ), 1, tde_exe );

   if (cfg.color == FALSE)
      index = 0;
   else
      index = 1;

   fields[0].color = temp_colors[index][HELP];
   fields[1].color = temp_colors[index][HEAD];
   fields[2].color = temp_colors[index][TEXT];
   fields[3].color = temp_colors[index][BLOCK];
   fields[4].color = temp_colors[index][WARNING];
   fields[5].color = temp_colors[index][MODE];
   fields[6].color = temp_colors[index][WRAP];
   fields[7].color = temp_colors[index][CEOF];

   fields[0].show_me = show_help_color;
   fields[1].show_me = show_fileheader_color;
   fields[2].show_me = show_text_color;
   fields[3].show_me = show_block_color;
   fields[4].show_me = show_warning_color;
   fields[5].show_me = show_mode_color;
   fields[6].show_me = show_wrapped_color;
   fields[7].show_me = show_eof_color;
}


/*
 * Name:    show_init_sample
 * Date:    July 21, 1991
 * Notes:   Draw all of the sample screens.
 */
void show_init_sample( void )
{
char *sample;
int line, i, j, k, l;
char temp[6], num[6];
char far *p;

   xygoto( -1, -1 );
   sample = sample_screen[0];
   for (line=0; sample != NULL; ) {
      s_output( (char far *)sample, line, 0, 7 );
      sample = sample_screen[++line];
   }
   for (i=0; i<8; i++)
      (*fields[i].show_me)();
   sample = field_screen[0];
   for (line=12, i=1; sample != NULL; line++,i++) {
      s_output( (char far *)sample, line, 0, 7 );
      sample = field_screen[i];
   }
   p = (char far *)temp;
   for (i=0,k=0,line=17; i<8; i++, line++) {
      for (j=0,l=0; j<16; j++, k++,l+=5) {
         color_number( temp, k );
         s_output( p, line, l, k );
      }
   }
   for (i=0; i<8; i++) {
      color_number( temp, fields[i].color );
      s_output( p, fields[i].line, fields[i].col, fields[i].color );
   }
}


/*
 * Name:    color_number
 * Date:    July 21, 1991
 * Passed:  dest:  buffer to store the color sample
 *          num:   attribute number
 * Notes:   Show the use what the foreground and background colors look like.
 */
void color_number( char *dest, int num )
{
int i, j, k;
char temp[6];

   strcpy( dest, "[   ]" );
   itoa( num, temp, 10 );
   i = strlen( temp );
   j = 4 - i;
   for (k=0; i > 0; i--,j++, k++)
      dest[j] = temp[k];
}


/*
 * Name:    current_color_number
 * Date:    July 21, 1991
 * Passed:  dest:  buffer to store the color sample
 *          num:   attribute number
 * Notes:   Put '*' around the sample color to give the user an idea of where
 *          the current field is.
 */
void current_color_number( char *dest, int num )
{
int i, j, k;
char temp[6];

   strcpy( dest, "*   *" );
   itoa( num, temp, 10 );
   i = strlen( temp );
   j = 4 - i;
   for (k=0; i > 0; i--,j++, k++)
      dest[j] = temp[k];
}


/*
 * Name:    show_help_color
 * Date:    July 21, 1991
 */
void show_help_color( void )
{
int color;
int line, len;

   color = fields[0].color;
   for (line=1; line <11; line++)
      hlight_line( 1, line, 37, color );
}


/*
 * Name:    show_fileheader_color
 * Date:    July 21, 1991
 */
void show_fileheader_color( void )
{
   hlight_line( 41, 1, 38, fields[1].color );
}


/*
 * Name:    show_text_color
 * Date:    July 21, 1991
 */
void show_text_color( void )
{
int color;
int line, len;

   color = fields[2].color;
   for (line=2; line <6; line++)
      hlight_line( 41, line, 38, color );
}


/*
 * Name:    show_block_color
 * Date:    July 21, 1991
 */
void show_block_color( void )
{
int color;
int line, len;

   color = fields[3].color;
   for (line=6; line <8; line++)
      hlight_line( 41, line, 38, color );
}


/*
 * Name:    show_warning_color
 * Date:    July 21, 1991
 */
void show_warning_color( void )
{
   hlight_line( 41, 9, 38, fields[4].color );
}


/*
 * Name:    show_mode_color
 * Date:    July 21, 1991
 */
void show_mode_color( void )
{
   hlight_line( 41, 10, 26, fields[5].color );
}


/*
 * Name:    show_wrapped_color
 * Date:    July 21, 1991
 */
void show_wrapped_color( void )
{
   hlight_line( 67, 10, 12, fields[6].color );
}


/*
 * Name:    show_eof_color
 * Date:    July 21, 1991
 */
void show_eof_color( void )
{
   hlight_line( 41, 8, 38, fields[7].color );
}


/*
 * Name:    change_colors
 * Date:    July 21, 1991
 * Notes:   Real workhorse function of the utility.  Get a key and then
 *          figure out what to do with it.
 */
void change_colors( void )
{
int c;
int area;
int color;
int new_color;
int i;
char temp[6];
char far *p;

   p = (char far *)temp;
   area = 0;
   current_color_number( temp, fields[area].color );
   s_output( p, fields[area].line, fields[area].col, fields[area].color );
   xygoto( fields[area].col+3, fields[area].line );
   for (c=0; c != F3  &&  c != F10  &&  c != ESC;) {
      new_color = FALSE;
      c = getkey( );
      switch (c) {
         case RTURN :
            color_number( temp, fields[area].color );
            s_output( p, fields[area].line, fields[area].col, fields[area].color );
            ++area;
            if (area > 7)
               area = 0;
            current_color_number( temp, fields[area].color );
            s_output( p, fields[area].line, fields[area].col, fields[area].color );
            xygoto( fields[area].col+3, fields[area].line );
            break;
         case UP :
            --fields[area].color;
            if (fields[area].color < 0)
               fields[area].color = 127;
            new_color = TRUE;
            break;
         case DOWN :
            ++fields[area].color;
            if (fields[area].color > 127)
               fields[area].color = 0;
            new_color = TRUE;
            break;
         case PGUP :
            fields[area].color -= 16;
            if (fields[area].color < 0)
               fields[area].color = (fields[area].color & 0x000f) + 0x70;
            new_color = TRUE;
            break;
         case PGDN :
            fields[area].color += 16;
            if (fields[area].color > 127)
               fields[area].color = fields[area].color & 0x000f;
            new_color = TRUE;
            break;
         case F2 :

            /*
             * get back the original colors and display
             */
            fields[0].color = colors[index][HELP];
            fields[1].color = colors[index][HEAD];
            fields[2].color = colors[index][TEXT];
            fields[3].color = colors[index][BLOCK];
            fields[4].color = colors[index][WARNING];
            fields[5].color = colors[index][MODE];
            fields[6].color = colors[index][WRAP];
            fields[7].color = colors[index][CEOF];
            for (i=0; i<8; i++) {
               color_number( temp, fields[i].color );
               s_output( p, fields[i].line, fields[i].col, fields[i].color );
               (*fields[i].show_me)();
            }
            current_color_number( temp, fields[area].color );
            s_output( p, fields[area].line, fields[area].col, fields[area].color );
            break;
      }
      if (new_color) {
         current_color_number( temp, fields[area].color );
         s_output( p, fields[area].line, fields[area].col, fields[area].color );
         (*fields[area].show_me)();
      }
   }

   /*
    * write changes to "tde.exe" if user presses F10.
    */
   if (c == F10) {
      temp_colors[index][HELP]    = fields[0].color;
      temp_colors[index][HEAD]    = fields[1].color;
      temp_colors[index][TEXT]    = fields[2].color;
      temp_colors[index][BLOCK]   = fields[3].color;
      temp_colors[index][WARNING] = fields[4].color;
      temp_colors[index][MODE]    = fields[5].color;
      temp_colors[index][WRAP]    = fields[6].color;
      temp_colors[index][CEOF]    = fields[7].color;
      fseek( tde_exe, COLOR_OFFSET, SEEK_SET );
      fwrite( (void *)temp_colors, sizeof( temp_colors ), 1, tde_exe );
   }
   cls( );
}
