#define TRUE            1
#define FALSE           0

#define EXIST           0

#define VIDEO_INT       0x10

#define VGA             3
#define EGA             2
#define CGA             1
#define MDA             0

#define NORMAL          7
#define COLOR_ATTR      31
#define MONO_ATTR       112


#define ESC             27
#define LEFT            (75 | 0x100)
#define RIGHT           (77 | 0x100)
#define UP              (72 | 0x100)
#define DOWN            (80 | 0x100)
#define RTURN           13
#define PGUP            (73 | 0x100)
#define PGDN            (81 | 0x100)
#define F1              (59 | 0x100)
#define F2              (60 | 0x100)
#define F3              (61 | 0x100)
#define F5              (63 | 0x100)
#define F10             (68 | 0x100)


#define U_LEFT          218
#define U_RIGHT         191
#define VER_LINE        179
#define HOR_LINE        196
#define L_LEFT          192
#define L_RIGHT         217

#define SAVE            0
#define RESTORE         1


/*
 * Save the underlying text of the screen in a structure.  We need to know
 * the column and row to begin saving the text.  Since we are doing an
 * optimal save and restore, we don't know how much memory to allocate to
 * the save buffer.  If we use a pointer, then we can dynamically allocate as
 * much or as little memory as we need.  Finally, we need a window pointer
 * to point to the next item on the stack.
 */
typedef struct win {
   int x;
   int y;
   int *buf;
   struct win *n;
} WINDOW;


/*
 * Structure to store the row and column of a string.
 */
struct screen {
   unsigned int   row;
   unsigned int   col;
   unsigned char *text;
};


/*
 * video adapter stuff.
 */
struct vcfg {
   int color;
   int rescan;
   int mode;
   int adapter;
   int attr;
   int far *videomem;
};


/*
 * When we display a pop-up or pull-down window, we need to know a few things
 * about the window and the text to display in the window.
 */
typedef struct {
   int dply_col;        /* offset into window to begin displaying help list */
   int dply_row;        /* dito */
   int line_length;     /* the length of the help line in the window */
   int avail_lines;     /* number of lines in the window available for list */
   int v_row;           /* virtual row of cursor in window */
   int select;          /* item currently selected in help list */
   int num_entries;     /* total number of items in help list */
   int ulft_col;        /* absolute upper left column of window */
   int ulft_row;        /* absolute upper left row of window */
   int total_col;       /* total number of columns in window */
   int total_row;       /* total number of rows in window */
} HELP_WINDOW;


/*
 * structure for list of available keys.   See default.h for more info.
 */
typedef struct {
   char *key;           /* key name */
   int  key_index;      /* offset into key structure in tde.exe file */
   unsigned char func_index;     /* function of key */
} KEY_DEFS;


/*************  prototypes for functions in  tdecfg.c  *******************/
void  main( int, char *[] );
void xygoto( int, int );
void video_config( void );
int getkey( void );
void s_output( char far *, int, int, int );
void cls( void );
void hlight_line( int, int, int, int );
void c_off( void );
void c_on( void );
void scroll_window( int, int, int, int, int, int );
void cls( void );
void show_box( int, int, struct screen *, int );
void make_window( int, int, int, int, int );
void buf_box( int, int, int, int, int );
void clear_window( int, int, int, int );
void window_control( WINDOW **, int, int, int, int, int );
void save_window( int *, int, int, int, int );
void restore_window( int *, int, int, int, int );
/*************************************************************************/


/*************  prototypes for functions in  tdecolor.c  *****************/
void tdecolor( void );
void initialize_color( void );
void show_init_sample( void );
void color_number( char *, int );
void current_color_number( char *, int );
void show_help_color( void );
void show_fileheader_color( void );
void show_text_color( void );
void show_block_color( void );
void show_warning_color( void );
void show_mode_color( void );
void show_wrapped_color( void );
void show_eof_color( void );
void change_colors( void );
/*************************************************************************/


/*************  prototypes for functions in  tdekeys.c  *****************/
void tdekeys( void );
void initialize_keys( void );
void show_key_def_list( HELP_WINDOW *, KEY_DEFS * );
void show_func_list( HELP_WINDOW *, char *[] );
void position_cursor( HELP_WINDOW *, int, int *, int *, int * );
void master_help( HELP_WINDOW *, KEY_DEFS *, struct screen *, char *, int * );
void new_assignment_help( HELP_WINDOW *, char *[], struct screen *, int * );
void save_and_draw( HELP_WINDOW *, struct screen *, WINDOW ** );
/*************************************************************************/


/*************  prototypes for function in  tdehelp.c  *******************/
void tdehelp( void );
/*************************************************************************/

