;
; ADOSX16.ASM
; (c) Rainer Schnitker 92,93,94
;

	INCLUDE TRANS.INC
	.286p

DGROUP group _DATA

_DATA segment word public 'DATA'
	extrn _cs16real: word		; RM cs segment
	extrn _ds16real: word		; RM ds segment
	extrn _real_mode_stack: word	; RM stack pointer
	td TRANS  <>			; translation struct for dos
	_ts TRANS  <>
	goProtectMode	dd	?
_DATA ends

_TEXT segment byte public 'CODE'
        assume cs:_TEXT,ds:DGROUP

;
; Entry point for int 0x21
;
public _doscall
_doscall proc far
	cmp	ah, 4Ch
	jne	int16bit

; jmp to orginal handler (DPMI-host)
        db 0EAh         ; jmp
public _int21voff
_int21voff:
        dw 2            ; off
public _int21vsel
_int21vsel:
        dw 1            ; sel

;
; all 16bit calls assume that this call is equal to a real mode call
; where the segment registers are equal to programs segments
;
; stack: 0=ip 2=cs 4=flags

int16bit:
	mov	word ptr td.T_EAX, ax
	mov	word ptr td.T_EBX, bx
	mov	word ptr td.T_ECX, cx
	mov	word ptr td.T_EDX, dx
	mov	word ptr td.T_ESI, si
	mov	word ptr td.T_EDI, di
	mov	word ptr td.T_EBP, bp

	mov	ax, _cs16real			; set RM segments
	mov	word ptr td.T_CS, ax
	mov	ax, _ds16real
	mov	word ptr td.T_DS, ax
	mov	word ptr td.T_ES, ax
	mov	word ptr td.T_SS, ax
	mov	ax, _real_mode_stack		; stack for int
	mov	word ptr td.T_sp, ax

	push	ds				; DPMI call now
	pop	es
	mov	cx, 0				; no stack words
	mov	bh, 0				; flags
	mov	bl, 21h 			; interrupt no
	mov	di, offset DGROUP:td		; es:edi translation
	mov	ax, 0300h
	int	31h				; simulate real-mode int

	mov	bp, sp
	mov	ax, word ptr td.T_FLAGS
	mov	word ptr [bp+4], ax
	mov	ax, word ptr td.T_EAX
	mov	bx, word ptr td.T_EBX
	mov	cx, word ptr td.T_ECX
	mov	dx, word ptr td.T_EDX
	mov	si, word ptr td.T_ESI
	mov	di, word ptr td.T_EDI
	mov	bp, word ptr td.T_EBP
	iret
_doscall endp

;
;	void RealModeSwitch(void)
;
public	_RealModeSwitch
_RealModeSwitch proc near
	pop	bx			;Where to return from this procedure
	.386
	movzx	ebx, bx
	movzx	esi, si
	movzx	edi, di
	movzx	ebp, bp
	mov	dword ptr _ts.T_EBX, ebx
	mov	dword ptr _ts.T_ESI, esi
	mov	dword ptr _ts.T_EDI, edi
	mov	dword ptr _ts.T_EBP, ebp

	mov	word ptr _ts.T_SP, sp
	mov	word ptr _ts.T_IP, offset _TEXT:@@realModeEntry
	mov	word ptr _ts.T_FLAGS, 0202h
	mov	ax, _cs16real
	mov	word ptr _ts.T_CS, ax
	mov	ax, _ds16real
	mov	word ptr _ts.T_DS, ax
	mov	word ptr _ts.T_ES, ax
	mov	word ptr _ts.T_SS, ax

	xor	ebx, ebx
	xor	ecx, ecx
	push	ds
	pop	es
	mov	di, offset DGROUP:_ts
	movzx	edi, di
	mov	ax,0301h
	int	31h

	mov	esi, dword ptr _ts.T_ESI
	mov	edi, dword ptr _ts.T_EDI
	mov	ebp, dword ptr _ts.T_EBP
	mov	sp, word ptr _ts.T_SP
	jmp	word ptr _ts.T_EBX    ; stored by DPMIprotectedMode() below
@@realModeEntry:
	pop	goProtectMode	; Address to return from real mode callback
	push	bx		; Address stored in realRegs above
	ret			; RealModeSwitch()
_RealModeSwitch   endp

;
;	void ProtectedModeSwitch(void)
;
public	_ProtectedModeSwitch
_ProtectedModeSwitch proc near
	pop	bx			  ;Return point (will be used in
	mov	dword ptr _ts.T_EBX, ebx  ;  RealModeSwitch above)
	mov	dword ptr _ts.T_ESI, esi
	mov	dword ptr _ts.T_EDI, edi
	mov	dword ptr _ts.T_EBP, ebp
	mov	word ptr _ts.T_SP, sp
	jmp	goProtectMode	;Saved retf address from real mode callback
_ProtectedModeSwitch endp
	.286

_TEXT ends
      end
