

     ZOO(1)         REFERENCE MANUAL  (Aug 25, 1988)            ZOO(1)


     NAME
          zoo - manipulate archives of files in compressed form

     SYNOPSIS
          zoo {acfDeghlLPTuUvVx}[aAcCdEfgImMnNoOpPqSu1:/.@n+-=]
          archive [file] ...
          zoo -command archive [file] ...
          zoo h

     DESCRIPTION
          Zoo is used to create and maintain collections of files in
          compressed form.  It uses a Lempel-Ziv compression algorithm
          that gives space savings in the range of 20% to 80%
          depending on the type of file data.  Zoo can store and
          selectively extract multiple generations of the same file.
          Data can be recovered from damaged archives by skipping the
          damaged portion and locating undamaged data with the help of
          fiz(1).

          This documentation is for version 2.01.  Changes from
          previous versions are described in the section labelled
          CHANGES.

          The command zoo h gives summary of commands.

          Zoo will not add an archive to itself, nor add the archive's
          backup (with .bak extension to the filename) to the archive.

          Zoo has two types of commands:  Expert commands, which
          consist of one command letter followed by zero or more
          modifier characters, and Novice commands, which consist of a
          hyphen (`-') followed by a command word that may be
          abbreviated.  Expert commands are case-sensitive but Novice
          commands are not.

          When zoo adds a file to an existing archive, the default
          action is to maintain one generation of each file in an
          archive and to mark any older generation as deleted.  A
          limit on the number of generations to save can be specified
          by the user for an entire archive, or for each file
          individually, or both.  Zoo deletes a stored copy of an
          added file if necessary to prevent the number of stored
          generations from exceeding the user-specified limit.

          Deleted files may be later undeleted.  Archives may be
          packed to recover space occupied by deleted files.

          All commands assume that the archive name ends with the
          characters .zoo unless a different extension is supplied.

          Novice commands

          Novice commands may be abbreviated to a hyphen followed by
          at least one command character.  Each Novice command works
          in two stages. First, the command does its intended work.
          Then, if the result was that one or more files were deleted
          in the specified archive, the archive is packed.  If packing
          occurs, the original unpacked archive is always left behind
          with an extension of .bak.

          No Novice command ever stores the directory prefix of a
          file.

          The Novice commands are as follows.

          -add    Adds the specified files to the archive.

          -freshen
               Adds a specified file to the archive if and only if an
               older file by the same name already exists in the
               archive.

          -delete
               Deletes the specified files from the archive.

          -update
               Adds a specified file to the archive either:  if an
               older file by the same name already exists in the
               archive or:  if a file by the same name does not
               already exist in the archive.

          -extract
               Extracts the specified files from the archive.  If no
               file is specified all files are extracted.

          -move
               Equivalent to -add except that source files are deleted
               after addition.

          -print
               Equivalent to -extract except that extracted data are
               sent to standard output.

          -list
               Gives information about the specified archived files
               including any attached comments.  If no files are
               specified all files are listed.  Deleted files are not
               listed.

          -test
               Equivalent to -extract except that the extracted data
               are not saved but any errors encountered are reported.

          -comment
               Allows the user to add or update comments attached to
               archived files.  When prompted, the user may:  type a
               carriage return to skip the file, leaving any current
               comment unchanged;  or type a (possibly null) comment
               of up to 65,535 characters terminated by /end (case-
               insensitive) on a separate line;  or type the end-of-
               file character (normally control D) to skip all
               remaining files.

          -delete
               Deletes the specified files.

          The correspondence between Novice and Expert commands is as follows.

          Novice                                        Equivalent
          Command    Description                        Expert Command
          ____________________________________________________________
          -add       add files to archive               aP:
          -extract   extract files from archive         x
          -move      move files to archive              aMP:
          -test      test archive integrity             xNd
          -print     extract files to standard output   xp
          -delete    delete files from archive          DP
          -list      list archive contents              VC
          -update    add new or newer files             aunP:
          -freshen   by add newer files                 auP:
          -comment   add comments to files              c

          Expert commands

          The general format of expert commands is:

          zoo {acDeghlLPTuUvVx}[aAcCdEfImMnNoOpPqSu1:/.@n+-=] archive
          [file] ...

          The characters enclosed within {} are commands.  Choose any
          one of these.  The characters enclosed within [] just to the
          right of the {} are modifiers and zero or more of these may
          immediately follow the command character.  All combinations
          of command and modifier characters may not be valid.

          Files are added to an archive with the command:

          zoo {au}[cfIMnPqu:+-] archive [file] ...

          Command characters are:

          a    Add each specified file to archive.  Any already-
               archived copy of the file is deleted if this is
               necessary to avoid exceeding the user-specified limit
               on the number of generations of the file to maintain in
               the archive.

          u    Do an update of the archive.  A specified file is added
               to the archive only if a copy of it is already in the
               archive and the copy being added is newer than the copy
               already in the archive.

          The following modifiers are specific to these commands.

          M    Move files to archive.  This makes zoo delete (unlink)
               the original files after they have been added to the
               archive.  Files are deleted after addition of all files
               to the archive is complete and after any requested
               packing of the archive has been done, and only if zoo
               detected no errors.

          n    Add new files only.  A specified file is added only if
               it isn't already in the archive.

          P    Pack archive after files have been added.

          u    Applied to the a command, this modifier makes it behave
               identically to the u command.

               The combination of the n modifier with the u modifier
               or u command causes addition of a file to the archive
               either if the file is not already in the archive, or if
               the file is already in the archive but the archived
               copy is older than the copy being added.

          :    Do not store directory names.  In the absence of this
               modifier zoo stores the full pathname of each archived
               file.

          I    Read filenames to be archived from standard input. Zoo
               will read its standard input and assume that each line
               of text contains a filename.  Under AmigaDOS and the
               **IX family, the entire line is used.  Under MS-DOS and
               VAX/VMS, zoo assumes that the filename is terminated by
               a blank, tab, or newline; thus it is permissible for
               the line of text to contain more than one field
               separated by white space, and only the first field will
               be used.

               Under the **IX family of operating systems, zoo can be
               used as follows in a pipeline:

                    find . -print | zoo aI sources



               If the I modifier is specified, no filenames may be
               supplied on the command line itself.

          +,-  These modifiers take effect only if the a command
               results in the creation of a new archive.  + causes any
               newly-created archive to have generations enabled.  -
               is provided for symmetry and causes any newly-created
               archive to have generations disabled;  this is also the
               default if neither + nor - is specified.

          Files are extracted from an archive with the command:

          zoo {ex}[dNoOpqS./@] archive [file] ...

          The e and x commands are synonymous.  If no file was
          specified, all files are extracted from the archive.

          The following modifiers are specific to the e and x
          commands:

          N    Do not save extracted data but report any errors
               encountered.

          O    Overwrite files.  Normally, if a file being extracted
               would overwrite an already-existing file of the same
               name, zoo asks you if you really want to overwrite it.
               You may answer the question with `y', which means yes,
               overwrite; or `n', which means no, don't overwrite; or
               `a', which means assume the answer is `y' for this and
               all subsequent files.  The O modifier makes zoo assume
               that files may always be overwritten.  Neither
               answering the question affirmatively nor using O alone
               will cause read-only files to be overwritten.

               On **IX systems, however, doubling this modifier as OO
               will force zoo to unconditionally overwrite any read-
               protected files with extracted files if it can do so.

               The O, N, and p modifiers are mutually exclusive.

          S    Supersede newer files on disk with older extracted
               files.  Unless this modifier is used, zoo will not
               overwrite a newer existing file with an older extracted
               file.

          o    This is equivalent to the O modifier if and only if it
               is given at least twice.  It is otherwise ignored.

          p    Pipe extracted data to standard output.  Error messages
               are piped to standard output as well.  However, if a
               bad CRC is detected, an error message is sent both to
               standard error and to standard output.

          /    Extract to original pathname.  Any needed directories
               must already exist.  In the absence of this modifier
               all files are extracted into the current directory.  If
               this modifier is doubled as //, required directories
               need not exist and are created if necessary.

          The management of multiple generations of archived files is
          done with the commands:

          zoo gl[Aq]{+-=}number archive files ..
          zoo gc[q]{+-=}number archive files ..
          zoo gA[q]- archive
          zoo gA[q]+ archive

          The first form, gl, adjusts the generation limit of selected
          files by the specified value.  If the form =n is used, where
          n is a decimal number, this sets the generation limit to the
          specified value.  If + or - are used in placed of = the
          effect is to increment or decrement the generation limit by
          the specified value.  For example, the command

               zoo gl=5 xyz :


          sets the generation limit of each file in the archive
          xyz.zoo to a value of 5.  The command

               zoo gl-3 xyz :


          decrements the generation limit of each file in the archive
          to 3 less than it currently is.

          If the A modifier is used, the archive-wide generation limit
          is adjusted instead.

          The number of generations of a file maintained in an archive
          is limited by the file generation limit, or the archive
          generation limit, whichever is lower.  As a special case, a
          generation limit of 0 stands for no limit.  Thus the default
          file generation limit of 0 and archive generation limit of 1
          limits the number of generations of each file in a newly-
          created archive to one.

          The generation limit specified should be in the range 0
          through 15;  any higher numbers are interpreted modulo 16.

          The second form of the command, using gc, adjusts the
          generation count of selected files.  Each file has a
          generation count of 1 when it is first added to an archive.
          Each time a file by the same name is added again to an
          archive, it receives a generation count that is one higher
          than the highest generation count of the archived copy of
          the file.  The permissible range of generation counts is 1
          through 65535.  If repeated manipulations of an archive
          result in files having very high generation counts, they may
          be set back to lower numbers with the gc command.  The
          syntax of the command is analogous to the syntax of the gl
          command, except that the A modifier is not applicable to the
          gc command.

          The third form, gA-, disables generations in an archive.
          Generations are off when an archive is first created, but
          may be enabled with the fourth form of the command, gA+.
          When generations are disabled in an archive, zoo will not
          display generation numbers in archive listings or maintain
          multiple generations.  Generations can be re-enabled at any
          time, though manipulation of an archive with repeated
          interspersed gA- and gA+ commands may result in an archive
          whose behavior is not easily understandable.

          Archived files are listed with the command:

          zoo {lLvV}[aAcCdfgmqvV@/1+-] archive[.zoo] [file] ...

          l    Information presented includes the date and time of
               each file, its original and current (compressed) sizes,
               and the percentage size decrease due to compression
               (labelled CF or compression factor).  If a file was
               added to the archive in a different timezone, the
               difference between timezones is shown in hours as a
               signed number.  As an example, if the difference is
               listed as +3, this means that the file was added to the
               archive in a timezone that is 3 hours west of the
               current timezone.  The file time listed is, however,
               always the original timestamp of the archived file, as
               observed by the user who archived the file, expressed
               as that user's local time.  (Timezone information is
               stored and displayed only if the underlying operating
               system knows about timezones.)

               If no filename is supplied all files are listed except
               deleted files.

               Zoo selects which generation(s) of a file to list
               according to the following algorithm.

               If no filename is supplied, only the latest generation
               of each file is listed.  If any filenames are
               specified, and a generation is specified for an
               argument, only the requested generation is listed.  If
               a filename is specified ending with the generation
               character (`:' or `;'), all generations of that file
               are listed.  Thus a filename argument of the form zoo.c
               will cause only the latest generation of zoo.c to be
               listed;  an argument of the form zoo.c:4 will cause
               generation 4 of zoo.c to be listed;  and an argument of
               the form zoo.c: or zoo.c:* will cause all generations
               of zoo.c to be listed.

          L    This is similar to the l command except that all
               supplied arguments must be archives and all non-deleted
               generations of all files in each archive appear in the
               listing.

               On **IX systems, on which the shell expands arguments,
               if multiple archives are to be listed, the L command
               must be used.  On other systems (VAX/VMS, AmigaDOS,
               MSDOS) on which wildcard expansion is done internally
               by zoo, wildcards may be used in the archive name, and
               a multiple archive listing obtained, using the l
               command.

          v    This causes any comment attached to the archive to be
               listed in addition to the other information.

          V    This causes any comment attached to the archive and
               also any comment attached to each file to be listed.

               Both the V and v command characters can also be used as
               modifiers to the l and L commands.

          In addition to the general modifiers described later, the
          following modifiers can be applied to the archive list
          commands.

          a    This gives a single-line format containing both each
               filename and the name of the archive, sorted by archive
               name.  It is especially useful with the L command,
               since the result can be further sorted on any field to
               give a master listing of the entire contents of a set
               of archives.

          A    This causes any comment attached to the archive to be
               listed.

          g    This modifier causes file generation information to be
               listed about the archive.  For each file listed, the
               user-specified generation limit, if any, is listed.
               For example, `3g' for a file means that the user wants
               no more than three generations of the file to be kept.
               In archives created by older versions of zoo, the
               listing will show `-g', meaning that no generation
               information is kept and multiple generations of the
               file are not being maintained.

               In addition to the generation information for each
               file, the archive-wide generation limit, if any, is
               shown at the end of the listing.  If generations have
               been disabled by the user, this is so indicated, for
               example:

                    Archive generation limit is 3 (generations off).

               For more information about generations see the
               description of the g command.

          m    This modifier is currently applicable to **IX systems
               only.  It causes the mode bits (file protection code)
               of each file to be listed as a three-digit octal
               number.  Currently zoo preserves only the lowest nine
               mode bits.  Their meanings are as described in the **IX
               documentation for the chmod(1) command.

          C    This modifier causes the stored cyclic redundancy code
               (CRC) for each archived file to be shown as a four-
               digit hexadecimal number.

          1    This forces one filename to be listed per line.  It is
               most useful in combination with the f modifier.

          /    This forces any directory name to be always listed,
               even in fast columnized listings that do not normally
               include any directory names.

          +,-  The - modifier causes trailing generation numbers to be
               omitted from filenames.  The + modifier causes the
               trailing generation numbers to be shown, which is also
               the default if neither - nor + is specified.

          Files may be deleted and undeleted from an archive with the
          following commands:

          zoo {DU}[Pq1] archive file ...

          The D command deletes the specified files and the U command
          undeletes the specified files.  The 1 modifier (the digit
          one, not the letter ell) forces deletion or undeletion of at
          most one file.  If multiple instances of the same file exist
          in an archive, use of the 1 modifier may allow selective
          extraction of one of these.

          Comments may be added to an archive with the command:

          zoo c[A] archive

          Without the modifier A, this behaves identically to the
          -comment command.  With the modifier A, the command serves
          to add or update the comment attached to the archive as a
          whole.  This comment may be listed with the lA, LA, v, and V
          commands.  Applying the cA command to an archive that was
          created with an older version of zoo will result in an error
          message requesting that the user first pack the archive with
          the P command.  This reorganizes the archive and creates
          space for the archive comment.

          The timestamp of an archive may be adjusted with the
          command:

          zoo T[q] archive

          Zoo normally attempts to maintain the timestamp of an
          archive to reflect the age of the newest file stored in it.
          Should the timestamp ever be incorrect it can be fixed with
          the T command.

          An archive may be packed with the command:

          zoo P[EPq] archive

          If the backup copy of the archive already exists, zoo will
          refuse to pack the archive unless the P modifier is also
          given.  The E modifier causes zoo not to save a backup copy
          of the original archive after packing.  A unique temporary
          file in the current directory is used to initially hold the
          packed archive.  This file will be left behind if packing is
          interrupted or if for some reason this file cannot be
          renamed to the name of the original archive when packing is
          complete.

          Packing removes any garbage data appended to an archive
          because of Xmodem file transfer and also recovers any wasted
          space remaining in an archive that has been frequently
          updated or in which comments were replaced.  Packing also
          updates the format of any archive that was created by an
          older version of zoo so that newer features (e.g. archive-
          wide generation limit, archive comment) become fully
          available.

          Zoo can act as a pure compression or uncompression filter,
          reading from standard input and writing to standard output.
          This is achieved with the command:

          zoo f{cu}

          where c specifies compression and u specifies uncompression.
          A CRC value is used to check the integrity of the data.  The
          compressed data stream has no internal archive structure and
          contains multiple files only if the input data stream was
          already structured, as might be obtained, for example, from
          tar or cpio.

           Modem transfers can be speeded up with these commands:

                    zoo fc < file | sz ... rz | zoo fu > file



          General modifiers

          The following modifiers are applicable to several commands:

          c    Applied to the a and u commands, this causes the user
               to be prompted for a comment for each file added to the
               archive.  If the file being added has replaced, or is a
               newer generation of, a file already in the archive, any
               comment attached to that file is shown to the user and
               becomes attached to the newly-added file unless the
               user changes it.  Possible user responses are as
               described for the -comment command.  Applied to the
               archive list command l, the c modifier causes the
               listing of any comments attached to archived files.

           .   In conjunction with / or // this modifier causes any
               extracted pathname beginning with `/' to be interpreted
               relative to the current directory, resulting in the
               possible creation of a subtree rooted at the current
               directory.  In conjunction with the command P the .
               modifier causes the packed archive to be created in the
               current directory.  This is intended to allow users
               with limited disk space but multiple disk drives to
               pack large archives.

          d    Most commands that act on an archive act only on files
               that are not deleted.  The d modifier makes commands
               act on both normal and deleted files.  If doubled as
               dd, this modifier forces selection only of deleted
               files.

          f    Applied to the a and u commands, the f modifier causes
               fast archiving by adding files without compression.
               Applied to l it causes a fast listing of files in a
               multicolumn format.

          q    Be quiet.  Normally zoo lists the name of each file and
               what action it is performing.  The q modifier
               suppresses this.  When files are being extracted to
               standard output, the q modifier suppresses the header
               preceding each file.  When archive contents are being
               listed, this modifier suppresses any header and
               trailer.  When a fast columnized listing is being
               obtained, this modifier causes all output to be
               combined into a single set of filenames for all
               archives being listed.

               When doubled as qq, this modifier suppresses WARNING
               messages, and when tripled as qqq, ERROR messages are
               suppressed too.  FATAL error messages are never
               suppressed.

          Recovering data from damaged archives

          The @ modifier allows the user to specify the exact position
          in an archive where zoo should extract a file from, allowing
          damaged portions of an archive to be skipped.  This modifier
          must be immediately followed by a decimal integer without
          intervening spaces, and possibly by a comma and another
          decimal integer, giving a command of the form l@m or l@m,n
          (to list archive contents) or x@m or x@m,n (to extract files
          from an archive).  Listing or extraction begin at position m
          in the archive.  The value of m must be the position within
          the archive of an undamaged directory entry.  This position
          is usually obtained from fiz(1) version 2.0 or later.

          If damage to the archive has shortened or lengthened it, all
          positions within the archive may be changed by some constant
          amount.  To compensate for this, the value of n may be
          specified.  This value is also usually obtained from fiz(1).
          It should be the position in the archive of the file data
          corresponding to the directory entry that has been specified
          with m.  Thus if the command x@456,575 is given, it will
          cause the first 456 bytes of the archive to be skipped and
          extraction to begin at offset 456;  in addition, zoo will
          attempt to extract the file data from position 575 in the
          archive instead of the value that is found in the directory
          entry read from the archive.  For example, here is some of
          the output of fiz when it acts on a damaged zoo archive:

          ****************
              2526: DIR  [changes] ==>   95
              2587: DATA
          ****************
              3909: DIR  [copyrite] ==> 1478
              3970: DATA
              4769: DATA
          ****************

          In such output, DIR indicates where fiz found a directory
          entry in the archive, and DATA indicates where fiz found
          file data in the archive.  Filenames located by fiz are
          enclosed in square brackets, and the notation "==>   95"
          indicates that the directory entry found by fiz at position
          2526 has a file data pointer to position 95.  (This is
          clearly wrong, since file data always occur in an archive
          after their directory entry.)  In actuality, fiz found file
          data at positions 2587, 3970, and 4769.  Since fiz found
          only two directory entries, and each directory entry
          corresponds to one file, one of the file data positions is
          an artifact.

          In this case, commands to try giving to zoo might be
          x@2526,2587 (extract beginning at position 2526, and get
          file data from position 2587), x@3090,3970 (extract at 3090,
          get data from 3970) and x@3909,4769 (extract at 3909, get
          data from 4769).  Once a correctly-matched directory
          entry/file data pair is found, zoo will in most cases
          synchronize with and correctly extract all files
          subsequently found in the archive.  Trial and error should
          allow all undamaged files to be extracted.  Also note that
          self-extracting archives created using sez (the Self-
          Extracting Zoo utility for MS-DOS), which are normally
          executed on an MS-DOS system for extraction, can be
          extracted on non-MSDOS systems using zoo's damaged-archive
          recovery method using the @ modifier.

          Wildcard handling

          Under the **IX family of operating systems, the shell
          normally expands wildcards to a list of matching files.
          Wildcards that are meant to match files within an archive
          must therefore be escaped or quoted.  When selecting files
          to be added to an archive, wildcard conventions are as
          defined for the shell.  When selecting files from within an
          archive, wildcard handling is done by zoo as described
          below.

          Under MS-DOS and AmigaDOS, quoting of wildcards is not
          needed.  All wildcard expansion of filenames is done by zoo,
          and wildcards inside directory names are expanded only when
          listing or extracting files but not when adding them.

          The wildcard syntax interpreted by zoo is limited to the
          following characters.

          *    Matches any sequence of zero or more characters.

          ?    Matches any single character.

               Arbitrary combinations of * and ? are allowed.

          /    If a supplied pattern contains a slash anywhere in it,
               then the slash separating any directory prefix from the
               filename must be matched explicitly.  If a supplied
               pattern contains no slashes, the match is selective
               only on the filename.

          c-c  Two characters separated by a hyphen specify a
               character range.  All filenames beginning with those
               characters will match.  The character range is
               meaningful only by itself or preceded by a directory
               name.  It is not specially interpreted if it is part of
               a filename.

          : and ;
               These characters are used to separate a filename from a
               generation number and are used when selecting specific
               generations of archived files.  If no generation
               character is used, the filename specified matches only
               the latest generation of the file.  If the generation
               character is specified, the filename and the generation
               are matched independently by zoo's wildcard mechanism.
               If no generation is specified following the : or ;
               character, all generations of that file will match.  As
               a special case, a generation number of 0 matches only
               the latest generation of a file, while ^0 matches all
               generations of a file except the latest one.  If no
               filename is specified preceding the generation
               character, all filenames will match.  As a corollary,
               the generation character by itself matches all
               generations of all files.

          MS-DOS users should note that zoo does not treat the dot as
          a special character, and it does not ignore characters
          following an asterisk.  Thus * matches all filenames; *.*
          matches filenames containing a dot; *_* matches filenames
          containing an underscore;  and *z matches all filenames that
          end with the character z, whether or not they contain a dot.

          Usage hints

          The Novice command set in zoo is meant to provide an
          interface with functionality and format that will be
          familiar to users of other similar archive utilities.  In
          keeping with this objective, the Novice commands do not
          maintain or use any subdirectory information or allow the
          use of zoo's ability to maintain multiple generations of
          files.  For this reason, users should switch to exclusively
          using the Expert commands as soon as possible.

          Although the Expert command set is quite large, it should be
          noted that in almost every case, all legal modifiers for a
          command are fully orthogonal.  This means that the user can
          select any combination of modifiers, and when they act
          together, they will have the intuitively obvious effect.
          Thus the user need only memorize what each modifier does,
          and then can combine them as needed without much further
          thought.

          For example, consider the a command which is used to add
          files to an archive.  By itself, it simply adds the
          specified files.  To cause only already-archived files to be
          updated if their disk copies have been modified, it is only
          necessary to add the u modifier, making the command au.  To
          cause only new files (i.e., files not already in the
          archive) to be added, the n modifier is used to create the
          command an.  To cause both already-archived files to be
          updated and new files to be added, the u and n modifiers can
          be used together, giving the command aun.  Since the order
          of modifiers is not significant, the command could also be
          anu.

          Further, the c modifier can be used to cause zoo to prompt
          the user for a comment to attach to each file added.  And
          the f modifier can cause fast addition (addition without
          compression).  It should be obvious then that the command
          auncf will cause zoo to update already-archived files, add
          new files, prompt the user for comments, and do the addition
          of files without any compression.  Furthermore, if the user
          wishes to move files to the archive, i.e., delete the disk
          copy of each file after it is added to the archive, it is
          only necessary to add the M modifier to the command, so it
          becomes auncfM.  And if the user also wishes to cause the
          archive to be packed as part of the command, thus recovering
          space from any files that are replaced, the command can be
          modified to auncfMP by adding the P modifier that causes
          packing.

          Similarly, the archive listing commands can be built up by
          combining modifiers.  The basic command to list the contents
          of an archive is l.  If the user wants a fast columnized
          listing, the f modifier can be added to give the lf command.
          Since this listing will have a header giving the archive
          name and a trailer summarizing interesting information about
          the archive, such as the number of deleted files, the user
          may wish to "quieten" the listing by suppressing these;  the
          relevant modifier is q, which when added to the command
          gives lfq.  If the user wishes to see the **IX mode (file
          protection) bits, and also information about multiple
          generations, the modifiers m (show mode bits) and g (show
          generation information) can be added, giving the command
          lfqmg.  If the user also wishes to see an attached archive
          comment, the modifier A (for archive) will serve.  Thus the
          command lfqmgA will give a fast columnized listing of the
          archive, suppressing any header and trailer, showing mode
          bits and generation information, and showing any comment
          attached to the archive as a whole.  If in addition
          individual comments attached to files are also needed,
          simply append the c modifier to the command, making it
          lfqmgAc.  The above command will not show any deleted files,
          however;  to see them, use the d modifier, making the
          command lfqmgAcd (or double it as in lfqmgAcdd if only the
          deleted files are to be listed).  And if the user also
          wishes to see the CRC value for each file being listed, the
          modifier C will do this, as in the command lfqmgAcdC, which
          gives a fast columnized listing of all files, including
          deleted files, showing any archive comment and file
          comments, and file protection codes and generation
          information, as well as the CRC value of each file.

          Note that the above command lfqmgAcdC could also be
          abbreviated to VfqmgdC because the command V is shorthand
          for lcA (archive listing with all comments shown).
          Similarly the command v is shorthand for lA (archive listing
          with archive comment shown).  Both V and v can be used as
          modifiers to any of the other archive listing commands.

          Generations

          By default, zoo assumes that only the latest generation of a
          specified file is needed.  If generations other than the
          latest one need to be selected, this may be done by
          specifying them in the filename.  For example, the name
          stdio.h would normally refer to the latest generation of the
          file stdio.h stored in a zoo archive.  To get an archive
          listing showing all generations of stdio.h in the archive,
          the specification stdio.h:* could be used (enclosed in
          single quotes if necessary to protect the wildcard character
          * from the shell).  Also, stdio.h:0 selects only the latest
          generation of stdio.h, while stdio.h:^0 selects all
          generations except the latest one.  The : character here
          separates the filename from the generation number, and the
          character * is a wildcard that matches all possible
          generations.  For convenience, the generation itself may be
          left out, so that the name stdio.h: (with the : but without
          a generation number or a wildcard) matches all generations
          exactly as stdio.h:* does.

          If a generation is specified but no filename is present, as
          in :5, :*, or just :, all filenames of the specified
          generation will be selected.  Thus :5 selects generation 5
          of each file, and :* and : select all generations of all
          files.

          It is important to note that zoo's idea of the latest
          generation of a file is not based upon searching the entire
          archive.  Instead, whenever zoo adds a file to an archive,
          it is marked as being the latest generation.  Thus, if the
          latest generation of a file is deleted, then no generation
          of that file is considered the latest any more.  This can be
          surprising to the user.  For example, if an archive already
          contains the file stdio.h:5 and a new copy is added,
          appearing in the archive listing as stdio.h:6, and then
          stdio.h:6 is deleted, the remaining copy stdio.h:5 will no
          longer be considered to be the latest generation, and the
          file stdio.h:5, even if undeleted, will no longer appear in
          an archive listing unless generation 5 (or every generation)
          is specifically requested.  This behavior will likely be
          improved in future releases of zoo.

     FILES
          xXXXXXX - temporary file used during packing
          archive_name.bak - backup of archive

     SEE ALSO
          compress(1), fiz(1)

     BUGS
          When files are being added to an archive on a non-MS-DOS
          system, it is possible for zoo to fail to detect a full disk
          and hence create an invalid archive.  This bug will be fixed
          in a future release.

          Files with generation counts that wrap around from 65535 to
          1 are not currently handled correctly.  If a file's
          generation count reaches a value close to 65535, it should
          be manually set back down to a low number.  This may be
          easily done with a command such as gc-65000, which subtracts
          65000 from the generation count of each specified file.
          This problem will be fixed in a future release.

          Although zoo on **IX systems preserves the lowest nine mode
          bits of regular files, it does not currently do the same for
          directories.

          Currently zoo's handling of the characters : and ; in
          filenames is not robust, because it interprets these to
          separate a filename from a generation number.  A quoting
          mechanism will eventually be implemented.

          Standard input cannot be archived nor can a created archive
          be sent to standard output.  Spurious error messages may
          appear if the filename of an archive is too long.

          Since zoo never archives any file with the same name as the
          archive or its backup (regardless of any path prefixes),
          care should be taken to make sure that a file to be archived
          does not coincidentally have the same name as the archive it
          is being added to.  It usually suffices to make sure that no
          file being archived is itself a zoo archive.  (Previous
          versions of zoo sometimes tried to add an archive to itself.
          This bug now seems to be fixed.)

          Only regular files are archived; devices and empty
          directories are not.  Support for archiving empty
          directories and for preserving directory attributes is
          planned for the near future.

          Early versions of MS-DOS have a bug that prevents "." from
          referring to the root directory;  this leads to anomalous
          results if the extraction of paths beginning with a dot is
          attempted.

          VAX/VMS destroys case information unless arguments are
          enclosed in double quotes.  For this reason if a command
          given to zoo on a VAX/VMS system includes any uppercase
          characters, it must be enclosed in double quotes.  Under
          VAX/VMS, zoo does not currently restore file timestamps;
          this will be fixed as soon as I figure out RMS extended
          attribute blocks, or DEC supplies a utime() function,
          whichever occurs first.  Other VMS bugs, related to file
          structures, can often be overcome by using the program
          bilf.c that is supplied with zoo.

          It is not currently possible to create a zoo archive
          containing all zoo archives that do not contain themselves.

     DIAGNOSTICS
          Error messages are intended to be self-explanatory and are
          divided into three categories.  WARNINGS are intended to
          inform the user of an unusual situation, such as a CRC error
          during extraction, or -freshening of an archive containing a
          file newer than one specified on the command line.  ERRORS
          are fatal to one file, but execution continues with the next
          file if any.  FATAL errors cause execution to be aborted.
          The occurrence of any of these causes an exit status of 1.
          Normal termination without any errors gives an exit status
          of 0.  (Under VAX/VMS, however, to avoid an annoying
          message, zoo always exits with an error code of 1.)

     COMPATIBILITY
          All versions of zoo on all systems are required to create
          archives that can be extracted and listed with all versions
          of zoo on all systems, regardless of filename and directory
          syntax or archive structure;  furthermore, any version of
          zoo must be able to fully manipulate all archives created by
          all lower-numbered versions of zoo on all systems.  So far
          as I can tell, this upward compatiblity (all manipulations)
          and downward compatiblity (ability to extract and list) is
          maintained by zoo version 2.0.  You are forbidden, with the
          force of copyright law, to create from the zoo source code
          any derivative work that violates this compatibility goal,
          whether knowingly or through negligence.  If any violation
          of this compatibility goal is observed-i.e., if you are able
          to use an implementation of zoo to create an archive that
          some implementation of zoo on any system cannot extract-this
          should be considered a serious problem and reported to me.

     CHANGES
          Here is a list of changes occurring from version 1.50 to
          version 2.01.  In parentheses is given the version in which
          each change occurred.

          -    (1.71) New modifiers to the list commands permit
               optional suppression of header and trailer information,
               inclusion of directory names in columnized listings,
               and fast one-column listings.

          -    (1.71) Timezones are handled.

          -    (1.71) A bug was fixed that had made it impossible to
               individually update comments for a file whose name did
               not correspond to MS-DOS format.

          -    (1.71) A change was made that now permits use of the
               shared library on the **IX PC.

          -    (1.71) VAX/VMS is now supported reasonably well.

          -    (2.00) A comment may now be attached to the archive
               itself.

          -    (2.00) The OO option allows forced overwriting of
               read-only files.

          -    (2.00) Zoo will no longer extract a file if a newer
               copy already exists on disk;  the S option will
               override this.

          -    (2.00) File attributes are preserved for **IX systems.

          -    (2.00) Multiple generations of the same file are
               supported.

          -    (2.00) Zoo will now act as a compression or
               decompression filter on a stream of data and will use a
               CRC value to check the integrity of a data stream that
               is uncompressed.

          -    (2.00) A bug was fixed that caused removal of a
               directory link if files were moved to an archive by the
               superuser on a **IX system.

          -    (2.00) The data recovery modifier @ was greatly
               enhanced.  Self-extracting archives created for MS-DOS
               systems can now be extracted by zoo on any system with
               help from fiz(1).

          -    (2.01) A bug was fixed that had caused the first
               generation of a file to sometimes unexpectedly show up
               in archive listings.

          -    (2.01) A bug was fixed that had caused the MS-DOS
               version to silently skip files that could not be
               extracted because of insufficient disk space.

          -    (2.01) A bug was fixed that had sometimes made it
               impossible to selectively extract a file by specifying
               its name, even though all files could be extracted from
               the archive by not specifying any filenames.  This
               occurred when a file had been archived on a longer-
               filename system (e.g. AmigaDOS) and extraction was
               attempted on a shorter-filename system (e.g. MS-DOS).

          -    (2.01) A change was made that will make zoo preserve
               the mode (file protection) of a zoo archive when it is
               packed.  This is effective only if zoo is compiled to
               preserve and restore file attributes.  Currently this
               is so only for **IX systems.

          -    (2.01) A bug was fixed that had caused an update of an
               archive to not always add all newer files.

          -    (2.01) Blanks around equal signs in commands given to
               "make" were removed from the mk* scripts for better
               compatiblity with more **IX implementations including
               Sun's.

     FUTURE DIRECTIONS
          A revised version of zoo is in the works that will be able
          to write newly-created archives to standard output, and will
          also automatically perform end-of-line conversion for text
          files moved between dissimilar systems.  It will be upward
          and downward compatible with existing versions of zoo.

     ACKNOWLEDGEMENTS
          The zoo archiver was initially developed using Microsoft C
          3.0 on a PC clone manufactured by Toshiba of Japan and
          almost sold by Xerox.  Availability of the following systems
          was helpful in achieving portability:  Paul Homchick's
          Compaq running Microport System V/AT;  The Eskimo BBS
          somewhere in Oregon running Xenix/68000; Greg Laskin's
          system 'gryphon' which is an Intel 310 running Xenix/286;
          Ball State University's AT&T 3B2/300, UNIX PC, and VAX-
          11/785 (4.3BSD) systems.  In addition J. Brian Waters
          provided feedback to help me make the code compilable on his
          Amiga using Manx/Aztec C.  More recently, actual
          development, as opposed to portability testing, has been
          done exclusively on my own AT from PC's Limited running
          Microport System V/AT.  The executable version 2.0 for MS-
          DOS is currently compiled with Borland's Turbo C 1.0.

          Special thanks are due to:

          J. Brian Waters <uunet!bsu-cs!jbwaters>, who has worked
          diligently to port zoo to AmigaDOS, created Amiga-specific
          code, and continues keeping it updated.

          Paul Homchick <rutgers!cgh!paul>, who provided numerous
          detailed reports about some nasty bugs.

          Bill Davidsen <steinmetz!crdos1!davidsen>, who fixed zoo's
          handling of daylight savings time, provided changes to make
          this manual format correctly with troff, and provided many
          useful bug reports and suggestions.

          Mark Alexander <amdahl!drivax!alexande>, who provided me
          with some bug fixes, and also some portability modifications
          and speed optimizations that are due to be incorporated into
          the next release.

     AUTHOR
          Rahul Dhesi
