UNIT KeyBoard;
(*****************************************************************************)
(*                                                                           *)
(*   KeyBoard inneholder to rutiner som gjr input fra tastaturet enklere.   *)
(*                                                                           *)
(*****************************************************************************)

{-----------------------------------------------------------------------------}
INTERFACE
{-----------------------------------------------------------------------------}

USES HtScreen;

TYPE  KeyType = (NullKey,F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,
                 Return,TabKey,BackSpaceKey,UpArrow,
                 DownArrow,RightArrow,LeftArrow,DelKey,
                 InsertKey,HomeKey,EndKey,TextKey,NumberKey,
                 SpaceKey,PgUp,PgDn,Escape);
   KeySetType = SET OF KeyType;

VAR   Key  : KeyType;
      Ch   : CHAR;
      Fk   : BOOLEAN;
      InsertOn : BOOLEAN;

PROCEDURE InKey(VAR Ch:CHAR; VAR Fk:BOOLEAN; VAR Key:KeyType);
PROCEDURE InputString(VAR S:STRING; R,C,L:BYTE; Attr:INTEGER; KeySet:KeySetType);

{-----------------------------------------------------------------------------}
IMPLEMENTATION
{-----------------------------------------------------------------------------}

PROCEDURE InKey(VAR Ch:CHAR; VAR Fk:BOOLEAN; VAR Key:KeyType);
(*****************************************************************************)
(*                                                                           *)
(*   Fr en tast fra bruker og returnerer karakt eren. Setter Fk=TRUE hvis   *)
(*   funksjons-tast.  Returnerer ogs taste-typen.                           *)
(*                                                                           *)
(*****************************************************************************)
BEGIN
  Ch:=HtReadKey(Fk);
  IF Fk THEN
  CASE Ch OF
    #72 : Key:=UpArrow;
    #80 : Key:=DownArrow;
    #82 : Key:=InsertKey;
    #75 : Key:=LeftArrow;
    #77 : Key:=RightArrow;
    #73 : Key:=PgUp;
    #81 : Key:=PgDn;
    #71 : Key:=HomeKey;
    #79 : Key:=EndKey;
    #83 : Key:=DelKey;
    #82 : Key:=InsertKey;
    #59 : Key:=F1;
    #60 : Key:=F2;
    #61 : Key:=F3;
    #62 : Key:=F4;
    #63 : Key:=F5;
    #64 : Key:=F6;
    #65 : Key:=F7;
    #66 : Key:=F8;
    #67 : Key:=F9;
    #68 : Key:=F10;
  END
  ELSE
  CASE Ch OF
     #8 : Key:=BackSpaceKey;
     #9 : Key:=TabKey;
    #13 : Key:=Return;
    #27 : Key:=Escape;
    #32 : Key:=SpaceKey;
    #33..#47,
    #58..#255 : Key:=TextKey;
    #48..#57 : Key:=NumberKey;
  END;
END;


PROCEDURE InputString(VAR S:STRING; R,C,L:BYTE; Attr:INTEGER; KeySet:KeySetType);
(*****************************************************************************)
(*                                                                           *)
(*   Tillater brukeren  lese inn en streng S ved koordinater X:Y med max    *)
(*   lengde L. Strengen vises i attributtene Attr.                           *)
(*   KeySet er et sett av taster som bestemmer nr innlesningen skal stoppes.*)
(*                                                                           *)
(*****************************************************************************)
CONST Fill : CHAR = #0;
VAR   P : BYTE;
      I,J : WORD;
      Ch : CHAR;
      Fk : BOOLEAN;
BEGIN
  InsertOn := FALSE;
  I:=Length(S)+1;
  IF I>L THEN
    S:=Copy(S,1,L)
  ELSE BEGIN
    FOR J:=I TO L DO
      S[J]:=Fill;
    S[0]:=Chr(L);
  END;
  P:=1;
  REPEAT
    HtWrite(R,C,Attr,S);
    GoToRC(R,C+P-1);
    IF InsertOn THEN
      SetCursor(CursorBlock)
    ELSE SetCursor(CursorUnderline);
    InKey(Ch,Fk,Key);
    SetCursor(CursorOff);
    CASE Key OF
      TextKey,
      NumberKey,
      SpaceKey : BEGIN
                   IF InsertOn THEN
                   BEGIN
                     Insert(Ch,S,P);
                     S[0]:=Chr(L);
                     IF P<L THEN
                     Inc(P);
                   END
                   ELSE BEGIN
                     S[P]:=Ch;
                     IF P<L THEN
                     Inc(P);
                   END;
                 END;
      InsertKey: BEGIN
                   InsertOn:= NOT InsertOn;
                 END;
      DelKey   : BEGIN
                   Delete(S,P,1);
                   S:=S+Fill;
                 END;
      LeftArrow: BEGIN
                   IF P>1 THEN
                   Dec(P);
                 END;
      RightArrow:BEGIN
                   IF (Pos(Fill,S)>0) THEN
                   BEGIN
                     IF (P<Pos(Fill,S)) THEN
                     Inc(P);
                   END
                   ELSE IF (P<L) THEN
                     Inc(P);
                 END;
    HomeKey     :P := 1;
    EndKey      :P := Pos(Fill,S);
    BackSpaceKey:BEGIN
                   IF P>1 THEN
                   BEGIN
                     Dec(P);
                     Delete(S,P,1);
                     S:=S+Fill;
                   END;
                 END;
    END;
  UNTIL Key IN KeySet;
  I:=Pos(Fill,S);
  IF I>0 THEN
    S:=Copy(S,1,I-1);
END;


BEGIN
  InsertOn:=FALSE;
  Key:=NullKey;
END.
