/*===========================================*
/*  NAMES.C: string operations (on demand?)  *
/*===========================================*


If the  source is  compiled with no extra definitions, all routines will be
     present in the object file.
If the  source is  compiled with  the symbol  CHOOSE defined,  the user  is
     allowed to select which routines are to be present in the object file:
     only routines  with the  corresponding symbol defined will be actually
     compiled.


  SYMBOL      ROUTINE           SUMMARY
------------------------------------------------------------------------
  RPL_EXT     RplExt(f,e)       Replaces (or adds) the ext e to filename f
  OPT_EXT     OptExt(f,e)       If f lacks extension, default e is added
  GET_EXT     GetExt(f)         Return the extension of f, or null string


/*===================================================================*/
#include <string.h>


/*===================================================================*/
#ifdef MSDOS
#define PATH_SEP(c) (c=='/' || c=='\\')
#else
#define PATH_SEP(c) (c=='/')
#endif

#ifndef CHOOSE
#define ALL
#endif

/*===================================================================*/
#if defined RPL_EXT || defined ALL
/*;#
&!char *RplExt(char *f, char *e);
$S Replaces (or adds) the extension of f with e.
;#*/

char *RplExt(char *f, char *e)
{
  int i;
  int n=strlen(f);

  for (i=strlen(f); --i>=0;)
    {
    if (f[i]=='.') n=i;       /* search for a dot */
    if PATH_SEP(f[i]) break;
    }

  f[n]=0;
  strcat(f,e);
  return(f);
}
#endif

/*====================================================================*/
#if defined OPT_EXT || defined ALL
/*;#
&!char *OptExt(char *f, char *e);
$S Adds the extension e to f, if f lacks ext.
;#*/

char *OptExt(char *f, char *e)
{
  int i;
  int n=-1;

  for (i=strlen(f); --i>=0;)
    {
    if (f[i]=='.') n=i;       /* search for a dot */
    if PATH_SEP(f[i]) break;
    }

  if (n<0)
    strcat(f,e);
  return(f);
}
#endif

/*====================================================================*/
#if defined GET_EXT || defined ALL
/*;#
&!char *GetExt(char *f);
$S Return a pointer to the first '.' in the last component
      of pathname f or a pointer to the end of f.
;#*/


char *GetExt(char *f)
{
  int i,n;

  n=strlen(f);

  for (i=strlen(f); --i>=0;)
    {
    if (f[i]=='.') n=i;       /* search for a dot */
    if PATH_SEP(f[i]) break;
    }

  return (f+n);
}
#endif

/*===================================================================*/





