##
##  PM-Menu.r
##  Extensions to the Pegasus Mail Main Menu, for PMail 3.0
##  Copright (c) 1993, David Harris, All Rights Reserved.
##
##  This resource-based scheme replaces the SENDER.PM file
##  found in PMail 2.35 and earlier. While the format of the
##  new scheme is slightly more complex than the old method,
##  it is more in keeping with the resource basis of PMail
##  v3.0 and can potentially do considerably more at the 
##  cost of less memory.
##
##  The first three items in the resource file MUST be popup
##  menus - the first for additions to the "New Mail" option
##  on the main menu, the second for additions to the "Send
##  a message" option and the third for any site-specific
##  directory lookup services. It may be possible in future
##  to add other options to the main menu as well.
##
##  The "return" field of each option in the popup menu should
##  be a resource number in this file describing the action
##  which should be taken.
##
##  To create submenus for PMail v3.0, make any changes necessary
##  to this file, then compile it using the Pegasus Mail Resource
##  Compiler, ResCom, using the command "rescom pm-menu.r". The
##  result will be a file called PM-MENU.RSC - you can either copy
##  this file into the same directory as PMAIL.EXE if you want it
##  to be available to all users on your network, or into your home
##  mailbox if you want it to apply only to you.
##
##  To disable one of the menus while retaining the other, set
##  the first integer in the popup menu definition for the menu
##  you do NOT want to 0.
##

include defines.rh

##  Ŀ
##   The following declaration creates the necessary type 
##   information for ResCom, the PMail resource compiler. 
##   It must NEVER be changed.                            
##  

typedef popup_menu 51
   {
   integer,    #  Resource ID of menu numbering from 0 in the file
   integer,    #  X-coordinate of the TLC of the menu on the screen
   integer,    #  Y-coordinate of the TLC of the menu on the screen
   integer     #  Attribute word for the popup menu (colours etc)
   string 30   #  Window title for popup menu
   };

typedef menu_option 90
   {
   char,       #  Non-zero to save and clear the screen before running
   char,       #  Non-zero if the temporary file should be mailed on return
   char,       #  Non-zero to enter the newmail screen after invoking
   char,       #  Non-zero if the command is actually a form filename
   string 100  #  The command line, formatted for substitution
   };


##  Ŀ
##   The first three entries in the resource (0,1,2) must 
##   describe the popup menu for new mail additions, send 
##   mail additions and directory services respectively.  
##  

popup_menu new_mail        # Resource 0 - New mail submenu
   {
   0,                      #  (3) Set to 0 if you do not want a new mail submenu
   29, 8,                  #  X and Y co-ordinates of TLC of popup menu
   BLIGHTGREY | RED | wshadow,
   " New mail options "
   };

popup_menu send_mail       # Resource 1 - Send mail submenu
   {
   0,                      #  (4) Set to 0 if you do not want a send mail submenu
   29, 10,                 #  X and Y co-ordinates of TLC of popup menu
   BLIGHTGREY | RED | wshadow,
   " Send mail options "
   };


## This one enables the F2 submenu !!!!!!!!!!!

popup_menu addresses       # Resource 2 - Directory service interface
   {
   5,                      #  (5) Set to 0 if no address lookup services are present
   10, 4,                  #  X and Y co-ordinates of TLC of popup menu
   BLIGHTGREY | RED | wshadow,
   " Local directory service "
   };


##  Ŀ
##   The menu agglomerated data type consists of a header         
##   followed by an array of menu records. The header has         
##   up to five integer values:                                   
##                                                                
##      1:  Number of items in this menu                          
##      2:  The menu mode (any M* constants in defines.rh ORed)   
##      3:  The default choice in the menu (starting from 0)      
##      4:  The colour of an unhighlighted entry                  
##      5:  The colour of a highlighted entry                     
##                                                                
##   All the header values except 1 are sensibly defaulted        
##                                                                
##   A menu record describes on entry in the menu: it is built    
##   as follows:                                                  
##                                                                
##      1:  (Integer)  The X (horizontal) position of the item    
##      2:  (Integer)  The Y (vertical) position of the item      
##      3:  (Integer)  An optional help or ID value for the item  
##      4:  (Char)     The character which selects this item      
##      5:  (Integer)  The value to return if item is selected    
##      6:  (String)   The text to display for the choice         
##                                                                
##   No item in a menu record is defaulted.                       
##  

menu new_mail_menu            ##  This is resource 3 in the file
   {
   1, 0, 0, BLUE | BLIGHTGREY, BBLUE | WHITE;

   1, 1, 0, 'N', 6, "Read Nn@ew mail",
#   1, 2, 0, 'G', 7, "NG@et new POP3 mail",
   };

menu send_mail_menu           ##  This is resource 4 in the file
   {
   6, 0, 0, BLUE | BLIGHTGREY, BBLUE | WHITE;

   1, 1, 0, 'B', 8,  "NB@asic mail form",
   1, 2, 0, 'E', 12, "NE@xtended mail form",
   1, 3, 0, 'O', 33, "NO@pen draft message",
   1, 4, 0, 'P', 9,  "NP@hone message form",
   1, 5, 0, 'R', 13, "Set a Nr@eminder alarm",
   1, 6, 0, 'D', 16, "ND@eferred mail message"
   };


## This is the definition for the F2 submenu !!!!!!!!!!!

menu address_menu             ##  This is resource 5 in the file
   {
   2, 0, 0, BLUE | BLIGHTGREY, BBLUE | WHITE;

   1, 1, 0, 'L', 41,  "NL@ocal users",
   1, 3, 0, 'C', 15, "NC@ampus directory",
   };


##  Ŀ
##   And now we have the actual resources describing the actions which    
##   should occur when a particular item is selected from a menu.         
##                                                                        
##   The following definitions are intended as samples for you to use.    
##   Note that you have to double any '\' characters you use in file      
##   names or command strings because the resource compiler views a       
##   single '\' as an escape character.                                   
##                                                                        
##   The command to run for an option can include most of the command     
##   substitutions defined in the User-defined gateway guide (UDG.TXT)    
##   contained in this release of PMail in the file UDG.ZIP. The command  
##   substitution you will use most often is "~c", which is replaced by   
##   the name of the temporary file PMail creates containing the data     
##   from the message.                                                    
##  

menu_option read_new_1        ##  This is resource 6 in the file
   {
   0,                   ##  Don't bother saving the screen before invoking
   0,                   ##  Do not mail the temporary file on return
   0,                   ##  Enter the newmail screen once this command returns
   0,                   ##  No, this entry is not a form
   ""                   ##  Empty string invokes the standard action (read new mail)
   };

menu_option read_new_2        ##  This is resource 7 in the file
   {
   0,                   ##  Don't bother saving the screen before invoking
   0,                   ##  Do not mail the temporary file on return
   1,                   ##  Enter the newmail screen once this command returns
   0,                   ##  No, this entry is not a form
   "pmpop -v2 -g > nul" ##  Invoke the PMPOP gateway to retrieve new mail
   };

menu_option send_1            ##  This is resource 8 in the file
   {
   0,                   ##  Don't bother saving the screen before invoking
   0,                   ##  Do not mail the temporary file on return
   0,                   ##  Don't Enter the send message screen on return
   0,                   ##  No, this entry is not a form
   "" 			##  Empty string invokes standard mail editor
   };

menu_option send_2            ##  This is resource 9 in the file
   {
   0,                   ##  Don't bother saving the screen before invoking
   0,                   ##  Do not mail the temporary file on return
   0,                   ##  Don't Enter the send message screen on return
   1,                   ##  Yes, this entry is a form
   "~a/forms/tphone.rsc"         ##  Name of form resource file
   };

menu_option send_3            ##  This is resource 10 in the file
   {
   0,                   ##  Don't bother saving the screen before invoking
   0,                   ##  Do not mail the temporary file on return
   0,                   ##  Don't Enter the send message screen on return
   0,                   ##  No, this entry is not a form
   "pmpop -s > nul"     ##  Invoke the PMPOP gateway to send waiting mail
   };

menu_option send_4            ##  This is resource 11 in the file
   {
   0,                   ##  Don't bother saving the screen before invoking
   0,                   ##  Do not mail the temporary file on return
   0,                   ##  Don't Enter the send message screen on return
   1,                   ##  Yes, this entry is a form
   "~a/forms/basic.rsc"          ##  The resource file containing the form
   };

menu_option send_5            ##  This is resource 12 in the file
   {
   0,             ##  Don't bother saving the screen before invoking
   0,             ##  Do not mail the temporary file on return
   0,             ##  Don't Enter the send message screen on return
   1,             ##  Yes, this entry is a form
   "~a/forms/enhanced.rsc"       ##  The resource file containing the form
   };

menu_option send_6            ##  This is resource 13 in the file
   {
   0,             ##  Don't bother saving the screen before invoking
   0,             ##  Do not mail the temporary file on return
   0,             ##  Don't Enter the send message screen on return
   1,             ##  Yes, this entry is a form
   "~a/forms/reminder.rsc"       ##  The resource file containing the form
   };

menu_option send_7            ##  This is resource 14 in the file
   {
   0,             ##  Don't bother saving the screen before invoking
   0,             ##  Do not mail the temporary file on return
   0,             ##  Don't Enter the send message screen on return
   1,             ##  Yes, this entry is a form
   "~a/forms/testfrm.rsc"       ##  The resource file containing the form
   };


## This is the definition for the NicePH call !!!!!!!!!!!

menu_option address_1         ## This is resource 15 in the file
   {
   1,             ##  Save the screen before invoking 
   0,             ##  Do not mail the temporary file on return
   0,             ##  Don't Enter the send message screen on return
   0,             ##  No, this entry is not a form
   "ph ~c"        ##  The command to run. Full path possible.
   };

menu_option send_8            ##  This is resource 16 in the file
   {
   0,             ##  Don't bother saving the screen before invoking
   0,             ##  Do not mail the temporary file on return
   0,             ##  Don't Enter the send message screen on return
   1,             ##  Yes, this entry is a form
   "~a/forms/remail.rsc"       ##  The resource file containing the form
   };
