/***********************************************************
   SUONA.C - EXAMPLE PROGRAM for:  Programma Esempio per:

	- SBLIB.LIB

	- SBDSK.LIB

   v.0.01 (c)opy Rights 1995 by A&A Luciano Tm.

   (see file SBMAN.ENG for more information)

   (vedi file SB.MAN per ulteriori informazioni)

 FREEWARE - free use and distribute this file - no fee
	    libero uso e distribuzione - nulla  dovuto

************************************************************/


#include "CONIO.H"

#include "SBlast.H"  //defination library prototypes

/******** Definitions ***********/

#define CD  1
#define MIC 2

/********************************/

char extf[MAXPATH]=""; //do this for best low level interface
		       //necessario per le routine I/O in asm
main(argc,argv)
int argc;
char *argv[];
{
   unsigned stato=0,time;
   char ch;
   unsigned X,Y,OLD_STATUS;
   unsigned base=0x220,irq=7,dma=1;


   if (argc==2) strcpy(extf,argv[1]); //c' un parametro, allora suono dall'esterno
   else {
	 printf("PLAY&REC - (c) 1995 by A&A Team - Use SBLib");
	 printf("\nHELP SYNTAX: SOUND <file> where: <file> name.ext");
	 return 1;
	}

  clrscr();
	 printf("\n");
	 printf(" PLAY&REC - SiMpLe PlayER & RECorder for VOC files\n");
	 printf("** By A&A Team included in SBLib **\n");
	 printf("\n");


   if (load_driver(NULL))       // carica driver  - load driver
   {
      printf("ERRORE\n");
      exit(0);
   }
   ch='a';
   X=wherex();  //where I am?
   Y=wherey();
   cprintf("SB SETtings are DMA=1 IRQ=7 PORT=220h (wrong values crash system). OK(y/n)?");
   while ((ch!='y')&&(ch!='n')) { ch=getch(); ch |=0x20;}

   gotoxy(X,Y);
   clreol();
   if (ch=='n')
	     {
	      cprintf("Insert Port hex (220/240/260): ");cscanf("%X",base);
	      gotoxy(X,Y);
	      clreol();
	      cprintf("Insert IRQ (1 to 10): ");cscanf("%d",irq);
	      gotoxy(X,Y);
	      clreol();
	      cprintf("Insert DMA (0 or 1): ");cscanf("%d",dma);
	     }
   SET_IRQ(irq);           //set SB at PORT 220h IRQ 7  DMA 1
   SET_IOBASE(base);    //if sound seem not work
   SET_DMA(dma);           //change these values using SET for
			 //view how is setted your card

   INIT_CARD(10);   //initialize card - inizializza la scheda

   printf("File loaded:%s     Result:%X\n",extf,SOUND_VOC(extf)); // play parameter - suona il parametro
   printf("ܿ\n");
   printf(" P:play W:wait S:stop O:open R:record C:close 0:ON/OFF audio ESC:quit    \n");
   printf("\n\n");
   X=wherex();
   Y=wherey();
   while ( ch != 27)
   {
	  if (kbhit()) {
	    ch=getch();
	    switch (ch) {
	      case 'R':
	      case 'r':
		     gotoxy(X,Y+1);
		     clreol();
		     cprintf("*** FILE to be RECorded ? (*=no change) ***");
		     gotoxy(X,Y+2);         //read file name
		     cscanf("%128s", extf);
		     gotoxy(X,Y+2);         //how long time for
		     clreol();
		     cprintf("Time in milliseconds: ");
		     cscanf("%d",&time);

		     gotoxy(X,Y+2);
		     if (!strcmp(extf,"*")) cprintf("OK no recording!");
		     else
			 {
			 cprintf("Recording file: %s",extf);
		SET_SOURCE(MIC);  // source = MIC - sorgente microfono
		SET_MONO();     // rec in mono
		SPEAKER_OFF();  // redirect A/D converter
		RECORD_VOC(extf,25000);
		delay(time);
		STOP_VOC();  //stop record
		SPEAKER_ON(); //restore A/D
		gotoxy(X,Y+2); clreol(); cprintf("Use O to play: %s",extf);

			 }
	      break;
	       case '0':
		     stato=stato?0:1;
		     if (stato) SPEAKER_ON();
		     else SPEAKER_OFF();
		     break;
	       case 'P':
	       case 'p':
		     gotoxy(X,Y+1);
		     clreol();
		     cprintf("-> Risultato funzione PLAY: %Xh.",RESUME_VOC());
		     break;
	       case 'W':
	       case 'w':
		     gotoxy(X,Y+1);
		     clreol();
		     cprintf("-> Risultato funzione PAUSA: %Xh.",PAUSE_VOC());
		     break;
	       case 'S':
	       case 's':
		     STOP_VOC();
		     break;
	       case 'C':
	       case 'c':
		     gotoxy(X,Y+1);
		     clreol();
		     cprintf("-> Function CLOSE_VOC Return: %Xh.",CLOSE_VOC());
		     break;
	       case 'O':
	       case 'o':
		     gotoxy(X,Y+1);
		     clreol();
		     cprintf("*** ENTER FILE TO BE PLAYed (*=no change) ***");
		     gotoxy(X,Y+2);
		     clreol();
		     cscanf("%128s", extf); //read new name
		     gotoxy(X,Y+2);
		     if (!strcmp(extf,"*")) cprintf("Use P to replay %s",extf);
		     else
			 {
			 gotoxy(X,Y-5);
			 clreol();
			 CLOSE_VOC();      //close old file
			 cprintf("New file: %s    Result: %X",extf,SOUND_VOC(extf)); //open&play new file

			 }
		     break;
	       default:
	       break;
	    }
	  }
	  else
	  {
	    if (STATUS_VOC!=OLD_STATUS)
	    {
	      gotoxy(X,Y); clreol();
	      OLD_STATUS=STATUS_VOC;
	      cprintf("STATUS: %Xh",OLD_STATUS);
	    }
	  }

	  }

   close_driver();   // chiudi driver

   clrscr(); // pulisci schermo

   return 0;
}
