<%@ page import="com.workroll.app.help.HelpManager" %>

<%=HelpManager.itemTitle("Instance")%>



If you are a software developer using WorkRoll as an issue-tracker (as opposed to as a general-purpose to-do list), you may want to take advantage of WorkRoll's instance-related features.  WorkRoll considers an "instance" to be one of various copies of the application or web site under development.  For example, a Weblogic-based web site that is currently visible to the world might have the following instances associated with it (or, these instances may be associated with all projects):

<ul>
<li>Developer A's development instance (at http://12.345.6.789:7001/index.jsp)
<li>Developer B's development instance (at http://12.345.6.789:7003/index.jsp)
<li>Developer C's development instance (at http://12.345.6.789:7005/index.jsp)
<li>Developer D's development instance (at http://12.345.6.789:7007/index.jsp)
<li>Developer E's development instance (at http://12.345.6.789:7009/index.jsp)
<li>The shared development instance (at http://12.345.6.789:80/index.jsp)
<li>The staging instance (at http://stage.someurl.com/index.jsp)
<li>The production instance (at http://www.someurl.com/index.jsp)
</ul>

Note that each of the URLs above points to the home page of the same site, but each to a different instance of the site (instances are therefore completely different from <%=HelpManager.itemLink("projects","project")%>).  Since issues are often found in one instance of a site but not in another, WorkRoll allows administrators, optionally, to create instances that can (again, optionally) be associated with specific issues.  Also optionally, a <%=HelpManager.itemLink("root URL","rootUrl")%> (such as those above) can be associated with an instance.  This URL-association feature will be useful to web developers, but not to software developers working on a multi-instance project that is not web-based.<BR><BR>

If you are an administrator and do not wish to use WorkRoll's instance-related features, simply don't create any instances.  If you are a user and are assigning an issue that affects more than one instance (or all instances), just select "all instances" in the <%=HelpManager.itemLink("add/edit-issue dialog box","addEditDialog")%>.<BR><BR>

Instances are not tied to specific projects.<BR><BR>


