package demo;

import java.awt.*;
import java.awt.event.*;

import com.japisoft.formula.*;
import com.japisoft.formula.node.*;

/**
 * Graph demonstration
 * @author Alexandre Brillant (abrillant@wanadoo.fr)
 * @version 1.0 */
public class Graph extends Panel implements ActionListener {
    public Graph() {
	super();   
	initUI();
    }

    TextField fx;
    TextField from;
    TextField to;
    TextField step;
    Grapher g;

    private void initUI() {
	setLayout( new BorderLayout() );
	Panel p = new Panel();
	p.add( new Label( "F(x):" ) );
	p.add( fx = new TextField( "2x          " ) );
	Button b;
	p.add( b = new Button( "Eval" ) );
	b.addActionListener( this );
	add( p, BorderLayout.NORTH );
	p = new Panel();
	p.add( new Label( "From:" ) );
	p.add( from = new TextField( "0" ) );
	p.add( new Label( "To:" ) );
	p.add( to = new TextField( "20" ) );
	p.add( new Label( "Step:" ) );
	p.add( step = new TextField( "0.1" ) );
	add( p, BorderLayout.SOUTH );
	add( g = new Grapher(), BorderLayout.CENTER );
    }

    public void actionPerformed( ActionEvent e ) {
	Double d1 = new Double( from.getText() );
	Double d2 = new Double( to.getText() );
	Double d3 = new Double( step.getText() );
	showGraph( fx.getText(), d1.doubleValue(), d2.doubleValue(), d3.doubleValue() );
    }

    void showGraph( String fx, double from, double to, double step ) {
	double[] d = new double[ ( (int)( Math.abs( from - to ) / step ) ) + 1 ];

	FormulaFactory mFac = FormulaFactory.getInstance();
	Formula fo = mFac.getFormula();
	fo.setExpression( fx );

	try {
	    int i = 0;
	    for ( double f = from; f < to; f += step ) {
		fo.setSymbolValue( "x", new Variant( f ) );
		Variant v = fo.evaluate();
		d[ i++ ] = v.getDoubleValue();
	    }
	    g.showCurve( d, i );
	    this.fx.setForeground( Color.black );
	} catch( Throwable th ) {
	    this.fx.setForeground( Color.red );
	    th.printStackTrace();
	    g.showCurve( new double[] {}, 0 );
	}
    }

    ///////////////////////////////

    class Grapher extends Canvas {
	double[] values;
	int pt = 0;
	double my = 0;

	public void showCurve( double[] values, int pt ) {
	    this.values = values;
	    this.pt = pt;
	    my = 0;
	    for ( int i = 0; i < pt; i++ ) {
		if ( values[ i ] > my )
		    my = values[ i ];
	    }
	    repaint();
	}

	public void paint( Graphics gc ) {
	    super.paint( gc );
	    int w = getWidth();
	    int h = getHeight();
	    gc.setColor( Color.blue );
	    gc.drawRect( 0,0, w - 1, h - 1 );
	    if ( values == null )
		return;
	    double dx = ( (double)w / (double)Math.max( 1, pt ) );
	    double ix = 0;
	    double iy;
	    double ox = 0,oy = 0;
	    gc.setColor( Color.black );
	    for  ( int i = 0; i < pt; i++ ) {
		double j = values[ i ];
		iy = ( j / my ) * h;
		ix += dx;
		if ( i > 0 ) {
		    gc.drawLine( (int)ox, h - (int)oy, (int)ix, h - (int)iy ); 
		}
		ox = ix;
		oy = iy;
	    }
	}
    }

}

// Graph ends here
