/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.formula;

import com.japisoft.formula.FormulaContext;
import com.japisoft.formula.FormulaException;
import com.japisoft.formula.FormulaFactory;
import com.japisoft.formula.FormulaParser;
import com.japisoft.formula.FormulaTreeBuilder;
import com.japisoft.formula.FunctionResolver;
import com.japisoft.formula.FunctionResolverException;
import com.japisoft.formula.ListOfArgument;
import com.japisoft.formula.SymbolResolver;
import com.japisoft.formula.SymbolResolverException;
import com.japisoft.formula.Variant;
import com.japisoft.formula.lib.LibException;
import com.japisoft.formula.lib.LibManager;
import com.japisoft.formula.node.AbstractNode;
import com.japisoft.formula.node.EvaluateException;
import com.japisoft.formula.node.NodeFactory;
import com.japisoft.formula.node.VariableNode;
import com.japisoft.formula.operator.OperatorFactory;
import com.japisoft.formula.operator.OperatorFactoryImpl;
import com.japisoft.formula.operator.OperatorFactory_hpImpl;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Formula {
    private String b;
    private Vector j;
    private Vector i;
    private Hashtable g;
    private Formula e;
    private OperatorFactory f;
    public static String PI_SYMBOL = "PI";
    public static String E_SYMBOL = "E";
    public static String TRUE_SYMBOL = "true";
    public static String FALSE_SYMBOL = "false";
    public static int DEF_ROUNDING_MODE = 3;
    public static int DEF_HP_SCALE = 15;
    boolean a = false;
    private FormulaTreeBuilder d = null;
    FormulaContext c = null;
    private boolean h = false;

    static {
        char[] cArray = new char[]{'J', 'F', 'o', 'r', 'm', 'u', 'l', 'a', ' ', '3', '.', '0', ' ', 'e', 'v', 'a', 'l', 'u', 'a', 't', 'i', 'o', 'n', ' ', 'v', 'e', 'r', 's', 'i', 'o', 'n', '\n', '(', 'c', ')', ' ', '2', '0', '0', '2', '-', '2', '0', '0', '5', ' ', 'J', 'A', 'P', 'I', 'S', 'o', 'f', 't', '\n', 'h', 't', 't', 'p', ':', '/', '/', 'w', 'w', 'w', '.', 'j', 'a', 'p', 'i', 's', 'o', 'f', 't', '.', 'c', 'o', 'm'};
        System.out.println(new String(cArray));
    }

    public Formula(Formula formula) {
        this();
        this.setShareFormulaContext(formula);
    }

    public Formula() {
        this.initDefaultSymbols();
    }

    public Formula(boolean bl) {
        this();
        this.setHighPrecisionMode(bl);
    }

    protected void initDefaultSymbols() {
        this.setSymbolValue(PI_SYMBOL, new Variant(Math.PI));
        this.setSymbolValue(E_SYMBOL, new Variant(Math.E));
        this.setSymbolValue(TRUE_SYMBOL, new Variant(true));
        this.setSymbolValue(FALSE_SYMBOL, new Variant(false));
    }

    public void setParent(Formula formula) {
        this.e = formula;
    }

    public void setShareFormulaContext(Formula formula) {
        this.e = formula;
    }

    public Formula(String string) {
        this();
        this.setExpression(string);
    }

    public Formula(String string, boolean bl) {
        this(bl);
        this.setExpression(string);
    }

    public void setOperatorFactory(OperatorFactory operatorFactory) {
        this.f = operatorFactory;
    }

    public OperatorFactory getOperatorFactory() {
        if (this.f == null) {
            this.f = FormulaFactory.getInstance().getSharedOperatorFactory();
        }
        return this.f;
    }

    public void setSymbolValue(String string, Variant variant) {
        if (this.g == null) {
            this.g = new Hashtable();
        }
        this.g.put(string, variant);
    }

    public void setSymbolValue(String string, String string2) {
        if (string2 == null) {
            new RuntimeException("Can't assign a null value");
        }
        this.setSymbolValue(string, new Variant(string2));
    }

    public void setSymbolValue(String string, boolean bl) {
        this.setSymbolValue(string, new Variant(bl));
    }

    public void setSymbolValue(String string, double d) {
        if (this.h) {
            this.setSymbolValue(string, new Variant(new BigDecimal(d)));
        } else {
            this.setSymbolValue(string, new Variant(d));
        }
    }

    public void setSymbolValue(String string, BigDecimal bigDecimal) {
        this.setSymbolValue(string, new Variant(bigDecimal));
    }

    public void removeSymbolValue(String string) {
        if (this.g != null) {
            this.g.remove(string);
        }
    }

    public Enumeration getSymbolNames() {
        if (this.g == null) {
            return null;
        }
        return this.g.keys();
    }

    public void addFunctionResolver(FunctionResolver functionResolver) {
        if (functionResolver == null) {
            throw new FormulaException(this, "Invalid function resolver");
        }
        if (this.j == null) {
            this.j = new Vector();
        }
        this.j.addElement(functionResolver);
    }

    public void removeFunctionResolver(FunctionResolver functionResolver) {
        if (this.j != null) {
            this.j.removeElement(functionResolver);
        }
    }

    public void addSymbolResolver(SymbolResolver symbolResolver) {
        if (symbolResolver == null) {
            throw new FormulaException(this, "Invalid symbol resolver");
        }
        if (this.i == null) {
            this.i = new Vector();
        }
        this.i.addElement(symbolResolver);
    }

    public void removeSymbolResolver(SymbolResolver symbolResolver) {
        if (this.i != null) {
            this.i.removeElement(symbolResolver);
        }
    }

    public void setExpression(String string) {
        if (string == null) {
            throw new FormulaException(this, "Invalid empty expression ");
        }
        this.b = string;
        this.a = false;
    }

    public String getExpression() {
        return this.b;
    }

    public void setFormulaTreeBuilder(FormulaTreeBuilder formulaTreeBuilder) {
        this.d = formulaTreeBuilder;
    }

    protected FormulaContext getContext() {
        if (this.c == null) {
            this.c = new FormulaContext(this);
        }
        return this.c;
    }

    public AbstractNode parse() throws EvaluateException {
        if (this.getExpression() == null) {
            throw new EvaluateException("Invalid empty expression");
        }
        if (this.a) {
            return this.d.getRootNode();
        }
        if (this.d == null) {
            this.d = new FormulaTreeBuilder();
        }
        this.d.setNodeFactory(new NodeFactory(this.getContext(), this.h));
        this.d.setFormulaContext(this.getContext());
        this.d.reset();
        FormulaParser formulaParser = null;
        try {
            formulaParser = new FormulaParser(new StringReader(this.getExpression()), this.d);
            formulaParser.e();
        }
        catch (RuntimeException runtimeException) {
            try {
                if ("true".equals(System.getProperty("formula.debug"))) {
                    runtimeException.printStackTrace();
                }
                throw new EvaluateException(formulaParser.getCurrentPos(), runtimeException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new EvaluateException(0, runtimeException.getMessage());
            }
        }
        this.a = true;
        return this.d.getRootNode();
    }

    public Variant evaluate() throws EvaluateException {
        AbstractNode abstractNode = this.parse();
        if (abstractNode == null) {
            throw new EvaluateException("No evaluation");
        }
        return new Variant(abstractNode.evaluate(this.getContext()));
    }

    public Variant getValueForSymbol(String string) throws SymbolResolverException {
        SymbolResolverException symbolResolverException;
        block10: {
            if (this.g != null && this.g.containsKey(string)) {
                return (Variant)this.g.get(string);
            }
            symbolResolverException = null;
            if (this.i != null) {
                Object var3_3 = null;
                int n = 0;
                while (n < this.i.size()) {
                    try {
                        return ((SymbolResolver)this.i.elementAt(n)).getValue(string);
                    }
                    catch (SymbolResolverException symbolResolverException2) {
                        if (symbolResolverException == null) {
                            symbolResolverException = symbolResolverException2;
                        }
                        ++n;
                    }
                }
            } else {
                symbolResolverException = new SymbolResolverException("No symbol resolver for " + string);
            }
            if (this.e != null) {
                try {
                    return this.e.getValueForSymbol(string);
                }
                catch (SymbolResolverException symbolResolverException3) {
                    if (symbolResolverException != null) break block10;
                    symbolResolverException = symbolResolverException3;
                }
            }
        }
        throw symbolResolverException;
    }

    public Enumeration getSymbolsFromExpression() throws EvaluateException {
        if (this.b == null) {
            return null;
        }
        AbstractNode abstractNode = this.parse();
        Vector vector = new Vector();
        this.a(abstractNode, vector);
        return vector.elements();
    }

    private void a(AbstractNode abstractNode, Vector vector) {
        if (abstractNode instanceof VariableNode) {
            vector.addElement(((VariableNode)abstractNode).getVariableName());
        } else {
            int n = 0;
            while (n < abstractNode.getChildCount()) {
                this.a(abstractNode.getChildAt(n), vector);
                ++n;
            }
        }
    }

    public Variant getValueForFunction(String string, ListOfArgument listOfArgument) throws FunctionResolverException {
        block14: {
            FunctionResolverException functionResolverException;
            block13: {
                functionResolverException = null;
                if (this.j != null) {
                    Object var4_4 = null;
                    int n = 0;
                    while (n < this.j.size()) {
                        block12: {
                            try {
                                Variant variant = ((FunctionResolver)this.j.elementAt(n)).getValue(string, listOfArgument);
                                if (variant != null) {
                                    return variant;
                                }
                            }
                            catch (FunctionResolverException functionResolverException2) {
                                if (functionResolverException != null) break block12;
                                functionResolverException = functionResolverException2;
                            }
                        }
                        ++n;
                    }
                }
                if (this.e != null) {
                    try {
                        return this.e.getValueForFunction(string, listOfArgument);
                    }
                    catch (FunctionResolverException functionResolverException3) {
                        if (functionResolverException != null) break block13;
                        functionResolverException = functionResolverException3;
                    }
                }
            }
            if (LibManager.getLib() != null) {
                try {
                    return LibManager.getLib().evaluate(string, listOfArgument);
                }
                catch (Throwable throwable) {
                    if (functionResolverException != null) {
                        throw functionResolverException;
                    }
                    if (!(throwable instanceof LibException)) break block14;
                    throw new FunctionResolverException(throwable.getMessage());
                }
            }
        }
        throw new FunctionResolverException("No function resolver for " + string);
    }

    public void setHighPrecisionMode(boolean bl) {
        this.h = bl;
        if (bl) {
            this.setOperatorFactory(new OperatorFactory_hpImpl());
        } else {
            this.setOperatorFactory(new OperatorFactoryImpl());
        }
    }

    public boolean isHighPrecisionMode() {
        return this.h;
    }
}

