/*
 * Copyright (c) 2001-2005 Servertec. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

public class RegistryExplorer_DeleteDialog extends JDialog implements ActionListener
{
	JPanel insetsPanel1 = new JPanel();
	JButton buttonNo = new JButton();
	JButton buttonYes = new JButton();

	boolean completed;
	JPanel jPanel3 = new JPanel();
	JPanel jPanel2 = new JPanel();
	JPanel jPanel1 = new JPanel();
	JTextField jTextFieldMessage = new JTextField();
	JButton jButton1 = new JButton();
	GridBagLayout gridBagLayout2 = new GridBagLayout();

	ImageIcon warning_icon = new ImageIcon(RegistryExplorer.class.getResource("/icons/warning.gif"));
	JPanel jPanel4 = new JPanel();
	FlowLayout flowLayout1 = new FlowLayout();
	GridBagLayout gridBagLayout1 = new GridBagLayout();

	public RegistryExplorer_DeleteDialog(Frame parent)
	{
		super(parent);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try
		{
			jbInit();
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		pack();
	}
	/**Component initialization*/
	private void jbInit() throws Exception
	{
		//imageLabel.setIcon(new ImageIcon(RegistryExplorer_DeleteDialog.class.getResource("[Your Image]")));
		this.setTitle("Delete");
		this.addComponentListener(new java.awt.event.ComponentAdapter()
		{
			public void componentShown(ComponentEvent e)
			{
				this_componentShown(e);
			}
		});
		setResizable(false);
		this.setModal(true);
		buttonNo.setMaximumSize(new Dimension(55, 27));
		buttonNo.setMinimumSize(new Dimension(55, 27));
		buttonNo.setPreferredSize(new Dimension(55, 27));
		buttonNo.setText("No");
		buttonNo.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				buttonNo_keyTyped(e);
			}
		});
		buttonNo.addActionListener(this);
		buttonYes.addActionListener(this);
		buttonYes.setText("Yes");
		buttonYes.addKeyListener(new java.awt.event.KeyAdapter()
		{
			public void keyTyped(KeyEvent e)
			{
				buttonYes_keyTyped(e);
			}
		});
		jPanel3.setLayout(null);
		jPanel1.setLayout(gridBagLayout2);
		jTextFieldMessage.setBackground(Color.lightGray);
		jTextFieldMessage.setEnabled(false);
		jTextFieldMessage.setBorder(null);
		jTextFieldMessage.setOpaque(false);
		jTextFieldMessage.setDisabledTextColor(Color.black);
		jTextFieldMessage.setEditable(false);
		jTextFieldMessage.setSelectedTextColor(Color.lightGray);
		jButton1.setBorder(null);
		jButton1.setIcon(warning_icon);
		jPanel1.setMinimumSize(new Dimension(400, 55));
		jPanel1.setPreferredSize(new Dimension(400, 55));
		insetsPanel1.setLayout(flowLayout1);
		jPanel4.setLayout(gridBagLayout1);
		this.getContentPane().add(insetsPanel1, BorderLayout.SOUTH);
		insetsPanel1.add(jPanel4, null);
		jPanel4.add(buttonNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 8, 0));
		jPanel4.add(buttonYes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
			,GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 0), 3, 0));
		this.getContentPane().add(jPanel1, BorderLayout.NORTH);
		jPanel1.add(jPanel3, new GridBagConstraints(0, 0, 1, 5, 1.0, 1.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(1, 0, 0, 4), 19, 51));
		jPanel1.add(jButton1, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 2, 9), 6, 9));
		jPanel1.add(jPanel2, new GridBagConstraints(4, 0, 1, 9, 1.0, 1.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 18, 43));
		jPanel1.add(jTextFieldMessage, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0
			,GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(16, 0, 18, 0), 273, 0));
	}
	/**Overridden so we can exit when window is closed*/
	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING)
		{
			cancel();
		}
		super.processWindowEvent(e);
	}
	/**Close the dialog*/
	void cancel()
	{
		completed = false;
		hide();
	}
	void done()
	{
		completed = true;
		hide();
	}

	/**Close the dialog on a button event*/
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == buttonNo)
		{
			cancel();
		}
		else if (e.getSource() == buttonYes)
		{
			done();
		}
	}

	void this_componentShown(ComponentEvent e)
	{
		completed = false;
		buttonNo.grabFocus();
	}

	void buttonNo_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == 27 || chr == ' ' || chr == '\n' || chr == 'N' || chr == 'n')
		{
			cancel();
		}
		else if(chr == 'Y' || chr == 'y')
		{
			done();
		}
	}

	void buttonYes_keyTyped(KeyEvent e)
	{
		char chr = e.getKeyChar();
		if(chr == ' ' || chr == '\n' || chr == 'Y' || chr == 'y')
		{
			done();
		}
		else if(chr == 27 || chr == 'N' || chr == 'n')
		{
			cancel();
		}
	}
}