/*
 * Decompiled with CFR 0.152.
 */
package javak.zs;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javak.exception.ZSjavakException;
import javak.iface.zs.I_ResultSet;
import javak.zs.ZSAssert;

class DBjavakResultSet
extends UnicastRemoteObject
implements I_ResultSet {
    private static final int DEFAULTSPALTENGROESSE = 35;
    private int actualSpaltenGroesse = 35;
    private int NoColumn = 0;
    private Vector allResults = null;
    private int currentRow = 0;
    private Hashtable columnnames = null;
    private ResultSet resultSet = null;
    private ResultSetMetaData rsMetaData = null;
    private static final int VECTORSIZEDEFAULT = 15;
    private static final String NULLVALUE = "SQL-Null";

    public DBjavakResultSet(ResultSet resultSet, int n) throws RemoteException, ZSjavakException {
        ZSAssert.assert(resultSet != null, "ResultSet invalid (null)");
        this.resultSet = resultSet;
        try {
            this.rsMetaData = resultSet.getMetaData();
            this.NoColumn = this.rsMetaData.getColumnCount();
            this.allResults = new Vector(n);
            this.columnnames = this.getColumnNames();
        }
        catch (Exception exception) {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (this.resultSet != null) {
                    this.resultSet.getStatement().close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw new ZSjavakException(exception, "Error occurred in Constructor");
        }
    }

    public DBjavakResultSet(ResultSet resultSet) throws RemoteException, ZSjavakException {
        this(resultSet, 15);
    }

    public synchronized void setResultColumnSize(int n) throws RemoteException, ZSjavakException {
        this.actualSpaltenGroesse = n;
    }

    public int getReadDatasets() throws RemoteException, ZSjavakException {
        return this.allResults.size();
    }

    public void finish() throws RemoteException, ZSjavakException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.resultSet != null) {
                this.resultSet.getStatement().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized String getAsString() throws RemoteException, ZSjavakException {
        Hashtable hashtable = this.get();
        if (hashtable == null) {
            return "";
        }
        return DBjavakResultSet.HashToString(hashtable, this.actualSpaltenGroesse);
    }

    public synchronized Hashtable get() throws RemoteException, ZSjavakException {
        if (this.allResults.size() > this.currentRow) {
            return (Hashtable)this.allResults.elementAt(this.currentRow);
        }
        Hashtable<String, String> hashtable = null;
        String string = null;
        try {
            if (!this.resultSet.next()) {
                this.finish();
                return null;
            }
            hashtable = new Hashtable<String, String>(this.NoColumn);
            int n = 1;
            while (n <= this.NoColumn) {
                string = this.resultSet.getString(n);
                if (string == null) {
                    string = NULLVALUE;
                }
                hashtable.put("" + n, string);
                ++n;
            }
        }
        catch (Exception exception) {
            this.finish();
            throw new ZSjavakException(exception, "Error at reading a result-row");
        }
        this.allResults.addElement(hashtable);
        this.currentRow = this.allResults.size() - 1;
        return hashtable;
    }

    public synchronized Hashtable getColumnNames() throws RemoteException, ZSjavakException {
        if (this.columnnames != null) {
            return this.columnnames;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(this.NoColumn);
        try {
            int n = 1;
            while (n <= this.NoColumn) {
                hashtable.put("" + n, this.rsMetaData.getColumnName(n));
                ++n;
            }
        }
        catch (Exception exception) {
            throw new ZSjavakException(exception, "Error at reading the columnnames");
        }
        return hashtable;
    }

    public synchronized void advance() throws RemoteException, ZSjavakException {
        ++this.currentRow;
    }

    public synchronized void retrieve() throws RemoteException, ZSjavakException {
        ZSAssert.assert(this.currentRow > 0, "Index cannot get negativ");
        --this.currentRow;
    }

    public synchronized void retrieveToStart() throws RemoteException, ZSjavakException {
        this.currentRow = 0;
    }

    public synchronized String getAllResultsString() throws RemoteException, ZSjavakException {
        Hashtable hashtable = null;
        String string = "";
        int n = this.currentRow;
        this.retrieveToStart();
        hashtable = this.get();
        while ((hashtable = this.get()) != null) {
            string = string + DBjavakResultSet.HashToString(hashtable, this.actualSpaltenGroesse) + "\n";
            this.advance();
        }
        this.currentRow = n;
        return string;
    }

    public synchronized Vector getAllResultsVector() throws RemoteException, ZSjavakException {
        int n = this.currentRow;
        Hashtable hashtable = null;
        this.retrieveToStart();
        hashtable = this.get();
        while ((hashtable = this.get()) != null) {
            this.advance();
        }
        this.currentRow = n;
        return this.allResults;
    }

    private static String HashToString(Hashtable hashtable, int n) throws ZSjavakException {
        ZSAssert.assert(hashtable != null, "Hashtable invalid (null)");
        if (n == 0) {
            n = 35;
        }
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = hashtable.get(enumeration.nextElement()).toString();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = string2.length();
            while (n - n2 >= 0) {
                stringBuffer.append(" ");
                ++n2;
            }
            string = string + string2 + stringBuffer;
            if (!enumeration.hasMoreElements()) continue;
            string = string + "|";
        }
        return string;
    }
}

