VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsGetSystemInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

Private Const MAX_WSADescription As Long = 256
Private Const MAX_WSASYSStatus As Long = 128
Private Const ERROR_SUCCESS       As Long = 0
Private Const WS_VERSION_REQD     As Long = &H101
Private Const WS_VERSION_MAJOR    As Long = WS_VERSION_REQD \ &H100 And &HFF&
Private Const WS_VERSION_MINOR    As Long = WS_VERSION_REQD And &HFF&
Private Const MIN_SOCKETS_REQD    As Long = 1
Private Const SOCKET_ERROR        As Long = -1
Private Const MAX_DOMAIN_NAME_LEN   As Long = 128
Private Const MAX_HOSTNAME_LEN      As Long = 128
Private Const MAX_SCOPE_ID_LEN      As Long = 256
Private Const PROCESSOR_INTEL_386 As Long = 386
Private Const PROCESSOR_INTEL_486 As Long = 486
Private Const PROCESSOR_INTEL_PENTIUM As Long = 586
Private Const PROCESSOR_MIPS_R4000 As Long = 4000
Private Const PROCESSOR_ALPHA_21064 As Long = 21064
Private Const PROCESSOR_PPC_601 As Long = 601
Private Const PROCESSOR_PPC_603 As Long = 603
Private Const PROCESSOR_PPC_604 As Long = 604
Private Const PROCESSOR_PPC_620 As Long = 620
Private Const PROCESSOR_HITACHI_SH3 As Long = 10003    'Windows CE
Private Const PROCESSOR_HITACHI_SH3E As Long = 10004   'Windows CE
Private Const PROCESSOR_HITACHI_SH4 As Long = 10005    'Windows CE
Private Const PROCESSOR_MOTOROLA_821 As Long = 821     'Windows CE
Private Const PROCESSOR_SHx_SH3 As Long = 103          'Windows CE
Private Const PROCESSOR_SHx_SH4 As Long = 104          'Windows CE
Private Const PROCESSOR_STRONGARM As Long = 2577       'Windows CE - 0xA11
Private Const PROCESSOR_ARM720 As Long = 1824          'Windows CE - 0x720
Private Const PROCESSOR_ARM820 As Long = 2080          'Windows CE - 0x820
Private Const PROCESSOR_ARM920 As Long = 2336          'Windows CE - 0x920
Private Const PROCESSOR_ARM_7TDMI As Long = 70001      'Windows CE
Private Const PROCESSOR_ARCHITECTURE_INTEL As Long = 0
Private Const PROCESSOR_ARCHITECTURE_MIPS As Long = 1
Private Const PROCESSOR_ARCHITECTURE_ALPHA As Long = 2
Private Const PROCESSOR_ARCHITECTURE_PPC As Long = 3
Private Const PROCESSOR_ARCHITECTURE_SHX As Long = 4
Private Const PROCESSOR_ARCHITECTURE_ARM As Long = 5
Private Const PROCESSOR_ARCHITECTURE_IA64 As Long = 6
Private Const PROCESSOR_ARCHITECTURE_ALPHA64 As Long = 7
Private Const PROCESSOR_ARCHITECTURE_UNKNOWN   As Long = &HFFFF
Private Const PROCESSOR_LEVEL_80386 As Long = 3
Private Const PROCESSOR_LEVEL_80486 As Long = 4
Private Const PROCESSOR_LEVEL_PENTIUM As Long = 5
Private Const PROCESSOR_LEVEL_PENTIUMII As Long = 6
Private Const PROCESSOR_LEVEL_PENTIUMIV As Long = 15
Private Const HKEY_LOCAL_MACHINE As Long = &H80000002
Private Const MAX_ADAPTER_NAME_LENGTH        As Long = 256
Private Const MAX_ADAPTER_DESCRIPTION_LENGTH As Long = 128
Private Const MAX_ADAPTER_ADDRESS_LENGTH     As Long = 8
Private Const NCBASTAT As Long = &H33
Private Const NCBNAMSZ As Long = 16
Private Const HEAP_ZERO_MEMORY As Long = &H8
Private Const HEAP_GENERATE_EXCEPTIONS As Long = &H4
Private Const NCBRESET As Long = &H32
Private Const NERR_SUCCESS As Long = 0&
Private Const MAX_PREFERRED_LENGTH As Long = -1
Private Const ERROR_MORE_DATA As Long = 234&
Private Const LB_SETTABSTOPS As Long = &H192

Private Type SYSTEM_INFO
    dwOemID As Long
    dwPageSize As Long
    lpMinimumApplicationAddress As Long
    lpMaximumApplicationAddress As Long
    dwActiveProcessorMask As Long
    dwNumberOfProcessors As Long
    dwProcessorType As Long
    dwAllocationGranularity As Long
    wProcessorLevel As Integer
    wProcessorRevision As Integer
End Type

Private Type HOSTENT
   hName      As Long
   hAliases   As Long
   hAddrType  As Integer
   hLen       As Integer
   hAddrList  As Long
End Type

Private Type WSADATA
   wVersion      As Integer
   wHighVersion  As Integer
   szDescription(0 To MAX_WSADescription)   As Byte
   szSystemStatus(0 To MAX_WSASYSStatus)    As Byte
   wMaxSockets   As Integer
   wMaxUDPDG     As Integer
   dwVendorInfo  As Long
End Type

Private Type IP_ADDRESS_STRING
    IpAddr(0 To 15)  As Byte
End Type

Private Type IP_MASK_STRING
    IpMask(0 To 15)  As Byte
End Type

Private Type IP_ADDR_STRING
    dwNext     As Long
    IpAddress  As IP_ADDRESS_STRING
    IpMask     As IP_MASK_STRING
    dwContext  As Long
End Type

Private Type FIXED_INFO
  HostName(0 To (MAX_HOSTNAME_LEN + 3))         As Byte
  DomainName(0 To (MAX_DOMAIN_NAME_LEN + 3))    As Byte
  CurrentDnsServer   As IP_ADDR_STRING
  DnsServerList      As IP_ADDR_STRING
  NodeType           As Long
  ScopeId(0 To (MAX_SCOPE_ID_LEN + 3))          As Byte
  EnableRouting      As Long
  EnableProxy        As Long
  EnableDns          As Long
End Type

Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128
End Type

Private Type MEMORYSTATUS
    dwLength As Long
    dwMemoryLoad As Long
    dwTotalPhys As Long
    dwAvailPhys As Long
    dwTotalPageFile As Long
    dwAvailPageFile As Long
    dwTotalVirtual As Long
    dwAvailVirtual As Long
End Type

Private Type NET_CONTROL_BLOCK  'NCB
   ncb_command    As Byte
   ncb_retcode    As Byte
   ncb_lsn        As Byte
   ncb_num        As Byte
   ncb_buffer     As Long
   ncb_length     As Integer
   ncb_callname   As String * NCBNAMSZ
   ncb_name       As String * NCBNAMSZ
   ncb_rto        As Byte
   ncb_sto        As Byte
   ncb_post       As Long
   ncb_lana_num   As Byte
   ncb_cmd_cplt   As Byte
   ncb_reserve(9) As Byte ' Reserved, must be 0
   ncb_event      As Long
End Type

Private Type ADAPTER_STATUS
   adapter_address(5) As Byte
   rev_major         As Byte
   reserved0         As Byte
   adapter_type      As Byte
   rev_minor         As Byte
   duration          As Integer
   frmr_recv         As Integer
   frmr_xmit         As Integer
   iframe_recv_err   As Integer
   xmit_aborts       As Integer
   xmit_success      As Long
   recv_success      As Long
   iframe_xmit_err   As Integer
   recv_buff_unavail As Integer
   t1_timeouts       As Integer
   ti_timeouts       As Integer
   Reserved1         As Long
   free_ncbs         As Integer
   max_cfg_ncbs      As Integer
   max_ncbs          As Integer
   xmit_buf_unavail  As Integer
   max_dgram_size    As Integer
   pending_sess      As Integer
   max_cfg_sess      As Integer
   max_sess          As Integer
   max_sess_pkt_size As Integer
   name_count        As Integer
End Type
   
Private Type NAME_BUFFER
   name        As String * NCBNAMSZ
   name_num    As Integer
   name_flags  As Integer
End Type

Private Type ASTAT
   adapt          As ADAPTER_STATUS
   NameBuff(30)   As NAME_BUFFER
End Type

Private Type IP_ADAPTER_INFO
  dwNext                As Long
  ComboIndex            As Long  'reserved
  sAdapterName(0 To (MAX_ADAPTER_NAME_LENGTH + 3))        As Byte
  sDescription(0 To (MAX_ADAPTER_DESCRIPTION_LENGTH + 3)) As Byte
  dwAddressLength       As Long
  sIPAddress(0 To (MAX_ADAPTER_ADDRESS_LENGTH - 1))       As Byte
  dwIndex               As Long
  uType                 As Long
  uDhcpEnabled          As Long
  CurrentIpAddress      As Long
  IpAddressList         As IP_ADDR_STRING
  GatewayList           As IP_ADDR_STRING
  DhcpServer            As IP_ADDR_STRING
  bHaveWins             As Long
  PrimaryWinsServer     As IP_ADDR_STRING
  SecondaryWinsServer   As IP_ADDR_STRING
  LeaseObtained         As Long
  LeaseExpires          As Long
End Type

'for use on Win NT/2000 only
Private Type WKSTA_USER_INFO_0
  wkui0_username  As Long
End Type

Private Type WKSTA_USER_INFO_1
  wkui1_username As Long
  wkui1_logon_domain As Long
  wkui1_oth_domains As Long
  wkui1_logon_server As Long
End Type

Private Declare Sub GetSystemInfo Lib "kernel32" _
    (lpSystemInfo As SYSTEM_INFO)
    
Private Declare Function GetAdaptersInfo Lib "iphlpapi.dll" _
  (pTcpTable As Any, _
   pdwSize As Long) As Long

Private Declare Function Netbios Lib "netapi32.dll" _
   (pncb As NET_CONTROL_BLOCK) As Byte
     
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" _
   (hpvDest As Any, ByVal _
    hpvSource As Long, ByVal _
    cbCopy As Long)
     
Private Declare Function GetProcessHeap Lib "kernel32" () As Long

Private Declare Function HeapAlloc Lib "kernel32" _
    (ByVal hHeap As Long, ByVal dwFlags As Long, _
     ByVal dwBytes As Long) As Long
     
Private Declare Function HeapFree Lib "kernel32" _
    (ByVal hHeap As Long, _
     ByVal dwFlags As Long, _
     lpMem As Any) As Long

Private Declare Function WSAGetLastError Lib "WSOCK32.DLL" () As Long

Private Declare Function WSAStartup Lib "WSOCK32.DLL" _
   (ByVal wVersionRequired As Long, lpWSADATA As WSADATA) As Long
   
Private Declare Function WSACleanup Lib "WSOCK32.DLL" () As Long

Private Declare Function gethostname Lib "WSOCK32.DLL" _
   (ByVal szHost As String, ByVal dwHostLen As Long) As Long
   
Private Declare Function gethostbyname Lib "WSOCK32.DLL" _
   (ByVal szHost As String) As Long

Private Declare Function GetNetworkParams Lib "iphlpapi.dll" _
  (pFixedInfo As Any, _
   pOutBufLen As Long) As Long

Private Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" _
   (lpVersionInformation As OSVERSIONINFO) As Long
             
Private Declare Sub GlobalMemoryStatus Lib "kernel32" (lpBuffer As _
    MEMORYSTATUS)

Private Declare Function GetLogicalDriveStrings Lib "kernel32" _
   Alias "GetLogicalDriveStringsA" _
   (ByVal nBufferLength As Long, _
    ByVal lpBuffer As String) As Long

Private Declare Function GetDiskFreeSpace Lib "kernel32" _
   Alias "GetDiskFreeSpaceA" _
  (ByVal lpRootPathName As String, _
   lpSectorsPerCluster As Long, _
   lpBytesPerSector As Long, _
   lpNumberOfFreeClusters As Long, _
   lpTtoalNumberOfClusters As Long) As Long
   
Private Declare Function GetDiskFreeSpaceEx Lib "kernel32" _
   Alias "GetDiskFreeSpaceExA" _
   (ByVal lpRootPathName As String, _
   lpFreeBytesAvailableToCaller As Currency, _
   lpTotalNumberOfBytes As Currency, _
   lpTotalNumberOfFreeBytes As Currency) As Long
      
Private Declare Function GetModuleHandle Lib "kernel32" _
   Alias "GetModuleHandleA" _
  (ByVal lpModuleName As String) As Long
  
Private Declare Function GetProcAddress Lib "kernel32" _
  (ByVal hModule As Long, _
   ByVal lpProcName As String) As Long

Private Enum sysInfo
    si_OS = 0
    si_RAM = 1
    si_Processor = 2
End Enum

Private Declare Function NetWkstaUserEnum Lib "Netapi32" _
  (ByVal servername As Long, _
   ByVal level As Long, _
   bufptr As Long, _
   ByVal prefmaxlen As Long, _
   entriesread As Long, _
   totalentries As Long, _
   resume_handle As Long) As Long
        
Private Declare Function NetApiBufferFree Lib "netapi32.dll" _
   (ByVal Buffer As Long) As Long
   
Private Declare Function lstrlenW Lib "kernel32" _
  (ByVal lpString As Long) As Long
  
Private Declare Function GetVolumeInformation Lib "kernel32" _
   Alias "GetVolumeInformationA" _
  (ByVal lpRootPathName As String, _
   ByVal lpVolumeNameBuffer As String, _
   ByVal nVolumeNameSize As Long, _
   lpVolumeSerialNumber As Long, _
   lpMaximumComponentLength As Long, _
   lpFileSystemFlags As Long, _
   ByVal lpFileSystemNameBuffer As String, _
   ByVal nFileSystemNameSize As Long) As Long
   
Private sProcessorInfo As String 'local copy
Private varApplications As Variant 'local copy
Private sMachineName As String 'local copy
Private sIPAddress As String 'local copy
Private sDomainName As String 'local copy
Private sOSName As String 'local copy
Private sOSVersion As String
Private sOSServicePack As String
Private sRAM As String 'local copy
Private sNotes As String 'local copy
Private sDHCP As String
Private dblFreeDriveSpace As Double
Private dblTotalDriveSpace As Double
Private sScreenRes As String
Private sMacAddress As String
Private dScanDate As Date
Private sUserName As String

Public Property Let UserName(ByVal vData As String)
    sUserName = vData
End Property

Public Property Get UserName() As String
    UserName = sUserName
End Property

Public Property Let Notes(ByVal vData As String)
    sNotes = vData
End Property

Public Property Get Notes() As String
    Notes = sNotes
End Property

Public Property Let RAM(ByVal vData As String)
    sRAM = vData
End Property

Public Property Get RAM() As String
    RAM = sRAM
End Property

Public Property Let DomainName(ByVal vData As String)
    sDomainName = vData
End Property

Public Property Get DomainName() As String
    DomainName = sDomainName
End Property

Public Property Let IpAddress(ByVal vData As String)
    sIPAddress = vData
End Property

Public Property Get IpAddress() As String
    IpAddress = sIPAddress
End Property

Public Property Let MachineName(ByVal vData As String)
    sMachineName = vData
End Property

Public Property Get MachineName() As String
    MachineName = sMachineName
End Property

Public Property Let Applications(ByVal vData As Variant)
    varApplications = vData
End Property

Public Property Set Applications(ByVal vData As Variant)
    Set varApplications = vData
End Property

Public Property Get Applications() As Variant
    If IsObject(varApplications) Then
        Set Applications = varApplications
    Else
        Applications = varApplications
    End If
End Property

Public Property Let ProcessorInfo(ByVal vData As String)
    sProcessorInfo = vData
End Property

Public Property Get ProcessorInfo() As String
    ProcessorInfo = sProcessorInfo
End Property

Public Property Let OSName(ByVal vData As String)
    sOSName = vData
End Property

Public Property Get OSName() As String
    OSName = sOSName
End Property

Public Property Let OSVersion(ByVal vData As String)
    OSVersion = vData
End Property

Public Property Get OSVersion() As String
    OSVersion = sOSVersion
End Property

Public Property Let OSServicePack(ByVal vData As String)
    OSServicePack = vData
End Property

Public Property Get OSServicePack() As String
    OSServicePack = sOSServicePack
End Property

Public Property Let UsingDHCP(ByVal vData As String)
    sDHCP = vData
End Property

Public Property Get UsingDHCP() As String
    UsingDHCP = sDHCP
End Property

Public Property Let FreeDriveSpace(ByVal vData As String)
    dblFreeDriveSpace = vData
End Property

Public Property Get FreeDriveSpace() As String
    FreeDriveSpace = dblFreeDriveSpace
End Property

Public Property Let TotalDriveSpace(ByVal vData As String)
    dblTotalDriveSpace = vData
End Property

Public Property Get TotalDriveSpace() As String
    TotalDriveSpace = dblTotalDriveSpace
End Property

Public Property Let ScreenResolution(ByVal vData As String)
    sScreenRes = vData
End Property

Public Property Get ScreenResolution() As String
    ScreenResolution = sScreenRes
End Property

Public Property Let MacAddress(ByVal vData As String)
    sMacAddress = vData
End Property

Public Property Get MacAddress() As String
    MacAddress = sMacAddress
End Property

Public Property Let ScanDate(ByVal vData As String)
    dScanDate = vData
End Property

Public Property Get ScanDate() As String
    ScanDate = dScanDate
End Property

Private Function GetMACAddress() As String
  'retrieve the MAC Address for the network controller
  'installed, returning a formatted string
   
   Dim tmp As String
   Dim pASTAT As Long
   Dim NCB As NET_CONTROL_BLOCK
   Dim AST As ASTAT

  'The IBM NetBIOS 3.0 specifications defines four basic
  'NetBIOS environments under the NCBRESET command. Win32
  'follows the OS/2 Dynamic Link Routine (DLR) environment.
  'This means that the first NCB issued by an application
  'must be a NCBRESET, with the exception of NCBENUM.
  'The Windows NT implementation differs from the IBM
  'NetBIOS 3.0 specifications in the NCB_CALLNAME field.
   NCB.ncb_command = NCBRESET
   Call Netbios(NCB)
   
  'To get the Media Access Control (MAC) address for an
  'ethernet adapter programmatically, use the Netbios()
  'NCBASTAT command and provide a "*" as the name in the
  'NCB.ncb_CallName field (in a 16-chr string).
   NCB.ncb_callname = "*               "
   NCB.ncb_command = NCBASTAT
   
  'For machines with multiple network adapters you need to
  'enumerate the LANA numbers and perform the NCBASTAT
  'command on each. Even when you have a single network
  'adapter, it is a good idea to enumerate valid LANA numbers
  'first and perform the NCBASTAT on one of the valid LANA
  'numbers. It is considered bad programming to hardcode the
  'LANA number to 0 (see the comments section below).
   NCB.ncb_lana_num = 0
   NCB.ncb_length = Len(AST)
   
   pASTAT = HeapAlloc(GetProcessHeap(), HEAP_GENERATE_EXCEPTIONS _
            Or HEAP_ZERO_MEMORY, NCB.ncb_length)
            
   If pASTAT = 0 Then
      Exit Function
   End If
   
   NCB.ncb_buffer = pASTAT
   Call Netbios(NCB)
   
   CopyMemory AST, NCB.ncb_buffer, Len(AST)
   
   tmp = Right$("00" & Hex(AST.adapt.adapter_address(0)), 2) & _
         Right$("00" & Hex(AST.adapt.adapter_address(1)), 2) & _
         Right$("00" & Hex(AST.adapt.adapter_address(2)), 2) & _
         Right$("00" & Hex(AST.adapt.adapter_address(3)), 2) & _
         Right$("00" & Hex(AST.adapt.adapter_address(4)), 2) & _
         Right$("00" & Hex(AST.adapt.adapter_address(5)), 2)
                    
   HeapFree GetProcessHeap(), 0, pASTAT
   
   GetMACAddress = tmp
End Function

Private Function GetDiskSpace(sDrive As String) As Single
  'for GetDiskFreeSpaceEx
   Dim BytesFree As Currency
   Dim TotalBytes As Currency
   Dim TotalBytesFree As Currency
   Dim TotalBytesUsed As Currency
   
  'for GetDiskFreeSpace
   Dim nSectors As Long
   Dim nBytesPerSector As Long
   Dim nFreeClusters As Long
   Dim nTotalClusters As Long
     
  'for GetProcAddress
   Dim ptr As Long
  
  'attempt to obtain a pointer to
  'the GetDiskFreeSpaceExA API in kernel32
   ptr = GetProcAddress(GetModuleHandle("kernel32.dll"), "GetDiskFreeSpaceExA")
   
   If ptr Then

     'get drive info using GetDiskFreeSpaceEx
      If GetDiskFreeSpaceEx(sDrive, _
                            BytesFree, _
                            TotalBytes, _
                            TotalBytesFree) <> 0 Then
      
        'adjust the by multiplying the returned
        'value by 10000 accommodate for the decimal
        'places the currency data type returns.
         GetDiskSpace = TotalBytes * 10000
      
      End If  'if GetDiskFreeSpaceEx
   
   Else
   
     'get drive info using GetDiskFreeSpace
      If GetDiskFreeSpace(sDrive, nSectors, _
                          nBytesPerSector, _
                          nFreeClusters, _
                          nTotalClusters) <> 0 Then
   
        'perform math to get the data
         On Local Error Resume Next
         GetDiskSpace = (nSectors * nBytesPerSector * nTotalClusters)
         On Local Error GoTo 0
     
     End If  'if GetDiskFreeSpace
   End If  'If ptr
End Function

Private Function GetDiskSpaceFree(sDrive As String) As Currency
  'for GetDiskFreeSpaceEx
   Dim BytesFree As Currency
   Dim TotalBytes As Currency
   Dim TotalBytesFree As Currency
   Dim TotalBytesUsed As Currency
   
  'for GetDiskFreeSpace
   Dim nSectors As Long
   Dim nBytesPerSector As Long
   Dim nFreeClusters As Long
   Dim nTotalClusters As Long
     
  'for GetProcAddress
   Dim ptr As Long
  
  'attempt to obtain a pointer to
  'the GetDiskFreeSpaceExA API in kernel32
   ptr = GetProcAddress(GetModuleHandle("kernel32.dll"), "GetDiskFreeSpaceExA")
  
   If ptr Then
     'get drive info using GetDiskFreeSpaceEx
      If GetDiskFreeSpaceEx(sDrive, _
                            BytesFree, _
                            TotalBytes, _
                            TotalBytesFree) <> 0 Then
      
        'adjust the by multiplying the returned
        'value by 10000 accommodate for the decimal
        'places the currency data type returns.
         GetDiskSpaceFree = TotalBytesFree * 10000
      
      End If  'if GetDiskFreeSpaceEx
   Else
   
     'get drive info using GetDiskFreeSpace
      If GetDiskFreeSpace(sDrive, _
                          nSectors, _
                          nBytesPerSector, _
                          nFreeClusters, _
                          nTotalClusters) <> 0 Then
   
        'perform math to get the data
         On Local Error Resume Next
         GetDiskSpaceFree = (nSectors * nBytesPerSector * nFreeClusters)
         On Local Error GoTo 0
     
     End If  'if GetDiskFreeSpace
   End If  'If ptr

End Function

Private Function IsDhcpEnabled() As Boolean
  'api vars
   Dim cbRequired   As Long
   Dim buff()       As Byte
   Dim Adapter      As IP_ADAPTER_INFO
   Dim AdapterStr   As IP_ADDR_STRING
    
  'working vars
   Dim ptr1         As Long
   Dim flag         As Long
   
   Call GetAdaptersInfo(ByVal 0&, cbRequired)

   If cbRequired > 0 Then
    
      ReDim buff(0 To cbRequired - 1) As Byte
      
      If GetAdaptersInfo(buff(0), cbRequired) = ERROR_SUCCESS Then
        'get a pointer to the data stored in buff()
         ptr1 = VarPtr(buff(0))
                  
         Do While ptr1
           'copy the data from the pointer to the
           'first adapter into the IP_ADAPTER_INFO type
            CopyMemory Adapter, ByVal ptr1, LenB(Adapter)
         
           'retrieve the adapter data
            With Adapter
              'set a flag indicating whether
              'DHCP is enabled for the adapter
               flag = .uDhcpEnabled = 1
               
              'if the flag was set, we have the info
              'so we can exit the function
               If flag = True Then Exit Do
  
              'flag must be false, so check for
              'additional adapters
               ptr1 = .dwNext
            End With
         Loop
      End If
   End If
   
   IsDhcpEnabled = flag
End Function

Private Function GetApplications() As Variant
    Const INSTALLED_APPS_REGKEY = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
    Dim sRegValue As String
    Dim lCount As Long
    Dim aAllApps() As String
    Dim aRegKeys() As String
    Dim lResult As Long
    Dim sValues As String
    Dim oReg As clsRegistry
    Dim i As Long
    
    Set oReg = New clsRegistry
    
    lResult = oReg.EnumKey(HKEY_LOCAL_MACHINE, INSTALLED_APPS_REGKEY, sValues)
    aRegKeys = Split(sValues, Chr(0))

    lCount = -1
    ReDim aAllApps(UBound(aRegKeys))
    For i = LBound(aRegKeys) To UBound(aRegKeys)
      If Len(aRegKeys(i)) > 0 Then
        If oReg.ReadValue(HKEY_LOCAL_MACHINE, INSTALLED_APPS_REGKEY & "\" & aRegKeys(i), "DisplayName", "S", "", sRegValue) = 0 Then
          If Len(sRegValue) > 0 Then
            lCount = lCount + 1
            aAllApps(lCount) = sRegValue
          End If
        End If
      End If
    Next i
    
    ReDim Preserve aAllApps(lCount)
    Set oReg = Nothing

    GetApplications = aAllApps

End Function

Public Function GetSystemInformation() As Boolean
    Dim ret As Integer        ' OS Information
    Dim oReg As clsRegistry

    'Get Windows Version
    Dim ver_major As Integer  ' OS Version
    Dim ver_minor As Integer  ' Minor Os Version
    Dim lBuild As String      ' OS lBuild

    'Get operating system and version.
    Dim verinfo As OSVERSIONINFO
    verinfo.dwOSVersionInfoSize = Len(verinfo)
    ret = GetVersionEx(verinfo)
    If ret = 0 Then
        'Call Error object
        
        End
    End If

    ver_major = verinfo.dwMajorVersion
    ver_minor = verinfo.dwMinorVersion
    lBuild = verinfo.dwBuildNumber

    sOSVersion = ver_major & "." & ver_minor & " (Build " & lBuild & ")"
    Set oReg = New clsRegistry
    
    
    'We need to handle NT4 and 95/98/me/xp versions here
    Select Case ver_major
        Case Is = 5
            Select Case lBuild
                Case Is = 2195
                    'Win 2000
                    Call oReg.ReadValue(HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows NT\CurrentVersion", "CSDVersion", "S", "", sOSServicePack)
                    Call oReg.ReadValue(HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows NT\CurrentVersion", "ProductName", "S", "", sOSName)
                    sOSName = Replace(OSName, "Microsoft ", "", , , vbTextCompare)
            End Select
            
        Case Is = 4
            Select Case lBuild
                Case Is = 1381
                    'Win NT
                    Call oReg.ReadValue(HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows NT\CurrentVersion", "CSDVersion", "S", "", sOSServicePack)
                    sOSName = "Windows NT" 'Reg key for name does not exist
                
                Case Is = 950, 1111, 1212, 1213, 1214
                    'Win 95
                    sOSName = "Windows 95"

                Case Is = 1998, 2222 ' Win 98
                    'Win 98
                    sOSName = "Windows 98"
            
                Case Is = 3000
                    'Win ME
                    sOSName = "Windows ME"
                    
                Case Is = 2600
                    'Win ME
                    sOSName = "Windows XP"
                    
            End Select
    End Select
    
    
    ' Get total memory.
    Dim memsts As MEMORYSTATUS
    Dim memory As Long
    GlobalMemoryStatus memsts
    memory = memsts.dwTotalPhys
    sRAM = Format((memory \ 1024 \ 1024) + 1, "###,###") & " MB"

    'Processor type and speed
    Dim SI As SYSTEM_INFO
    Dim sTemp As String
    
    Call GetSystemInfo(SI)
    
    Select Case SI.dwProcessorType
        Case PROCESSOR_INTEL_386: sTemp = "386"
        Case PROCESSOR_INTEL_486: sTemp = "486"
        Case PROCESSOR_INTEL_PENTIUM: sTemp = "Intel"
        Case PROCESSOR_MIPS_R4000: sTemp = "MIPS 4000"
        Case PROCESSOR_ALPHA_21064: sTemp = "Alpha"
    End Select

    Select Case SI.wProcessorLevel
        Case PROCESSOR_LEVEL_80386
            sTemp = "80386"
            
        Case PROCESSOR_LEVEL_80486
            sTemp = "80486"
            
        Case PROCESSOR_LEVEL_PENTIUM
            sTemp = "Pentium"

        Case PROCESSOR_LEVEL_PENTIUMII
            If GetCPUSpeed() < 240 Then
                sTemp = "Pentium Pro"
            ElseIf GetCPUSpeed() < 470 Then
                sTemp = "Pentium II"
            ElseIf GetCPUSpeed() < 1220 Then
                sTemp = "Pentium III"
            End If

        Case PROCESSOR_LEVEL_PENTIUMIV
            sTemp = "Pentium IV"
    End Select
    
    'Processor type and speed
    sProcessorInfo = GetCPUSpeed() & "MHz " & sTemp
    
    'Domain Name
    sDomainName = Environ$("USERDOMAIN")
    
    'Array of installed applications
    varApplications = GetApplications
    
    'User Name
    sUserName = Environ$("USERNAME")
    
    'Machine Name
    sMachineName = Environ$("COMPUTERNAME")
    
    'IP Address
    sIPAddress = GetIPAddress
    
    'DHCP Enabled or not
    sDHCP = IsDhcpEnabled
    
    'Total drive space
    'Divide by 1024000 to return megabytes, then round to 0 places
    dblTotalDriveSpace = Round(Format(GetDiskSpace("C:") / 1024000, "0"), 0)
    
    'Free drive space
    'Divide by 1024000 to return megabytes, then round to 0 places
    dblFreeDriveSpace = Round(GetDiskSpaceFree("C:") / 1024000, 0)
    
    'Screen resolution
    sScreenRes = (Screen.Width / Screen.TwipsPerPixelX) & " X " & _
                 (Screen.Height / Screen.TwipsPerPixelY)
    
    'MacAddress
    sMacAddress = GetMACAddress
    
    'Scan Date
    dScanDate = Now
    
    Set oReg = Nothing
End Function

Private Function GetCPUSpeed() As Long
    Dim hKey As Long
    Dim cpuSpeed As Long
    Const CPU_REG_KEY = "HARDWARE\DESCRIPTION\System\CentralProcessor\0"
    Dim oReg As clsRegistry
    
    Set oReg = New clsRegistry
    Call oReg.ReadValue(HKEY_LOCAL_MACHINE, CPU_REG_KEY, "~MHz", "D", 1, cpuSpeed)
    Set oReg = Nothing
    
    
    GetCPUSpeed = (Round(cpuSpeed / 10, 0)) * 10
End Function

Private Function TrimNull(item As String)
    Dim pos As Integer
   
   'double check that there is a chr$(0) in the string
    pos = InStr(item, Chr$(0))
    If pos Then
          TrimNull = Left$(item, pos - 1)
    Else: TrimNull = item
    End If
End Function

Private Function GetIPAddress() As String
   Dim sHostName    As String * 256
   Dim lpHost    As Long
   Dim HOST      As HOSTENT
   Dim dwIPAddr  As Long
   Dim tmpIPAddr() As Byte
   Dim i         As Integer
   Dim sIPAddr  As String
   
   If Not SocketsInitialize() Then
      GetIPAddress = ""
      Exit Function
   End If
    
  'gethostname returns the name of the local host into
  'the buffer specified by the name parameter. The host
  'name is returned as a null-terminated string. The
  'form of the host name is dependent on the Windows
  'Sockets provider - it can be a simple host name, or
  'it can be a fully qualified domain name. However, it
  'is guaranteed that the name returned will be successfully
  'parsed by gethostbyname and WSAAsyncGetHostByName.

  'In actual application, if no local host name has been
  'configured, gethostname must succeed and return a token
  'host name that gethostbyname or WSAAsyncGetHostByName
  'can resolve.
   If gethostname(sHostName, 256) = SOCKET_ERROR Then
      GetIPAddress = ""
      SocketsCleanup
      Exit Function
   End If
   
  'gethostbyname returns a pointer to a HOSTENT structure
  '- a structure allocated by Windows Sockets. The HOSTENT
  'structure contains the results of a successful search
  'for the host specified in the name parameter.

  'The application must never attempt to modify this
  'structure or to free any of its components. Furthermore,
  'only one copy of this structure is allocated per thread,
  'so the application should copy any information it needs
  'before issuing any other Windows Sockets function calls.

  'gethostbyname function cannot resolve IP address strings
  'passed to it. Such a request is treated exactly as if an
  'unknown host name were passed. Use inet_addr to convert
  'an IP address string the string to an actual IP address,
  'then use another function, gethostbyaddr, to obtain the
  'contents of the HOSTENT structure.
   sHostName = Trim$(sHostName)
   lpHost = gethostbyname(sHostName)
    
   If lpHost = 0 Then
      GetIPAddress = ""
      SocketsCleanup
      Exit Function
   End If
    
  'to extract the returned IP address, we have to copy
  'the HOST structure and its members
   CopyMemory HOST, lpHost, Len(HOST)
   CopyMemory dwIPAddr, HOST.hAddrList, 4
   
  'create an array to hold the result
   ReDim tmpIPAddr(1 To HOST.hLen)
   CopyMemory tmpIPAddr(1), dwIPAddr, HOST.hLen
   
  'and with the array, build the actual address,
  'appending a period between members
   For i = 1 To HOST.hLen
      sIPAddr = sIPAddr & tmpIPAddr(i) & "."
   Next
  
  'the routine adds a period to the end of the
  'string, so remove it here
   GetIPAddress = Mid$(sIPAddr, 1, Len(sIPAddr) - 1)
   
   SocketsCleanup
End Function

Private Function HiByte(ByVal wParam As Integer) As Byte
   HiByte = (wParam And &HFF00&) \ (&H100)
End Function

Private Function LoByte(ByVal wParam As Integer) As Byte
   LoByte = wParam And &HFF&
End Function

Private Sub SocketsCleanup()
    If WSACleanup() <> ERROR_SUCCESS Then
        'Call Error object
    End If
End Sub

Private Function SocketsInitialize() As Boolean
    Dim WSAD As WSADATA
    Dim sLoByte As String
    Dim sHiByte As String
    
    If WSAStartup(WS_VERSION_REQD, WSAD) <> ERROR_SUCCESS Then
        SocketsInitialize = False
        Exit Function
    End If
    
    If WSAD.wMaxSockets < MIN_SOCKETS_REQD Then
        SocketsInitialize = False
        Exit Function
    End If
    
    If LoByte(WSAD.wVersion) < WS_VERSION_MAJOR Or _
        (LoByte(WSAD.wVersion) = WS_VERSION_MAJOR And _
        HiByte(WSAD.wVersion) < WS_VERSION_MINOR) Then
    
        sHiByte = CStr(HiByte(WSAD.wVersion))
        sLoByte = CStr(LoByte(WSAD.wVersion))
    
        SocketsInitialize = False
        Exit Function
    End If

    'must be OK, so lets do it
    SocketsInitialize = True
End Function

Private Function GetPointerToByteStringW(ByVal dwData As Long) As String
  
   Dim tmp() As Byte
   Dim tmplen As Long
   
   If dwData <> 0 Then
      tmplen = lstrlenW(dwData) * 2
      
      If tmplen <> 0 Then
         ReDim tmp(0 To (tmplen - 1)) As Byte
         CopyMemory tmp(0), ByVal dwData, tmplen
         GetPointerToByteStringW = tmp
     End If
   End If
End Function

Private Function GetDriveSN(PathName As String) As String
 
  'create working variables
  'to keep it simple, use dummy variables for info
  'we're not interested in right now
   Dim lReturn As Long
   Dim VolumeSN As Long

   Dim UnusedStr As String
   Dim UnusedVal1 As Long
   Dim UnusedVal2 As Long
   Dim DrvVolumeName As String

  'pad the strings
   DrvVolumeName = Space$(14)
   UnusedStr = Space$(32)

  'do what it says
   lReturn = GetVolumeInformation(PathName, _
                            DrvVolumeName, _
                            Len(DrvVolumeName), _
                            VolumeSN, _
                            UnusedVal1, UnusedVal1, _
                            UnusedStr, Len(UnusedStr))


  'error check
   If lReturn = 0 Then Exit Function
 
   GetDriveSN = Hex(VolumeSN)
End Function

Private Function getNow() As String
    Dim sBuild As String
    Dim lCount As Integer
    
    sBuild = Hex(Format(Date, "MMNNYY"))
    sBuild = sBuild & Hex(Format(Time, "HHMMSS"))
    sBuild = sBuild & Hex((Timer * 100))
    getNow = sBuild
End Function

Public Function GetUniqueFile() As String
    GetUniqueFile = GetDriveSN("C:\") & getNow
End Function

