VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSaveSystemInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Function SaveSystemInfo() As Boolean
    'Remote file info
    Dim oRemote As clsRemote
    Set oRemote = New clsRemote
    
    'Main system information object
    Dim oSys As clsGetSystemInfo
    Set oSys = New clsGetSystemInfo
    
    'Next available free file
    Dim lFreeFile As Long

    'Holds the complete remote file path
    Dim sRemoteFile As String

    'HDD Serial Number
    Dim sHDDSN As String
    
    'HDD Volume Name
    Dim sHDDVol As String

    'Counter
    Dim lCount As Long
    
    'Refresh the system information
    oSys.GetSystemInformation
    
    'Will return local or remote path to save file
    sRemoteFile = oRemote.GetRemoteFilePath(oSys.GetUniqueFile)
    
    If sRemoteFile = "" Then
        'Can't save file just exit sub
        Set oRemote = Nothing
        Set oSys = Nothing
        SaveSystemInfo = False
        Exit Function
    End If
    
    'Get the next free file number
    lFreeFile = FreeFile
    
    'Open the file for output
    Open sRemoteFile For Output As lFreeFile
    
    'Write the data to the file
    Print #lFreeFile, "ScanDate=" & oSys.ScanDate
    Print #lFreeFile, "DomainName=" & oSys.DomainName
    Print #lFreeFile, "FreeDriveSpace=" & oSys.FreeDriveSpace
    Print #lFreeFile, "IpAddress=" & oSys.IpAddress
    Print #lFreeFile, "MacAddress=" & oSys.MacAddress
    Print #lFreeFile, "MachineName=" & oSys.MachineName
    Print #lFreeFile, "OSName=" & oSys.OSName
    Print #lFreeFile, "OSServicePack=" & oSys.OSServicePack
    Print #lFreeFile, "OSVersion=" & oSys.OSVersion
    Print #lFreeFile, "ProcessorInfo=" & oSys.ProcessorInfo
    Print #lFreeFile, "RAM=" & oSys.RAM
    Print #lFreeFile, "ScreenResolution=" & oSys.ScreenResolution
    Print #lFreeFile, "TotalDriveSpace=" & oSys.TotalDriveSpace
    Print #lFreeFile, "UsingDHCP=" & oSys.UsingDHCP
    Print #lFreeFile, "UserName=" & oSys.UserName
    
    'Loop through all applications
    For lCount = 0 To UBound(oSys.Applications) Step 1
        Print #lFreeFile, "App=" & oSys.Applications(lCount)
    Next lCount
    
    'Close the file
    Close lFreeFile
    
    'Cleanup
    Set oRemote = Nothing
    
    'Return true if we succeeded
    SaveSystemInfo = True
End Function
