function _ListManager()
{
	this.minimumInitialRows=window.minimumInitialRows
	this.listIsVisible=false
	this.currTotalRows=0
	this.selectedRowIdx=0
	this.selectedIssueId=top.initialSelectedIssueId
	this.isDisplaySingleLine=top.initialDisplaySingleLine
	this.selectedRowDefaultClass=""
	this.issueIndicesToRowIndices=new HashMap()
	this.rowIndicesToIssueIndices=new HashMap()
	this.headerNames=["ID","By","To","Status","Priority","Project","Instance","Opened","Due","Description",""]
	this.sortNames=["idSort","assignedByUserFullnameSort","assignedToUserFullnameSort","statusSort","prioritySort","projectNameSort","instanceNameSort","openDateSort","dueDateSort","descriptionSort",""]
	this.colWidths=[35,60,60,57,72,80,80,72,107,150,74]
	this.issues=[] // set by init()
	this.currentSort // set by init()
	this.dataTableObj // set by init()
	this.lastSortName=""
	this.isAscendingSort=top.initialSortAscending
	this.init=_ListManager_init
	this.sort=_ListManager_sort
	this.addIssue=_ListManager_addIssue
	this.updateIssue=_ListManager_updateIssue
	this.closeIssue=_ListManager_closeIssue
	this.updateList=_ListManager_updateList
	//this.highlightIssue=_ListManager_highlightIssue
	this.writeInitialTableHTML=_ListManager_writeInitialTableHTML
	this.getDateText=_ListManager_getDateText
	this.openIssueDialog=_ListManager_openIssueDialog
	this.openCloseIssueDialog=_ListManager_openCloseIssueDialog
	this.changeRowLinksColor=_ListManager_changeRowLinksColor
	this.populateRow=_ListManager_populateRow
	this.colHeadersHTML=_ListManager_colHeadersHTML
	this.createBlankRow=_ListManager_createBlankRow
	this.createRuleRow=_ListManager_createRuleRow
	this.addBlankRows=_ListManager_addBlankRows
	this.rowOnmousedownEvent=_ListManager_rowOnmousedownEvent
	this.rowOndblclickEvent=_ListManager_rowOndblclickEvent
	this.setRowStyles=_ListManager_setRowStyles
	this.sortAndRedisplay=_ListManager_sortAndRedisplay
	this.writeSortArrowsMaps=_ListManager_writeSortArrowsMaps
	this.lineFormat=_ListManager_lineFormat
	this.singleLineBoxCheck=_ListManager_singleLineBoxCheck
	this.showSuppressedNames=_ListManager_showSuppressedNames
	this.showSuppressedProjectsOrInstances=_ListManager_showSuppressedProjectsOrInstances
	//this.highlightIssueById=_ListManager_highlightIssueById
}


function _ListManager_showSuppressedNames(namesList, isAssignedByUsers)
{
	generalAlert("Issues assigned "+(isAssignedByUsers?"by":"to")+" all users except "+namesList+" are shown.")
}

function _ListManager_showSuppressedProjectsOrInstances(namesList, isProjects)
{
	generalAlert("Issues associated with all "+(isProjects?"projects":"instances")+" except "+namesList+" are shown.")
}

function _ListManager_singleLineBoxCheck(checkboxObj)
{
	this.isDisplaySingleLine=checkboxObj.checked
	this.updateList()

}

function _ListManager_sortAndRedisplay(isAscending,sortName,invokedByButtonClick)
{

	if (this.issues.length==0 && invokedByButtonClick)
	{
		generalAlert("You clicked a column-sort arrow button, but there are no active (non-closed) issues to sort. To add an issue, click the \"add\" button. To view closed issues, click \"view closed issues.\"")
	}
	
	// still go through sort, even if no issues to sort, to init table for future issues:
	
	this.currentSort=idSort
	this.isAscendingSort=true
	this.sort()
	
	this.currentSort=window[sortName]
	this.isAscendingSort=isAscending
	this.sort()

	this.updateList()
	if (this.issues.length==0)
	{
		document.getElementById("noIssuesIndicator").style.display="block"
	}
	else
	{
		document.getElementById("noIssuesIndicator").style.display="none"
	}
	top.frames["header"].document.getElementById(sortName+"SortArrows").src=top.frames["header"][(isAscending?"ascendingSortArrowImage":"descendingSortArrowImage")].src
	if (this.lastSortName!="" && this.lastSortName!=sortName)
	{
		top.frames["header"].document.getElementById(this.lastSortName+"SortArrows").src=top.frames["header"]["noSortArrowImage"].src
	}
	this.lastSortName=sortName


}


function _ListManager_writeSortArrowsMaps()
{
	var s=""
	for (var i=0; i<this.sortNames.length; i++)
	{
		s+="<MAP NAME="+this.sortNames[i]+"Map>"
		s+="<AREA alt=\"sort by this column (ascending order)\" SHAPE=RECT COORDS=0,0,11,7 HREF=# onclick=\"top.frames['content'].ListManager.sortAndRedisplay(true,'"+this.sortNames[i]+"',true); return false\">"
		s+="<AREA alt=\"sort by this column (descending order)\" SHAPE=RECT COORDS=0,7,11,14 HREF=# onclick=\"top.frames['content'].ListManager.sortAndRedisplay(false,'"+this.sortNames[i]+"',true); return false\">"
		s+="</MAP>"
		document.write(s)
	}
}




function _ListManager_rowOnmousedownEvent()
{
	var srcEl=event.srcElement
	while(srcEl.id.indexOf("issueRow")==-1)
	{
		srcEl=srcEl.parentElement
	}
	//ListManager.highlightIssue(srcEl.rowIndex)
}


function _ListManager_rowOndblclickEvent()
{
	var srcEl=event.srcElement
	while(srcEl.id.indexOf("issueRow")==-1)
	{
		srcEl=srcEl.parentElement
	}
	ListManager.openIssueDialog(srcEl.rowIndex)
}


function _ListManager_init(issuesArray)
{
	this.issues=issuesArray
}

function _ListManager_openCloseIssueDialog(rowIdx)
{
	//var oldIssueIndicesToRowIndices=this.issueIndicesToRowIndices.clone()
	//var oldRowIndicesToIssueIndices=this.rowIndicesToIssueIndices.clone()
	var issueIdx=this.rowIndicesToIssueIndices.get(rowIdx)
	var issue=this.issues[issueIdx]
	var issueClosed=window.closeIssue(issue.id, top.users.get(issue.assignedByUserId).fullname, top.users.get(issue.assignedToUserId).fullname)
	if (issueClosed)
	{
		this.issues=removeArrayElement(this.issues,issueIdx)
		this.setRowStyles()
		this.sortAndRedisplay(ListManager.isAscendingSort,this.lastSortName,false)
		
	}
	//alert(oldIssueIndicesToRowIndices+"\n"+this.issueIndicesToRowIndices)
	//alert(oldRowIndicesToIssueIndices+"\n"+this.rowIndicesToIssueIndices)
	
}



function _ListManager_openIssueDialog(rowIdx)
{
	if (rowIdx>0)
	{
		//this.highlightIssue(rowIdx)
	}
	var issueIdx=this.rowIndicesToIssueIndices.get(rowIdx)
	var issue=this.issues[issueIdx]
	var dialogReturnValue
	if (rowIdx>0) // if edit:
	{
		dialogReturnValue=window.editIssue(issue.id)
	}
	else // if add:
	{
		dialogReturnValue=window.addIssue()
	}
	
	if (dialogReturnValue!=null)
	{
		var issueAsArray=dialogReturnValue[0]
		var mode=dialogReturnValue[1] // "add" or "edit"
		// empty array will be returned if user closed the window via any means but by
		// pressing "ok":
		//alert("in openIssueDialog(), issueAsArray[0]="+issueAsArray[0])

		var changedIssue=new Issue(issueAsArray)
		//alert("in openIssueDialog(), changedIssue.id="+changedIssue.id)
		if (mode=="edit")
		{
			// not adding; changing:
			this.updateIssue(changedIssue)
		}
		else
		{
			this.issues[this.issues.length]=changedIssue
			//this.addBlankRows()
			this.setRowStyles()
			
			this.sort()
			this.updateList()
			
			// uncomment to have newly added row highlighted after added:
			// this.highlightIssue(this.selectedRowIdx)
		}
	}
	if (this.issues.length>this.currTotalRows)
	{
		window.reloadPage()		
	}
}

function _ListManager_sort()
{
	this.issues.sort(this.currentSort)
	//alert(this.isAscendingSort)
	if (!this.isAscendingSort)
	{
		this.issues.reverse()
	}
}

function _ListManager_addIssue(issue)
{

	//this.issues[this.issues.length]=issue
	alert("implement")
}

function _ListManager_updateIssue(issue)
{
	var id=issue.id
	var issueIdx=0
	//alert(this.issues.length)
	for (var i=0; i<this.issues.length; i++)
	{
		var currIssue=this.issues[i]
		if (currIssue.id==id)
		{
			this.issues[i]=issue
			issueIdx=i
			break
		}
	}
	var rowToUpdate=this.dataTableObj.rows("issueRow"+issueIdx)
	this.populateRow(rowToUpdate,issue)
}

function _ListManager_closeIssue(rowIdx)
{
	generalConfirm("Are you sure you want to close this issue? It will be moved to the \"closed issues\" list and will no longer be editable. (Closed issues may, however, be re-opened as needed.)")
}

function _ListManager_updateList()
{
	var tableRows=this.dataTableObj.rows	
	var currIssueIdx=0
	this.issueIndicesToRowIndices.clear()
	this.rowIndicesToIssueIndices.clear()
	for (var i=0; i<tableRows.length; i++)
	{
		var row=tableRows[i]
		if (row.id.indexOf("issueRow")==-1)
		{
			continue
		}
		var issue=this.issues[currIssueIdx]
		this.issueIndicesToRowIndices.put(currIssueIdx,i)
		this.rowIndicesToIssueIndices.put(i,currIssueIdx)
		currIssueIdx++
		this.populateRow(row,issue)
	}
	//this.highlightIssueById(this.selectedIssueId)
}

function _ListManager_populateRow(row,issue)
{
	if (!issue)
	{
		return
	}
	var widthOffset=8 // compensate for border and padding specified in dataCell* classes
	row.cells("idDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[0]-widthOffset)+"px;\">"+issue.id+"</div>")

	var byFullname=top.users.get(issue.assignedByUserId).fullname
	var descriptionSummary=(issue.descriptionText+"                          ").substring(0,20);
	descriptionSummary=trim(descriptionSummary.replace(/\+/g," ").replace(/\r/g," ").replace(/\n/g," ").replace(/\"/g,"").replace(/\'/g,"").replace(/\t/g," ").replace(/\</g,"").replace(/\>/g,""))+"...";

	if (top.users.get(issue.assignedByUserId).emailAddress!=null && trim(top.users.get(issue.assignedByUserId).emailAddress).length>0)
	{
		byFullname="<a id=\"cellLinkBy"+row.rowIndex+"\" href=\"mailto:"+top.users.get(issue.assignedByUserId).emailAddress+"?subject=Regarding active WorkRoll issue #"+issue.id+", assigned by you ('"+descriptionSummary+"')\">"+byFullname+"</a>"
	}
	row.cells("assignedByDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[1]-widthOffset)+"px;\">"+byFullname+"</div>")
	var toFullname=top.users.get(issue.assignedToUserId).fullname
	if (top.users.get(issue.assignedToUserId).emailAddress!=null && trim(top.users.get(issue.assignedToUserId).emailAddress).length>0)
	{
		toFullname="<a id=\"cellLinkTo"+row.rowIndex+"\" href=\"mailto:"+top.users.get(issue.assignedToUserId).emailAddress+"?subject=Regarding active WorkRoll issue #"+issue.id+", assigned to you ('"+descriptionSummary+"')\">"+toFullname+"</a>"
	}
	row.cells("assignedToDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[2]-widthOffset)+"px;\">"+toFullname+"</div>")
	row.cells("statusDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[3]-widthOffset)+"px;\">"+statusCodesToLabelsMap.get(issue.status)+"</div>")
	row.cells("priorityDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[4]-widthOffset)+"px;\">"+priorityCodesToLabelsMap.get(issue.priority)+"</div>")
	var project=top.projects.get(issue.projectId)
	var projectName=(project!=null?top.projects.get(issue.projectId).name:"All projects")
	row.cells("projectDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[5]-widthOffset)+"px;\">"+projectName+"</div>")
	var instance=top.instances.get(issue.instanceId)
	var instanceName=(instance!=null?top.instances.get(issue.instanceId).name:"All instances")
	if (issue.instanceId>0 && instance.rootUrl!=null && trim(instance.rootUrl).length>0)
	{
		instanceName="<a id=\"cellLinkInstance"+row.rowIndex+"\" href=\""+instance.rootUrl+"\" target=\"_blank\">"+instanceName+"</a>"
	}
	row.cells("instanceDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[6]-widthOffset)+"px;\">"+instanceName+"</div>")
	row.cells("openDateDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[7]-widthOffset)+"px;\">"+this.getDateText(issue.openDate,"short")+"</div>")
	row.cells("dueDateDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[8]-widthOffset)+"px;\">"+this.getDateText(issue.dueDate,(this.isDisplaySingleLine?"medium":"long"))+"</div>")
	var urlLink=""
	if (issue.url!=null && trim(issue.url).length>0)
	{
		urlLink=(this.isDisplaySingleLine?" ":"<BR>")
			+"<span style=\"xborder:1px solid #7f7f5e; padding-left:2px; padding-right:2px; \">"
			+"<a id=\"cellLinkIssueUrl"+row.rowIndex+"\" href=\""+issue.url+"\" target=_blank><img alt=\"View URL: "+issue.url+"\" src=\"../images/icon_url.gif\" height=14 width=10 border=0 align=absmiddle></a></span>"
	}
	row.cells("descriptionTextDataCell").innerHTML=this.lineFormat("<div class=dataCellWidthConstraint style=\"width:"+(this.colWidths[9]-widthOffset)+"px;\">"+formatTextAsHTML(unescape(issue.descriptionText).replace(/\+/g," "))+urlLink+"</div>")
}

function _ListManager_lineFormat(s)
{
	if (this.isDisplaySingleLine)
	{
		var ret=""+s
		ret=ret.replace(/<BR>/g,"")
		return "<nobr>"+ret+"</nobr>"
	}
	return ""+s
}



function _ListManager_changeRowLinksColor(row,color)
{
	for (var c=0; c<row.cells.length; c++)
	{
		for (var a=0; a<row.cells[c].childNodes.length; a++)
		{
			if (row.cells[c].childNodes(a).id.indexOf("cellLink")>-1)
			{
				row.cells[c].childNodes(a).style.color=color
			}
		}
	}
}


/*
function _ListManager_highlightIssueById(issueId)
{
	if (issueId>0)
	{
		// need to translate issueId to row-idx:
		var rowIdx=-1
		for (var i=0; i<this.issues.length; i++)
		{
			var id=this.issues[i].id
			if (id==issueId)
			{
				rowIdx=this.issueIndicesToRowIndices.get(i)
				if (rowIdx==null)
				{
					rowIdx=-1
				}
				break
			}
		}
		if (rowIdx>-1)
		{
			ListManager.highlightIssue(rowIdx)
		}
	}
}
*/

/*
function _ListManager_highlightIssue(rowIdx)
{

	var unhighlightOnly=(rowIdx==-1)
	var rows=this.dataTableObj.rows
	if ((rowIdx>=3 && rowIdx<=rows.length-2) || unhighlightOnly)
	{
		if (this.selectedRowIdx>0)
		{
			row=rows(this.selectedRowIdx)
			row.className=this.selectedRowDefaultClass
			row.cells[0].style.backgroundColor="#7F7F5E"
			row.cells[row.cells.length-1].style.backgroundColor="#7F7F5E"
			cells=row.cells
			for (var i=2; i<=cells.length-2; i++)
			{
				cells[i].className="dataCell"
			}
		}

		if (!unhighlightOnly)
		{
			var row=rows(rowIdx)
			row.className="selectedDataRow"
			var cells=row.cells
			for (var i=2; i<=cells.length-2; i++)
			{
				cells[i].className="dataCellHighlighted"
			}
			if (this.listIsVisible)
			{
				// will get error if list not yet visible (right after page load):
				row.cells[0].childNodes("hiddenFocusReceiver").focus()
			}
			this.selectedRowDefaultClass=(row.rowIndex/2==parseInt(row.rowIndex/2)?"evenDataRow":"oddDataRow")
			this.selectedRowIdx=rowIdx			
		}
		else
		{
			this.selectedRowDefaultClass=""
			this.selectedRowIdx=-1
		}
	}
	if (!unhighlightOnly)
	{
		var issueIdx=this.rowIndicesToIssueIndices.get(rowIdx)
		if (issueIdx!=null)
		{
			this.selectedIssueId=this.issues[issueIdx].id
		}
	}
}
*/



function _ListManager_setRowStyles()
{

	var currentClass="evenDataRow"
	var rows=this.dataTableObj.rows
	var issuesIdx=-1
	for (var i=0; i<rows.length; i++)
	{
		var row=rows(i)
		if (row.id.indexOf("issueRow")>-1)
		{
			issuesIdx++
			if (issuesIdx>this.issues.length-1)
			{
				currentClass="hiddenDataRow"
			}
			else
			{
				currentClass=(currentClass=="evenDataRow"?"oddDataRow":"evenDataRow")
			}
			//alert("about to set class to '"+currentClass+"'")
			row.className=currentClass
		}
	}

}

function _ListManager_createBlankRow(row,idx)
{
	row.onselectstart=returnFalse
	row.ondblclick=ListManager.rowOndblclickEvent
	row.setAttribute("valign","top",0)
	row.onmousedown=ListManager.rowOnmousedownEvent
	//row.className="evenDataRow" // will switch to oddDataRow as needed
	row.setAttribute("id","issueRow"+idx,0)
	
	var defaultCellHTML=""
	
	// rule-row cell, with hidden focus receiver gif:
	var cell=row.insertCell(-1)
	cell.className="ruleRow"
	cell.setAttribute("nowrap","true",0)
	cell.setAttribute("width","1",0)
	cell.innerHTML="<a id=hiddenFocusReceiver href=\"javascript:void(0)\" onclick=\"return false\" hidefocus=true tabindex=-1><img src=\"../images/spacer.gif\" height=18 width=1 border=0 hidefocus=true onmouseover=\"this.style.cursor='default'; window.status=''; return true\"></a><br>"
	
	var idPrefixes=["id","assignedBy","assignedTo","status","priority","project","instance","openDate","dueDate","descriptionText"]
	
	for (var i=0; i<idPrefixes.length; i++)
	{
		cell=row.insertCell(-1)
		cell.setAttribute("id",idPrefixes[i]+"DataCell",0)
		cell.setAttribute("width",""+this.colWidths[i],0)
		cell.setAttribute("nowrap","true",0)
		cell.className="dataCell"+(i==0?"Left":"")
		cell.innerHTML=defaultCellHTML		
	}
	
	// row-end rule-row cell
	var cell=row.insertCell()
	cell.className="ruleRow"
	cell.setAttribute("nowrap","true",0)
	cell.setAttribute("width","1",0)
	cell.innerHTML="<img src=\"../images/spacer.gif\" height=1 width=1><br>"

	
}


function _ListManager_createRuleRow(row,idx)
{
	row.onselectstart=returnFalse
	row.className="ruleRow"
	row.id="ruleRow"+idx
	var cell=row.insertCell()
	cell.setAttribute("colspan",""+(this.headerNames.length+2),0)
	cell.innerHTML="<img src=\"../images/spacer.gif\" height=1 width=1><BR>"
}

function _ListManager_addBlankRows()
{
	// clear out all rows that are data-row-related:
	var rows=this.dataTableObj.rows
	for (var i=0; i<rows.length; i++)
	{
		var row=rows[i]
		if (row.id.indexOf("issueRow")>-1 || row.id.indexOf("ruleRow")>-1)
		{
			this.dataTableObj.deleteRow(row.rowIndex)
			i--
		}
	}
	for (var i=0; i<this.issues.length; i++)
	{
		var row=this.dataTableObj.insertRow()
		this.createBlankRow(row,i)
		row=this.dataTableObj.insertRow()
		this.createRuleRow(row,i)

	}
}

function _ListManager_writeInitialTableHTML(showColHeaders)
{
	var tableWidth=0
	for (var i=0; i<this.colWidths.length; i++)
	{
		tableWidth+=this.colWidths[i]
	}
	var s=""
	s+="<table width="+tableWidth+" border=0 cellspacing=0 cellpadding=0 id=dataTable>"
	s+="<tr style=\"display:"+(showColHeaders?"block":"none")+";\" class=ruleRow><td colspan="+(this.headerNames.length+2)+"><img src=\"../images/spacer.gif\" height=1 width=1><BR></td></tr>"
	s+=this.colHeadersHTML(showColHeaders)
	document.write(s)
	s=""
	
	this.currTotalRows=this.minimumInitialRows
	//alert()
	for (var i=0; i<this.currTotalRows; i++)
	{
		var rowClass=((i/2==parseInt(i/2))?"evenDataRow":"oddDataRow")
		s+="<tr onselectstart=\"return false\" ondblclick=\"ListManager.openIssueDialog(this.rowIndex)\" xonmousedown=\"ListManager.highlightIssue(this.rowIndex)\" class="+rowClass+" valign=top id=\"issueRow"+i+"\">"
		
		s+="<td valign=bottom class=ruleRow nowrap width=1><a id=hiddenFocusReceiver href=\"javascript:void(0)\" onclick=\"return false\" hidefocus=true tabindex=-1><img src=\"../images/spacer.gif\" height=18 width=1 border=0 hidefocus=true onmouseover=\"this.style.cursor='default'; window.status=''; return true\"></a><br></td>"
		
		s+="<td id=\"idDataCell\" width="+this.colWidths[0]+" nowrap align=left class=\"dataCellLeft\"></td>"
		s+="<td id=\"assignedByDataCell\" width="+this.colWidths[1]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"assignedToDataCell\" width="+this.colWidths[2]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"statusDataCell\" width="+this.colWidths[3]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"priorityDataCell\" width="+this.colWidths[4]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"projectDataCell\" width="+this.colWidths[5]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"instanceDataCell\" width="+this.colWidths[6]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"openDateDataCell\" width="+this.colWidths[7]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"dueDateDataCell\" width="+this.colWidths[8]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"descriptionTextDataCell\" width="+this.colWidths[9]+" nowrap align=left class=\"dataCell\"></td>"
		s+="<td id=\"blankDataCell\" width="+this.colWidths[10]+" nowrap align=left class=\"dataCell\"><nobr>"
		s+="<a href=# onclick=\"ListManager.openIssueDialog(this.parentElement.parentElement.parentElement.rowIndex); return false\" title=\"click to edit this issue (or double-click this row)\">edit</a> | "
		s+="<a href=# id=\"closelink"+i+"\" onclick=\"ListManager.openCloseIssueDialog(this.parentElement.parentElement.parentElement.rowIndex); return false\" title=\"click to move this issue to the closed-issues list\">close</a><BR></nobr></td>"
		s+="<td class=ruleRow nowrap width=1><img src=\"../images/spacer.gif\" height=1 width=1><br></td>"
		s+="</tr>"
		//s+="<tr class=ruleRow><td colspan="+(this.headerNames.length+2)+"><img src=\"../images/spacer.gif\" height=1 width=1><BR></td></tr>"
		document.write(s)
		//alert(s)
		s=""
	}

	// if uncommenting this, remember that adding dynamic rows will become more complicated (and according to MS documentation, slower):
	//s+=this.colHeadersHTML(showColHeaders)

	s+="</table>"
	document.write(s)
}

function _ListManager_colHeadersHTML(showColHeaders)
{
	var s=""
	s+="<tr style=\"display:"+(showColHeaders?"block":"none")+";\" class=headerRow height=20>"
	s+="<td class=ruleRow width=1><img src=\"../images/spacer.gif\" height=1 width=1><br></td>"
	for (var i=0; i<this.headerNames.length; i++)
	{
		s+="<td width="+this.colWidths[i]+" nowrap valign=middle align=center><font class=boldishColumnHeaderFont>"+this.headerNames[i]
		if (this.sortNames[i]!="")
		{
			s+=" <img src=../images/sortNone.gif align=absmiddle id="+this.sortNames[i]+"SortArrows height=14 width=11 border=0 hidefocus=true usemap=#"+this.sortNames[i]+"Map>"
		}
		s+="<BR></font></td>"
	}
	s+="<td class=ruleRow nowrap width=1><img src=\"../images/spacer.gif\" height=1 width=1><br></td>"
	s+="</tr>"
	s+="<tr style=\"display:"+(showColHeaders?"block":"none")+";\" class=ruleRow><td colspan="+(this.headerNames.length+2)+"><img src=\"../images/spacer.gif\" height=1 width=1><BR></td></tr>"
	return s
}

function _ListManager_getDateText(epochTime,format)
{
	if (format=="long")
	{
		var thisDate=new Calendar(epochTime)
		var s=""
		s+=thisDate.weekdayNamesAbbrev[thisDate.get(thisDate.DAY)]+"., "
		s+=thisDate.monthNamesAbbrev[thisDate.get(thisDate.MONTH)]+". "
		s+=thisDate.get(thisDate.DATE)+", "

		s+=(""+thisDate.get(thisDate.YEAR))+" "
		var thisDateMidnight=new Calendar(epochTime)
		thisDateMidnight.set(thisDateMidnight.HOUR,0)
		thisDateMidnight.set(thisDateMidnight.MINUTE,0)
		thisDateMidnight.set(thisDateMidnight.SECOND,0)
		thisDateMidnight.set(thisDateMidnight.MILLISECOND,0)
		var hourMs=thisDate.getTimeInMillis()-thisDateMidnight.getTimeInMillis()
		if (msToLabelsMap.get(hourMs)==null)
		{
			// alert("'"+(hourMs/(1000*60*60))+"': '"+new Date(hourMs)+"': "+msToLabelsMap.keys())
		}
		s+="("+msToLabelsMap.get(hourMs)+")"
		return s
	}
	if (format=="medium")
	{
		var thisDate=new Calendar(epochTime)
		var s=""
		//s+=thisDate.weekdayNamesAbbrev[thisDate.get(thisDate.DAY)]+"., "
		s+=toTwoDigit(thisDate.get(thisDate.MONTH)+1)+"/"
		s+=toTwoDigit(thisDate.get(thisDate.DATE))+"/"
		s+=(""+thisDate.get(thisDate.YEAR)).substring(2,4)+" "
		var thisDateMidnight=new Calendar(epochTime)
		thisDateMidnight.set(thisDateMidnight.HOUR,0)
		thisDateMidnight.set(thisDateMidnight.MINUTE,0)
		thisDateMidnight.set(thisDateMidnight.SECOND,0)
		thisDateMidnight.set(thisDateMidnight.MILLISECOND,0)
		var hourMs=thisDate.getTimeInMillis()-thisDateMidnight.getTimeInMillis()
		if (msToLabelsMap.get(hourMs)==null)
		{
			// alert("'"+(hourMs/(1000*60*60))+"': '"+new Date(hourMs)+"': "+msToLabelsMap.keys())
		}
		s+="("+msToLabelsMap.get(hourMs)+")"
		return s
	}
	if (format=="short")
	{
		var thisDate=new Date(epochTime)
		var s=""
		s+=(thisDate.getMonth()+1)+"/"
		s+=(thisDate.getDate())+"/"
		s+=(""+thisDate.getFullYear()).substring(2,4)
		return s
	}
}


var ListManager=new _ListManager()
