<%

int tableWidth=0;
for (int i=0; i<((listType==LIST_TYPE_STANDARD)?colWidths.length:colWidths.length-1); i++)
{
	tableWidth+=colWidths[i];
}

int initialBufferSize;
if (outputToWeb)
{
	initialBufferSize=4000;
}
else
{
	initialBufferSize=1200;
}

StringBuffer outStr=new StringBuffer(initialBufferSize);


if (outputToWeb)
{
	outStr.append("<table width=\""+tableWidth+"\" border=0 cellspacing=0 cellpadding=0 class=dataTableClass>");
	outStr.append("<tr class=ruleRow><td colspan="+(headerNames.length+2)+"><img src=\"../images/spacer.gif\" height=1 width=1><BR></td></tr>");
	outStr.append("<tr class=headerRow height=20>");
	outStr.append("<td class=ruleRow width=1><img src=\"../images/spacer.gif\" height=1 width=1><br></td>");
}


boolean doColHeaders=(outputToWeb || controller.getParamAsBoolean("doColHeaders"));
if (doColHeaders)
{
	if (!outputToWeb)
	{
		// Excel 2000 has a bug: if a file starts with "ID", it sometimes (always?) tries to interpret it as a SYLK file and fails, and gives an error message; since users are likely to import into Excel, starting off the file with this instead:
		outStr.append(" ");
	}
	for (int i=0; i<((listType==LIST_TYPE_STANDARD)?headerNames.length:headerNames.length-1); i++)
	{
		if (outputToWeb)
		{
			String addlStyle="";
			if (listType==LIST_TYPE_IMPORT_PREVIEW && i==0)
			{
				addlStyle="style=\"display:none; \"";
			}
			else if (listType==LIST_TYPE_PRINTABLE)
			{
				addlStyle=" style=\"border-left:1px solid #000000; border-bottom:1px solid #000000; border-top:1px solid #000000; ";
				if (i==headerNames.length-2)
				{
					addlStyle+="border-right:1px solid #000000; ";
				}
				addlStyle+=" \"";
			}
			outStr.append("<td "+addlStyle+" width="+colWidths[i]+" nowrap valign=middle align=center><font class=boldishColumnHeaderFont>");
		}
		if (listType==LIST_TYPE_EXPORT && i==headerNames.length-2)
		{
			outStr.append("URL\t");
		}
		outStr.append(headerNames[i]);
		if (!outputToWeb && i<headerNames.length-2)
		{
			outStr.append("\t");
		}
		if (sortNames[i].length()>0  && listType==LIST_TYPE_STANDARD)
		{
			String sortImageSuffix;
			if (!(sortNames[i].equals(staticListSortName)))
			{
				sortImageSuffix="None";
			}
			else
			{
				if (staticListSortAscending)
				{
					sortImageSuffix="Up";
				}
				else
				{
					sortImageSuffix="Down";
				}
			}
			outStr.append(" <img src=../images/sort"+sortImageSuffix+".gif align=absmiddle id="+sortNames[i]+"SortArrows height=14 width=11 border=0 hidefocus=true usemap=#"+sortNames[i]+"Map>");
		}
		if (outputToWeb)
		{
			outStr.append("<BR></font></td>");
		}


	}
	if (outputToWeb)
	{
		outStr.append("<td class=ruleRow width=1><img src=\"../images/spacer.gif\" height=1 width=1><br></td></tr>");

		outStr.append("<tr class=ruleRow><td colspan="+(headerNames.length+2)+"><img src=\"../images/spacer.gif\" height=1 width=1><BR></td></tr>");
		// Each row gets its own table if this is printable, so rows don't get split across two pages:
		if (listType==LIST_TYPE_PRINTABLE)
		{
			outStr.append("</table>");
		}
	}
	else
	{
		outStr.append(WorkRollConstants.LINE_SEPARATOR);
	}

}

if (outputToWeb)
{
	out.println(outStr.toString());
	out.println("");
}
else
{
	out.print(outStr.toString());
}
outStr=new StringBuffer(initialBufferSize);


for (int i=0; i<issues.size(); i++) 
{
	AbstractIssue issue=(AbstractIssue)issues.get(i);
	String rowClass=((i%2!=0)?"evenDataRow":"oddDataRow");
	int widthOffset=8; // compensate for border and padding specified in dataCell* classes
	
	// default these to error text:
	String idCellContents="[error]";
	String byCellContents="[error]";
	String toCellContents="[error]";
	String statusCellContents="[error]";
	String priorityCellContents="[error]";
	String projectCellContents="[error]";
	String instanceCellContents="[error]";
	String openedCellContents="[error]";
	String dueCellContents="[error]";
	String descriptionCellContents="[error]";
	
	DateFormat timeFormat=null;
	
	if (controller.getParamAsBoolean("doDueTime"))
	{
		timeFormat=new SimpleDateFormat("HH:mm:ss");
	}
	
	try
	{
		User byUser=(User)usersMap.get(new Integer(issue.getAssignedByUserId()));
		User toUser=(User)usersMap.get(new Integer(issue.getAssignedToUserId()));

		Project project=(Project)projectsMap.get(new Integer(issue.getProjectId()));
		String projectText;
		if (project!=null)
		{
			projectText=project.getName();
		}
		else
		{
			projectText="All projects";
		}
		Instance instance=(Instance)instancesMap.get(new Integer(issue.getInstanceId()));
		String instanceText;
		if (instance!=null)
		{
			instanceText=instance.getName();
		}
		else
		{
			instanceText="All instances";
		}


		DateFormat dateFormat;
		
		if (outputToWeb)
		{
			dateFormat=DateFormat.getDateInstance(DateFormat.SHORT);
		}
		else
		{
			dateFormat=GeneralUtils.getDateFormat(controller.getParamAsInt("dateFormatType"));
		}
		

		idCellContents=""+issue.getId();
		if (controller.getParamAsBoolean("byUsersAreUsernames"))
		{
			byCellContents=""+byUser.getUsername();
		}
		else
		{
			byCellContents=""+byUser.getFullname();
		}
	
		String descriptionSummary=(issue.getDescriptionText()+"                          ").substring(0,20);
		descriptionSummary=descriptionSummary.replace('\r',' ').replace('\n',' ').replace('\"',' ').replace('\'',' ').replace('\t',' ').replace('<',' ').replace('>',' ').trim()+"...";
		
		if (listType==LIST_TYPE_STANDARD && byUser.getEmailAddress()!=null && byUser.getEmailAddress().trim().length()>0)
		{
			byCellContents="<a href=\"mailto:"+byUser.getEmailAddress()+"?subject=Regarding closed WorkRoll issue #"+issue.getId()+", assigned by you ('"+descriptionSummary+"')\">"+byCellContents+"</a>";
		}
		if (controller.getParamAsBoolean("toUsersAreUsernames"))
		{
			toCellContents=""+toUser.getUsername();
		}
		else
		{
			toCellContents=""+toUser.getFullname();
		}
		
	
		if (listType==LIST_TYPE_STANDARD && toUser.getEmailAddress()!=null && toUser.getEmailAddress().trim().length()>0)
		{
			toCellContents="<a href=\"mailto:"+toUser.getEmailAddress()+"?subject=Regarding closed WorkRoll issue #"+issue.getId()+", assigned to you ('"+descriptionSummary+"')\">"+toCellContents+"</a>";
		}
		statusCellContents=GeneralUtils.getStatusLabelFromCode(issue.getStatus());
		priorityCellContents=GeneralUtils.getPriorityLabelFromCode(issue.getPriority());
		projectCellContents=""+projectText;
		instanceCellContents=""+instanceText;
		if (listType==LIST_TYPE_STANDARD && instance!=null && instance.getRootUrl()!=null && instance.getRootUrl().trim().length()>0)
		{
			instanceCellContents="<a target=_blank href=\""+instance.getRootUrl()+"\">"+instanceCellContents+"</a>";
		}
		openedCellContents=dateFormat.format(issue.getOpenDate());
		dueCellContents=dateFormat.format(issue.getDueDate());
		if (timeFormat!=null)
		{
			dueCellContents+=" "+timeFormat.format(issue.getDueDate());
		}

		if (outputToWeb)
		{
			descriptionCellContents="<script>document.write(formatTextAsHTML(urlDecode(\""+URLEncoder.encode(issue.getDescriptionText()+((issue.getUrl()!=null && issue.getUrl().length()>0)?WorkRollConstants.LINE_SEPARATOR+"URL: "+issue.getUrl():""))+"\")));</script>";
		}
		else
		{
			descriptionCellContents=""+issue.getDescriptionText();
		}
		if (prependSortableText)
		{
			NumberFormat epochMillisFormat=NumberFormat.getInstance();
			epochMillisFormat.setMinimumFractionDigits(0);
			epochMillisFormat.setMaximumFractionDigits(0);
			epochMillisFormat.setMinimumIntegerDigits(13);
			epochMillisFormat.setMaximumIntegerDigits(13);
			epochMillisFormat.setGroupingUsed(false);

			statusCellContents="["+issue.getStatus()+"] "+statusCellContents;
			priorityCellContents="["+issue.getPriority()+"] "+priorityCellContents;
			openedCellContents="["+epochMillisFormat.format(issue.getOpenDate().getTime())+"] "+openedCellContents;
			dueCellContents="["+epochMillisFormat.format(issue.getDueDate().getTime())+"] "+dueCellContents;
		}		
		

	}
	catch (Throwable t) 
	{
		Printer.p(t);
	}
	if (outputToWeb)
	{
		// Each row gets its own table if this is printable, so rows don't get split across two pages:
		if (listType==LIST_TYPE_PRINTABLE)
		{
			outStr.append("<table width=\""+tableWidth+"\" border=0 cellspacing=0 cellpadding=0 class=dataTableClass>");
		}
		outStr.append("<tr class=\""+rowClass+"\" valign=top>");
		outStr.append("<td class=ruleRow nowrap width=1><img src=\"../images/spacer.gif\" height=18 width=1 border=0><br></td>");
	}
	String[] cellContents=
	{
		idCellContents,
		byCellContents,
		toCellContents,
		statusCellContents,
		priorityCellContents,
		projectCellContents,
		instanceCellContents,
		openedCellContents,
		dueCellContents,
		descriptionCellContents,
	};
	for (int c=0; c<cellContents.length; c++)
	{	
		if (outputToWeb)
		{
			String addlStyle="";
			if (listType==LIST_TYPE_IMPORT_PREVIEW && c==0)
			{
				addlStyle="style=\"display:none; \"";
			}
			else if (listType==LIST_TYPE_PRINTABLE && c==cellContents.length-1)
			{
				addlStyle=" style=\"border-right:1px solid #000000; \" ";
			}
			outStr.append("<td id=\"idDataCell\" width="+colWidths[c]+" nowrap align=left "+addlStyle+" class=\"dataCell"+((c==0 || (listType==LIST_TYPE_IMPORT_PREVIEW && c==1))?"Left":"")+"\"><div class=dataCellWidthConstraint style=\"width:"+(colWidths[c]-widthOffset)+"px;\">"+cellContents[c]+"<BR></div></td>");
		}
		else
		{
			String cellText=cellContents[c].replace('\t',' ');
			cellText=GeneralUtils.stringReplace(cellText, WorkRollConstants.LINE_SEPARATOR, eolSubstitute);
			cellText=GeneralUtils.stringReplace(cellText, "\t", tabSubstitute);
			if (listType==LIST_TYPE_EXPORT && c==cellContents.length-1)
			{
				outStr.append((issue.getUrl()!=null?issue.getUrl():"")+"\t");
			}
			outStr.append(cellText);
			if (c<cellContents.length-1)
			{
				outStr.append("\t");
			}
		}
	}



	if (listType==LIST_TYPE_STANDARD)
	{
		if (isActiveIssues)
		{
			outStr.append("<td id=\"blankDataCell\" width="+colWidths[10]+" nowrap align=left class=\"dataCell\"><nobr><a href=# onclick=\"editIssue("+issue.getId()+"); return false\" title=\"click to edit this issue\">edit</a> | <a href=# onclick=\"closeIssue("+issue.getId()+"); return false\" title=\"click to close this issue\">close</a><BR></nobr></td>");
		}
		else
		{
			outStr.append("<td id=\"blankDataCell\" width="+colWidths[10]+" nowrap align=left class=\"dataCell\"><nobr><a href=# onclick=\"reopenIssue("+issue.getId()+"); return false\" title=\"click to reopen this issue\">reopen</a><BR></nobr></td>");
		}
	}
	
	if (outputToWeb)
	{
		outStr.append("<td class=ruleRow nowrap width=1><img src=\"../images/spacer.gif\" height=1 width=1><br></td></tr>");
		if (listType==LIST_TYPE_PRINTABLE)
		{
			outStr.append("</table>");
		}
	}
	else
	{
		outStr.append(WorkRollConstants.LINE_SEPARATOR);
	}
	
	
	if (outputToWeb)
	{
		out.println(outStr.toString());
		out.println("");
	}
	else
	{
		out.print(outStr.toString());
	}
	outStr=new StringBuffer(initialBufferSize);
}

if (outputToWeb)
{
	if (listType!=LIST_TYPE_PRINTABLE)
	{
		outStr.append("</table>");
	}
}


if (outputToWeb)
{
	out.print(outStr.toString());
}
else
{
	out.print(outStr.toString());
}
outStr=new StringBuffer(initialBufferSize);

if (issues.size()==0)
{
	String noIssuesText;
	String issueTypeText=(isActiveIssues?"active (non-closed)":"closed");
	if (controller.getSessionInfo().getCurrentFilter()==null)
	{
		noIssuesText="There are no "+issueTypeText+" issues to view.";
	}
	else
	{
		noIssuesText="This list is filtered.  As filtered, this list contains no "+issueTypeText+" issues.";
	}
	if (listType!=LIST_TYPE_EXPORT)
	{
		%><div id=noIssuesIndicator><%=noIssuesText%><BR></div><%
	}
	else
	{
		out.print(noIssuesText);
		outStr=new StringBuffer(initialBufferSize);
	}
}


%>