

<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>
       

<% PageUtils.jspStart(request); %>

<%@ page import="java.util.*" %>   
      
<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.util.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>
 
<%@ include file="../global/topInclude.jsp" %>
<%@ include file="../global/cookieJs.jsp" %>
<%@ include file="../global/validationJs.jsp" %>
<%!

static final String[] SORT_LABELS=
{
	"(none)",
	"ID",
	"Assigning user",
	"Assigned-to user",
	"Status",
	"Priority",
	"Project name",
	"Instance name",
	"Open date",
	"Due date",
	"Description",
};
static final String[] SORT_NAMES=
{
	"idSort", // we take "no sort" to mean sort by ID.
	"idSort",
	"assignedByUserFullnameSort",
	"assignedToUserFullnameSort",
	"statusSort",
	"prioritySort",
	"projectNameSort",
	"instanceNameSort",
	"openDateSort",
	"dueDateSort",
	"descriptionSort",
};

%>        

<%

boolean defaultActive=controller.getParamAsBoolean("isDefaultActive");


%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>

<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/popupHeadInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>




<script language="JavaScript">

top.focus()

top.setModalReturnValue(null)

var EXPORT_EOL_CHARS="<%=WorkRollConstants.EXPORT_EOL_CHARS%>"
var EXPORT_TAB_CHARS="<%=WorkRollConstants.EXPORT_TAB_CHARS%>"

var activeIsDefault=<%=defaultActive%>

function doExport()
{
	var els=document.forms["mainForm"].elements
	
	var exportType=""+radioGroupValue(document.forms["mainForm"],"exportType")
	var useCurrentFilter=""+radioGroupValue(document.forms["mainForm"],"useCurrentFilter")
	var sortAscending=""+radioGroupValue(document.forms["mainForm"],"sortAscending")
	var doColHeaders=""+radioGroupValue(document.forms["mainForm"],"doColHeaders")
	var doDueTime=""+radioGroupValue(document.forms["mainForm"],"doDueTime")
	var byUsersAreUsernames=""+radioGroupValue(document.forms["mainForm"],"byUsersAreUsernames")
	var toUsersAreUsernames=""+radioGroupValue(document.forms["mainForm"],"toUsersAreUsernames")
	var sortablePrefixes=""+radioGroupValue(document.forms["mainForm"],"sortablePrefixes")
	var eolSubstitute=""+escape(els["eolSubstitute"].value.replace(/_/g,"-"))
	var tabSubstitute=""+escape(els["tabSubstitute"].value.replace(/_/g,"-"))
	var dateFormat=""+selectValue(els["dateFormat"])
	var sortBy=""+selectValue(els["sortBy"])

	if (els["savePrefs"].checked)
	{
		setCookie
		(
			"expp",
			""
				+exportType+"_"
				+useCurrentFilter+"_"
				+sortAscending+"_"
				+doColHeaders+"_"
				+doDueTime+"_"
				+byUsersAreUsernames+"_"
				+toUsersAreUsernames+"_"
				+sortablePrefixes+"_"
				+eolSubstitute+"_"
				+tabSubstitute+"_"
				+dateFormat+"_"
				+sortBy,
			null,
			"/"
		)
	}
	hidePageAndShowPleaseWait()
	return true
}

function setDefaults()
{
	var els=document.forms["mainForm"].elements
	checkRadioWithNameAndValue("mainForm", "exportType", "all")
	checkRadioWithNameAndValue("mainForm", "useCurrentFilter", "false")
	checkRadioWithNameAndValue("mainForm", "sortAscending", "true")
	checkRadioWithNameAndValue("mainForm", "doColHeaders", "false")
	checkRadioWithNameAndValue("mainForm", "doDueTime", "true")
	checkRadioWithNameAndValue("mainForm", "byUsersAreUsernames", "true")
	checkRadioWithNameAndValue("mainForm", "toUsersAreUsernames", "true")
	checkRadioWithNameAndValue("mainForm", "sortablePrefixes", "false")
	els["eolSubstitute"].value=unescape(EXPORT_EOL_CHARS)
	els["tabSubstitute"].value=unescape(EXPORT_TAB_CHARS)
	selectMenuOption(els["dateFormat"],"0")
	selectMenuOption(els["sortBy"],"idSort")
	generalAlert("Form values have been set to defaults ideal for import into another WorkRoll instance.")

}

function init()
{
	var exportType="all"
	var useCurrentFilter="false"
	var sortAscending="true"
	var doColHeaders="true"
	var doDueTime="true"
	var byUsersAreUsernames="true"
	var toUsersAreUsernames="true"
	var sortablePrefixes="false"
	var tabSubstitute=EXPORT_TAB_CHARS
	var eolSubstitute=EXPORT_EOL_CHARS
	var dateFormat=0
	var sortBy="idSort"
	
	var exportPrefsCookie=getCookie("expp")
	if (exportPrefsCookie!=null)
	{
		var prefs=exportPrefsCookie.split("_")
		exportType=prefs[0]
		useCurrentFilter=prefs[1]
		sortAscending=prefs[2]
		doColHeaders=prefs[3]
		doDueTime=prefs[4]
		byUsersAreUsernames=prefs[5]
		toUsersAreUsernames=prefs[6]
		sortablePrefixes=prefs[7]
		eolSubstitute=prefs[8]
		tabSubstitute=prefs[9]
		dateFormat=prefs[10]
		sortBy=prefs[11]
	}
	
	var els=document.forms["mainForm"].elements
	
	checkRadioWithNameAndValue("mainForm", "exportType", exportType)
	checkRadioWithNameAndValue("mainForm", "useCurrentFilter", useCurrentFilter)
	checkRadioWithNameAndValue("mainForm", "sortAscending", sortAscending)
	checkRadioWithNameAndValue("mainForm", "doColHeaders", doColHeaders)
	checkRadioWithNameAndValue("mainForm", "doDueTime", doDueTime)
	checkRadioWithNameAndValue("mainForm", "byUsersAreUsernames", byUsersAreUsernames)
	checkRadioWithNameAndValue("mainForm", "toUsersAreUsernames", toUsersAreUsernames)
	checkRadioWithNameAndValue("mainForm", "sortablePrefixes", sortablePrefixes)
	els["eolSubstitute"].value=unescape(eolSubstitute)
	els["tabSubstitute"].value=unescape(tabSubstitute)
	selectMenuOption(els["dateFormat"],dateFormat)
	selectMenuOption(els["sortBy"],sortBy)

	if (document.getElementById("submitButton").focus)
	{
		document.getElementById("submitButton").focus()
	}
}
</script> 

<style type="text/css">
.inputClass {padding:2px; height:20px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; width:294px; } 
.textareaClass {padding:4px; height:120px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; } 
.selectClass {padding:2px; width:294px; border: 1px solid #7F7F5E; font-size:11px; font-family:arial,helvetica; }
.defaultButton {background-color:#A2A27A; border:1px solid #444434; width:65px; height:18px; font-family:arial,helvetica; font-size:11px; color:#444434;">}

</style>

 
  
 
</head>

<%@ include file="../global/bodyOpen.jsp" %>  

<div id=popupMainDiv style="width:525px; ">
<form action=displayDownloadUrl.jsp name=mainForm id=mainForm method=post onSubmit="return doExport()">

<font class=bodyFont>

<span class=firstSentenceFont>
You are about to export<%=HelpManager.helpLink("exporting","F2F2E1",request)%>
</span> 

issues to a tab-delimited text file that can be opened by spreadsheet programs such as Excel and Lotus 1-2-3, or imported into a database (or another WorkRoll installation). Please do one of the following...

<ul>
<li>If you are exporting issues so that you can import them into another WorkRoll installation, click "set WorkRoll export/import defaults", then press "OK", <I>or</I>
<li>If you are exporting issues for another purpose, choose export preferences in the form below, then press "OK".
</ul>

<input id="defaultsButton" onclick="setDefaults()" class=defaultButton type=button value="set WorkRoll export/import defaults" style="width:190px;"><BR><BR>


<span class=boldishFont>Export type:</span>

<input class=noBorder  type=radio name="exportType" value=active checked id="exportTypeActive"><label for="exportTypeActive">Active issues</label>

<input class=noBorder   type=radio name="exportType" value=closed id="exportTypeClosed"><label for="exportTypeClosed">Closed issues</label>

<input class=noBorder   type=radio name="exportType" value=all id="exportTypeAll"><label for="exportTypeAll">Active and closed issues</label>

<BR>


<span class=boldishFont>Filter<%=HelpManager.helpLink("filter","F2F2E1",request)%>:</span> <%=HtmlUtils.getYesNoRadios(true, "useCurrentFilter", "Use current filter (if found)", "Do not filter")%><%=HtmlUtils.doubleLB(request,5)%>

<span class=boldishFont>Sort by<%=HelpManager.helpLink("sort","F2F2E1",request)%><BR></span>
<select name=sortBy id=sortBy class=selectText style="width:130px;">
<%
for (int i=0; i<SORT_LABELS.length; i++)
{
	%>
	<option value="<%=SORT_NAMES[i]%>"><%=SORT_LABELS[i]%></option>
	<%
}
%>
</select><%=HtmlUtils.doubleLB(request,5)%>

<span class=boldishFont>Sort order:</span> <%=HtmlUtils.getYesNoRadios(true, "sortAscending", "Ascending", "Descending")%><%=HtmlUtils.doubleLB(request,5)%>

<span class=boldishFont>Replace end-of-line characters with<BR></span>
<input type=text name=eolSubstitute id=eolSubstitute class=inputText style="width:75px;"><%=HtmlUtils.doubleLB(request,5)%>

<span class=boldishFont>Replace tab characters with<BR></span>
<input type=text name=tabSubstitute id=tabSubstitute class=inputText style="width:75px;"><%=HtmlUtils.doubleLB(request,5)%>

<span class=boldishFont>Include column-header text:</span> <%=HtmlUtils.getYesNoRadios(true, "doColHeaders")%><%=HtmlUtils.doubleLB(request,5)%>

<span class=boldishFont>Date-field format<BR></span>
<select name=dateFormat id=dateFormat class=selectText style="width:130px;">
<option value="<%=""+WorkRollConstants.DATE_FORMAT_MMDDYYYY_SLASHES%>">01/31/2004</option>
<option value="<%=""+WorkRollConstants.DATE_FORMAT_MMDDYY_SLASHES%>">01/31/04</option>
<option value="<%=""+WorkRollConstants.DATE_FORMAT_YYYYMMDD_DASHES%>">2004-01-31</option>
<option value="<%=""+WorkRollConstants.DATE_FORMAT_DDMMYYYY_SLASHES%>">31/01/2003</option>
<option value="<%=""+WorkRollConstants.DATE_FORMAT_DDMMYY_SLASHES%>">31/01/03</option>
</select><%=HtmlUtils.doubleLB(request,5)%>

<span class=boldishFont>For due-date field, include time as well as date:</span> <%=HtmlUtils.getYesNoRadios(true, "doDueTime")%><BR>

<span class=boldishFont>Export assigned-by users'...</span> <%=HtmlUtils.getYesNoRadios(true, "byUsersAreUsernames", "Usernames"+HelpManager.helpLink("username","F2F2E1",request), "Full names"+HelpManager.helpLink("fullName","F2F2E1",request))%><BR>

<span class=boldishFont>Export assigned-to users'...</span> <%=HtmlUtils.getYesNoRadios(true, "toUsersAreUsernames", "Usernames"+HelpManager.helpLink("username","F2F2E1",request), "Full names"+HelpManager.helpLink("fullName","F2F2E1",request))%><BR>

<span class=boldishFont>Prepend selected fields with alpha-sortable prefix<%=HelpManager.helpLink("sortablePrefix","F2F2E1",request)%>:</span><%=HtmlUtils.getYesNoRadios(false, "sortablePrefixes")%><%=HtmlUtils.doubleLB(request,5)%>



<input type=checkbox checked name=savePrefs id=savePrefsTrue value=true><label for="savePrefsTrue">Remember these preferences for this session</label><BR><BR>


<input id="submitButton" class=formButton type=submit value="OK"> <input  class=formButton type=button value=cancel onclick="top.close()">
</font>

</form>	

</div>

<%@ include file="../global/popupBodyClose.jsp" %>

</html>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>


