<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>

  
<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>

<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>


<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

boolean showAll=controller.getParamAsBoolean("showAll",true);


ArrayList allUsers=Manager.selectAllUsers();
if (allUsers==null)
{
	allUsers=new ArrayList();
}

if (!showAll)
{
	ArrayList tempList=new ArrayList(allUsers.size());
	for (int i=0; i<allUsers.size(); i++)
	{
		User user=(User)allUsers.get(i);
		if (user.isActive())
		{
			tempList.add(user);
		}
	}
	allUsers=tempList;
}

String[] usernames=new String[allUsers.size()];
String[] fullnames=new String[allUsers.size()];
String[] emailAddresses=new String[allUsers.size()];
String[] passwords=new String[allUsers.size()];
boolean[] actives=new boolean[allUsers.size()];
boolean[] superUsers=new boolean[allUsers.size()];
int[] ids=new int[allUsers.size()];

for (int i=0; i<allUsers.size(); i++)
{
	User user=(User)allUsers.get(i);
	usernames[i]=user.getUsername();
	fullnames[i]=user.getFullname();
	emailAddresses[i]=user.getEmailAddress();
	passwords[i]=user.getPassword();
	actives[i]=user.isActive();
	superUsers[i]=user.isSuperUser();
	ids[i]=user.getId();
}

%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<html>
<head>
 
<%@ include file="../global/headInclude.jsp" %>
<%@ include file="../global/validationJs.jsp" %>


<script language="JavaScript">

var maxAllowedActiveUsers=<%=controller.getCurrentInstallationConfig().getMaxNumUsers()%>

var numUsers=<%=allUsers.size()%>
var doNotifications=<%=(controller.getCurrentInstallationConfig().isDoNotifications()?"true":"false")%>

<% pageContext.include("includes/writeAllUsernamesArray.jsp?jsVarName=allUsernames"); %>

<% pageContext.include("includes/writeAllFullnamesArray.jsp?jsVarName=allFullnames"); %>

function isValidForm(formObj)
{
	if (getNumActiveSuperusers(formObj,numUsers)==0)
	{
		errorAlert("You must specify at least one user who is both an administrator and active; please fix and try again.")
		return false
	}
	var els=formObj.elements
	// we have at least one user; make sure that all users entered have all fields entered:
	var upgradeLink="<%=controller.getUpgradeLink()%>"
	var totalActiveUsersCount=0
	for (var i=0; i<numUsers; i++)
	{
		var username=trim(els["username"+i].value)
		if (username.length==0)
		{
			errorAlert("You have left a username blank; all users must have a username. Please fix and try again.",els["username"+i])
			return false
		}
		if (trim(els["fullname"+i].value).length==0)
		{
			errorAlert("You have not entered a full name for username '"+username+"'; please fix and try again.",els["fullname"+i])
			return false
		}
		if (trim(els["emailAddress"+i].value).length==0)
		{
			errorAlert("You have not entered an e-mail address for username '"+username+"'. Please fix and try again. (If you don't currently know this user's e-mail address, please enter your own and change it later.)",els["emailAddress"+i])
			return false
		}
		if (radioGroupValue(formObj,"active"+i)=="true")
		{
			totalActiveUsersCount++
		}

	}
	if (maxAllowedActiveUsers>-1 && maxAllowedActiveUsers<totalActiveUsersCount)
	{
	
		var upgradeLink="<%=controller.getUpgradeLink()%>"
		alertConfirm("You are trying to set "+(totalActiveUsersCount>1?""+totalActiveUsersCount+" users'":"a user's")+" \"Is active\" status to \"Yes\", but your WorkRoll license only allows you to have "+maxAllowedActiveUsers+" active users at one time (an unlimited number of inactive users is allowed). Please <a style=\"color:#870000; text-decoration:underline;\" href=\"#\" onclick=\"top.window.open('"+upgradeLink+"');top.close()\">upgrade</a> your WorkRoll license or deactivate some users (by checking the user's \"No\" button under \"Is active\").", true, true, 300)
		return false
	}

	if (duplicateUsernamesInForm(formObj,numUsers))
	{
		return false
	}
	if (duplicateFullnamesInForm(formObj,numUsers))
	{
		return false
	}

	if (badUsernameFound(formObj,numUsers))
	{
		return false
	}
	if (badPasswordFound(formObj,numUsers))
	{
		return false
	}
	if (badEmailFound(formObj,numUsers))
	{
		return false
	}
	hidePageAndShowPleaseWait()
	return true
} 

function switchDisplayMode(showAll)
{
	top.location.href="users.jsp?showAll="+(showAll?"true":"false")
}

<% pageContext.include("js/js.jsp"); %>

</script>

<style type="text/css">

</style>
</head>

<%@ include file="../global/bodyOpen.jsp" %>

<div id=mainDiv>
  
<form action=processUsers.jsp method=post onsubmit="return isValidForm(this)" name=mainForm id=mainForm>
<input type=hidden name=numUsers id=numUsers value="<%=usernames.length%>">
<font class=bodyFont>
<span class=standardTextBlockWidth>
<span class=firstSentenceFont>Edit users here<%=HelpManager.helpLink("user",request)%></span>. If you've changed your mind and don't want to edit any users right now, click the "cancel" button below.<BR><BR>

<B>Note: Type a password into a password-column textbox only if you wish to change it.  Otherwise, leave the field blank; this will leave the password unchanged.  It is not possible to retrieve a user's forgotten password; as an administrator, you may change a user's password, but not view his or her current password.</B><BR><BR>


<input type=radio name=showAll id=showAllTrue value=true <%=showAll?"checked":"onclick=switchDisplayMode(true)"%>><label for=showAllTrue>Show all users</label>
<input type=radio name=showAll id=showAllFalse value=false <%=showAll?"onclick=switchDisplayMode(false)":"checked"%>><label for=showAllFalse>Show active users only</label>


</span>
<%=HtmlUtils.doubleLB(request)%>

<table border=0 cellspacing=0 cellpadding=0>
<%@ include file="usersTableHeaderRow.jsp" %>



<% 

for (int i=0; i<usernames.length; i++)
{
	%>
	<input type=hidden name=id<%=i%> id=id<%=i%> value="<%=ids[i]%>">
	<tr class=<%=((((double)i/2)==(double)((int)(i/2)))?"evenDataRow":"oddDataRow")%> height=24>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=10 name=username<%=i%> id=username<%=i%> value="<%=usernames[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=25 name=fullname<%=i%> id=fullname<%=i%> value="<%=fullnames[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=text size=35 name=emailAddress<%=i%> id=emailAddress<%=i%> value="<%=emailAddresses[i]%>"><BR></font></td>
	<td align=left><font class=columnDataFont>&nbsp;<input class=inputText type=password size=10 name=password<%=i%> id=password<%=i%> value="">&nbsp;<BR></font></td>
	<td align=center><font class=columnDataFont><%=HtmlUtils.getYesNoRadios(actives[i],"active"+i)%><BR></font></td>
	<td align=center><font class=columnDataFont><%=HtmlUtils.getYesNoRadios(superUsers[i],"superUser"+i)%><BR></font></td>
	<%=HtmlUtils.getSingleRuleCell(request)%>
	</tr> 
	<%=HtmlUtils.getHorizRuleTr(8, request)%>
	<%
}

%>

</table><BR>

<input  class=formButton type=submit value=change> <input  class=formButton type=button value=cancel onclick="location.href='menu.jsp'"><BR>

<%=HtmlUtils.doubleLB(request)%><BR>


<br></font>

</form>
</div>

<%@ include file="../global/bodyClose.jsp" %>

</html>

<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

