<%@ page import="com.workroll.app.*" %>
<%@ page import="com.workroll.app.util.*" %>
<%@ page import="com.workroll.app.control.*" %>

<%@ page import="java.io.*" %>
<%@ page import="java.util.*" %>

<% PageUtils.forceNoCache(response); %>
<% PageUtils.setPathToAppRoot("../../",request); %>


<%!
static final String FS=WorkRollConstants.FILE_SEPARATOR;
%>

<%

Controller controller=new Controller();
controller.initController(pageContext);


String dbPath=controller.getParam("dbPath").trim();


boolean propsFileCreateSuccess=false;
boolean fileCreateSuccess=false;

try
{
	String databaseRootDir=dbPath+FS+"tables";

	HashMap tableNamesToObjects=new HashMap();

	for (int i=0; i<WorkRollConstants.DATABASE_OBJECT_NAMES.length; i++)
	{
		tableNamesToObjects.put(WorkRollConstants.DATABASE_TABLE_NAMES[i],WorkRollConstants.ENTITY_PACKAGE_ROOT+"."+WorkRollConstants.DATABASE_OBJECT_NAMES[i]);
	}


	com.workroll.app.filesystem.FileSystem.createDatabasePropertiesFile(dbPath, WorkRollConstants.DBPROPS_FILENAME, databaseRootDir, tableNamesToObjects);
	fileCreateSuccess=true;
}
catch (Exception e)
{
	Printer.p("Exception creating db: "+e+": "+e.getMessage()+"");
}

if (!(com.workroll.app.filesystem.FileSystem.isInstalledAsWebapp(application)))
{
	// only need to set this if this is a non-web-app:
	if (fileCreateSuccess)
	{
		try
		{
			com.workroll.app.filesystem.FileSystem.setDbPath(dbPath, application);
			propsFileCreateSuccess=true;
		}
		catch (Exception e)
		{
			Printer.p("Exception thrown by setDbPath: "+e+": "+e.getMessage()+"");
		}
	}
}
else
{
	propsFileCreateSuccess=true;
}
%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 3.2 Final//EN">
<HTML>

<HEAD>

<TITLE>Welcome to WorkRoll</TITLE>

<%@ include file="../../global/headInclude.jsp" %>


<script>


</script>


<style type=text/css>
a {text-decoration:none;}
.bodyText {font-family:arial,helvetica; font-size:11px; color:#000000;}
.formButton {background-color:#870000; color:#cccc99; border:1px solid #870000; width:65px; }
#mainDiv {position:absolute; top:93px; left:15px; }
</style>
 
</HEAD>

<BODY onload="if (window.init) {init()}" BGCOLOR="#FFFFFF" link=#ff6600 vlink=#ff6600 alink=#ff6600>
<div id=mainDiv>
<form action=setDbLocation.jsp onsubmit="return isValidForm(this)">
<img src=../../images/workRollInstaller.gif height=73 width=588><BR><BR>
<span style="width:450px;">

<%

// not the default location:
if (fileCreateSuccess)
{
	if (propsFileCreateSuccess)
	{
		%>
		<font class=bodyText><B>The database was created.</B><BR><BR>
		Please click <a href="compileJsps.jsp">here</a> to continue. 
		</font>	
		<%
	}
	else
	{
		%>
		<font class=bodyText><B>There was a problem.</B><BR><BR>
		The database was created at "<%=dbPath%>", but WorkRoll could not create a "/WORKROLL-INF/workrollDoNotDelete.properties" file in your http root directory to reflect this configuration.  Please ensure that your application server has read/write permissions to create directories in your http-root directory, and to create new files within those directories.<BR><BR>
		</font>	
		<%
	}
}
else
{
	%>
	<font class=bodyText><B>There was a problem.</B><BR><BR>
	WorkRoll could not create its database at "<%=dbPath%>", either because it was not a valid path on the server where WorkRoll is installed, or because your application server does not have permission to create directories in that location.  Please <a href="index.jsp">go back</a> and try again.
	</font>	
	<%

}

%>

<BR>

<BR><font class=bodyText>
<%@ include file="helpInclude.jsp" %>
</font>


</span>

</form>
</div>
</BODY>

</HTML>
