<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>


<%@ page import="java.net.*" %>
<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.db.Manager" %>
<%@ page import="com.workroll.app.util.PageUtils" %>
<%@ page import="com.workroll.app.filesystem.FileSystem" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>

<% PageUtils.setPathToAppRoot("../../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_INSTALL,request); %>

<%@ include file="../../global/installTopInclude.jsp" %>

<%!

%>

<%


int numInstanceSlots=Integer.parseInt(controller.getParam("numInstances","0"));

for (int i=0; i<numInstanceSlots; i++)
{
	String name=controller.getParam("instanceName"+i);
	String url=controller.getParam("instanceUrl"+i);
	if (name.trim().length()>0)
	{
		Instance instance=new Instance();
		instance.setName(name);
		instance.setRootUrl(url);
		try
		{
			Manager.insertInstance(instance);
		}
		catch (Exception e)
		{
			Printer.pe("Exception caught in createInitialInstances.jsp",e);
			Printer.p(""+e+e.getMessage());
		}		
	}
}


InstallationConfig installationConfig=new InstallationConfig();
installationConfig.setDoNotifications(false); // user does this from admin screens after install
installationConfig.setAgreementRead(true); // if we got here, we assume this
installationConfig.setInitialConfigurationComplete(true);; // if we got here, we assume this
installationConfig.setInstallTimeInMillis(new Date().getTime()); // trial starts now.
User user=controller.getSessionInfo().getUser();
installationConfig.setCompanyName((String)session.getAttribute("wr.registrant.name"));
installationConfig.setAdminName(user.getFullname());
installationConfig.setAdminEmail(user.getEmailAddress());

Printer.p("in createinitialinstances.jsp, about to store IC: "+installationConfig);
controller.storeInstallationConfig(installationConfig);
Printer.p("in createinitialinstances.jsp, controller.getCurrentInstallationConfig(): "+controller.getCurrentInstallationConfig());

controller.redirect("../menu.jsp?icf=true");

%>


<%@ include file="../../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

